/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseInventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryClosingBalanceDAO;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class InventoryTransactionDAO
extends BaseInventoryTransactionDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction initialize(InventoryTransaction inventoryTransaction) {
        if (inventoryTransaction == null || inventoryTransaction.getId() == null) {
            return inventoryTransaction;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryTransaction);
            InventoryTransaction inventoryTransaction2 = inventoryTransaction;
            return inventoryTransaction2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Boolean convertInventoryUnit(Session session, MenuItem menuItem, InventoryStock inventoryStock, IUnit iUnit, IUnit iUnit2, Double d) {
        Boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            double d2 = menuItem.getUnitQuantity(iUnit, iUnit2) * d;
            Date date = new Date();
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            inventoryTransaction.setReason("UNIT. CONV.");
            inventoryTransaction.setTransactionDate(date);
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setType(InventoryTransactionType.OUT.getType());
            inventoryTransaction.setQuantity(d);
            inventoryTransaction.setUnitId(iUnit.getId());
            inventoryTransaction.setUnitType(iUnit.getUnitType());
            inventoryTransaction.setUnitCost(menuItem.getCost());
            inventoryTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
            inventoryTransaction.calculateTotal();
            if (inventoryStock != null) {
                inventoryTransaction.setFromInventoryLocation(inventoryStock.getInventoryLocation());
            }
            InventoryTransaction inventoryTransaction2 = new InventoryTransaction();
            inventoryTransaction2.setReason("UNIT. CONV.");
            inventoryTransaction2.setTransactionDate(date);
            inventoryTransaction2.setMenuItem(menuItem);
            inventoryTransaction2.setType(InventoryTransactionType.IN.getType());
            inventoryTransaction2.setQuantity(d2);
            inventoryTransaction2.setUnitId(iUnit2.getId());
            inventoryTransaction2.setUnitType(iUnit2.getUnitType());
            inventoryTransaction2.setUnitCost(menuItem.getCost());
            inventoryTransaction2.setOutletId(DataProvider.get().getCurrentOutletId());
            inventoryTransaction2.calculateTotal();
            if (inventoryStock != null) {
                inventoryTransaction2.setToInventoryLocation(inventoryStock.getInventoryLocation());
            }
            this.adjustOutTransactionInventoryStock(inventoryTransaction, session, true);
            this.adjustInTransactionInventoryStock(inventoryTransaction2, session, true);
            transaction.commit();
            bl = true;
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            PosLog.error(this.getReferenceClass(), exception);
        }
        return bl;
    }

    private void adjustOutTransactionInventoryStock(InventoryTransaction inventoryTransaction, Session session, boolean bl) {
        try {
            MenuItem menuItem = inventoryTransaction.getMenuItem();
            PosLog.info(this.getClass(), menuItem.getName() + " |" + (Object)((Object)inventoryTransaction.getTransactionType()) + "| |" + inventoryTransaction.getQuantity() + "| " + inventoryTransaction.getReason());
            InventoryLocation inventoryLocation = inventoryTransaction.getFromInventoryLocation();
            InventoryStock inventoryStock = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getFromLocationId(), inventoryTransaction.getUnitId(), session);
            double d = this.createStockItem(inventoryTransaction, session, menuItem, 1.0, inventoryStock, inventoryLocation);
            this.saveOrUpdate(inventoryTransaction, session);
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d, !bl, !bl, session);
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
    }

    private void adjustInTransactionInventoryStock(InventoryTransaction inventoryTransaction, Session session, boolean bl) {
        try {
            MenuItem menuItem = inventoryTransaction.getMenuItem();
            PosLog.info(this.getClass(), menuItem.getName() + " |" + (Object)((Object)inventoryTransaction.getTransactionType()) + "| |" + inventoryTransaction.getQuantity() + "| " + inventoryTransaction.getReason());
            InventoryLocation inventoryLocation = inventoryTransaction.getToInventoryLocation();
            InventoryStock inventoryStock = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getToLocationId(), inventoryTransaction.getUnitId(), session);
            double d = this.createStockItem(inventoryTransaction, session, menuItem, 1.0, inventoryStock, inventoryLocation);
            this.saveOrUpdate(inventoryTransaction, session);
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d, !bl, !bl, session);
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
    }

    public void adjustInventoryStock(InventoryTransaction inventoryTransaction, Session session) {
        this.adjustInventoryStock(inventoryTransaction, session, true, true);
    }

    public void adjustInventoryStock(InventoryTransaction inventoryTransaction, Session session, boolean bl, boolean bl2) {
        this.adjustInventoryStock(inventoryTransaction, session, bl, bl2, true);
    }

    public void adjustInventoryStock(InventoryTransaction inventoryTransaction, Session session, boolean bl, boolean bl2, boolean bl3) {
        this.adjustInventoryStock(inventoryTransaction, session, bl, bl2, bl3, null);
    }

    public void adjustInventoryStock(InventoryTransaction inventoryTransaction, Session session, boolean bl, boolean bl2, boolean bl3, PurchaseOrderItem purchaseOrderItem) {
        String string;
        Object object;
        MenuItem menuItem = inventoryTransaction.getMenuItem();
        double d = menuItem.getBaseUnitQuantity(inventoryTransaction.getUnitId());
        String string2 = "";
        if (menuItem.getUnit() != null) {
            string2 = menuItem.getUnit().getId();
        }
        inventoryTransaction.setBaseUnit(string2);
        inventoryTransaction.setBaseUnitQuantity(d);
        if (bl3) {
            object = DataProvider.get().getUnitById(inventoryTransaction.getUnitId(), inventoryTransaction.getUnitType());
            inventoryTransaction.setDisplayUnit((IUnit)object, inventoryTransaction.getQuantity(), menuItem);
        }
        object = null;
        InventoryLocation inventoryLocation = null;
        InventoryStock inventoryStock = null;
        double d2 = 0.0;
        PosLog.info(this.getClass(), menuItem.getName() + " |" + (Object)((Object)inventoryTransaction.getTransactionType()) + "| |" + inventoryTransaction.getQuantity() + "| " + inventoryTransaction.getReason());
        String string3 = string = purchaseOrderItem == null ? null : purchaseOrderItem.getBatchNumber();
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.IN) {
            inventoryLocation = inventoryTransaction.getToInventoryLocation();
            inventoryStock = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getToLocationId(), inventoryTransaction.getUnitId(), session, string);
            d2 = this.createStockItem(inventoryTransaction, session, menuItem, d, inventoryStock, inventoryLocation, purchaseOrderItem);
            this.saveOrUpdate(inventoryTransaction, session);
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d2, bl, bl2, session);
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.OUT) {
            object = inventoryTransaction.getFromInventoryLocation();
            inventoryStock = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getFromLocationId(), inventoryTransaction.getUnitId(), session, string);
            d2 = this.createStockItem(inventoryTransaction, session, menuItem, d, inventoryStock, (InventoryLocation)object, purchaseOrderItem);
            this.saveOrUpdate(inventoryTransaction, session);
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d2, bl, bl2, session);
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.UNCHANGED) {
            object = inventoryTransaction.getFromInventoryLocation();
            inventoryLocation = inventoryTransaction.getToInventoryLocation();
            this.createStockItemForTransfer(inventoryTransaction, session, menuItem, d, inventoryTransaction.getFromLocationId(), inventoryTransaction.getToLocationId());
            InventoryTransactionDAO.getInstance().saveOrUpdate(inventoryTransaction, session);
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.CONVERSION) {
            object = inventoryTransaction.getFromInventoryLocation();
            inventoryLocation = inventoryTransaction.getToInventoryLocation();
            InventoryStock inventoryStock2 = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getFromLocationId(), inventoryTransaction.getUnitId(), session);
            InventoryStock inventoryStock3 = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getToLocationId(), inventoryTransaction.getBaseUnit(), session);
            this.createConversionStockItem(inventoryTransaction, session, menuItem, d, inventoryStock2, inventoryStock3, inventoryLocation);
            InventoryTransactionDAO.getInstance().saveOrUpdate(inventoryTransaction, session);
        }
    }

    private void createStockItemForTransfer(InventoryTransaction inventoryTransaction, Session session, MenuItem menuItem, double d, String string, String string2) {
        InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
        InventoryStock inventoryStock = inventoryStockDAO.getInventoryStock(menuItem, string, inventoryTransaction.getUnitId(), session);
        InventoryStock inventoryStock2 = inventoryStockDAO.getInventoryStock(menuItem, string2, inventoryTransaction.getUnitId(), session);
        if (inventoryStock == null) {
            return;
        }
        if (inventoryStock2 == null) {
            inventoryStock2 = new InventoryStock();
            inventoryStock2.setMenuItem(menuItem);
            inventoryStock2.setLocationId(string2);
            inventoryStock2.setUnitId(inventoryTransaction.getUnitId());
            inventoryStock2.setUnitType(inventoryTransaction.getUnitType());
        }
        inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() - inventoryTransaction.getQuantity());
        inventoryStock2.setQuantityInHand(inventoryStock2.getQuantityInHand() + inventoryTransaction.getQuantity());
        if (inventoryStock.getQuantityInHand() == 0.0) {
            inventoryStockDAO.delete(inventoryStock, session);
        } else {
            inventoryStockDAO.saveOrUpdate(inventoryStock, session);
        }
        inventoryStockDAO.saveOrUpdate(inventoryStock2, session);
    }

    private double createStockItem(InventoryTransaction inventoryTransaction, Session session, MenuItem menuItem, double d, InventoryStock inventoryStock, InventoryLocation inventoryLocation) {
        return this.createStockItem(inventoryTransaction, session, menuItem, d, inventoryStock, inventoryLocation, null);
    }

    private double createStockItem(InventoryTransaction inventoryTransaction, Session session, MenuItem menuItem, double d, InventoryStock inventoryStock, InventoryLocation inventoryLocation, PurchaseOrderItem purchaseOrderItem) {
        if (inventoryStock == null) {
            inventoryStock = new InventoryStock();
            inventoryStock.setMenuItem(menuItem);
            if (inventoryLocation != null) {
                inventoryStock.setLocationId(inventoryLocation.getId());
            }
            inventoryStock.setUnitId(inventoryTransaction.getUnitId());
            inventoryStock.setUnitType(inventoryTransaction.getUnitType());
        }
        if (purchaseOrderItem != null) {
            inventoryStock.setBatchNumber(purchaseOrderItem.getBatchNumber());
            inventoryStock.setExpireDate(purchaseOrderItem.getExpireDate());
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.IN) {
            inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() + inventoryTransaction.getQuantity());
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.OUT) {
            inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() - inventoryTransaction.getQuantity());
        }
        double d2 = 0.0;
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.IN) {
            d2 += d * inventoryTransaction.getQuantity();
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.OUT) {
            d2 -= d * inventoryTransaction.getQuantity();
        }
        InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
        inventoryStockDAO.saveOrUpdate(inventoryStock, session);
        return d2;
    }

    private void createConversionStockItem(InventoryTransaction inventoryTransaction, Session session, MenuItem menuItem, double d, InventoryStock inventoryStock, InventoryStock inventoryStock2, InventoryLocation inventoryLocation) {
        if (inventoryStock2 == null) {
            inventoryStock2 = new InventoryStock();
            inventoryStock2.setMenuItem(menuItem);
            inventoryStock2.setLocationId(inventoryLocation.getId());
            inventoryStock2.setUnitId(inventoryTransaction.getBaseUnit());
            inventoryStock2.setUnitType(inventoryTransaction.getUnitType());
        }
        inventoryStock2.setQuantityInHand(inventoryStock2.getQuantityInHand() + inventoryTransaction.getQuantity() * d);
        inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() - inventoryTransaction.getQuantity());
        InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
        if (inventoryStock.getQuantityInHand() == 0.0) {
            inventoryStockDAO.delete(inventoryStock, session);
        } else {
            inventoryStockDAO.saveOrUpdate(inventoryStock, session);
        }
        inventoryStockDAO.saveOrUpdate(inventoryStock2, session);
    }

    public void performInventoryTransaction(InventoryTransaction inventoryTransaction) {
        try (Session session = this.createNewSession();){
            this.performInventoryTransaction(inventoryTransaction, session);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void performInventoryTransaction(InventoryTransaction inventoryTransaction, Session session) throws Exception {
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            this.adjustInventoryStock(inventoryTransaction, session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    public void performInventoryTransactions(InventoryTransaction ... inventoryTransactionArray) {
        block15: {
            if (inventoryTransactionArray == null || inventoryTransactionArray.length == 0) {
                return;
            }
            Transaction transaction = null;
            try (Session session = this.createNewSession();){
                transaction = session.beginTransaction();
                this.performInventoryTransactions(session, inventoryTransactionArray);
                transaction.commit();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
                if (transaction == null) break block15;
                transaction.rollback();
            }
        }
    }

    public void performInventoryTransactions(Session session, InventoryTransaction ... inventoryTransactionArray) {
        if (inventoryTransactionArray == null || inventoryTransactionArray.length == 0) {
            return;
        }
        for (InventoryTransaction inventoryTransaction : inventoryTransactionArray) {
            this.adjustInventoryStock(inventoryTransaction, session);
            InventoryVendorItemsDAO.getInstance().saveItems(inventoryTransaction, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void saveInventoryTransactionList(List<InventoryTransaction> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryTransaction inventoryTransaction : list) {
                this.adjustInventoryStock(inventoryTransaction, session);
                if (inventoryTransaction.getReason().equals("PURCHASE")) {
                    InventoryVendorItemsDAO.getInstance().saveItems(inventoryTransaction, session);
                    continue;
                }
                if (!inventoryTransaction.getReason().equals("NEW STOCK")) continue;
                InventoryVendorItemsDAO.getInstance().saveItems(inventoryTransaction, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInventoryTransfer(InventoryTransaction inventoryTransaction, InventoryTransaction inventoryTransaction2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
            InventoryStock inventoryStock = inventoryStockDAO.getInventoryStock(inventoryTransaction.getMenuItem(), inventoryTransaction.getToLocationId(), inventoryTransaction.getUnitId());
            if (inventoryStock == null) {
                inventoryStock = new InventoryStock();
                inventoryStock.setMenuItem(inventoryTransaction.getMenuItem());
                inventoryStock.setLocationId(inventoryTransaction.getToLocationId());
                inventoryStock.setQuantityInHand(inventoryTransaction.getQuantity());
                inventoryStock.setUnitId(inventoryTransaction.getUnitId());
                inventoryStock.setUnitType(inventoryTransaction.getUnitType());
            } else {
                inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() + inventoryTransaction.getQuantity());
            }
            InventoryStock inventoryStock2 = inventoryStockDAO.getInventoryStock(inventoryTransaction2.getMenuItem(), inventoryTransaction2.getFromLocationId(), inventoryTransaction2.getUnitId());
            if (inventoryStock2 == null) {
                inventoryStock2 = new InventoryStock();
                inventoryStock2.setMenuItem(inventoryTransaction2.getMenuItem());
                inventoryStock2.setLocationId(inventoryTransaction2.getFromLocationId());
                inventoryStock2.setQuantityInHand(inventoryTransaction2.getQuantity());
                inventoryStock2.setUnitId(inventoryTransaction2.getUnitId());
                inventoryStock2.setUnitType(inventoryTransaction2.getUnitType());
            } else {
                inventoryStock2.setQuantityInHand(inventoryStock2.getQuantityInHand() - inventoryTransaction2.getQuantity());
            }
            this.saveOrUpdate(inventoryTransaction, session);
            this.saveOrUpdate(inventoryTransaction2, session);
            inventoryStockDAO.saveOrUpdate(inventoryStock, session);
            inventoryStockDAO.saveOrUpdate(inventoryStock2, session);
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            InventoryTransaction inventoryTransaction = this.get(string, session);
            MenuItem menuItem = inventoryTransaction.getMenuItem();
            menuItem.setAvailableUnit(menuItem.getAvailableUnit() - inventoryTransaction.getQuantity());
            MenuItemDAO.getInstance().saveOrUpdate(menuItem, session);
            this.delete(inventoryTransaction, session);
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction getInventoryTransaction(int n) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            criteria.createAlias(InventoryTransaction.PROP_REFERENCE_NO, "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)n));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                InventoryTransaction inventoryTransaction = null;
                return inventoryTransaction;
            }
            InventoryTransaction inventoryTransaction = (InventoryTransaction)list.get(0);
            return inventoryTransaction;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PurchaseOrder getPurchaseOrderId(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(PurchaseOrder.class);
            criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_ORDER_ID, (Object)string));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                PurchaseOrder purchaseOrder = null;
                return purchaseOrder;
            }
            PurchaseOrder purchaseOrder = (PurchaseOrder)list.get(0);
            return purchaseOrder;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactionsByType(String string, List<Integer> list, MenuGroup menuGroup, MenuCategory menuCategory, Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = this.buildCriteriaForTransactionReport(session, string, list, menuGroup, menuCategory);
            criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date, (Object)date2));
            criteria.addOrder(Order.asc((String)"menuItem.name"));
            criteria.addOrder(Order.asc((String)"menuItem.id"));
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list2 = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Criteria buildCriteriaForTransactionReport(Session session, String string, List<Integer> list, MenuGroup menuGroup, MenuCategory menuCategory) {
        Criteria criteria = session.createCriteria(InventoryTransaction.class);
        criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "menuItem");
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"menuItem.deleted"), (Criterion)Restrictions.eq((String)"menuItem.deleted", (Object)Boolean.FALSE)));
        if (list != null && !list.isEmpty()) {
            criteria.add(Restrictions.in((String)InventoryTransaction.PROP_TYPE, list));
        }
        if (StringUtils.isNotEmpty((String)string)) {
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_ID), (Object)string));
            disjunction.add(Restrictions.ilike((String)("menuItem." + MenuItem.PROP_NAME), (String)string, (MatchMode)MatchMode.START));
            disjunction.add(Restrictions.ilike((String)("menuItem." + MenuItem.PROP_SKU), (String)string, (MatchMode)MatchMode.EXACT));
            criteria.add((Criterion)disjunction);
        }
        if (menuGroup != null) {
            criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_MENU_GROUP_ID), (Object)menuGroup.getId()));
        }
        if (menuCategory != null) {
            criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_MENU_CATEGORY_ID), (Object)menuCategory.getId()));
        }
        return criteria;
    }

    public Map<String, InventoryTransaction> populateOpeningBalance(Map<String, MenuItem> map, Date date, Date date2) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        Date date3 = null;
        List<InventoryTransaction> list = date3 == null ? null : this.getClosingBalances(map, arrayList, date3);
        List<InventoryTransaction> list2 = this.getInTransactions(arrayList, date3, date);
        return this.mergeLastClosingBalanceAndTrans(list, list2);
    }

    private List<InventoryTransaction> getClosingBalances(Map<String, MenuItem> map, List<String> list, Date date) {
        List<InventoryClosingBalance> list2 = InventoryClosingBalanceDAO.getInstance().getClosingBalances(list, date);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        ArrayList<InventoryTransaction> arrayList = new ArrayList<InventoryTransaction>();
        for (InventoryClosingBalance inventoryClosingBalance : list2) {
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            inventoryTransaction.setUnitId(inventoryClosingBalance.getUnitId());
            inventoryTransaction.setUnitType(inventoryClosingBalance.getUnitType());
            inventoryTransaction.setQuantity(inventoryClosingBalance.getBalance());
            inventoryTransaction.setUnitCost(inventoryClosingBalance.getUnitCost());
            inventoryTransaction.setTotal(inventoryClosingBalance.getTotal());
            inventoryTransaction.setMenuItem(map.get(inventoryClosingBalance.getMenuItemId()));
            arrayList.add(inventoryTransaction);
        }
        return arrayList;
    }

    private List<InventoryTransaction> getInTransactions(List<String> list, Date date, Date date2) {
        List list2;
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.groupProperty((String)InventoryTransaction.PROP_MENU_ITEM), InventoryTransaction.PROP_MENU_ITEM);
            projectionList.add((Projection)Projections.groupProperty((String)InventoryTransaction.PROP_UNIT_ID), InventoryTransaction.PROP_UNIT_ID);
            projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_QUANTITY), InventoryTransaction.PROP_QUANTITY);
            projectionList.add((Projection)Projections.groupProperty((String)InventoryTransaction.PROP_UNIT_COST), InventoryTransaction.PROP_UNIT_COST);
            projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_TOTAL), InventoryTransaction.PROP_TOTAL);
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
            criteria.add(Restrictions.in((String)"item.id", list));
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            if (date != null) {
                criteria.add((Criterion)Restrictions.gt((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
            }
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(InventoryTransaction.class));
            list2 = criteria.list();
        }
        return list2;
    }

    private Map<String, InventoryTransaction> mergeLastClosingBalanceAndTrans(List<InventoryTransaction> list, List<InventoryTransaction> list2) {
        HashMap<String, InventoryTransaction> hashMap = new HashMap<String, InventoryTransaction>();
        if (list != null && list.size() > 0) {
            for (InventoryTransaction inventoryTransaction : list) {
                this.mergeAndPopulateToMap(hashMap, inventoryTransaction);
            }
        }
        if (list2 != null && list2.size() > 0) {
            for (InventoryTransaction inventoryTransaction : list2) {
                this.mergeAndPopulateToMap(hashMap, inventoryTransaction);
            }
        }
        return hashMap;
    }

    private void mergeAndPopulateToMap(Map<String, InventoryTransaction> map, InventoryTransaction inventoryTransaction) {
        InventoryTransaction inventoryTransaction2 = map.get(inventoryTransaction.getMenuItem().getId());
        double d = 0.0;
        double d2 = 0.0;
        if (inventoryTransaction2 == null) {
            inventoryTransaction2 = inventoryTransaction;
            map.put(inventoryTransaction.getMenuItem().getId(), inventoryTransaction2);
        } else {
            d = inventoryTransaction2.getQuantity();
            d2 = inventoryTransaction2.getTotal();
        }
        IUnit iUnit = DataProvider.get().getUnitById(inventoryTransaction.getUnitId(), inventoryTransaction.getUnitType());
        Double d3 = InventoryUnitConvertionUtil.calculateCost(inventoryTransaction.getUnitCost(), iUnit, inventoryTransaction.getMenuItem().getUnit(), inventoryTransaction.getMenuItem());
        Double d4 = inventoryTransaction.getTotal() == 0.0 || inventoryTransaction.getUnitCost() == 0.0 ? 0.0 : inventoryTransaction.getTotal() / d3;
        inventoryTransaction2.setQuantity(d + d4);
        inventoryTransaction2.setUnitCost(d3);
        inventoryTransaction2.setTotal(d2 + inventoryTransaction.getTotal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction findOpeningBalance(MenuItem menuItem, Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_MENU_ITEM, (Object)menuItem));
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
            List list = criteria.list();
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (InventoryTransaction inventoryTransaction2 : list) {
                d += inventoryTransaction2.getQuantity().doubleValue();
                d3 += inventoryTransaction2.getTotal().doubleValue();
            }
            d2 = d3 / d;
            if (Double.isNaN(d2)) {
                d2 = 0.0;
            }
            inventoryTransaction.setQuantity(d);
            inventoryTransaction.setTotal(d3);
            inventoryTransaction.setUnitCost(d2);
            InventoryTransaction inventoryTransaction3 = inventoryTransaction;
            return inventoryTransaction3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactionsForAvgCosting(MenuGroup menuGroup, Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "menuItem");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"menuItem.deleted"), (Criterion)Restrictions.eq((String)"menuItem.deleted", (Object)Boolean.FALSE)));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_MENU_GROUP_ID), (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)("menuItem." + MenuItem.PROP_MENU_GROUP_NAME)));
            criteria.addOrder(Order.asc((String)("menuItem." + MenuItem.PROP_NAME)));
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String string, Object object, Date date, Date date2) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            criteria.setProjection(Projections.rowCount());
            criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date, (Object)date2));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
                criteria.add(Restrictions.ilike((String)"item.name", (Object)("%" + string + "%")));
            }
            if (object instanceof InventoryLocation) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)((InventoryLocation)object).getId()));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void getInventoryTransactions(PaginationSupport paginationSupport, String string, Object object, Date date, Date date2) {
        try (Session session = this.createNewSession();){
            Disjunction disjunction;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date, (Object)date2));
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
            String string2 = "item.";
            if (StringUtils.isNotEmpty((String)string)) {
                string = string.trim();
                disjunction = Restrictions.disjunction();
                disjunction.add((Criterion)Restrictions.eq((String)(string2 + MenuItem.PROP_BARCODE), (Object)string));
                disjunction.add((Criterion)Restrictions.eq((String)(string2 + MenuItem.PROP_SKU), (Object)string));
                disjunction.add(Restrictions.ilike((String)(string2 + MenuItem.PROP_NAME), (String)string, (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)disjunction);
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)(string2 + "deleted")), (Criterion)Restrictions.eq((String)(string2 + "deleted"), (Object)Boolean.FALSE)));
            if (object instanceof InventoryLocation) {
                disjunction = Restrictions.disjunction();
                String string3 = ((InventoryLocation)object).getId();
                disjunction.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)string3));
                disjunction.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TO_LOCATION_ID, (Object)string3));
                criteria.add((Criterion)disjunction);
            }
            this.addDeletedFilter(criteria);
            paginationSupport.setNumRows(super.rowCount(criteria));
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            paginationSupport.setRows(criteria.list());
        }
    }

    public List<InventoryTransaction> getInventoryTransactionsByItemName(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.getSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
                criteria.add(Restrictions.ilike((String)"item.name", (Object)("%" + string + "%")));
            }
            if ((list = criteria.list()) == null || list.size() == 0) {
                return null;
            }
            return list;
        }
        catch (Exception exception) {
            return criteria.list();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket getTicketId(int n) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)n));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                Ticket ticket = null;
                return ticket;
            }
            Ticket ticket = (Ticket)list.get(0);
            return ticket;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findItemAvgCost(MenuItem menuItem) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_MENU_ITEM, (Object)menuItem));
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            calendar.set(5, 1);
            Date date = DateUtil.startOfDay(calendar.getTime());
            calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMaximum(5));
            Date date2 = DateUtil.endOfDay(calendar.getTime());
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_QUANTITY));
            projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_TOTAL));
            criteria.setProjection((Projection)projectionList);
            List list = criteria.list();
            Object[] objectArray = (Object[])list.get(0);
            double d = 0.0;
            if (objectArray[0] != null) {
                d = ((Number)objectArray[0]).doubleValue();
            }
            double d2 = 0.0;
            if (objectArray[1] != null) {
                d2 = ((Number)objectArray[1]).doubleValue();
            }
            if (d == 0.0) {
                double d3 = 0.0;
                return d3;
            }
            double d4 = d2 / d;
            return d4;
        }
        finally {
            this.closeSession(session);
        }
    }

    public double findItemAvgCost(String string, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
        criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)string));
        criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        Date date = DateUtil.startOfDay(calendar.getTime());
        calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        Date date2 = DateUtil.endOfDay(calendar.getTime());
        criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_QUANTITY));
        projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_TOTAL));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        Object[] objectArray = (Object[])list.get(0);
        double d = 0.0;
        if (objectArray[0] != null) {
            d = ((Number)objectArray[0]).doubleValue();
        }
        double d2 = 0.0;
        if (objectArray[1] != null) {
            d2 = ((Number)objectArray[1]).doubleValue();
        }
        if (d == 0.0) {
            return 0.0;
        }
        return d2 / d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactions(String string, InventoryTransactionType inventoryTransactionType) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (inventoryTransactionType != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)inventoryTransactionType.getType()));
            }
            if (string != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)string));
            }
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findUnsyncedByTicketId(String string) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (string != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TICKET_ID, (Object)string));
                list = Restrictions.isNull((String)InventoryTransaction.PROP_LAST_UPDATE_TIME);
                Criterion criterion = Restrictions.isNull((String)InventoryTransaction.PROP_LAST_SYNC_TIME);
                PropertyExpression propertyExpression = Restrictions.gtProperty((String)InventoryTransaction.PROP_LAST_UPDATE_TIME, (String)InventoryTransaction.PROP_LAST_SYNC_TIME);
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{list, criterion, propertyExpression}));
            }
            list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

