/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.base.BaseInventoryVendorItems;
import com.floreantpos.model.dao.BaseInventoryVendorItemsDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryVendorItemsDAO
extends BaseInventoryVendorItemsDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof InventoryVendorItems) {
            InventoryVendorItems inventoryVendorItems = (InventoryVendorItems)object;
            inventoryVendorItems.setVendor(null);
            inventoryVendorItems.setItem(null);
            super.update(inventoryVendorItems, session);
        } else {
            super.delete(object, session);
        }
    }

    @Override
    public List<InventoryVendorItems> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)InventoryVendorItems.PROP_VENDOR), (Criterion)Restrictions.isNotNull((String)InventoryVendorItems.PROP_ITEM)));
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorItems> findByItem(MenuItem menuItem) {
        if (menuItem.getId() == null) {
            return null;
        }
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuItem != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)menuItem));
            }
            if ((list = criteria.list()).isEmpty()) {
                List<InventoryVendorItems> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    public InventoryVendorItems findByItemAndVendor(MenuItem menuItem, InventoryVendor inventoryVendor) {
        try (Session session = this.createNewSession();){
            InventoryVendorItems inventoryVendorItems = this.findByItemAndVendor(menuItem, inventoryVendor, session);
            return inventoryVendorItems;
        }
    }

    private InventoryVendorItems findByItemAndVendor(MenuItem menuItem, InventoryVendor inventoryVendor, Session session) {
        if (menuItem == null || StringUtils.isBlank((String)menuItem.getId()) || inventoryVendor == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)menuItem));
        criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
        criteria.setMaxResults(1);
        return (InventoryVendorItems)criteria.uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vendorHasItem(InventoryVendor inventoryVendor, MenuItem menuItem, Session session) {
        if (menuItem.getId() == null) {
            return false;
        }
        boolean bl = false;
        try {
            List list;
            if (session == null) {
                session = this.createNewSession();
                bl = true;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuItem != null && inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)menuItem));
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (Exception exception) {
            PosLog.error(InventoryVendorDAO.class, exception.getMessage(), exception);
        }
        finally {
            if (bl && session != null) {
                session.close();
            }
        }
        return false;
    }

    public void saveItems(PurchaseOrder purchaseOrder) {
        try (Session session = this.createNewSession();){
            Transaction transaction = session.beginTransaction();
            this.saveItems(purchaseOrder, session);
            transaction.commit();
        }
    }

    public void saveItems(PurchaseOrder purchaseOrder, Session session) {
        List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
        for (PurchaseOrderItem purchaseOrderItem : list) {
            MenuItem menuItem = purchaseOrderItem.getMenuItem();
            InventoryVendor inventoryVendor = purchaseOrder.getVendor();
            if (this.vendorHasItem(inventoryVendor, menuItem, null)) continue;
            InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
            inventoryVendorItems.setItem(menuItem);
            inventoryVendorItems.setVendor(inventoryVendor);
            session.saveOrUpdate((Object)inventoryVendorItems);
        }
        session.saveOrUpdate((Object)purchaseOrder);
    }

    public void saveItems(InventoryTransaction inventoryTransaction, Session session) {
        try {
            MenuItem menuItem = inventoryTransaction.getMenuItem();
            InventoryVendor inventoryVendor = null;
            if (inventoryTransaction.getVendorId() != null) {
                inventoryVendor = InventoryVendorDAO.getInstance().get(inventoryTransaction.getVendorId());
            }
            if (!this.vendorHasItem(inventoryVendor, menuItem, session)) {
                InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
                inventoryVendorItems.setItem(menuItem);
                inventoryVendorItems.setVendor(inventoryVendor);
                session.saveOrUpdate((Object)inventoryVendorItems);
            }
        }
        catch (Exception exception) {
            PosLog.error(InventoryVendorDAO.class, exception.getMessage(), exception);
        }
    }

    public void saveAll(List<InventoryVendorItems> list) {
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveAll(list, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveAll(List<InventoryVendorItems> list, Session session) {
        for (InventoryVendorItems inventoryVendorItems : list) {
            this.saveOrUpdate(inventoryVendorItems, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorItems> findByVendor(InventoryVendor inventoryVendor) {
        if (inventoryVendor.getId() == null) {
            return null;
        }
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("item", "menuItem");
            criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_DELETED), (Object)false));
            criteria.addOrder(Order.asc((String)("menuItem." + MenuItem.PROP_NAME)).ignoreCase());
            if (inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                List<InventoryVendorItems> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVendorItems(PaginatedListModel paginatedListModel, InventoryVendor inventoryVendor) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginatedListModel.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            List list = criteria.list();
            for (Object e : list) {
                InventoryVendorItems inventoryVendorItems;
                if (!(e instanceof InventoryVendorItems) || (inventoryVendorItems = (InventoryVendorItems)e).getItem() == null || inventoryVendorItems.getItem().getId() == null) continue;
                paginatedListModel.setData(criteria.list());
            }
        }
    }

    public void saveOrUpdateInventoryVendorItems(List<InventoryVendorItems> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        HashMap<String, MenuItem> hashMap = new HashMap<String, MenuItem>();
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryVendorItems inventoryVendorItems : list) {
                Comparable comparable;
                MenuItem menuItem = inventoryVendorItems.getItem();
                if (menuItem != null) {
                    comparable = (MenuItem)hashMap.get(menuItem.getId());
                    if (comparable != null) {
                        inventoryVendorItems.setItem((MenuItem)comparable);
                    } else {
                        menuItem = MenuItemDAO.getInstance().get(menuItem.getId());
                        inventoryVendorItems.setItem(menuItem);
                        hashMap.put(menuItem.getId(), menuItem);
                    }
                }
                if ((comparable = this.get(inventoryVendorItems.getId(), session)) == null) {
                    comparable = this.findByItemAndVendor(inventoryVendorItems.getItem(), inventoryVendorItems.getVendor(), session);
                }
                if (comparable != null) {
                    if (!BaseDataServiceDao.get().shouldSave(inventoryVendorItems.getLastUpdateTime(), ((BaseInventoryVendorItems)comparable).getLastUpdateTime())) {
                        PosLog.info(this.getClass(), inventoryVendorItems.getId() + " already updated");
                        continue;
                    }
                    long l = ((BaseInventoryVendorItems)comparable).getVersion();
                    String string = ((BaseInventoryVendorItems)comparable).getId();
                    PropertyUtils.copyProperties((Object)comparable, (Object)inventoryVendorItems);
                    ((BaseInventoryVendorItems)comparable).setId(string);
                    ((BaseInventoryVendorItems)comparable).setVersion(l);
                    ((InventoryVendorItems)comparable).setUpdateLastUpdateTime(bl);
                    ((InventoryVendorItems)comparable).setUpdateSyncTime(bl2);
                    this.update((InventoryVendorItems)comparable, session);
                    continue;
                }
                inventoryVendorItems.setUpdateLastUpdateTime(bl);
                inventoryVendorItems.setUpdateSyncTime(bl2);
                this.save(inventoryVendorItems, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void nullifyByInventoryVendor(InventoryVendor inventoryVendor, Session session) {
        String string = "UPDATE %s items SET items.%s = :vendor1, items.%s = :item WHERE items.%s = :vendor0";
        string = String.format(string, InventoryVendorItems.REF, InventoryVendorItems.PROP_VENDOR, InventoryVendorItems.PROP_ITEM, InventoryVendorItems.PROP_VENDOR);
        Query query = session.createQuery(string);
        query.setParameter("vendor1", null);
        query.setParameter("item", null);
        query.setParameter("vendor0", (Object)inventoryVendor);
        query.executeUpdate();
    }

    public void saveOrUpdateMenuItemVendors(MenuItem menuItem, List<InventoryVendorItems> list) {
        if (menuItem == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null && list.size() > 0) {
                Object object;
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    ((BaseInventoryVendorItems)object).setItem(menuItem);
                    this.saveOrUpdate((InventoryVendorItems)object, session);
                    arrayList.add(((BaseInventoryVendorItems)object).getId());
                }
                if (menuItem.isHasVariant().booleanValue() && (object2 = menuItem.getVariants()) != null && object2.size() > 0) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        MenuItem menuItem2 = (MenuItem)object.next();
                        List<InventoryVendorItems> list2 = InventoryVendorItemsDAO.getInstance().findByItem(menuItem2);
                        if (list2 == null) {
                            list2 = new ArrayList<InventoryVendorItems>();
                        }
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        HashMap<String, InventoryVendorItems> hashMap = new HashMap<String, InventoryVendorItems>();
                        for (InventoryVendorItems inventoryVendorItems : list2) {
                            hashMap.put(inventoryVendorItems.getVendor().getId(), inventoryVendorItems);
                            arrayList2.add(inventoryVendorItems.getId());
                        }
                        for (InventoryVendorItems inventoryVendorItems : list) {
                            InventoryVendorItems inventoryVendorItems2 = (InventoryVendorItems)hashMap.get(inventoryVendorItems.getVendor().getId());
                            if (inventoryVendorItems2 != null) continue;
                            InventoryVendorItems inventoryVendorItems3 = new InventoryVendorItems();
                            inventoryVendorItems3.setVendor(inventoryVendorItems.getVendor());
                            inventoryVendorItems3.setItem(menuItem2);
                            this.saveOrUpdate(inventoryVendorItems3, session);
                            arrayList2.add(inventoryVendorItems3.getId());
                        }
                        this.clearVendorItems(menuItem2, session, arrayList2);
                    }
                }
            }
            this.clearVendorItems(menuItem, session, arrayList);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    private void clearVendorItems(MenuItem menuItem, Session session, List<String> list) {
        if (list.size() == 0) {
            String string = "delete from " + InventoryVendorItems.REF + " where %s=:item";
            Query query = session.createQuery(String.format(string, InventoryVendorItems.PROP_ITEM));
            query.setParameter("item", (Object)menuItem);
            query.executeUpdate();
        } else {
            String string = "delete from " + InventoryVendorItems.REF + " where %s=:item and %s not in (:ids)";
            Query query = session.createQuery(String.format(string, InventoryVendorItems.PROP_ITEM, InventoryVendorItems.PROP_ID));
            query.setParameter("item", (Object)menuItem);
            query.setParameterList("ids", list);
            query.executeUpdate();
        }
    }

    public void saveOrUpdateVendorMenuItems(InventoryVendor inventoryVendor, List<InventoryVendorItems> list, List<InventoryVendorItems> list2) {
        if (inventoryVendor == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            InventoryVendorDAO.getInstance().saveOrUpdate(inventoryVendor, session);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null && list.size() > 0) {
                for (InventoryVendorItems object : list) {
                    object.setVendor(inventoryVendor);
                    this.saveOrUpdate(object, session);
                    arrayList.add(object.getId());
                }
            }
            if (list2 != null && list2.size() > 0) {
                ArrayList arrayList2 = new ArrayList();
                for (InventoryVendorItems inventoryVendorItems : list2) {
                    if (arrayList.contains(inventoryVendorItems.getId())) continue;
                    arrayList2.add(inventoryVendorItems.getId());
                }
                if (arrayList2.size() > 0) {
                    this.removeVendorItems(inventoryVendor, session, arrayList2);
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    private void removeVendorItems(InventoryVendor inventoryVendor, Session session, List<String> list) {
        String string = "delete from " + InventoryVendorItems.REF + " where %s=:vendor and %s in (:ids)";
        Query query = session.createQuery(String.format(string, InventoryVendorItems.PROP_VENDOR, InventoryVendorItems.PROP_ID));
        query.setParameter("vendor", (Object)inventoryVendor);
        query.setParameterList("ids", list);
        query.executeUpdate();
    }
}

