/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuGroupDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.Transformers;

public class MenuGroupDAO
extends BaseMenuGroupDAO {
    @Override
    public Serializable save(Object object, Session session) throws HibernateException {
        MenuGroup menuGroup = (MenuGroup)object;
        menuGroup.setSortOrder(this.getNextSortOrder(menuGroup.getMenuCategoryId(), session));
        this.updateTime(menuGroup);
        Serializable serializable = super.save(menuGroup, session);
        this.updateDependentModels(menuGroup, session);
        return serializable;
    }

    @Override
    public void update(Object object, Session session) throws HibernateException {
        this.updateTime(object);
        super.update(object, session);
        this.updateDependentModels((MenuGroup)object, session);
    }

    @Override
    public void saveOrUpdate(Object object, Session session) throws HibernateException {
        MenuGroup menuGroup = (MenuGroup)object;
        if (StringUtils.isBlank((String)menuGroup.getId())) {
            menuGroup.setSortOrder(this.getNextSortOrder(menuGroup.getMenuCategoryId(), session));
        }
        this.updateTime(menuGroup);
        super.saveOrUpdate(menuGroup, session);
        this.updateDependentModels(menuGroup, session);
    }

    @Override
    public void delete(Object object, Session session) throws HibernateException {
        MenuGroup menuGroup = (MenuGroup)object;
        if (menuGroup == null) {
            throw new PosException(Messages.getString("MenuGroupDAO.0"));
        }
        this.checkIfGroupCanbeDeleted(session, menuGroup);
        menuGroup.setMenuCategory(null);
        menuGroup.setDeleted(true);
        this.removeFromDependentModels(menuGroup, session);
        this.update(menuGroup, session);
        this.removeFromDiscounts(menuGroup, session);
    }

    private void checkIfGroupCanbeDeleted(Session session, MenuGroup menuGroup) {
        String string = "";
        List<MenuItem> list = MenuItemDAO.getInstance().getMenuItemsByGroupId(menuGroup.getId(), session);
        if (list != null && !list.isEmpty()) {
            if (StringUtils.isNotBlank((String)string)) {
                string = string + "\n\n";
            }
            string = string + Messages.getString("MenuGroupDAO.1") + " " + menuGroup.getName() + " " + Messages.getString("MenuGroupDAO.2");
            int n = 1;
            for (MenuItem menuItem : list) {
                string = string + "\n" + n + ". " + menuItem.getName();
                ++n;
            }
        }
        if (StringUtils.isNotBlank((String)string)) {
            throw new PosException(Messages.getString("MenuGroupDAO.3") + " " + menuGroup.getName() + " " + Messages.getString("MenuGroupDAO.4"), string);
        }
    }

    public List<MenuGroup> getMenuGroupsId(String string, Session session) {
        Criteria criteria = session.createCriteria(MenuGroup.class);
        this.addDeletedFilter(criteria, MenuGroup.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)string));
        return criteria.list();
    }

    @Override
    public List<MenuGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME).ignoreCase());
            List list = criteria.list();
            return list;
        }
    }

    private void updateDependentModels(MenuGroup menuGroup, Session session) {
        String string = "update MenuItem set %s=:groupName, %s=:categoryId, %s=:categoryName, %s=:beverage where %s=:groupId";
        string = String.format(string, MenuItem.PROP_MENU_GROUP_NAME, MenuItem.PROP_MENU_CATEGORY_ID, MenuItem.PROP_MENU_CATEGORY_NAME, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_GROUP_ID);
        Query query = session.createQuery(string);
        query.setParameter("groupName", (Object)menuGroup.getName());
        query.setParameter("categoryId", (Object)menuGroup.getMenuCategoryId());
        query.setParameter("categoryName", (Object)menuGroup.getMenuCategoryName());
        query.setParameter("beverage", (Object)menuGroup.isBeverage());
        query.setParameter("groupId", (Object)menuGroup.getId());
        query.executeUpdate();
        session.saveOrUpdate((Object)menuGroup);
    }

    private void removeFromDependentModels(MenuGroup menuGroup, Session session) {
        String string = menuGroup.getId();
        String string2 = "update MenuItem set " + MenuItem.PROP_MENU_GROUP_NAME + "= null, " + MenuItem.PROP_MENU_GROUP_ID + "= null, " + MenuItem.PROP_MENU_CATEGORY_ID + "= null, " + MenuItem.PROP_MENU_CATEGORY_NAME + "= null, %s=:beverage where %s=:groupId";
        string2 = String.format(string2, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_GROUP_ID);
        Query query = session.createQuery(string2);
        query.setParameter("beverage", (Object)false);
        query.setParameter("groupId", (Object)string);
        query.executeUpdate();
        MenuPageDAO menuPageDAO = MenuPageDAO.getInstance();
        List<MenuPage> list = menuPageDAO.findByGroup(menuGroup);
        if (list != null && !list.isEmpty()) {
            menuPageDAO.deleteAll(list, session);
        }
    }

    private void removeFromDiscounts(MenuGroup menuGroup, Session session) {
        DiscountDAO discountDAO = DiscountDAO.getInstance();
        List<Discount> list = discountDAO.getDiscountsByMenuGroup(menuGroup, session);
        if (list != null && !list.isEmpty()) {
            for (Discount discount : list) {
                List<MenuGroup> list2 = discount.getMenuGroups();
                list2.remove(menuGroup);
                discountDAO.saveOrUpdate(discount, session);
            }
        }
    }

    public void initialize(MenuGroup menuGroup) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuGroup);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGroupsForGroupView(OrderType orderType, MenuCategory menuCategory, PaginatedListModel paginatedListModel) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            Disjunction disjunction = Restrictions.disjunction();
            DetachedCriteria detachedCriteria = DetachedCriteria.forClass(MenuItem.class);
            detachedCriteria.setProjection(Projections.distinct((Projection)Property.forName((String)MenuItem.PROP_MENU_GROUP_ID)));
            disjunction.add(Property.forName((String)MenuGroup.PROP_ID).in(detachedCriteria));
            DetachedCriteria detachedCriteria2 = DetachedCriteria.forClass(MenuPage.class);
            detachedCriteria2.setProjection(Projections.distinct((Projection)Property.forName((String)MenuPage.PROP_MENU_GROUP_ID)));
            Disjunction disjunction2 = Restrictions.disjunction();
            Criterion criterion = Restrictions.isNull((String)MenuPage.PROP_ORDER_TYPE_ID);
            SimpleExpression simpleExpression = Restrictions.eq((String)MenuPage.PROP_ORDER_TYPE_ID, (Object)orderType.getId());
            disjunction2.add(criterion);
            disjunction2.add((Criterion)simpleExpression);
            detachedCriteria2.add((Criterion)disjunction2);
            disjunction.add(Property.forName((String)MenuGroup.PROP_ID).in(detachedCriteria2));
            criteria.add((Criterion)disjunction);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            paginatedListModel.setNumRows(list.size());
            paginatedListModel.setPageSize(paginatedListModel.getNumRows());
            paginatedListModel.setData(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuGroup> loadActiveGroupsByOrderType(OrderType orderType) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            List<MenuCategory> list = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuCategory menuCategory : list) {
                arrayList.add(menuCategory.getId());
            }
            if (!arrayList.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuGroup.PROP_MENU_CATEGORY_ID, arrayList));
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = criteria.list();
            return list2;
        }
    }

    public List<MenuGroup> findEnabledByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<String> findEnabledGroupsIdsByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)MenuGroup.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuGroup> findByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Terminal terminal, MenuGroup menuGroup, OrderType orderType) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuItem.class);
            criteria.add(Restrictions.eqOrIsNull((String)MenuItem.PROP_DELETED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number.intValue() > 0;
            return bl;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            throw new PosException("");
        }
    }

    public void releaseParent(List<MenuGroup> list) {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (MenuGroup menuGroup : list) {
                menuGroup.setMenuCategoryId(null);
                session.saveOrUpdate((Object)menuGroup);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public void releaseParentAndDelete(MenuGroup menuGroup) {
        if (menuGroup == null) {
            return;
        }
        this.initialize(menuGroup);
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string = "delete from MENUGROUP_DISCOUNT where MENUGROUP_ID='%s'";
            string = String.format(string, menuGroup.getId());
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.executeUpdate();
            String string2 = "update MENU_ITEM set GROUP_ID=null where GROUP_ID='%s'";
            string2 = String.format(string2, menuGroup.getId());
            SQLQuery sQLQuery2 = session.createSQLQuery(string2);
            sQLQuery2.executeUpdate();
            session.delete((Object)menuGroup);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public boolean existsMenuGroups(MenuCategory menuCategory) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            Number number;
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuGroups(PaginationSupport paginationSupport, String string, MenuCategory menuCategory, String ... stringArray) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuGroup.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuGroup.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME));
            if (stringArray != null && stringArray.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String string2 : stringArray) {
                    projectionList.add((Projection)Projections.property((String)string2), string2);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuGroup.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuGroup> findGroupsWithInventoryItems() throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_MENU_GROUP_ID));
            List list = criteria.list();
            criteria = session.createCriteria(MenuGroup.class);
            if (!list.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuGroup.PROP_ID, (Collection)list));
            }
            List list2 = criteria.list();
            return list2;
        }
    }

    public MenuGroup findMenuGroupByName(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_NAME, (Object)string).ignoreCase());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuGroup menuGroup = (MenuGroup)list.get(0);
                return menuGroup;
            }
            MenuGroup menuGroup = null;
            return menuGroup;
        }
    }

    public List<MenuGroup> findAllUnSyncMenuGroup() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            SimpleExpression simpleExpression = Restrictions.eq((String)MenuGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)MenuGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateMenuGroups(List<MenuGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (MenuGroup menuGroup : list) {
                MenuGroup menuGroup2 = this.get(menuGroup.getId());
                if (menuGroup2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(menuGroup.getLastUpdateTime(), menuGroup2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), menuGroup.getName() + " already updated");
                        continue;
                    }
                    String string = menuGroup2.getId();
                    long l = menuGroup2.getVersion();
                    List<MenuPage> list2 = menuGroup2.getMenuPages();
                    PropertyUtils.copyProperties((Object)menuGroup2, (Object)menuGroup);
                    menuGroup2.setId(string);
                    menuGroup2.setVersion(l);
                    menuGroup2.setMenuPages(list2);
                    menuGroup2.setUpdateLastUpdateTime(bl);
                    menuGroup2.setUpdateSyncTime(bl2);
                    this.update(menuGroup2, session);
                    continue;
                }
                menuGroup.setUpdateLastUpdateTime(bl);
                menuGroup.setUpdateSyncTime(bl2);
                this.save(menuGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public List<MenuGroup> findByCategoryId(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)string));
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME).ignoreCase());
            List list = criteria.list();
            return list;
        }
    }

    public void findGroups(PaginationSupport paginationSupport, String string, MenuCategory menuCategory) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuGroup.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuGroup.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            paginationSupport.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME).ignoreCase());
            paginationSupport.setRows(criteria.list());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MenuGroup findOrCreateGroupByName(String string, String string2, String string3) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            MenuGroup menuGroup = this.findMenuGroupByName(string, true, session);
            if (menuGroup == null) {
                menuGroup = new MenuGroup();
                menuGroup.setName(string);
                menuGroup.setMenuCategoryId(string2);
                menuGroup.setMenuCategoryName(string3);
                menuGroup.setVisible(true);
                transaction = session.beginTransaction();
                MenuGroupDAO.getInstance().save(menuGroup, session);
                transaction.commit();
            }
            MenuGroup menuGroup2 = menuGroup;
            return menuGroup2;
        }
        catch (Exception exception) {
            if (transaction == null) throw exception;
            transaction.rollback();
            throw exception;
        }
    }

    public MenuGroup findMenuGroupByName(String string, boolean bl, Session session) {
        List list;
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_NAME, (Object)string).ignoreCase());
        if (bl) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        }
        if ((list = criteria.list()) != null && !list.isEmpty()) {
            return (MenuGroup)list.get(0);
        }
        return null;
    }

    public MenuGroup createMenuGroup(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            GenericDAO.getInstance().checkIdOrNameExists(null, string, MenuGroup.class);
        }
        catch (DuplicateDataException duplicateDataException) {
            String string2 = String.format(Messages.getString("SAME_NAME_WARRING"), Messages.getString("DataImportAction.8"));
            String string3 = Messages.getString("WARNING");
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string2, string3, Messages.getString("YES"), Messages.getString("NO"));
            if (n != 0) {
                throw new PosException(duplicateDataException.getMessage());
            }
            MenuGroup menuGroup = new MenuGroup();
            menuGroup.setName(string);
            menuGroup.setVisible(Boolean.TRUE);
            this.saveOrUpdate(menuGroup);
            return menuGroup;
        }
        MenuGroup menuGroup = new MenuGroup();
        menuGroup.setName(string);
        menuGroup.setVisible(Boolean.TRUE);
        this.saveOrUpdate(menuGroup);
        return menuGroup;
    }

    public void saveOrUpdate(List<MenuGroup> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                MenuGroup menuGroup = list.get(i);
                menuGroup.setSortOrder(i);
                this.saveOrUpdate(menuGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            PosLog.error(this.getClass(), exception);
        }
    }

    public int getNextSortOrder(String string, Session session) {
        Criteria criteria = session.createCriteria(MenuGroup.class);
        if (StringUtils.isNotBlank((String)string)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)string));
        }
        this.addDeletedFilter(criteria);
        criteria.setProjection((Projection)Property.forName((String)MenuGroup.PROP_ID));
        return this.rowCount(criteria);
    }
}

