/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.dao.BasePackagingUnitDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PackagingUnitDAO
extends BasePackagingUnitDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveOrUpdateInventoryStockUnits(List<PackagingUnit> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (PackagingUnit packagingUnit : list) {
                PackagingUnit packagingUnit2 = this.get(packagingUnit.getId());
                if (packagingUnit2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(packagingUnit.getLastUpdateTime(), packagingUnit2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), packagingUnit.getName() + " already updated");
                        continue;
                    }
                    long l = packagingUnit2.getVersion();
                    PropertyUtils.copyProperties((Object)packagingUnit2, (Object)packagingUnit);
                    packagingUnit2.setVersion(l);
                    packagingUnit2.setUpdateLastUpdateTime(bl);
                    packagingUnit2.setUpdateSyncTime(bl2);
                    this.update(packagingUnit2, session);
                    continue;
                }
                packagingUnit.setUpdateLastUpdateTime(bl);
                packagingUnit.setUpdateSyncTime(bl2);
                this.save(packagingUnit, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

