/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.dao.BasePriceTableItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.ui.model.PriceTableItemSelectionView;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class PriceTableItemDAO
extends BasePriceTableItemDAO {
    @Override
    public List<PriceTableItem> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof PriceTableItem) {
            PriceTableItem priceTableItem = (PriceTableItem)object;
            priceTableItem.setDeleted(Boolean.TRUE);
            super.update(priceTableItem, session);
        } else {
            super.delete(object, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PriceTableItem getItem(PriceTable priceTable, MenuItem menuItem) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Object)priceTable.getId()));
            this.addDeletedFilter(criteria);
            PriceTableItem priceTableItem = (PriceTableItem)criteria.uniqueResult();
            return priceTableItem;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PriceTableItem getItemById(String string, MenuItem menuItem) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Object)string));
            this.addDeletedFilter(criteria);
            PriceTableItem priceTableItem = (PriceTableItem)criteria.uniqueResult();
            return priceTableItem;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public PriceTableItem getPriceTableItemByMenuItemId(String string) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)string));
            this.addDeletedFilter(criteria);
            PriceTableItem priceTableItem = (PriceTableItem)criteria.uniqueResult();
            return priceTableItem;
        }
    }

    public List<PriceTableItem> getPriceTableItemsByMenuItemId(String string, Session session) throws PosException {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)string));
        this.addDeletedFilter(criteria);
        return criteria.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(PriceTable priceTable) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Object)priceTable.getId()));
            this.addDeletedFilter(criteria);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(PriceTable priceTable, PaginatedListModel paginatedListModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Object)priceTable.getId()));
            this.addDeletedFilter(criteria);
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            paginatedListModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<PriceTableItem> getItemsByPriceTable(PriceTable priceTable) {
        return this.getItemsByPriceTable(priceTable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PriceTableItem> getItemsByPriceTable(PriceTable priceTable, boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Object)priceTable.getId()));
            if (!bl) {
                this.addDeletedFilter(criteria);
            }
            List list = criteria.list();
            for (PriceTableItem priceTableItem : list) {
                MenuItem menuItem = MenuItemDAO.getInstance().get(priceTableItem.getMenuItemId());
                priceTableItem.setItemName(menuItem.getName());
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PriceTableItem getItemByPriceTableId(String string, MenuItem menuItem) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Object)string));
            criteria.addOrder(Order.desc((String)PriceTableItem.PROP_LAST_UPDATE_TIME));
            criteria.setMaxResults(1);
            PriceTableItem priceTableItem = (PriceTableItem)criteria.uniqueResult();
            return priceTableItem;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void getItemsByPriceTable(PriceTable priceTable, PriceTableItemSelectionView.PriceTableItemTableModel priceTableItemTableModel) {
        this.getItemsByPriceTable(priceTable, priceTableItemTableModel, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getItemsByPriceTable(PriceTable priceTable, PriceTableItemSelectionView.PriceTableItemTableModel priceTableItemTableModel, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(PriceTableItem.class);
            criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Object)priceTable.getId()));
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)string)) {
                object = Restrictions.disjunction();
                DetachedCriteria detachedCriteria = DetachedCriteria.forClass(MenuItem.class);
                detachedCriteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
                detachedCriteria.setProjection(Projections.distinct((Projection)Property.forName((String)MenuItem.PROP_ID)));
                object.add(Property.forName((String)PriceTableItem.PROP_MENU_ITEM_ID).in(detachedCriteria));
                object.add(Restrictions.ilike((String)PriceTableItem.PROP_ITEM_BARCODE, (String)string, (MatchMode)MatchMode.START));
                criteria.add((Criterion)object);
            }
            priceTableItemTableModel.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(priceTableItemTableModel.getCurrentRowIndex());
            criteria.setMaxResults(priceTableItemTableModel.getPageSize());
            object = criteria.list();
            priceTableItemTableModel.setRows(object);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateItems(PriceTable priceTable, List<PriceTableItem> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            PriceTableDAO.getInstance().saveOrUpdate(priceTable);
            for (PriceTableItem priceTableItem : list) {
                priceTableItem.setPriceTableId(priceTable.getId());
                PriceTableItemDAO.getInstance().saveOrUpdate(priceTableItem, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

