/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.PurchaseTransaction;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.base.BasePurchaseOrderItem;
import com.floreantpos.model.dao.BasePurchaseOrderDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.PurchaseOrderItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.InventoryService;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class PurchaseOrderDAO
extends BasePurchaseOrderDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof PurchaseOrder) {
            PurchaseOrder purchaseOrder = (PurchaseOrder)object;
            purchaseOrder.setDeleted(Boolean.TRUE);
            super.update(purchaseOrder, session);
        } else {
            super.delete(object, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(purchaseOrder, bl, session);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdateWithItemAvailBalance(PurchaseOrder purchaseOrder) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.updateAvailableUnit(purchaseOrder, session);
            transaction.commit();
        }
    }

    private void updateAvailableUnit(PurchaseOrder purchaseOrder, Session session) {
        List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
        if (list == null) {
            return;
        }
        for (PurchaseOrderItem purchaseOrderItem : list) {
            MenuItem menuItem = purchaseOrderItem.getMenuItem();
            Double d = purchaseOrderItem.getItemQuantity();
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d, true, false, session);
        }
        session.saveOrUpdate((Object)purchaseOrder);
    }

    public void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl, Session session) {
        if (purchaseOrder.getId() == null) {
            purchaseOrder.setCreatedDate(new Date());
            purchaseOrder.setStatus(0);
        }
        if (bl) {
            this.adjustInventoryItems(session, purchaseOrder);
        }
        session.saveOrUpdate((Object)purchaseOrder);
    }

    public void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl, boolean bl2) {
        this.saveOrUpdate(purchaseOrder, bl, bl2, false);
    }

    public void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl, boolean bl2, boolean bl3) {
        try (Session session = this.createNewSession();){
            Transaction transaction = session.beginTransaction();
            if (purchaseOrder.getId() == null) {
                if (purchaseOrder.getCreatedDate() == null) {
                    purchaseOrder.setCreatedDate(new Date());
                }
                purchaseOrder.setStatus(0);
            }
            if (bl) {
                List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
                if (list != null) {
                    HashMap hashMap = new HashMap();
                    list.forEach(purchaseOrderItem -> {
                        MenuItem menuItem = (MenuItem)hashMap.get(purchaseOrderItem.getMenuItemId());
                        if (menuItem == null && (menuItem = MenuItemDAO.getInstance().get(purchaseOrderItem.getMenuItemId(), session)) != null) {
                            MenuItemDAO.getInstance().initialize(menuItem, session);
                            hashMap.put(menuItem.getId(), menuItem);
                        }
                        purchaseOrderItem.setMenuItem(menuItem);
                        IUnit iUnit = DataProvider.get().getUnitById(purchaseOrderItem.getUnitId(), purchaseOrderItem.getUnitType());
                        InventoryUnit inventoryUnit = null;
                        if (iUnit instanceof InventoryUnit) {
                            inventoryUnit = (InventoryUnit)iUnit;
                        }
                        InventoryService.getInstance().adjustMenuItemCost(menuItem, purchaseOrderItem.getUnitPrice(), purchaseOrderItem.getItemQuantity(), inventoryUnit, session);
                    });
                    if (hashMap.size() > 0) {
                        for (MenuItem menuItem : hashMap.values()) {
                            MenuItemDAO.getInstance().saveOrUpdate(menuItem, session);
                        }
                    }
                }
                this.adjustInventoryItems(session, purchaseOrder, bl2, bl3);
            }
            session.saveOrUpdate((Object)purchaseOrder);
            transaction.commit();
        }
    }

    private void adjustInventoryItems(Session session, PurchaseOrder purchaseOrder) {
        this.adjustInventoryItems(session, purchaseOrder, true);
    }

    private void adjustInventoryItems(Session session, PurchaseOrder purchaseOrder, boolean bl) {
        this.adjustInventoryItems(session, purchaseOrder, bl, false);
    }

    private void adjustInventoryItems(Session session, PurchaseOrder purchaseOrder, boolean bl, boolean bl2) {
        List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
        if (list == null) {
            return;
        }
        boolean bl3 = true;
        for (PurchaseOrderItem purchaseOrderItem : list) {
            Double d = purchaseOrderItem.getQuantityToReceive();
            if (d == 0.0) continue;
            purchaseOrderItem.setQuantityReceived(purchaseOrderItem.getQuantityReceived() + d);
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            MenuItem menuItem = purchaseOrderItem.getMenuItem();
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setQuantity(d);
            inventoryTransaction.setBatchNumber(purchaseOrderItem.getBatchNumber());
            Double d2 = purchaseOrderItem.getUnitPrice();
            inventoryTransaction.setUnitCost(d2);
            inventoryTransaction.setToInventoryLocation(purchaseOrder.getInventoryLocation());
            inventoryTransaction.setOutletId(purchaseOrder.getOutletId());
            inventoryTransaction.setTransactionDate(purchaseOrder.getReceivingDate());
            inventoryTransaction.setVendor(purchaseOrder.getVendor());
            inventoryTransaction.setUnitId(purchaseOrderItem.getUnitId());
            inventoryTransaction.setUnitType(purchaseOrderItem.getUnitType());
            inventoryTransaction.setTotal(inventoryTransaction.getQuantity() * d2);
            if (purchaseOrder.getType().equals(PurchaseOrder.DEBIT)) {
                inventoryTransaction.setReason("PURCHASE");
                inventoryTransaction.setTransactionType(InventoryTransactionType.IN);
            } else {
                inventoryTransaction.setReason("RETURN");
                inventoryTransaction.setTransactionType(InventoryTransactionType.OUT);
            }
            purchaseOrderItem.setDisplayUnit(DataProvider.get().getUnitById(purchaseOrderItem.getUnitId(), purchaseOrderItem.getUnitType()));
            InventoryTransactionDAO.getInstance().adjustInventoryStock(inventoryTransaction, session, bl, true, true, purchaseOrderItem);
            if (purchaseOrderItem.getQuantityReceived().doubleValue() != purchaseOrderItem.getItemQuantity().doubleValue()) {
                bl3 = false;
            }
            purchaseOrderItem.setQuantityToReceive(0.0);
        }
        if (NumberUtil.isZero(purchaseOrder.getDueAmount()) && (bl3 || bl2)) {
            purchaseOrder.setStatus(7);
        } else if (bl3 || bl2) {
            purchaseOrder.setStatus(4);
        } else {
            purchaseOrder.setStatus(5);
        }
    }

    public String getNextOrderSequenceNumber() {
        DecimalFormat decimalFormat = new DecimalFormat("10000");
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(PurchaseOrder.class);
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.not((Criterion)Restrictions.sqlRestriction((String)"ORDER_ID like '%\\_%' escape '\\'")));
            int n = this.rowCount(criteria);
            String string = decimalFormat.format(n + 1);
            while (this.exists(string, null)) {
                string = String.valueOf(Integer.valueOf(string) + 1);
            }
            String string2 = string;
            return string2;
        }
    }

    public boolean exists(String string, String string2) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        try (Session session = this.createNewSession();){
            Number number;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_ORDER_ID, (Object)string));
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)string2)) {
                criteria.add((Criterion)Restrictions.ne((String)PurchaseOrder.PROP_ID, (Object)string2));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findBy(PaginationSupport paginationSupport, String string, InventoryVendor inventoryVendor, Date date, Date date2) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)PurchaseOrder.PROP_ORDER_ID, (String)string.trim(), (MatchMode)MatchMode.START));
            }
            if (inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_VENDOR, (Object)inventoryVendor));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)PurchaseOrder.PROP_CREATED_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)PurchaseOrder.PROP_CREATED_DATE, (Object)date2));
            }
            paginationSupport.setNumRows(super.rowCount(criteria));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.desc((String)PurchaseOrder.PROP_CREATED_DATE));
            paginationSupport.setRows(criteria.list());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveOrUpdatePurchaseOrders(List<PurchaseOrder> list, boolean bl, boolean bl2) throws Exception {
        List list2;
        if (list == null) {
            return;
        }
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        try (Session session = this.createNewSession();){
            for (PurchaseOrder purchaseOrder : list) {
                PurchaseOrder purchaseOrder2 = PurchaseOrderDAO.getInstance().get(purchaseOrder.getId(), session);
                if (purchaseOrder2 == null) continue;
                hashMap.put(purchaseOrder.getId(), purchaseOrder);
                list2 = purchaseOrder2.getOrderItems();
                for (Object object : list2) {
                    hashMap.put(((BasePurchaseOrderItem)object).getId(), (Serializable)object);
                }
            }
        }
        session = null;
        var6_6 = this.createNewSession();
        Object object = null;
        try {
            for (PurchaseOrder purchaseOrder2 : list) {
                try {
                    session = var6_6.beginTransaction();
                    list2 = POSUtil.copyList(purchaseOrder2.getOrderItems());
                    POSUtil.clear(purchaseOrder2.getOrderItems());
                    purchaseOrder2.setUpdateLastUpdateTime(bl);
                    purchaseOrder2.setUpdateSyncTime(bl2);
                    PurchaseOrder purchaseOrder = (PurchaseOrder)hashMap.get(purchaseOrder2.getId());
                    if (purchaseOrder != null) {
                        if (!BaseDataServiceDao.get().shouldSave(purchaseOrder2.getLastUpdateTime(), purchaseOrder.getLastUpdateTime())) {
                            PosLog.debug(this.getClass(), purchaseOrder2.getId() + " already updated");
                            continue;
                        }
                        long l = purchaseOrder.getVersion();
                        purchaseOrder2.setVersion(l);
                    } else {
                        this.save(purchaseOrder2, (Session)var6_6);
                    }
                    for (PurchaseOrderItem purchaseOrderItem : list2) {
                        purchaseOrderItem.setPurchaseOrder(purchaseOrder2);
                        PurchaseOrderItem purchaseOrderItem2 = (PurchaseOrderItem)hashMap.get(purchaseOrderItem.getId());
                        if (purchaseOrderItem2 == null) {
                            purchaseOrderItem.setVersion(0L);
                            PurchaseOrderItemDAO.getInstance().save(purchaseOrderItem, (Session)var6_6);
                            continue;
                        }
                        purchaseOrderItem.setVersion(purchaseOrderItem2.getVersion());
                        PurchaseOrderItemDAO.getInstance().update(purchaseOrderItem, (Session)var6_6);
                    }
                    if (purchaseOrder2.getOrderItems() != null) {
                        purchaseOrder2.getOrderItems().addAll(list2);
                    } else {
                        purchaseOrder2.setOrderItems(list2);
                    }
                    this.update(purchaseOrder2, (Session)var6_6);
                    session.commit();
                }
                catch (Exception exception) {
                    PosLog.error(this.getReferenceClass(), "Error saving purchase order " + purchaseOrder2.getId());
                    if (session == null) throw exception;
                    session.rollback();
                    throw exception;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (var6_6 != null) {
                if (object != null) {
                    try {
                        var6_6.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    var6_6.close();
                }
            }
        }
    }

    public List<PurchaseOrder> getPurchaseOrderByInvLocation(InventoryLocation inventoryLocation, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_INVENTORY_LOCATION, (Object)inventoryLocation));
        criteria.add((Criterion)Restrictions.ne((String)PurchaseOrder.PROP_STATUS, (Object)4));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PurchaseOrder.PROP_ID), (String)PurchaseOrder.PROP_ID));
        this.addDeletedFilter(criteria);
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    public PurchaseOrder initializeData(String string) {
        try (Session session = this.createNewSession();){
            PurchaseOrder purchaseOrder = this.get(string, session);
            if (purchaseOrder.getOrderItems() != null) {
                for (PurchaseOrderItem purchaseOrderItem : purchaseOrder.getOrderItems()) {
                    MenuItem menuItem = purchaseOrderItem.getMenuItem();
                    if (!menuItem.isVariant().booleanValue()) continue;
                    MenuItem menuItem2 = menuItem.getParentMenuItem();
                    MenuItemDAO.getInstance().initializeUnits(menuItem2);
                }
            }
            PurchaseOrder purchaseOrder2 = purchaseOrder;
            return purchaseOrder2;
        }
    }

    public PurchaseOrder saveAndGetBackOrder(boolean bl, PurchaseOrder purchaseOrder) {
        try (Session session = this.createNewSession();){
            Object object;
            Transaction transaction = session.beginTransaction();
            List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
            PurchaseOrder purchaseOrder2 = null;
            if (bl) {
                purchaseOrder2 = (PurchaseOrder)SerializationUtils.clone((Serializable)purchaseOrder);
                purchaseOrder2.setId(null);
                purchaseOrder2.setVersion(0L);
                purchaseOrder2.setOrderItems(null);
                purchaseOrder2.setReceivingDate(null);
                purchaseOrder2.setProperties(null);
                for (PurchaseOrderItem serializable2 : list) {
                    PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)SerializationUtils.clone((Serializable)serializable2);
                    if (purchaseOrderItem.getItemQuantity() == 0.0) continue;
                    double d = purchaseOrderItem.getQuantityReceived() + purchaseOrderItem.getQuantityToReceive();
                    double d2 = Math.abs(purchaseOrderItem.getItemQuantity() - d);
                    if (d2 == 0.0) continue;
                    purchaseOrderItem.setItemQuantity(d2);
                    purchaseOrderItem.setId(null);
                    purchaseOrderItem.setVersion(0L);
                    purchaseOrderItem.setPurchaseOrder(purchaseOrder2);
                    purchaseOrder2.addToorderItems(purchaseOrderItem);
                }
                purchaseOrder2.calculatePrice();
                object = purchaseOrder.getOrderId();
                if (StringUtils.isNotBlank((String)object)) {
                    purchaseOrder2.setOrderId(this.generateSubOrderNo((String)object));
                }
                purchaseOrder2.putBackOrderShortId(purchaseOrder.getOrderId());
                purchaseOrder2.putBackOrderLongId(purchaseOrder.getId());
                this.save(purchaseOrder2, session);
            }
            for (PurchaseOrderItem purchaseOrderItem : list) {
                double d = purchaseOrderItem.getQuantityReceived() + purchaseOrderItem.getQuantityToReceive();
                purchaseOrderItem.setItemQuantity(d);
            }
            purchaseOrder.calculatePrice();
            if (purchaseOrder2 != null) {
                this.createPaymentTransaction(session, purchaseOrder, purchaseOrder2);
            }
            object = purchaseOrder.getTotalAmount();
            Double d = purchaseOrder.getPaidAmount();
            if (d > (Double)object) {
                purchaseOrder.setDueValue(0.0);
                purchaseOrder.putFullPaid(true);
                purchaseOrder.setPaidAmount(d - purchaseOrder2.getSubtotalAmount());
            }
            this.receivePurchaseOrders(session, purchaseOrder);
            transaction.commit();
            PurchaseOrder purchaseOrder3 = purchaseOrder2;
            return purchaseOrder3;
        }
    }

    private String generateSubOrderNo(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length > 1) {
            try {
                String string2 = stringArray[stringArray.length - 1];
                int n = Double.valueOf(string2).intValue() + 1;
                string = string.substring(0, string.lastIndexOf(string2));
                string = string + n;
            }
            catch (Exception exception) {
                string = string + "_1";
            }
        } else {
            string = string + "_1";
        }
        return PurchaseOrderDAO.getInstance().exists(string, null) ? this.generateSubOrderNo(string) : string;
    }

    public void receivePurchaseOrders(Session session, PurchaseOrder purchaseOrder) {
        InventoryVendorItemsDAO.getInstance().saveItems(purchaseOrder, session);
        PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, true, session);
    }

    public void createPaymentTransaction(Session session, PurchaseOrder purchaseOrder, PurchaseOrder purchaseOrder2) {
        double d = purchaseOrder.getPaidAmount();
        if (purchaseOrder.getTotalAmount() > d) {
            return;
        }
        PurchaseTransaction purchaseTransaction = new PurchaseTransaction();
        purchaseTransaction.setEntityId(purchaseOrder.getId());
        purchaseTransaction.setEntityNo(purchaseOrder.getOrderId());
        purchaseTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
        purchaseTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        purchaseTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        purchaseTransaction.setTransactionType(TransactionType.CARRY_OUT.name());
        purchaseTransaction.setPaymentType(PaymentType.CARRY_OUT);
        purchaseTransaction.setAmount(-1.0 * (d - purchaseOrder.getTotalAmount()));
        purchaseTransaction.setEntityType("Purchase_order".toString());
        PurchaseTransaction purchaseTransaction2 = new PurchaseTransaction();
        purchaseTransaction2.setEntityId(purchaseOrder2.getId());
        purchaseTransaction2.setEntityNo(purchaseOrder2.getOrderId());
        purchaseTransaction2.putOriginPurchaseOrderId(purchaseOrder.getId());
        purchaseTransaction2.setOutletId(DataProvider.get().getCurrentOutletId());
        purchaseTransaction2.setTerminal(DataProvider.get().getCurrentTerminal());
        purchaseTransaction2.setTransactionTime(StoreDAO.getServerTimestamp());
        purchaseTransaction2.setTransactionType(TransactionType.CARRY_OVER.name());
        purchaseTransaction2.setPaymentType(PaymentType.CARRY_OVER);
        purchaseTransaction2.setAmount(d - purchaseOrder.getTotalAmount());
        purchaseTransaction2.setEntityType("Purchase_order".toString());
        double d2 = purchaseOrder2.getDueValue() - purchaseTransaction2.getAmount();
        purchaseOrder2.setDueValue(d2 < 0.0 ? 0.0 : d2);
        purchaseOrder2.setPaidAmount(purchaseTransaction2.getAmount());
        this.update(purchaseOrder2, session);
        PosTransactionDAO.getInstance().save(purchaseTransaction, session);
        PosTransactionDAO.getInstance().save(purchaseTransaction2, session);
    }
}

