/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Department;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseSalesAreaDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SalesAreaDAO
extends BaseSalesAreaDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        SalesArea salesArea = (SalesArea)object;
        if (salesArea == null) {
            throw new PosException(Messages.getString("SalesAreaDAO.0"));
        }
        this.checkForeignRelation(salesArea);
        salesArea.setDeleted(Boolean.TRUE);
        this.update(salesArea, session);
    }

    private void checkForeignRelation(SalesArea salesArea) throws PosException {
        String string = salesArea.getId();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Object object = this.createNewSession();
        Object object2 = null;
        try {
            GenericDAO genericDAO = GenericDAO.getInstance();
            this.append(genericDAO.getForeignDataListNames((Session)object, OrderType.class, OrderType.PROP_SALES_AREA_ID, string), Messages.getString("SalesAreaDAO.1"), stringBuilder, stringBuilder2);
            this.append(genericDAO.getForeignDataListNames((Session)object, PriceRule.class, PriceRule.PROP_SALES_AREA_ID, string), Messages.getString("SalesAreaDAO.2"), stringBuilder, stringBuilder2);
            this.append(genericDAO.getForeignDataListNames((Session)object, ShopTable.class, ShopTable.PROP_SALES_AREA_ID, string), Messages.getString("SalesAreaDAO.3"), stringBuilder, stringBuilder2);
            this.append(genericDAO.getForeignDataListNames((Session)object, Terminal.class, Terminal.PROP_SALES_AREA_ID, string), Messages.getString("SalesAreaDAO.4"), stringBuilder, stringBuilder2);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    object.close();
                }
            }
        }
        object = stringBuilder2.toString();
        if (StringUtils.isNotBlank((String)object)) {
            object2 = stringBuilder.toString();
            if (((String)object2).endsWith(", ")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
            }
            throw new PosException(Messages.getString("SalesAreaDAO.6") + (String)object2 + Messages.getString("SalesAreaDAO.7") + (String)object2 + ".", (String)object);
        }
    }

    private void append(List<String> list, String string, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (list == null || list.isEmpty()) {
            return;
        }
        stringBuilder2.append(Messages.getString("SalesAreaDAO.9") + string + ":");
        stringBuilder.append(string + ", ");
        int n = 1;
        for (String string2 : list) {
            stringBuilder2.append("\n" + n + ". " + string2);
            ++n;
        }
        stringBuilder2.append("\n");
    }

    @Override
    public List<SalesArea> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SalesArea> findSalesAreaByDept(Department department) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)SalesArea.PROP_DEPARTMENT_ID, (Object)department.getId()));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesArea findById(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)SalesArea.PROP_ID, (Object)string));
            this.addDeletedFilter(criteria);
            SalesArea salesArea = (SalesArea)criteria.uniqueResult();
            return salesArea;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesArea find(SalesArea salesArea) {
        Session session = null;
        try {
            if (salesArea == null) {
                SalesArea salesArea2 = null;
                return salesArea2;
            }
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)SalesArea.PROP_ID, (Object)salesArea.getId()));
            this.addDeletedFilter(criteria);
            SalesArea salesArea3 = (SalesArea)criteria.uniqueResult();
            return salesArea3;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesArea findByName(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)SalesArea.PROP_NAME, (Object)string));
            this.addDeletedFilter(criteria);
            SalesArea salesArea = (SalesArea)criteria.uniqueResult();
            return salesArea;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateSalesArea(List<SalesArea> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (SalesArea salesArea : list) {
                SalesAreaDAO salesAreaDAO = SalesAreaDAO.getInstance();
                SalesArea salesArea2 = salesAreaDAO.get(salesArea.getId());
                if (salesArea2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(salesArea.getLastUpdateTime(), salesArea2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), salesArea.getName() + " already updated");
                        continue;
                    }
                    long l = salesArea2.getVersion();
                    PropertyUtils.copyProperties((Object)salesArea2, (Object)salesArea);
                    salesArea2.setVersion(l);
                    salesArea2.setUpdateLastUpdateTime(bl);
                    salesArea2.setUpdateSyncTime(bl2);
                    salesAreaDAO.update(salesArea2);
                    continue;
                }
                salesArea.setVersion(0L);
                salesArea.setUpdateLastUpdateTime(bl);
                salesArea.setUpdateSyncTime(bl2);
                salesAreaDAO.save(salesArea);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

