/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketIdSequence;
import com.floreantpos.model.dao.BaseSequenceNumberDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SequenceNumberDAO
extends BaseSequenceNumberDAO {
    public int getNextSequenceNumber(String string, Session session) {
        SequenceNumber sequenceNumber = this.get(string, session);
        if (sequenceNumber == null) {
            sequenceNumber = new SequenceNumber(string, 1);
        }
        Date date = sequenceNumber.getLastUpdateTime();
        if (string == "TICKET_SEQUENCE_NUMBER" && date != null) {
            TicketIdSequence ticketIdSequence = DataProvider.get().getTicketIdGeneratorFormat();
            if (ticketIdSequence == TicketIdSequence.DateWithNumber) {
                if (!DateUtil.isToday(date)) {
                    int n = this.getNextIdSequence(ticketIdSequence);
                    sequenceNumber.setNextSequenceNumber(n);
                }
            } else if (ticketIdSequence == TicketIdSequence.WeekWithNumber && !DateUtil.isSameWeekOfYear(date)) {
                int n = this.getNextIdSequence(ticketIdSequence);
                sequenceNumber.setNextSequenceNumber(n);
            }
        }
        int n = sequenceNumber.getNextSequenceNumber();
        sequenceNumber.setNextSequenceNumber(n + 1);
        session.saveOrUpdate((Object)sequenceNumber);
        return n;
    }

    public void resetAll(Session session) {
        List list = this.findAll(session);
        if (list == null) {
            return;
        }
        for (SequenceNumber sequenceNumber : list) {
            sequenceNumber.setNextSequenceNumber(0);
            session.saveOrUpdate((Object)sequenceNumber);
        }
    }

    public int getNextIdSequence(TicketIdSequence ticketIdSequence) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(Ticket.class);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtil.startOfDay(calendar.getTime()));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)calendar.getTime()));
            if (ticketIdSequence == TicketIdSequence.DateWithNumber) {
                calendar.add(5, 1);
            } else if (ticketIdSequence == TicketIdSequence.WeekWithNumber) {
                calendar.add(3, 1);
            }
            criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)calendar.getTime()));
            criteria.setProjection((Projection)Projections.count((String)Ticket.PROP_ID));
            Number number = (Number)criteria.uniqueResult();
            if (number == null) {
                int n = 1;
                return n;
            }
            int n = number.intValue() + 1;
            return n;
        }
    }
}

