/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseStoreSessionDAO;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StoreSessionDAO
extends BaseStoreSessionDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStoreSession(PaginationSupport paginationSupport) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(StoreSession.class);
            criteria.addOrder(Order.asc((String)StoreSession.PROP_ID));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> findSessions(Date date, Date date2) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)date), (Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)date2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME), (Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_CLOSE_TIME, (Object)date), (Criterion)Restrictions.le((String)StoreSession.PROP_CLOSE_TIME, (Object)date2))));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> findSessions(Outlet outlet, Date date, Date date2) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)date), (Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)date2)));
            if (outlet != null) {
                criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
            }
            List list = criteria.list();
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_CLOSE_TIME, (Object)date), (Criterion)Restrictions.le((String)StoreSession.PROP_CLOSE_TIME, (Object)date2)));
            List list2 = criteria.list();
            if (!list2.isEmpty()) {
                for (StoreSession storeSession : list2) {
                    if (list.contains(storeSession)) continue;
                    list.add(storeSession);
                }
            }
            List list3 = list;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreSession findOpenSession(Outlet outlet) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME));
            if (outlet != null) {
                criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
            }
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            List list = criteria.list();
            if (list != null) {
                StoreSession storeSession = (StoreSession)list.get(0);
                return storeSession;
            }
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public Integer getStoreSessionTotalGuest(StoreSession storeSession) {
        if (storeSession == null) {
            return 0;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
            Long l = (Long)criteria.uniqueResult();
            if (l != null) {
                Integer n = l.intValue();
                return n;
            }
            Integer n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> getTransactionsByOutlet(Date date, Date date2, Outlet outlet, Pagination pagination) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, date, date2, outlet);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, date, date2, outlet);
            if (pagination != null) {
                object = (Number)criteria.uniqueResult();
                pagination.setNumRows(((Number)object).intValue());
            }
            object = list;
            return object;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(Criteria criteria, Date date, Date date2, Outlet outlet) {
        if (date != null) {
            criteria.add((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)date));
        }
        if (date2 != null) {
            criteria.add((Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)date2));
        }
        if (outlet != null) {
            criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
        }
    }

    public void saveOrUpdateStoreSessions(List<StoreSession> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (StoreSession storeSession : list) {
                StoreSession storeSession2 = this.get(storeSession.getId());
                String string = storeSession.getClosedByUserId();
                if (storeSession2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(storeSession.getLastUpdateTime(), storeSession2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), storeSession.getId() + " already updated");
                        continue;
                    }
                    long l = storeSession2.getVersion();
                    PropertyUtils.copyProperties((Object)storeSession2, (Object)storeSession);
                    if (string != null) {
                        storeSession2.setClosedByUserId(string);
                    }
                    storeSession2.setVersion(l);
                    storeSession2.setUpdateLastUpdateTime(bl);
                    storeSession2.setUpdateSyncTime(bl2);
                    this.update(storeSession2, session);
                    continue;
                }
                storeSession.setUpdateLastUpdateTime(bl);
                storeSession.setUpdateSyncTime(bl2);
                this.save(storeSession, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public StoreSession getLastOpenSession() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME));
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            criteria.setMaxResults(1);
            StoreSession storeSession = (StoreSession)criteria.uniqueResult();
            return storeSession;
        }
    }

    public StoreSession getLastStoreSession() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            criteria.setMaxResults(1);
            StoreSession storeSession = (StoreSession)criteria.uniqueResult();
            return storeSession;
        }
    }
}

