/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.BaseTerminalTypeDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.teminaltype.TerminalCategory;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class TerminalTypeDAO
extends BaseTerminalTypeDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof TerminalType) {
            String string;
            TerminalType terminalType = (TerminalType)object;
            List<Terminal> list = TerminalDAO.getInstance().getTerminalsByTerminalType(terminalType, session);
            String string2 = Messages.getString("TerminalTypeDAO.4");
            StringBuilder stringBuilder = new StringBuilder();
            if (list != null && !list.isEmpty()) {
                stringBuilder.append(this.constructExceptionDetailsByTerminal(terminalType, list));
            }
            if (StringUtils.isNotBlank((String)(string = stringBuilder.toString()))) {
                throw new PosException(string2, string);
            }
            if (terminalType.getCategories() != null) {
                terminalType.getCategories().clear();
            }
            if (terminalType.getOrderTypes() != null) {
                terminalType.getOrderTypes().clear();
            }
            terminalType.setDeleted(Boolean.TRUE);
            super.update(terminalType, session);
        } else {
            super.delete(object, session);
        }
    }

    private String constructExceptionDetailsByOrderType(TerminalType terminalType, List<OrderType> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(terminalType.getName() + EMPTY_SPACE_STRING + Messages.getString("TerminalTypeDAO.5"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return EMPTY_STRING;
    }

    private String constructExceptionDetailsByTerminal(TerminalType terminalType, List<Terminal> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(terminalType.getName() + EMPTY_SPACE_STRING + Messages.getString("TerminalTypeDAO.6"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    public List<TerminalType> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void initialize(TerminalType terminalType) {
        if (terminalType == null || terminalType.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(terminalType.getOrderTypes()) && Hibernate.isInitialized(terminalType.getCategories())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)terminalType);
            Hibernate.initialize(terminalType.getOrderTypes());
            Hibernate.initialize(terminalType.getCategories());
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean nameExists(TerminalType terminalType, String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)TerminalType.PROP_NAME, (Object)string).ignoreCase());
            if (terminalType.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)TerminalType.PROP_ID, (Object)terminalType.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
    }

    public TerminalType getTerminalType(TerminalCategory terminalCategory) {
        Object object;
        if (terminalCategory == null) {
            object = Application.getInstance().getTerminal().getTerminalType();
            if (object != null) {
                return object;
            }
            terminalCategory = TerminalCategory.REGULAR;
        }
        object = this.createNewSession();
        Throwable throwable = null;
        try {
            Criteria criteria = object.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)TerminalType.PROP_TYPE, (Object)terminalCategory.getType()));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                TerminalType terminalType = (TerminalType)list.get(0);
                return terminalType;
            }
            TerminalType terminalType = null;
            return terminalType;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    object.close();
                }
            }
        }
    }

    public void saveOrUpdateTerminalTypes(List list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (TerminalType terminalType : list) {
                TerminalTypeDAO terminalTypeDAO = TerminalTypeDAO.getInstance();
                TerminalType terminalType2 = terminalTypeDAO.get(terminalType.getId());
                if (terminalType2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(terminalType.getLastUpdateTime(), terminalType2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), terminalType.getName() + " already updated");
                        continue;
                    }
                    long l = terminalType2.getVersion();
                    PropertyUtils.copyProperties((Object)terminalType2, (Object)terminalType);
                    terminalType2.setVersion(l);
                    terminalType2.setUpdateLastUpdateTime(bl);
                    terminalType2.setUpdateSyncTime(bl2);
                    terminalTypeDAO.update(terminalType2);
                    continue;
                }
                terminalType.setUpdateLastUpdateTime(bl);
                terminalType.setUpdateSyncTime(bl2);
                terminalTypeDAO.save(terminalType);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

