/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao.util;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.Brand;
import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Department;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketIdSequence;
import com.floreantpos.model.UnitType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.BrandDAO;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GlobalConfigDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PackagingUnitDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.pricecalc.PriceRuleFactory;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DefaultDataInserter;
import com.floreantpos.util.NumberUtil;
import com.orocube.common.util.TerminalUtil;
import java.awt.Font;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;

public class PosCacheManager
extends DataProvider {
    protected Store store;
    protected Outlet outlet;
    protected Terminal terminal;
    private Currency mainCurrency;
    private PrinterGroup defaultPrinterGroup;
    private InventoryLocation defaultInLocation;
    private InventoryLocation defaultOutLocation;
    private Map<String, OrderType> orderTypes = null;
    private Map<String, UserType> userTypeMap = new LinkedHashMap<String, UserType>();
    private Map<String, Shift> shiftMap = new LinkedHashMap<String, Shift>();
    private Map<String, Currency> currencyMap = new LinkedHashMap<String, Currency>();
    private Map<String, TerminalType> terminalTypeMap = new LinkedHashMap<String, TerminalType>();
    private Map<String, Multiplier> multiplierMap = new LinkedHashMap<String, Multiplier>();
    private Map<String, Department> departmentMap = new LinkedHashMap<String, Department>();
    private Map<String, InventoryLocation> inventoryLocationMap = new LinkedHashMap<String, InventoryLocation>();
    private Map<String, InventoryUnit> inventoryUnitMap = new HashMap<String, InventoryUnit>();
    private Map<String, IUnit> inventoryUnitCodeMap = new HashMap<String, IUnit>();
    protected Map<String, TaxGroup> taxGroupMap = new HashMap<String, TaxGroup>();
    protected Map<String, Tax> taxMap = new HashMap<String, Tax>();
    private Map<String, PrinterGroup> printerGroupMap = new HashMap<String, PrinterGroup>();
    private Map<String, ReportGroup> reportGroupMap = new HashMap<String, ReportGroup>();
    private Map<String, Course> courseMap = new HashMap<String, Course>();
    private WeakHashMap<String, MenuItem> menuItemMap = new WeakHashMap();
    private WeakHashMap<String, ImageResource> imageResourceCache = new WeakHashMap();
    private WeakHashMap<String, String> brandNameMap = new WeakHashMap();
    private List<DayPart> daypartShifts;
    private List<PriceShift> priceShifts;
    private List<MenuShift> menuShifts;
    private List<Currency> currencyList;
    private List<ShopFloor> floors;
    private Map<Integer, Terminal> terminalMap = new LinkedHashMap<Integer, Terminal>();
    private Map<String, User> userMap = new LinkedHashMap<String, User>();
    private List<OrderType> orderTypeList;
    private List<Multiplier> multiplierList = new ArrayList<Multiplier>();
    private String defaultCourseId;
    private PosPrinters printers;
    private Font menuFont;
    private Font ticketViewFont;
    private Font categoryOrGroupViewFont;
    private Font kitchenReciptFont;
    private String ticketIdPrefix;
    private TicketIdSequence ticketIdGeneratorFormat;
    private DecimalFormat ticketIdSequenceFormat;
    private List<Class> cacheClasses;

    @Override
    public void initialize() {
        this.floors = null;
        this.menuFont = null;
        this.ticketViewFont = null;
        this.categoryOrGroupViewFont = null;
        this.kitchenReciptFont = null;
        this.terminalMap.clear();
        this.userMap.clear();
        this.multiplierList.clear();
        this.menuItemMap.clear();
        this.imageResourceCache.clear();
        this.clear(this.brandNameMap);
        this.loadStore();
        this.loadOutlet();
        this.initializeShifts();
        this.loadTerminalTypes();
        this.loadUserTypes();
        this.loadTerminal();
        this.loadOrderTypes();
        this.loadCurrencies();
        this.loadCourses();
        this.loadMultipliers();
        this.loadInventoryLocations();
        this.loadPrinterGroups();
        this.loadInventoryUnits();
        this.loadReportGroups();
        this.loadTaxGroups();
        this.loadTaxes();
        this.loadDepartments();
        this.loadPrinters();
        this.loadTicketPrefix();
        this.loadCacheClasses();
        NumberUtil.initializeNumberFormats();
        try {
            if (this.terminal.isEnableMenuItemFontNameAndSize() && StringUtils.isNotBlank((String)this.terminal.getMenuItemFontName())) {
                boolean bl = this.terminal.isEnableMenuItemFontBold();
                int n = bl ? 1 : 0;
                this.menuFont = new Font(this.terminal.getMenuItemFontName(), n, this.terminal.getMenuItemFontSize());
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        try {
            if (this.store.isEnableTicketViewFontNameAndSize() && StringUtils.isNotBlank((String)this.store.getTicketViewFontName())) {
                this.ticketViewFont = new Font(this.store.getTicketViewFontName(), 0, this.store.getTicketViewFontSize());
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        try {
            if (this.terminal.isEnableCategoryOrGroupFontNameAndSize() && StringUtils.isNotBlank((String)this.terminal.getCategoryOrGroupFontName())) {
                this.categoryOrGroupViewFont = new Font(this.terminal.getCategoryOrGroupFontName(), 0, this.terminal.getCategoryOrGroupFontSize());
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        try {
            if (this.store.isEnableKitchenItemFontNameAndSize() && StringUtils.isNotBlank((String)this.store.getKitchenItemFontName())) {
                this.kitchenReciptFont = new Font(this.store.getKitchenItemFontName(), 0, this.store.getKitchenItemFontSize());
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        this.fireCacheRefreshed();
    }

    private void loadCacheClasses() {
        if (this.cacheClasses == null) {
            this.cacheClasses = new ArrayList<Class>();
            this.cacheClasses.add(Store.class);
            this.cacheClasses.add(Shift.class);
            this.cacheClasses.add(MenuShift.class);
            this.cacheClasses.add(DayPart.class);
            this.cacheClasses.add(PriceShift.class);
            this.cacheClasses.add(TerminalType.class);
            this.cacheClasses.add(User.class);
            this.cacheClasses.add(UserType.class);
            this.cacheClasses.add(Terminal.class);
            this.cacheClasses.add(OrderType.class);
            this.cacheClasses.add(Currency.class);
            this.cacheClasses.add(Course.class);
            this.cacheClasses.add(Multiplier.class);
            this.cacheClasses.add(InventoryLocation.class);
            this.cacheClasses.add(InventoryUnit.class);
            this.cacheClasses.add(InventoryUnitGroup.class);
            this.cacheClasses.add(ReportGroup.class);
            this.cacheClasses.add(TaxGroup.class);
            this.cacheClasses.add(Tax.class);
            this.cacheClasses.add(Department.class);
            this.cacheClasses.add(TerminalPrinters.class);
            this.cacheClasses.add(PrinterGroup.class);
            this.cacheClasses.add(ImageResource.class);
            this.cacheClasses.add(ShopFloor.class);
        }
    }

    private void initializeShifts() {
        this.daypartShifts = new ArrayList<DayPart>();
        this.priceShifts = new ArrayList<PriceShift>();
        this.menuShifts = new ArrayList<MenuShift>();
        this.clear(this.shiftMap);
        List<Shift> list = ShiftDAO.getInstance().findAllActive();
        if (list != null && list.size() > 0) {
            for (Shift shift : list) {
                this.shiftMap.put(shift.getId(), shift);
                if (shift instanceof DayPart) {
                    this.daypartShifts.add((DayPart)shift);
                    continue;
                }
                if (shift instanceof PriceShift) {
                    this.priceShifts.add((PriceShift)shift);
                    continue;
                }
                if (!(shift instanceof MenuShift)) continue;
                this.menuShifts.add((MenuShift)shift);
            }
        }
    }

    private void loadMultipliers() {
        List<Multiplier> list = MultiplierDAO.getInstance().findAll();
        this.clear(this.multiplierMap);
        if (list != null && list.size() > 0) {
            for (Multiplier multiplier : list) {
                this.multiplierMap.put(multiplier.getId(), multiplier);
                this.multiplierList.add(multiplier);
            }
        }
    }

    private void loadTerminalTypes() {
        List<TerminalType> list = TerminalTypeDAO.getInstance().findAll();
        this.clear(this.terminalTypeMap);
        if (list != null && list.size() > 0) {
            for (TerminalType terminalType : list) {
                this.terminalTypeMap.put(terminalType.getId(), terminalType);
            }
        }
    }

    private void loadCurrencies() {
        List<Currency> list = CurrencyDAO.getInstance().findAll();
        this.clear(this.currencyMap);
        this.currencyList = new ArrayList<Currency>();
        this.mainCurrency = this.getOutlet().getCurrency();
        if (list != null && list.size() > 0) {
            for (Currency currency : list) {
                this.currencyMap.put(currency.getId(), currency);
                this.currencyList.add(currency);
                if (this.mainCurrency != null || !currency.isMain().booleanValue()) continue;
                this.mainCurrency = currency;
            }
        }
        if (this.mainCurrency == null && this.currencyList.size() > 0) {
            this.mainCurrency = this.currencyList.get(0);
            this.mainCurrency.setMain(true);
            CurrencyDAO.getInstance().update(this.mainCurrency);
        }
        if (this.mainCurrency == null) {
            Currency currency = new Currency();
            currency.setName("US Dollar");
            currency.setCode("USD");
            currency.setSymbol("$");
            currency.setExchangeRate(1.0);
            currency.setMain(true);
            this.mainCurrency = currency;
            CurrencyDAO.getInstance().save(currency);
        }
    }

    private void loadCourses() {
        List<Course> list = CourseDAO.getInstance().findAll();
        this.clear(this.courseMap);
        if (list != null && list.size() > 0) {
            this.defaultCourseId = list.get(0).getId();
            for (Course course : list) {
                this.courseMap.put(course.getId(), course);
            }
        }
    }

    private void loadUserTypes() {
        List<UserType> list = UserTypeDAO.getInstance().findAll();
        this.clear(this.userTypeMap);
        if (list != null && list.size() > 0) {
            for (UserType userType : list) {
                this.userTypeMap.put(userType.getId(), userType);
            }
        }
    }

    private void loadDepartments() {
        List<Department> list = DepartmentDAO.getInstance().findAll();
        this.clear(this.departmentMap);
        if (list != null && list.size() > 0) {
            for (Department department : list) {
                this.departmentMap.put(department.getId(), department);
            }
        }
    }

    public void loadCloudCacheData() {
        this.loadStore();
        this.loadTerminal();
        this.loadPrinterGroups();
    }

    @Override
    public void refreshStore() {
        this.loadStore();
    }

    @Override
    public void refreshCurrentTerminal() {
        TerminalDAO.getInstance().refresh(this.terminal);
    }

    private Outlet getDefaultOutlet() {
        OutletDAO outletDAO = OutletDAO.getInstance();
        String string = this.store.getDefaultOutletId();
        if (StringUtils.isNotBlank((String)string)) {
            return outletDAO.get(string);
        }
        try (Session session = outletDAO.createNewSession();){
            Criteria criteria = session.createCriteria(Outlet.class);
            criteria.setMaxResults(1);
            outletDAO.addDeletedFilter(criteria);
            Outlet outlet = (Outlet)criteria.uniqueResult();
            if (outlet != null) {
                this.store.setDefaultOutletId(outlet.getId());
                StoreDAO.getInstance().update(this.store);
                Outlet outlet2 = outlet;
                return outlet2;
            }
            outlet = new Outlet();
            outlet.setName("Main");
            outlet.setAddressLine1(this.store.getAddressLine1());
            outlet.setAddressLine2(this.store.getAddressLine2());
            outlet.setAddressLine3(this.store.getAddressLine3());
            outlet.setCountry(this.store.getCountry());
            outlet.setState(this.store.getState());
            outlet.setCity(this.store.getCity());
            outlet.setZipCode(this.store.getZipCode());
            outlet.setDateFormat(this.store.getDateFormat());
            outlet.setCurrency(this.getMainCurrency());
            outletDAO.save(outlet);
            this.store.setDefaultOutletId(outlet.getId());
            StoreDAO.getInstance().update(this.store);
            Outlet outlet3 = outlet;
            return outlet3;
        }
    }

    protected void loadStore() {
        this.store = StoreDAO.getRestaurant();
        if (this.store == null) {
            DefaultDataInserter.createStore(299);
            this.store = StoreDAO.getRestaurant();
        }
        AppConfig.put("store_uuid", this.store.getUuid());
    }

    @Override
    public void setStoreSession(StoreSession storeSession) {
    }

    @Override
    public StoreSession getStoreSession() {
        StoreSession storeSession = StoreSessionDAO.getInstance().getLastStoreSession();
        return storeSession;
    }

    private void loadOrderTypes() {
        this.orderTypes = new LinkedHashMap<String, OrderType>();
        this.orderTypeList = new ArrayList<OrderType>();
        List<OrderType> list = OrderTypeDAO.getInstance().findAll();
        if (list != null && list.size() > 0) {
            for (OrderType orderType : list) {
                this.orderTypes.put(orderType.getId(), orderType);
            }
        }
        if ((list = OrderTypeDAO.getInstance().findEnabledOrderTypesForTerminal(this.terminal)) != null && list.size() > 0) {
            for (OrderType orderType : list) {
                this.orderTypeList.add(orderType);
            }
        }
    }

    protected void loadTerminal() {
        try {
            String string = TerminalUtil.getSystemUID();
            TerminalDAO terminalDAO = TerminalDAO.getInstance();
            this.terminal = terminalDAO.getByTerminalKey(string);
            if (this.terminal == null) {
                this.terminal = terminalDAO.createNewTerminal(string, this.outlet);
            } else if (!string.equals(this.terminal.getTerminalKey())) {
                this.terminal = terminalDAO.createNewTerminal(string, this.outlet);
            }
            if (this.terminal.isDeleted().booleanValue()) {
                this.terminal.setDeleted(false);
                terminalDAO.update(this.terminal);
            }
            TerminalConfig.setTerminalId(this.terminal.toString());
            if (!this.outlet.equals(this.terminal.getOutlet())) {
                this.terminal.setOutlet(this.outlet);
                terminalDAO.update(this.terminal);
            }
        }
        catch (Exception exception) {
            throw new DatabaseConnectionException(exception);
        }
    }

    private void loadOutlet() {
        this.outlet = this.getDefaultOutlet();
    }

    protected void loadTaxGroups() {
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        this.clear(this.taxGroupMap);
        if (list != null && list.size() > 0) {
            for (TaxGroup taxGroup : list) {
                this.taxGroupMap.put(taxGroup.getId(), taxGroup);
            }
        }
    }

    protected void loadTaxes() {
        List<Tax> list = TaxDAO.getInstance().findAll();
        this.clear(this.taxMap);
        if (list != null && list.size() > 0) {
            for (Tax tax : list) {
                this.taxMap.put(tax.getId(), tax);
            }
        }
    }

    private void loadReportGroups() {
        List<ReportGroup> list = ReportGroupDAO.getInstance().findAll();
        this.clear(this.reportGroupMap);
        if (list != null && list.size() > 0) {
            for (ReportGroup reportGroup : list) {
                this.reportGroupMap.put(reportGroup.getId(), reportGroup);
            }
        }
    }

    private void loadInventoryUnits() {
        List<InventoryUnit> list = InventoryUnitDAO.getInstance().findAll();
        this.clear(this.inventoryUnitMap);
        this.clear(this.inventoryUnitCodeMap);
        if (list != null && list.size() > 0) {
            for (InventoryUnit inventoryUnit : list) {
                this.inventoryUnitMap.put(inventoryUnit.getId(), inventoryUnit);
                this.inventoryUnitCodeMap.put(inventoryUnit.getCode(), inventoryUnit);
            }
        }
    }

    private void loadPrinterGroups() {
        List<PrinterGroup> list = PrinterGroupDAO.getInstance().findAll();
        this.clear(this.printerGroupMap);
        if (list != null && list.size() > 0) {
            for (PrinterGroup printerGroup : list) {
                this.printerGroupMap.put(printerGroup.getId(), printerGroup);
                if (!printerGroup.isIsDefault()) continue;
                this.defaultPrinterGroup = printerGroup;
            }
        }
    }

    private void loadInventoryLocations() {
        this.defaultInLocation = null;
        this.defaultOutLocation = null;
        Terminal terminal = this.getCurrentTerminal();
        String string = terminal.getInventoryInLocationId();
        String string2 = terminal.getInventoryOutLocationId();
        if (StringUtils.isNotEmpty((String)string)) {
            this.defaultInLocation = InventoryLocationDAO.getInstance().get(string);
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            this.defaultOutLocation = InventoryLocationDAO.getInstance().get(string2);
        }
        List<InventoryLocation> list = InventoryLocationDAO.getInstance().findAll();
        this.clear(this.inventoryLocationMap);
        if (list != null && list.size() > 0) {
            for (InventoryLocation inventoryLocation : list) {
                this.inventoryLocationMap.put(inventoryLocation.getId(), inventoryLocation);
                if (this.defaultInLocation == null && inventoryLocation.isDefaultInLocation().booleanValue()) {
                    this.defaultInLocation = inventoryLocation;
                }
                if (this.defaultOutLocation != null || !inventoryLocation.isDefaultOutLocation().booleanValue()) continue;
                this.defaultOutLocation = inventoryLocation;
            }
        } else {
            InventoryLocation inventoryLocation = new InventoryLocation();
            inventoryLocation.setName("Store");
            inventoryLocation.setDefaultInLocation(true);
            inventoryLocation.setDefaultOutLocation(true);
            inventoryLocation.setSortOrder(0);
            inventoryLocation.setVisible(true);
            inventoryLocation.setRoot(true);
            inventoryLocation.setLastUpdateTime(StoreDAO.getServerTimestamp());
            InventoryLocationDAO.getInstance().save(inventoryLocation);
            list.add(inventoryLocation);
            this.inventoryLocationMap.put(inventoryLocation.getId(), inventoryLocation);
        }
        if (this.defaultInLocation == null) {
            this.defaultInLocation = list.get(0);
            this.defaultInLocation.setDefaultInLocation(true);
            InventoryLocationDAO.getInstance().saveOrUpdate(this.defaultInLocation);
            terminal.setInventoryInLocationId(this.defaultInLocation.getId());
            TerminalDAO.getInstance().update(terminal);
        }
        if (this.defaultOutLocation == null) {
            this.defaultOutLocation = list.get(0);
            this.defaultOutLocation.setDefaultOutLocation(true);
            InventoryLocationDAO.getInstance().saveOrUpdate(this.defaultOutLocation);
            terminal.setInventoryOutLocationId(this.defaultOutLocation.getId());
            TerminalDAO.getInstance().update(terminal);
        }
    }

    protected void clear(Map map) {
        if (map.size() > 0) {
            map.clear();
        }
    }

    @Override
    public Terminal getCurrentTerminal() {
        return this.terminal;
    }

    @Override
    public void setCloudTerminal(Terminal terminal) {
        this.terminalMap.put(terminal.getId(), terminal);
        this.terminal = terminal;
    }

    @Override
    public OrderType getOrderType(String string) {
        return this.orderTypes.get(string);
    }

    @Override
    public List<OrderType> getOrderTypes() {
        return this.orderTypeList;
    }

    @Override
    public UserType getUserType(String string) {
        UserType userType = this.userTypeMap.get(string);
        if (userType == null) {
            return UserTypeDAO.getInstance().get(string);
        }
        return userType;
    }

    @Override
    public Currency getCurrency(String string) {
        Currency currency = this.currencyMap.get(string);
        if (currency == null && StringUtils.isNotBlank((String)string) && (currency = CurrencyDAO.getInstance().get(string)) == null) {
            currency = new Currency();
            currency.setName(Messages.getString("PosCacheManager.1"));
        }
        return currency;
    }

    @Override
    public Course getCourse(String string) {
        return this.courseMap.get(string);
    }

    @Override
    public TerminalType getTerminalType(String string) {
        return this.terminalTypeMap.get(string);
    }

    @Override
    public Multiplier getMultiplierById(String string) {
        return this.multiplierMap.get(string);
    }

    @Override
    public List<Multiplier> getMultiplierList() {
        return this.multiplierList;
    }

    @Override
    public InventoryLocation getDefaultInLocation() {
        return this.defaultInLocation;
    }

    @Override
    public InventoryLocation getDefaultOutLocation() {
        return this.defaultOutLocation;
    }

    @Override
    public List<Course> getCourses() {
        if (this.courseMap.size() > 0) {
            return new ArrayList<Course>(this.courseMap.values());
        }
        return new ArrayList<Course>();
    }

    @Override
    public String getDefaultCourseId() {
        return this.defaultCourseId;
    }

    @Override
    public String getRecipeMenuItemName(Recepie recepie) {
        return RecepieDAO.getInstance().getMenuItemName(recepie);
    }

    @Override
    public MenuItemInventoryStatus getMenuItemStockStatus(MenuItem menuItem) {
        MenuItemInventoryStatusDAO menuItemInventoryStatusDAO = MenuItemInventoryStatusDAO.getInstance();
        try (Session session = menuItemInventoryStatusDAO.createNewSession();){
            MenuItemInventoryStatus menuItemInventoryStatus = menuItemInventoryStatusDAO.get(menuItem.getId(), session);
            if (menuItemInventoryStatus == null) {
                menuItemInventoryStatus = new MenuItemInventoryStatus(menuItem.getId());
                menuItemInventoryStatusDAO.save(menuItemInventoryStatus, session);
            }
            MenuItemInventoryStatus menuItemInventoryStatus2 = menuItemInventoryStatus;
            return menuItemInventoryStatus2;
        }
    }

    @Override
    public SalesArea getSalesArea(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return SalesAreaDAO.getInstance().get(string);
    }

    @Override
    public Customer getCustomer(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return CustomerDAO.getInstance().get(string);
    }

    @Override
    public Double getPriceFromPriceRule(Ticket ticket, MenuItem menuItem, IUnit iUnit) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Department department = terminal == null ? null : terminal.getDepartment();
        SalesArea salesArea = null;
        OrderType orderType = null;
        Customer customer = null;
        if (ticket != null) {
            orderType = ticket.getOrderType();
            salesArea = ticket.getSalesArea();
            customer = ticket.getCustomer();
        }
        return PriceRuleFactory.getPriceRuleService().getPrice(menuItem, orderType, department, salesArea, customer, iUnit == null ? null : iUnit.getId());
    }

    @Override
    public PosPrinters getPrinters() {
        return this.printers;
    }

    private void loadPrinters() {
        this.printers = PosPrinters.load();
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public Outlet getOutlet() {
        return this.outlet;
    }

    @Override
    public InventoryUnit getInventoryUnitById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.inventoryUnitMap.get(string);
    }

    @Override
    public IUnit getUnitById(String string, String string2) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (UnitType.PACKAGING_UNIT.name().equals(string2)) {
            return PackagingUnitDAO.getInstance().get(string);
        }
        return InventoryUnitDAO.getInstance().get(string);
    }

    @Override
    public TaxGroup getTaxGroupById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.taxGroupMap.get(string);
    }

    @Override
    public Tax getTaxById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.taxMap.get(string);
    }

    @Override
    public ReportGroup getReportGroupById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.reportGroupMap.get(string);
    }

    @Override
    public PrinterGroup getPrinterGroupById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.printerGroupMap.get(string);
    }

    @Override
    public Department getDepartmentById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.departmentMap.get(string);
    }

    @Override
    public OrderType getOrderTypeById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (this.orderTypes != null) {
            OrderType orderType = this.orderTypes.get(string);
            if (orderType == null) {
                orderType = OrderTypeDAO.getInstance().get(string);
                this.orderTypes.put(string, orderType);
            }
            return orderType;
        }
        return OrderTypeDAO.getInstance().get(string);
    }

    @Override
    public InventoryLocation getInventoryLocationById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        InventoryLocation inventoryLocation = this.inventoryLocationMap.get(string);
        if (inventoryLocation == null && (inventoryLocation = InventoryLocationDAO.getInstance().get(string)) != null) {
            this.inventoryLocationMap.put(string, inventoryLocation);
        }
        return inventoryLocation;
    }

    @Override
    public User getUserById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        User user = this.userMap.get(string);
        if (user == null && (user = UserDAO.getInstance().get(string)) != null) {
            this.userMap.put(string, user);
        }
        return user;
    }

    @Override
    public Terminal getTerminalById(Integer n) {
        if (n == null) {
            return null;
        }
        Terminal terminal = this.terminalMap.get(n);
        if (terminal == null && (terminal = TerminalDAO.getInstance().get(n)) != null) {
            this.terminalMap.put(n, terminal);
        }
        return terminal;
    }

    @Override
    public Shift getShiftById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.shiftMap.get(string);
    }

    @Override
    public List<DayPart> getDaryPartShifts() {
        return this.daypartShifts;
    }

    @Override
    public List<PriceShift> getPriceShifts() {
        return this.priceShifts;
    }

    @Override
    public List<MenuShift> getMenuShifts() {
        return this.menuShifts;
    }

    @Override
    public File getAppConfigFileLocation() {
        return new File(".");
    }

    @Override
    public Currency getMainCurrency() {
        return this.mainCurrency;
    }

    @Override
    public List<Currency> getCurrencies() {
        return this.currencyList;
    }

    @Override
    public ImageIcon getIconFromImageResource(String string) {
        try {
            if (string == null) {
                return null;
            }
            ImageResource imageResource = this.imageResourceCache.get(string);
            if (imageResource != null) {
                return imageResource.getImageIcon();
            }
            imageResource = ImageResourceDAO.getInstance().findById(string);
            if (imageResource != null) {
                this.imageResourceCache.put(string, imageResource);
                return imageResource.getImageIcon();
            }
        }
        catch (Exception exception) {
            PosLog.error(PosCacheManager.class, exception);
        }
        return null;
    }

    @Override
    public ImageIcon getIconFromImageResource(String string, int n, int n2) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            ImageResource imageResource = this.imageResourceCache.get(string);
            if (imageResource != null) {
                return imageResource.getScaledImage(n, n2);
            }
            imageResource = ImageResourceDAO.getInstance().get(string);
            if (imageResource != null) {
                this.imageResourceCache.put(String.valueOf(string), imageResource);
                return imageResource.getScaledImage(n, n2);
            }
        }
        catch (Exception exception) {
            PosLog.error(PosCacheManager.class, exception);
        }
        return null;
    }

    @Override
    public ImageResource getImageResource(String string) {
        try {
            if (StringUtils.isBlank((String)string)) {
                return null;
            }
            ImageResource imageResource = this.imageResourceCache.get(string);
            if (imageResource != null) {
                return imageResource;
            }
            imageResource = ImageResourceDAO.getInstance().findById(string);
            if (imageResource != null) {
                this.imageResourceCache.put(string, imageResource);
                return imageResource;
            }
        }
        catch (Exception exception) {
            PosLog.error(IconFactory.class, exception);
        }
        return null;
    }

    @Override
    public List<ShopFloor> getShopFloors() {
        if (this.floors == null) {
            this.floors = super.getShopFloors();
        }
        return this.floors;
    }

    @Override
    public PrinterGroup getDefaultPrinterGroup() {
        return this.defaultPrinterGroup;
    }

    @Override
    public boolean isCaching(Class clazz) {
        if (this.cacheClasses == null) {
            return false;
        }
        return this.cacheClasses.contains(clazz);
    }

    @Override
    public void refreshMultipliers() {
        this.loadMultipliers();
    }

    @Override
    public void refreshTaxGroup() {
        this.loadTaxGroups();
    }

    @Override
    public String getBrandNameById(String string) {
        if (StringUtils.isBlank((String)string)) {
            return "";
        }
        String string2 = this.brandNameMap.get(string);
        if (StringUtils.isNotBlank((String)string2)) {
            return string2;
        }
        Brand brand = BrandDAO.getInstance().get(string);
        if (brand == null) {
            return "";
        }
        this.brandNameMap.put(string, brand.getName());
        return brand.getName();
    }

    @Override
    public Font getMenuFont() {
        return this.menuFont;
    }

    @Override
    public Font getTicketViewFont() {
        return this.ticketViewFont;
    }

    @Override
    public Font getCategoryOrGroupViewFont() {
        return this.categoryOrGroupViewFont;
    }

    @Override
    public Font getKitchenReciptFont() {
        return this.kitchenReciptFont;
    }

    @Override
    public boolean isShowNewUserDashboard() {
        return AppConfig.getShowNewUserDashboard();
    }

    public void loadTicketPrefix() {
        GlobalConfigDAO globalConfigDAO = GlobalConfigDAO.getInstance();
        this.ticketIdPrefix = globalConfigDAO.getTicketIdPrefix();
        this.ticketIdGeneratorFormat = globalConfigDAO.getTicketIdGeneratorFormat();
        this.ticketIdSequenceFormat = globalConfigDAO.getTicketIdSequenceFormat();
    }

    @Override
    public void refreshTicketPrefix() {
        this.loadTicketPrefix();
    }

    @Override
    public String getTicketPrefix() {
        return this.ticketIdPrefix;
    }

    @Override
    public TicketIdSequence getTicketIdGeneratorFormat() {
        if (this.ticketIdGeneratorFormat == null) {
            return TicketIdSequence.Default;
        }
        return this.ticketIdGeneratorFormat;
    }

    @Override
    public DecimalFormat getTicketIdSequenceFormat() {
        return this.ticketIdSequenceFormat;
    }
}

