/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ext.UnitBaseItemPrice;
import com.floreantpos.model.util.pricecalc.DataUtilCalcFactory;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class InventoryUnitConvertionUtil {
    public static double calculateCost(Double d, IUnit iUnit, MenuItem menuItem) {
        return InventoryUnitConvertionUtil.calculateCost(d, menuItem.getUnit(), iUnit, menuItem);
    }

    public static double calculateCost(Double d, IUnit iUnit, IUnit iUnit2, MenuItem menuItem) {
        return DataUtilCalcFactory.getCalc().calculateCost(d, iUnit, iUnit2, menuItem);
    }

    public static double calculatePrice(Double d, IUnit iUnit, IUnit iUnit2, MenuItem menuItem) {
        return DataUtilCalcFactory.getCalc().calculatePrice(d, iUnit, iUnit2, menuItem);
    }

    public static double getUnitQuantity(IUnit iUnit, IUnit iUnit2, MenuItem menuItem) {
        return DataUtilCalcFactory.getCalc().getUnitQuantity(iUnit, iUnit2, menuItem);
    }

    public static double getBaseUnitQuantity(String string, MenuItem menuItem) {
        return DataUtilCalcFactory.getCalc().getBaseUnitQuantity(string, menuItem);
    }

    public static List<UnitBaseItemPrice> buildUnitBasePriceList(MenuItem menuItem, boolean bl) {
        return DataUtilCalcFactory.getCalc().buildUnitBasePriceList(menuItem, bl);
    }

    public static Double calculateUnitBaseItemPrice(MenuItem menuItem, IUnit iUnit, boolean bl) {
        if (menuItem.isVariant().booleanValue()) {
            return InventoryUnitConvertionUtil.calculatePrice(menuItem.getVariantPrice(), menuItem.getParentMenuItem().getUnit(), iUnit, menuItem);
        }
        String string = "unit.{name}.price".replace("{name}", iUnit.getUniqueCode());
        String string2 = menuItem.getProperty(string);
        Double d = 0.0;
        d = StringUtils.isBlank((String)string2) || bl ? Double.valueOf(InventoryUnitConvertionUtil.calculatePrice(menuItem.getPrice(), menuItem.getUnit(), iUnit, menuItem)) : Double.valueOf(NumberUtil.parseOrGetZero(string2).doubleValue());
        menuItem.addProperty(string, String.valueOf(d));
        return d;
    }
}

