/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment.common;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.payment.MemberPaymentPlugin;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.payment.common.Payable;
import com.floreantpos.payment.common.SettleProcessor;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosAmountInputUtil;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.CardTypeSelectionDialog;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class PayView
extends JPanel
implements PosAmountInputUtil {
    private static final String c = "0";
    private static final String d = "1";
    private static final String e = "clear";
    private static final String f = "clearall";
    private PosButton g;
    private PosButton h;
    private PosButton i;
    private TransparentPanel j;
    private JLabel k;
    private JLabel l;
    private TransparentPanel m;
    private PosButton n;
    private PosButton o;
    private PosButton p;
    private PosButton q;
    private PosButton r;
    private PosButton s;
    private PosButton t;
    private PosButton u;
    private PosButton v;
    private PosButton w;
    private PosButton x;
    private PosButton y;
    private PosButton z;
    private PosButton A;
    private PosButton B;
    private PosButton C;
    private PosButton D;
    private PosButton E;
    private PosButton F;
    private PosButton G;
    private PosButton H;
    private PosButton I;
    private DoubleTextField J;
    private JTextField K;
    private PosButton L;
    private List<Payable> M;
    private SettleProcessor N;
    private boolean O = true;
    private Terminal P;
    private RefreshableView Q;
    private PosButton R;
    private PosButton S;
    Action a = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DoubleTextField doubleTextField = PayView.this.J;
            PosButton posButton = (PosButton)actionEvent.getSource();
            posButton.getActionCommand();
            String string = actionEvent.getActionCommand();
            if (StringUtils.isBlank((String)string)) {
                return;
            }
            if (string.equals(PayView.e)) {
                PosAmountInputUtil.doClear(doubleTextField, true);
                return;
            }
            if (string.equals(PayView.f)) {
                doubleTextField.setText(NumberUtil.format(0.0));
            } else {
                PosAmountInputUtil.calculateValue(doubleTextField, true, string);
            }
        }
    };
    Action b = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PayView.this.a(actionEvent);
        }
    };

    public PayView(SettleProcessor settleProcessor, RefreshableView refreshableView) {
        this.N = settleProcessor;
        this.Q = refreshableView;
        this.P = Application.getInstance().getTerminal();
        this.a();
        this.c();
    }

    private void a() {
        Object object;
        boolean bl;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new MigLayout("fill, ins 0", "", ""));
        JPanel jPanel = new JPanel(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 0 0 5 0", "[][grow,fill]", "[grow][][grow]"));
        this.k = new JLabel();
        this.l = new JLabel();
        this.K = new JTextField();
        this.K.setFocusable(false);
        this.J = new DoubleTextField(10, 48, 10);
        this.J.setAllowNegativeValue(true);
        this.J.setFocusable(true);
        this.J.setEditable(true);
        this.J.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.setCaretPosition(jTextField.getDocument().getLength());
            }
        });
        this.J.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (!Character.isDigit(c)) {
                    keyEvent.consume();
                    return;
                }
                String string = String.valueOf(c);
                PosAmountInputUtil.calculateValue(PayView.this.J, true, string);
                keyEvent.consume();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 8) {
                    PosAmountInputUtil.doClear(PayView.this.J, true);
                    keyEvent.consume();
                    return;
                }
            }
        });
        Store store = DataProvider.get().getStore();
        Font font = this.k.getFont().deriveFont(1, PosUIManager.getFontSize((int)20));
        Font font2 = this.k.getFont().deriveFont(1, StoreUtil.getQuickTenderButtonFontSize(store));
        this.l.setFont(font);
        this.l.setText(Messages.getString("PaymentView.54") + " " + CurrencyUtil.getCurrencySymbol());
        this.l.setForeground(Color.gray);
        this.J.setHorizontalAlignment(4);
        this.J.setFont(font);
        this.k.setFont(font);
        this.k.setText(Messages.getString("PaymentView.52") + " " + CurrencyUtil.getCurrencySymbol());
        this.k.setForeground(Color.gray);
        this.K.setFont(font);
        this.K.setEditable(false);
        this.K.setHorizontalAlignment(4);
        transparentPanel.add((Component)this.k, "cell 0 0,alignx right,aligny center");
        transparentPanel.add((Component)this.l, "cell 0 1,alignx left,aligny center");
        transparentPanel.add((Component)this.K, "cell 1 0,growx,aligny top");
        transparentPanel.add((Component)this.J, "cell 1 1,growx,aligny top");
        jPanel.add((Component)transparentPanel, "North");
        this.j = new TransparentPanel();
        this.j.setPreferredSize(PosUIManager.getSize((int)240, (int)100));
        this.j.setLayout((LayoutManager)new MigLayout("wrap 4,fill, ins 0", "sg, fill", "sg, fill"));
        this.A = new PosButton();
        this.B = new PosButton();
        this.B.setFont(font2);
        this.C = new PosButton();
        this.C.setFont(font2);
        this.D = new PosButton();
        this.D.setFont(font2);
        this.E = new PosButton();
        this.E.setFont(font2);
        this.F = new PosButton();
        this.F.setFont(font2);
        this.G = new PosButton();
        this.G.setFont(font2);
        this.H = new PosButton();
        this.H.setFont(font2);
        this.I = new PosButton();
        this.n = new PosButton();
        this.r = new PosButton();
        this.s = new PosButton();
        this.t = new PosButton();
        this.u = new PosButton();
        this.v = new PosButton();
        this.y = new PosButton();
        this.x = new PosButton();
        this.w = new PosButton();
        this.p = new PosButton();
        this.o = new PosButton();
        this.q = new PosButton();
        this.z = new PosButton();
        this.B.setForeground(Color.blue);
        this.B.setAction(this.b);
        this.B.setText(StoreUtil.getQuickTenderButtonText(1, d, store));
        this.B.setActionCommand(String.valueOf(StoreUtil.getQuickTenderButtonValue(1, 1, store)));
        this.B.setFocusable(false);
        this.j.add(this.B);
        this.n.setAction(this.a);
        this.n.setText("7");
        this.n.setFont(font2);
        this.n.setActionCommand("7");
        this.n.setFocusable(false);
        this.j.add(this.n);
        this.r.setAction(this.a);
        this.r.setText("8");
        this.r.setFont(font2);
        this.r.setActionCommand("8");
        this.r.setFocusable(false);
        this.j.add(this.r);
        this.s.setAction(this.a);
        this.s.setText("9");
        this.s.setFont(font2);
        this.s.setActionCommand("9");
        this.s.setFocusable(false);
        this.j.add(this.s);
        this.C.setForeground(Color.blue);
        this.C.setAction(this.b);
        this.C.setText(StoreUtil.getQuickTenderButtonText(2, "2", store));
        this.C.setActionCommand(String.valueOf(StoreUtil.getQuickTenderButtonValue(2, 2, store)));
        this.C.setFocusable(false);
        this.j.add(this.C);
        this.t.setAction(this.a);
        this.t.setText("4");
        this.t.setFont(font2);
        this.t.setActionCommand("4");
        this.t.setFocusable(false);
        this.j.add(this.t);
        this.u.setAction(this.a);
        this.u.setText("5");
        this.u.setFont(font2);
        this.u.setActionCommand("5");
        this.u.setFocusable(false);
        this.j.add(this.u);
        this.v.setAction(this.a);
        this.v.setText("6");
        this.v.setFont(font2);
        this.v.setActionCommand("6");
        this.v.setFocusable(false);
        this.j.add(this.v);
        this.D.setForeground(Color.blue);
        this.D.setAction(this.b);
        this.D.setText(StoreUtil.getQuickTenderButtonText(3, "5", store));
        this.D.setActionCommand(String.valueOf(StoreUtil.getQuickTenderButtonValue(3, 5, store)));
        this.D.setFocusable(false);
        this.j.add(this.D);
        this.y.setAction(this.a);
        this.y.setText(d);
        this.y.setFont(font2);
        this.y.setActionCommand(d);
        this.y.setFocusable(false);
        this.j.add(this.y);
        this.x.setAction(this.a);
        this.x.setText("2");
        this.x.setFont(font2);
        this.x.setActionCommand("2");
        this.x.setFocusable(false);
        this.j.add(this.x);
        this.w.setAction(this.a);
        this.w.setText("3");
        this.w.setFont(font2);
        this.w.setActionCommand("3");
        this.w.setFocusable(false);
        this.j.add(this.w);
        this.E.setForeground(Color.blue);
        this.E.setAction(this.b);
        this.E.setText(StoreUtil.getQuickTenderButtonText(4, "10", store));
        this.E.setActionCommand(String.valueOf(StoreUtil.getQuickTenderButtonValue(4, 10, store)));
        this.E.setFocusable(false);
        this.j.add((Component)this.E, "grow");
        this.z.setAction(this.a);
        this.z.setText(Messages.getString("NumericKeypad2.0"));
        this.z.setFont(font2);
        this.z.setActionCommand(f);
        this.z.setFocusable(false);
        this.j.add(this.z);
        this.p.setAction(this.a);
        this.p.setText(c);
        this.p.setFont(font2);
        this.p.setActionCommand(c);
        this.p.setFocusable(false);
        this.j.add(this.p);
        this.q.setAction(this.a);
        this.q.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.ARROW_BACK, (float)PosUIManager.getSize((int)30)));
        this.q.setActionCommand(e);
        this.q.setFocusable(false);
        this.j.add(this.q);
        this.F.setForeground(Color.BLUE);
        this.F.setAction(this.b);
        this.F.setText(StoreUtil.getQuickTenderButtonText(5, "20", store));
        this.F.setActionCommand(String.valueOf(StoreUtil.getQuickTenderButtonValue(5, 20, store)));
        this.F.setFocusable(false);
        this.j.add((Component)this.F, "grow");
        this.G.setForeground(Color.blue);
        this.G.setAction(this.b);
        this.G.setText(StoreUtil.getQuickTenderButtonText(6, "50", store));
        this.G.setActionCommand(String.valueOf(StoreUtil.getQuickTenderButtonValue(6, 50, store)));
        this.G.setFocusable(false);
        this.j.add((Component)this.G, "grow");
        this.H.setForeground(Color.blue);
        this.H.setAction(this.b);
        this.H.setText(StoreUtil.getQuickTenderButtonText(7, "100", store));
        this.H.setActionCommand(String.valueOf(StoreUtil.getQuickTenderButtonValue(7, 100, store)));
        this.H.setFocusable(false);
        this.j.add((Component)this.H, "grow");
        this.j.add(this.o);
        this.I.setAction(this.b);
        this.I.setText(Messages.getString("PaymentView.20"));
        this.I.setActionCommand("exactAmount");
        this.I.setFocusable(false);
        this.j.add((Component)this.I, "span 2,grow");
        this.A.setAction(this.b);
        this.A.setText(Messages.getString("PaymentView.23"));
        this.A.setActionCommand("nextAmount");
        this.A.setFocusable(false);
        this.j.add((Component)this.A, "span 2,grow");
        jPanel.add((Component)this.j, "Center");
        this.m = new TransparentPanel();
        this.m.setPreferredSize(PosUIManager.getSize((int)80, (int)50));
        this.m.setOpaque(true);
        this.m.setLayout((LayoutManager)new MigLayout("hidemode 3,wrap 1, ins 0 5 0 0, fill", "sg, fill", ""));
        this.h = new PosButton(Messages.getString("PaymentView.31"));
        this.m.add((Component)this.h, "grow,wrap");
        this.h.addActionListener(actionEvent -> this.f());
        PosButton posButton = new PosButton("<html><center>" + Messages.getString("PaymentView.5") + "</center></html>");
        this.m.add((Component)posButton, "grow");
        posButton.setVisible(this.P.isEnableMultiCurrency());
        posButton.addActionListener(actionEvent -> this.g());
        String string = Messages.getString("PaymentView.33");
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        boolean bl2 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.supportsCashOut();
        if (bl) {
            string = paymentGatewayPlugin.getProductName();
        }
        this.S = new PosButton("<html><center>" + string + "</center></html>");
        this.m.add((Component)this.S, "grow");
        this.S.addActionListener(actionEvent -> this.j());
        if (bl) {
            object = new PosButton("<html><center>" + Messages.getString("PaymentView.46") + "</center></html>");
            this.m.add((Component)object, "grow");
            ((AbstractButton)object).addActionListener(actionEvent -> this.a(true));
        }
        this.R = new PosButton(Messages.getString("PaymentView.35"));
        this.m.add((Component)this.R, "grow");
        this.R.addActionListener(actionEvent -> {
            try {
                double d = this.e();
                this.a(d);
                if (d > this.getTotalDueAmount()) {
                    POSMessageDialog.showError(Messages.getString("PaymentView.6"));
                    return;
                }
                this.b(PaymentType.GIFT_CERTIFICATE);
            }
            catch (PosException posException) {
                POSMessageDialog.showError(this.getParent(), posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.27"), exception);
            }
        });
        object = new MemberPaymentPlugin();
        PosButton posButton2 = new PosButton("<html><center>" + ((MemberPaymentPlugin)object).getName() + "</center></html>");
        this.m.add((Component)posButton2, "grow");
        posButton2.addActionListener(arg_0 -> this.a((MemberPaymentPlugin)object, arg_0));
        List<FloreantPlugin> list = ExtensionManager.getPlugins(PaymentPlugin.class);
        for (FloreantPlugin floreantPlugin : list) {
            PaymentPlugin paymentPlugin = (PaymentPlugin)floreantPlugin;
            if (paymentPlugin instanceof GiftCardPaymentPlugin || paymentPlugin instanceof MemberPaymentPlugin) continue;
            PosButton posButton3 = new PosButton(paymentPlugin.getName());
            if (this.N.getTransactionType() != TransactionType.OUT) {
                this.m.add((Component)posButton3, "grow");
            }
            posButton3.addActionListener(actionEvent -> {
                try {
                    double d = this.e();
                    this.a(d);
                    if (!PosAction.checkPermission(this.N.getCurrentUser(), UserPermission.SETTLE_TICKET)) {
                        return;
                    }
                    this.O = true;
                }
                catch (StaleStateException staleStateException) {
                    POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.Q);
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            });
        }
        this.b();
        this.L = new PosButton(Messages.getString("PaymentView.17"));
        this.L.addActionListener(actionEvent -> {
            if (!POSUtil.checkDrawerAssignment()) {
                return;
            }
            this.O = true;
        });
        this.add((Component)jPanel, "cell 0 0,grow");
        this.add((Component)this.m, "cell 1 0,grow");
        if (this.N.getTransactionType() == TransactionType.OUT) {
            this.S.setVisible(false);
            this.R.setVisible(false);
            posButton2.setVisible(false);
        }
    }

    private void b() {
        List<CustomPayment> list = CustomPaymentDAO.getInstance().findAll();
        for (final CustomPayment customPayment : list) {
            if (!customPayment.isEnable().booleanValue()) continue;
            PosButton posButton = new PosButton("<html><body><center>" + customPayment.getName() + "</center></body></html>");
            posButton.setPreferredSize(new Dimension(120, 80));
            posButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        double d = PayView.this.e();
                        PayView.this.a(d);
                        if (d > PayView.this.getTotalDueAmount()) {
                            POSMessageDialog.showError(Messages.getString("PaymentView.22") + " " + customPayment.getName() + ".");
                            return;
                        }
                        if (!PosAction.checkPermission(Application.getCurrentUser(), UserPermission.SETTLE_TICKET)) {
                            return;
                        }
                        Payable payable = PayView.this.N.getPayableList().get(0);
                        if (payable instanceof PurchaseOrder) {
                            PurchaseOrder purchaseOrder = (PurchaseOrder)payable;
                            PayView.this.N.payByCustomPayment(customPayment, d, purchaseOrder);
                        }
                    }
                    catch (PosException posException) {
                        POSMessageDialog.showError(PayView.this.getParent(), posException.getMessage());
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.27"), exception);
                    }
                }
            });
            this.m.add((Component)posButton, "grow");
        }
    }

    private void c() {
        this.g = new PosButton(POSConstants.CANCEL);
        this.m.add((Component)this.g, "grow");
        this.g.addActionListener(actionEvent -> this.d());
    }

    protected List<MultiCurrencyTenderDialog.PaymentByCurrency> getMulticurrencyPayment(List<Currency> list) {
        Ticket ticket = new Ticket();
        ticket.setDueAmount(this.getTotalDueAmount());
        MultiCurrencyTenderDialog multiCurrencyTenderDialog = new MultiCurrencyTenderDialog(ticket, list);
        multiCurrencyTenderDialog.pack();
        multiCurrencyTenderDialog.open();
        if (multiCurrencyTenderDialog.isCanceled()) {
            return null;
        }
        this.J.setText(NumberUtil.formatNumber(multiCurrencyTenderDialog.getTenderedAmount()));
        return multiCurrencyTenderDialog.getPaymentByCurrencies();
    }

    public Customer doSetMember(Ticket ticket) {
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(ticket.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            customerSelectorDialog.updateView(true);
            if (ticket != null) {
                customerSelectorDialog.setTicket(ticket);
            }
            customerSelectorDialog.openUndecoratedFullScreen();
            if (customerSelectorDialog.isCanceled()) {
                throw new PosException(Messages.getString("MemberNotSelected"));
            }
            customer = customerSelectorDialog.getSelectedCustomer();
            if (customer == null) {
                throw new PosException(Messages.getString("MemberNotSelected"));
            }
            ticket.setCustomer(customer);
        }
        CustomerDAO.getInstance().refresh(customer);
        return customer;
    }

    protected void doTaxExempt() {
    }

    private void d() {
        this.N.cancelPayment();
    }

    public void updateView() {
        double d;
        if (this.M == null) {
            this.i();
            return;
        }
        double d2 = d = this.getTotalDueAmount();
        this.K.setText(NumberUtil.formatNumber(d2, true));
        PaymentView.setTenderedAmountConditionally(this.J, d);
    }

    public double getTenderedAmount() throws ParseException {
        double d = NumberUtil.parse(this.J.getText()).doubleValue();
        return d;
    }

    protected double getTotalDueAmount() {
        return this.getPayableList().stream().mapToDouble(payable -> payable.getDueValue()).sum();
    }

    protected double getAdvanceAmount() {
        return 0.0;
    }

    public void setDefaultFocus() {
        this.J.requestFocus();
    }

    public List<Payable> getPayableList() {
        return this.M;
    }

    public void setPayableList(List<Payable> list) {
        this.M = list;
        this.N.setPayableList(list);
        this.updateView();
    }

    private double e() throws ParseException {
        String string = this.J.getText();
        if (StringUtils.isBlank((String)string)) {
            return 0.0;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = numberFormat.parse(string);
        return number.doubleValue();
    }

    private void f() {
        try {
            double d = this.e();
            this.a(d);
            this.N.doSettle(PaymentType.CASH, d);
            this.O = true;
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.Q);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this.getParent(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.27"), exception);
        }
    }

    private void g() {
        try {
            this.a(this.getTotalDueAmount());
            List<Currency> list = CurrencyUtil.getAllCurrency();
            List<MultiCurrencyTenderDialog.PaymentByCurrency> list2 = null;
            if (list.size() > 0 && (list2 = this.getMulticurrencyPayment(list)) == null) {
                return;
            }
            double d = this.e();
            this.a(d);
            this.N.doSettle(PaymentType.CASH, d, list2);
            this.O = true;
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.Q);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this.getParent(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.28"), exception);
        }
    }

    private void a(PaymentType paymentType) {
        try {
            if (!this.h()) {
                return;
            }
            double d = this.e();
            this.a(d);
            this.N.doSettle(paymentType, d);
            this.O = true;
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.Q);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this.getParent(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.29"), exception);
        }
    }

    private boolean h() {
        if (this.getTotalDueAmount() == 0.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.30"));
            return false;
        }
        return true;
    }

    private void a(ActionEvent actionEvent) {
        try {
            PosButton posButton = (PosButton)actionEvent.getSource();
            String string = posButton.getActionCommand();
            if (string.equals("exactAmount")) {
                double d = this.getTotalDueAmount();
                this.J.setText(NumberUtil.formatNumber(d));
            } else if (string.equals("nextAmount")) {
                double d = Math.ceil(this.getTotalDueAmount());
                this.J.setText(NumberUtil.format(d));
            } else {
                if (this.O) {
                    this.J.setText(c);
                    this.O = false;
                }
                double d = this.e();
                double d2 = NumberUtil.parseDouble(string);
                double d3 = d + d2;
                this.J.setText(NumberUtil.format(d3));
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.Q);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this.getParent(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.34"), exception);
        }
    }

    private void i() {
        this.K.setText(c);
        this.J.setText(c);
        PaymentView.setTenderedAmountConditionally(this.J, 0.0);
    }

    private void j() {
        this.a(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl) {
        PaymentGatewayPlugin paymentGatewayPlugin = null;
        try {
            double d = this.e();
            this.a(d);
            if (d > this.getTotalDueAmount()) {
                POSMessageDialog.showError(Messages.getString("PaymentView.36"));
                return;
            }
            PaymentType paymentType = PaymentType.CREDIT_CARD;
            paymentGatewayPlugin = CardConfig.getPaymentGateway();
            if (paymentGatewayPlugin != null) {
                paymentGatewayPlugin.chargeWithCashout(bl);
                if (paymentGatewayPlugin.showCardTypeSelectionOption()) {
                    CardTypeSelectionDialog cardTypeSelectionDialog = new CardTypeSelectionDialog();
                    cardTypeSelectionDialog.open();
                    if (cardTypeSelectionDialog.isCanceled()) {
                        return;
                    }
                    paymentType = cardTypeSelectionDialog.getPaymentCardType();
                }
            }
            this.b(paymentType);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this.getParent(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.27"), exception);
        }
        finally {
            if (paymentGatewayPlugin != null) {
                paymentGatewayPlugin.chargeWithCashout(false);
            }
        }
    }

    private void a(MemberPaymentPlugin memberPaymentPlugin) throws Exception {
        Serializable serializable;
        Object object;
        double d = this.e();
        this.a(d);
        if (d > this.getTotalDueAmount()) {
            POSMessageDialog.showError(Messages.getString("PaymentView.39"));
            return;
        }
        if (!PosAction.checkPermission(this.N.getCurrentUser(), UserPermission.SETTLE_TICKET)) {
            return;
        }
        if (!POSUtil.checkDrawerAssignment()) {
            return;
        }
        String string = this.N.getPayableList().get(0).getCustomerId();
        Customer customer = null;
        if (StringUtils.isNotBlank((String)string)) {
            customer = CustomerDAO.getInstance().get(string);
        } else {
            object = CustomerSelectorFactory.createCustomerSelectorDialog(null);
            ((CustomerSelectorDialog)object).setCreateNewTicket(false);
            ((CustomerSelectorDialog)object).updateView(true);
            ((POSDialog)object).openUndecoratedFullScreen();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            customer = ((CustomerSelectorDialog)object).getSelectedCustomer();
            if (customer != null) {
                this.N.getPayableList().get(0).setCustomerId(customer.getId());
                String string2 = this.J.getText();
                this.N.doInformListenerPaymentUpdate();
                this.J.setText(string2);
                return;
            }
        }
        if (customer != null) {
            CustomerDAO.getInstance().refresh(customer);
            object = customer.getCreditLimit();
            serializable = customer.getBalance();
            double d2 = (Double)serializable + (Double)object;
            if (d > NumberUtil.round(d2)) {
                String string3 = Messages.getString("CreditLimitExceed");
                string3 = string3 + "\n";
                string3 = string3 + Messages.getString("MemberPaymentPlugin.0") + NumberUtil.formatNumberIfNeeded((Double)object);
                string3 = string3 + Messages.getString("MemberPaymentPlugin.4") + NumberUtil.formatAmount((Double)serializable) + ".";
                throw new PosException(string3);
            }
        }
        this.N.setTenderAmount(d);
        object = this.N.getPayableList();
        serializable = new ArrayList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Payable payable = (Payable)iterator.next();
            if (NumberUtil.isZero(payable.getDueValue())) continue;
            PosTransaction posTransaction2 = payable.createTransaction();
            posTransaction2.setPaymentType(PaymentType.MEMBER_ACCOUNT);
            posTransaction2.setCustomPaymentRef(customer.getId());
            posTransaction2.setCustomPaymentFieldName("MEMBER ID");
            serializable.add(posTransaction2);
        }
        this.N.settle((List<PosTransaction>)((Object)serializable), (posTransaction, session) -> {
            Customer customer = CustomerDAO.getInstance().get(string, session);
            Double d = customer.getBalance();
            customer.setBalance(d - posTransaction.getAmount());
            CustomerDAO.getInstance().saveOrUpdate(customer, session);
            BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.CUSTOMER, posTransaction.getEntityId(), posTransaction, TransactionType.DEBIT, customer.getId(), posTransaction.getAmount(), d, TransactionSubType.SALES, session);
        });
        this.O = true;
    }

    private void b(PaymentType paymentType) {
        this.a(paymentType, true);
    }

    private void a(PaymentType paymentType, boolean bl) {
        try {
            if (!this.h()) {
                return;
            }
            double d = this.e();
            this.a(d);
            if (bl && !PosAction.checkPermission(this.N.getCurrentUser(), UserPermission.SETTLE_TICKET)) {
                return;
            }
            this.N.doSettle(paymentType, d);
            this.O = true;
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.Q);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this.getParent(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentView.29"), exception);
        }
    }

    private void a(double d) {
        if (this.getTotalDueAmount() != 0.0 && d == 0.0) {
            throw new PosException(Messages.getString("PaymentView.25"));
        }
        if (d < 0.0) {
            throw new PosException(Messages.getString("PaymentView.25"));
        }
    }

    public static void setTenderedAmountConditionally(JTextField jTextField, Double d) {
        boolean bl = DataProvider.get().getStore().getBooleanProperty("prefill_tender_amount", true);
        if (bl) {
            jTextField.setText(NumberUtil.formatNumber(d, true));
        } else {
            jTextField.setText(NumberUtil.formatNumber(0));
        }
    }

    private /* synthetic */ void a(MemberPaymentPlugin memberPaymentPlugin, ActionEvent actionEvent) {
        try {
            this.a(memberPaymentPlugin);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.Q);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }
}

