/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment.common;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.payment.common.Payable;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TransactionCompletionDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CustomPaymentSelectionDialog;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentReferenceEntryDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.HeadlessException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;

public class SettleProcessor
implements CardInputProcessor {
    private Vector<PaymentListener> a = new Vector(3);
    private List<Payable> b;
    private double c;
    private PaymentType d;
    private User e;
    private RefreshableView f;
    private final TransactionType g;

    public SettleProcessor(User user, RefreshableView refreshableView, TransactionType transactionType) {
        this.e = user;
        this.f = refreshableView;
        this.g = transactionType;
    }

    public List<Payable> getPayableList() {
        return this.b;
    }

    public void setPayableList(List<Payable> list) {
        this.b = list;
    }

    public double getTenderAmount() {
        return this.c;
    }

    public void setTenderAmount(double d) {
        this.c = d;
    }

    public void addPaymentListener(PaymentListener paymentListener) {
        this.a.add(paymentListener);
    }

    public void removePaymentListener(PaymentListener paymentListener) {
        this.a.remove(paymentListener);
    }

    public void doSettle(PaymentType paymentType, double d) throws Exception {
        this.doSettle(paymentType, d, null);
    }

    public void doSettle(PaymentType paymentType, double d, List<MultiCurrencyTenderDialog.PaymentByCurrency> list) throws Exception {
        this.c = d;
        if (this.b == null) {
            return;
        }
        if (!paymentType.equals((Object)PaymentType.CUSTOM_PAYMENT) && !POSUtil.checkDrawerAssignment()) {
            return;
        }
        if (!this.a()) {
            return;
        }
        this.d = paymentType;
        switch (paymentType) {
            case CASH: {
                DrawerUtil.kickDrawer();
                this.a(paymentType, list);
                break;
            }
            case CUSTOM_PAYMENT: {
                CustomPaymentSelectionDialog customPaymentSelectionDialog = new CustomPaymentSelectionDialog(this.getCurrentUser());
                customPaymentSelectionDialog.setTitle(Messages.getString("SettleTicketDialog.8"));
                customPaymentSelectionDialog.pack();
                customPaymentSelectionDialog.open();
                if (customPaymentSelectionDialog.isCanceled()) {
                    return;
                }
                ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
                for (Payable payable : this.b) {
                    PosTransaction posTransaction = payable.createTransaction();
                    posTransaction.setCustomPaymentFieldName(customPaymentSelectionDialog.getPaymentFieldName());
                    posTransaction.setCustomPaymentId(customPaymentSelectionDialog.getCustomPaymentId());
                    posTransaction.setCustomPaymentName(customPaymentSelectionDialog.getPaymentName());
                    posTransaction.setCustomPaymentRef(customPaymentSelectionDialog.getPaymentRef());
                    arrayList.add(posTransaction);
                }
                this.doPayByCustomPayment(arrayList);
                break;
            }
            case CREDIT_CARD: 
            case DEBIT_CARD: {
                this.b(d);
                break;
            }
            case GIFT_CERTIFICATE: {
                this.a(d);
                break;
            }
        }
    }

    private void a(double d) throws Exception {
        try {
            GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
            if (giftCardPaymentPlugin == null) {
                throw new PosException(Messages.getString("SettleTicketProcessor.0"));
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void b(double d) {
        POSMessageDialog.showMessage("Under construction");
    }

    private boolean a() {
        if (!DataProvider.get().getCurrentTerminal().isConfirmTicketSettlement().booleanValue()) {
            return true;
        }
        String string = String.format(Messages.getString("SettleTicketProcessor.17"), CurrencyUtil.getCurrencySymbol(), NumberUtil.trimDecilamIfNotNeeded(this.c));
        int n = POSMessageDialog.showYesNoQuestionDialog(string);
        return n == 0;
    }

    private void a(final PaymentType paymentType, final List<MultiCurrencyTenderDialog.PaymentByCurrency> list) {
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketProcessor.24"));
        SwingWorker<Double, Void> swingWorker = new SwingWorker<Double, Void>(){
            private List<PosTransaction> e = null;

            @Override
            protected Double doInBackground() throws Exception {
                this.e = new ArrayList<PosTransaction>();
                Double d = SettleProcessor.this.c();
                Double d2 = 0.0;
                for (Payable payable : SettleProcessor.this.b) {
                    if (NumberUtil.isZero(payable.getDueValue())) continue;
                    PosTransaction posTransaction = payable.createTransaction();
                    this.e.add(posTransaction);
                    posTransaction.setPaymentType(paymentType);
                    SettleProcessor.this.setTransactionAmounts(posTransaction, list);
                    d2 = d2 + payable.getDueValue();
                    if (!(SettleProcessor.this.c <= d2)) continue;
                    break;
                }
                SettleProcessor.this.doSettle(this.e, null, true, false, list);
                return d;
            }

            @Override
            protected void done() {
                try {
                    Double d = (Double)this.get();
                    busyDialog.dispose();
                    SettleProcessor.this.doAfterSettleTask(this.e, d, true);
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        SettleProcessor.this.f.refresh();
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    public void settle(PosTransaction posTransaction, PostPaymentProcessor postPaymentProcessor) {
        this.settle(Arrays.asList(posTransaction), postPaymentProcessor);
    }

    public void settle(List<PosTransaction> list, PostPaymentProcessor postPaymentProcessor) {
        try {
            this.doSettle(list, postPaymentProcessor, true, true);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (UnknownHostException unknownHostException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void doSettle(List<PosTransaction> list, PostPaymentProcessor postPaymentProcessor, boolean bl, boolean bl2) throws Exception {
        this.doSettle(list, postPaymentProcessor, bl, bl2, null);
    }

    public void doSettle(List<PosTransaction> list, PostPaymentProcessor postPaymentProcessor, boolean bl, boolean bl2, List<MultiCurrencyTenderDialog.PaymentByCurrency> list2) throws Exception {
        double d = this.c();
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        Transaction transaction = null;
        try (Session session = TerminalDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                double d2;
                PosTransaction posTransaction = list.get(i);
                Payable payable = this.b.get(i);
                PurchaseOrder purchaseOrder = null;
                if (payable instanceof PurchaseOrder) {
                    purchaseOrder = (PurchaseOrder)payable;
                }
                if (purchaseOrder == null || NumberUtil.isZero(d2 = purchaseOrder.getDueValue().doubleValue()) || NumberUtil.isZero(this.c)) continue;
                posTransaction.setEntityId(purchaseOrder.getEntityId());
                posTransaction.setAmount(this.c > d2 ? d2 : this.c);
                posTransaction.setTransactionType(this.g.name());
                posTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
                posTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
                posTransaction.setCustomerId(payable.getCustomerId());
                posTransaction.setUser(Application.getCurrentUser());
                PosTransactionDAO.getInstance().save(posTransaction, session);
                if (postPaymentProcessor != null) {
                    postPaymentProcessor.paymentDone(posTransaction, session);
                }
                arrayList.add(posTransaction);
                purchaseOrder.setTransaction(posTransaction);
                purchaseOrder.calculatePrice();
                Double d3 = purchaseOrder.getDueAmount();
                if (purchaseOrder.getStatus() == 4 && NumberUtil.isZero(d3)) {
                    purchaseOrder.setStatus(7);
                }
                PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, session);
                if (this.c <= d3) break;
                this.c -= d3.doubleValue();
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                PosLog.error(SettleProcessor.class, exception2);
            }
        }
        if (bl2) {
            this.doAfterSettleTask(arrayList, d, true);
        }
    }

    public void payByCustomPayment(CustomPayment customPayment, double d, PurchaseOrder purchaseOrder) {
        this.c = d;
        CustomPaymentTransaction customPaymentTransaction = new CustomPaymentTransaction();
        customPaymentTransaction.setCustomPaymentFieldName(customPayment.getRefNumberFieldName());
        customPaymentTransaction.setCustomPaymentFieldName(customPayment.getRefNumberFieldName());
        customPaymentTransaction.setCustomPaymentId(customPayment.getId());
        customPaymentTransaction.setCustomPaymentName(customPayment.getName());
        customPaymentTransaction.putConfirmPayment(customPayment.isConfirmPaymentImmediately());
        customPaymentTransaction.setEntityNo(purchaseOrder.getOrderId());
        customPaymentTransaction.setEntityType("Purchase_order".toString());
        customPaymentTransaction.setEntityId(purchaseOrder.getId());
        if (customPayment.isRequiredRefNumber().booleanValue() || !customPayment.getInputPromptList().isEmpty()) {
            PaymentReferenceEntryDialog paymentReferenceEntryDialog = new PaymentReferenceEntryDialog(customPayment);
            paymentReferenceEntryDialog.pack();
            paymentReferenceEntryDialog.open();
            if (paymentReferenceEntryDialog.isCanceled()) {
                return;
            }
            customPaymentTransaction.setCustomPaymentRef(paymentReferenceEntryDialog.getPaymentRef());
        }
        this.doPayByCustomPayment(Arrays.asList(customPaymentTransaction));
    }

    public void doPayByCustomPayment(List<PosTransaction> list) {
        for (PosTransaction posTransaction : list) {
            posTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
            posTransaction.setCaptured(true);
            this.setTransactionAmounts(posTransaction);
        }
        this.settle(list);
    }

    public void settle(List<PosTransaction> list) {
        try {
            this.doSettle(list, null, true, true);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (UnknownHostException unknownHostException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void setTransactionAmounts(PosTransaction posTransaction) {
        this.setTransactionAmounts(posTransaction, null);
    }

    public void setTransactionAmounts(PosTransaction posTransaction, List<MultiCurrencyTenderDialog.PaymentByCurrency> list) {
        double d = 0.0;
        if (list != null && list.size() > 0) {
            for (MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency : list) {
                d += paymentByCurrency.cashBackAmount / paymentByCurrency.currency.getExchangeRate();
            }
        }
        if (d > this.c) {
            throw new PosException(Messages.getString("SettleTicketProcessor.26"));
        }
        posTransaction.setTenderAmount(this.c);
        if (this.c - d >= this.c()) {
            posTransaction.setAmount(this.c());
        } else {
            posTransaction.setAmount(this.c - d);
        }
        double d2 = NumberUtil.round(this.c - posTransaction.getAmount());
        posTransaction.setChangeAmount(d2);
    }

    public void doAfterSettleTask(List<PosTransaction> list, double d, boolean bl) throws HeadlessException {
        double d2 = 0.0;
        if (list.size() > 0) {
            d2 = list.get(list.size() - 1).getTenderAmount();
        }
        if (NumberUtil.isZero(this.c())) {
            this.b();
        } else {
            this.setPayableList(this.b);
            this.doInformListenerPaymentUpdate();
        }
        this.showTransactionCompleteMsg(d, d2, list);
        this.a(d, list);
    }

    private void b() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentDone();
        }
    }

    public void doInformListenerPaymentUpdate() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentDataChanged();
        }
    }

    public void showTransactionCompleteMsg(double d, double d2, List<PosTransaction> list) {
        TransactionCompletionDialog transactionCompletionDialog = new TransactionCompletionDialog(list);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (PosTransaction posTransaction : list) {
            d3 += posTransaction.getAmount().doubleValue();
            d4 += posTransaction.getTipsAmount().doubleValue();
            d5 += posTransaction.getCashoutAmount();
            d6 += posTransaction.getFeeAmount().doubleValue();
        }
        transactionCompletionDialog.setTenderedAmount(d2);
        transactionCompletionDialog.setTotalAmount(d);
        transactionCompletionDialog.setPaidAmount(d3);
        transactionCompletionDialog.setDueAmount(this.c());
        transactionCompletionDialog.setGratuityAmount(d4);
        if (list.size() > 0) {
            transactionCompletionDialog.setChangeAmount(list.get(list.size() - 1).getChangeAmount());
        }
        transactionCompletionDialog.setCashoutAmount(d5);
        transactionCompletionDialog.setFeeAmount(d6);
        transactionCompletionDialog.updateView();
        transactionCompletionDialog.pack();
        transactionCompletionDialog.open();
    }

    public User getCurrentUser() {
        return this.e != null ? this.e : Application.getCurrentUser();
    }

    public void setCurrentUser(User user) {
        this.e = user;
    }

    public RefreshableView getRefreshableView() {
        return this.f;
    }

    public void cancelPayment() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentCanceled();
        }
    }

    public TransactionType getTransactionType() {
        return this.g;
    }

    private double c() {
        if (this.b == null) {
            return 0.0;
        }
        return this.b.stream().mapToDouble(payable -> payable.getDueValue()).sum();
    }

    private void a(double d, List<PosTransaction> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Due amount: " + NumberUtil.getCurrencyFormat(d));
        double d2 = list2.stream().mapToDouble(posTransaction -> posTransaction.getAmount()).sum();
        stringBuilder.append(", Paid amount: " + NumberUtil.getCurrencyFormat(d2));
        Optional<List<Payable>> optional = Optional.ofNullable(this.getPayableList());
        optional.ifPresent(list -> {
            Payable payable = (Payable)list.get(0);
            if (payable instanceof PurchaseOrder) {
                List list2 = list;
                List<String> list3 = POSUtil.getStringIds(list2, PurchaseOrder.class, "getOrderId");
                stringBuilder.append(", Purchase order: " + list3);
            }
        });
        stringBuilder.append(", Transaction: " + POSUtil.getStringIds(list2, PosTransaction.class));
        stringBuilder.append('\n');
        String string = null;
        if (this.g == TransactionType.OUT) {
            string = "Pay bill";
        }
        if (StringUtils.isNotBlank((String)string)) {
            ActionHistoryDAO.saveHistory(string, stringBuilder.toString());
        }
    }
}

