/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.PrintServiceUtil;
import java.awt.Font;
import java.awt.print.PrinterAbortException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.util.JRFontNotFoundException;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;

public class JasperPrintService
extends ReceiptPrintServiceProvider {
    @Override
    public void printTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, null);
        jasperPrint.setName("ORDER-" + ticket.getId() + string);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printTransaction(Ticket ticket, HashMap hashMap, PosTransaction posTransaction, String string) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, posTransaction);
        jasperPrint.setName("ORDER-" + ticket.getId() + string);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printVoidTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, null);
        jasperPrint.setName("VOID_" + ticket.getId());
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printKitchenTicket(KitchenTicket kitchenTicket, HashMap hashMap, Ticket ticket, String string, String string2) throws Exception {
        JasperPrint jasperPrint = this.createKitchenPrint(hashMap, string, kitchenTicket, string2);
        jasperPrint.setName("KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
        jasperPrint.setProperty("printerName", string2);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printVoidKitchenTicket(KitchenTicket kitchenTicket, HashMap hashMap, String string, String string2) throws Exception {
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("kitchen-receipt"), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
        jasperPrint.setName("Void_KitchenReceipt_" + kitchenTicket.getId() + "_" + kitchenTicket.getSequenceNumber());
        jasperPrint.setProperty("printerName", string2);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void rendererTicketReceipt(Ticket ticket, Store store, JPanel jPanel, Font font) throws Exception {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, store, ticketPrintProperties, null, false, false, true);
        hashMap.put("IS_IGNORE_PAGINATION", true);
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, null, false, font);
        ReportUtil.mirrorLayout(jasperPrint);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        jPanel.add(ticketReceiptView.getReportPanel());
    }

    @Override
    public void rendererPosTransactionReceipt(PosTransaction posTransaction, JPanel jPanel, Font font) throws Exception {
        JasperPrint jasperPrint = this.createTransactionReceipt(posTransaction, font);
        ReportUtil.mirrorLayout(jasperPrint);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        jPanel.add(ticketReceiptView.getReportPanel());
    }

    @Override
    public void rendererKitchenReceipt(Ticket ticket, Store store, JPanel jPanel, Font font) throws Exception {
        JasperPrint jasperPrint = this.a(ticket, store, font);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        jPanel.add(ticketReceiptView.getReportPanel());
    }

    public JasperPrint createJasperPrint(JasperReport jasperReport, Map<String, Object> map, JRDataSource jRDataSource) throws Exception {
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)jRDataSource);
        return jasperPrint;
    }

    public JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction posTransaction) throws Exception {
        return this.createPrint(ticket, map, posTransaction, false);
    }

    public JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction posTransaction, boolean bl) throws Exception {
        return this.createPrint(ticket, map, posTransaction, bl, null);
    }

    public JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction posTransaction, boolean bl, Font font) throws Exception {
        Object object;
        Object object2;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        this.a(hashMap);
        ReciptPaperSize reciptPaperSize = JasperPrintService.a("main.recipt.paper_size");
        TicketDataSource ticketDataSource = new TicketDataSource(ticket, bl);
        ReportUtil.populatePatternExpression(hashMap, DataProvider.get().getStore());
        List<ReceiptPrintService.TransactionDataRow> list = ReceiptPrintService.buildPayments(posTransaction, ticket);
        Font font2 = DataProvider.get().getTicketViewFont();
        if (font != null) {
            font2 = font;
        }
        if (list != null && list.size() > 0) {
            object2 = new TransactionReportModel(list);
            hashMap.put("tenderAmountDataSource", new JRTableModelDataSource((TableModel)object2));
            object = ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("ticket-recipt-transaction"));
            if (font2 != null) {
                ReportUtil.setFont(object, font2, AppConfig.getMainReceiptFontPath());
            }
            hashMap.put("tenderAmountReport", object);
        }
        if ((object2 = ReceiptPrintService.buildVoidPayments(ticket)) != null && object2.size() > 0) {
            object = new VoidTransactionReportModel((List<ReceiptPrintService.VoidTransactionDataRow>)object2);
            hashMap.put("lblVoidTransactions", Messages.getString("ITextPrinter.5"));
            hashMap.put("voidAmountDataSource", new JRTableModelDataSource((TableModel)object));
            JasperReport jasperReport = ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("ticket-void-transaction"));
            if (font2 != null) {
                ReportUtil.setFont(jasperReport, font2, AppConfig.getMainReceiptFontPath());
            }
            hashMap.put("voidAmountSubReport", jasperReport);
        }
        object = ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("ticket-recipt"));
        if (font2 != null) {
            ReportUtil.setFont(object, font2, AppConfig.getMainReceiptFontPath());
        }
        return this.createJasperPrint((JasperReport)object, (Map<String, Object>)hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)ticketDataSource));
    }

    private void a(Map<String, Object> map) {
        this.a(map, "ticketHeader");
        this.a(map, "additionalOrderInfo");
        this.a(map, "headerLine1");
        this.a(map, "footerMessage");
        this.a(map, "bottomMessage");
    }

    private void a(Map<String, Object> map, String string) {
        Object object = map.get(string);
        if (object == null) {
            return;
        }
        String string2 = object.toString();
        if (string2.contains("<storeLogo> </storeLogo><br>")) {
            string2 = string2.replaceAll("<storeLogo> </storeLogo><br>", "");
        }
        map.put(string, string2.replaceAll("<\\w\\w\\w\\w\\w+>", "").replaceAll("</\\w\\w\\w\\w\\w+>", ""));
    }

    public JasperPrint createRefundPrint(Ticket ticket, HashMap<String, Object> hashMap) throws Exception {
        return this.createPrint(ticket, hashMap, null, false);
    }

    public JasperPrint createTransactionReceipt(PosTransaction posTransaction, Font font) {
        try {
            Ticket ticket = posTransaction.getTicket();
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            if (posTransaction != null && posTransaction.isCard()) {
                CardReader cardReader = CardReader.fromString(posTransaction.getCardReader());
                if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                    return null;
                }
                hashMap.put("cardPayment", true);
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.4"));
                JasperPrint jasperPrint = this.createPrint(ticket, hashMap, posTransaction, false, font);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-CustomerCopy");
                jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.5"));
                jasperPrint = this.createPrint(ticket, hashMap, posTransaction, false, font);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-MerchantCopy");
                jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
                return jasperPrint;
            }
            JasperPrint jasperPrint = this.createPrint(ticket, hashMap, posTransaction, false, font);
            jasperPrint.setName("Ticket-" + ticket.getId());
            jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
            return jasperPrint;
        }
        catch (JRFontNotFoundException jRFontNotFoundException) {
            throw jRFontNotFoundException;
        }
        catch (Exception exception) {
            ReceiptPrintService.getLogger().error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
            return null;
        }
    }

    private static ReciptPaperSize a(String string) {
        return ReceiptPrintService.getReceiptPaperSize(string);
    }

    public JasperPrint createKitchenPrint(KitchenTicket kitchenTicket) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("cardPayment", true);
        hashMap.put("showHeaderSeparator", Boolean.TRUE);
        hashMap.put("showHeaderSeparator", Boolean.TRUE);
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        ReciptPaperSize reciptPaperSize = JasperPrintService.a("kitchen.recipt.paper_size");
        return this.createJasperPrint(ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("kitchen-receipt")), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
    }

    public JasperPrint createKitchenPrint(HashMap hashMap, String string, KitchenTicket kitchenTicket, String string2) throws Exception {
        return this.createKitchenPrint(hashMap, string, kitchenTicket, string2, false, null);
    }

    public JasperPrint createKitchenPrint(HashMap hashMap, String string, KitchenTicket kitchenTicket, String string2, boolean bl, Font font) throws Exception {
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        String string3 = "kitchen-receipt";
        ReciptPaperSize reciptPaperSize = JasperPrintService.a("kitchen.recipt.paper_size");
        Font font2 = DataProvider.get().getKitchenReciptFont();
        if (font != null) {
            font2 = font;
        }
        if (Application.getInstance().getTerminal().isGroupByCatagoryKitReceipt().booleanValue()) {
            string3 = "kitchen-receipt-with-group";
        }
        JasperReport jasperReport = ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size(string3));
        if (font2 != null) {
            ReportUtil.setFont(jasperReport, font2, AppConfig.getKitchenReceiptFontPath());
        }
        return this.createJasperPrint(jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        block4: {
            ReportUtil.mirrorLayout(jasperPrint);
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                Date date = new Date();
                String string = simpleDateFormat.format(date);
                String string2 = jasperPrint.getProperty("printerName");
                if (string2 != null && string2.equals(ReceiptPrintService.OROPOS_PDF_PRINTER)) {
                    String string3 = jasperPrint.getName().replace(string2, "") + "-[" + string + "]";
                    File file = new File(ReceiptPrintService.getPdfPrinterDir(), string3 + ".pdf");
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)file.getAbsolutePath());
                } else {
                    SimplePrintServiceExporterConfiguration simplePrintServiceExporterConfiguration = new SimplePrintServiceExporterConfiguration();
                    simplePrintServiceExporterConfiguration.setPrintService(PrintServiceUtil.getPrintServiceForPrinter(jasperPrint.getProperty("printerName")));
                    JRPrintServiceExporter jRPrintServiceExporter = new JRPrintServiceExporter();
                    jRPrintServiceExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    jRPrintServiceExporter.setConfiguration((ExporterConfiguration)simplePrintServiceExporterConfiguration);
                    jRPrintServiceExporter.exportReport();
                }
            }
            catch (Exception exception) {
                if (exception != null && exception.getCause() instanceof PrinterAbortException) break block4;
                String string = "No print selected\n";
                ReceiptPrintService.getLogger().error((Object)(string + exception));
            }
        }
    }

    private JasperPrint a(Ticket ticket, Store store, Font font) {
        try {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, false);
            Iterator<KitchenTicket> iterator = list.iterator();
            if (iterator.hasNext()) {
                KitchenTicket kitchenTicket = iterator.next();
                kitchenTicket.setParentTicket(ticket);
                HashMap hashMap = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, store, "", "", true, false);
                JasperPrint jasperPrint = this.createKitchenPrint(hashMap, "", kitchenTicket, "", true, font);
                jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                return jasperPrint;
            }
        }
        catch (JRFontNotFoundException jRFontNotFoundException) {
            throw jRFontNotFoundException;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        return null;
    }

    public void printGenericReport(HashMap<String, Object> hashMap) throws Exception {
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("generic-receipt"), hashMap, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void testPrinter(HashMap<String, Object> hashMap, String string) throws Exception {
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("test-printer"), hashMap, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printServerSummaryReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = PosPrintService.createServerSummaryReportPrint(cashDrawer, hashMap);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void showServerSummaryReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        JasperPrint jasperPrint = PosPrintService.createServerSummaryReportPrint(cashDrawer, hashMap);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        ticketReceiptView.setZoom(1.25f);
        jPanel.add(ticketReceiptView.getReportPanel());
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Override
    public void printCashDrawerReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = PosPrintService.createCashDrawerReportPrint(cashDrawer, hashMap);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void showCashDrawerReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        JasperPrint jasperPrint = PosPrintService.createCashDrawerReportPrint(cashDrawer, hashMap);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        ticketReceiptView.setZoom(1.25f);
        jPanel.add(ticketReceiptView.getReportPanel());
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Override
    public void printStoreSessionSummaryReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = PosPrintService.createStoreSessionSummaryReportPrint(cashDrawer, hashMap);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void showStoreSessionSummaryReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        JasperPrint jasperPrint = PosPrintService.createStoreSessionSummaryReportPrint(cashDrawer, hashMap);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        ticketReceiptView.setZoom(1.25f);
        jPanel.add(ticketReceiptView.getReportPanel());
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Override
    public void printPayoutAmountReport(HashMap hashMap, PayOutTransaction payOutTransaction, String string) throws Exception {
        JasperPrint jasperPrint = PosPrintService.createPayoutAmountReportPrint(hashMap, payOutTransaction);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void rendererTicketReceiptView(Ticket ticket, Store store, JPanel jPanel, Font font, boolean bl) throws Exception {
        String string = null;
        if (bl) {
            string = Messages.getString("JasperPrintService.3");
        }
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(string, false, true, true);
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, store, ticketPrintProperties, null, false, false, true);
        hashMap.put("IS_IGNORE_PAGINATION", true);
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, null, false, font);
        ReportUtil.mirrorLayout(jasperPrint);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        jPanel.add(ticketReceiptView.getReportPanel());
    }

    private static class VoidTransactionReportModel
    extends ListTableModel<ReceiptPrintService.VoidTransactionDataRow> {
        public VoidTransactionReportModel(List<ReceiptPrintService.VoidTransactionDataRow> list) {
            super(new String[]{"voidTenderName", "voidTransAmount"}, list);
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ReceiptPrintService.VoidTransactionDataRow voidTransactionDataRow = (ReceiptPrintService.VoidTransactionDataRow)this.getRowData(n);
            switch (n2) {
                case 0: {
                    return voidTransactionDataRow.getPaymentType();
                }
                case 1: {
                    return voidTransactionDataRow.getAmount();
                }
            }
            return null;
        }
    }

    private static class TransactionReportModel
    extends ListTableModel<ReceiptPrintService.TransactionDataRow> {
        public TransactionReportModel(List<ReceiptPrintService.TransactionDataRow> list) {
            super(new String[]{"tenderName", "transAmount"}, list);
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ReceiptPrintService.TransactionDataRow transactionDataRow = (ReceiptPrintService.TransactionDataRow)this.getRowData(n);
            switch (n2) {
                case 0: {
                    return transactionDataRow.getPaymentType();
                }
                case 1: {
                    return NumberUtil.formatCurrencyAmount(transactionDataRow.getCurrencySymbol(), transactionDataRow.getAmount());
                }
            }
            return null;
        }
    }
}

