/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.qrcode;

import com.floreantpos.PosException;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import org.apache.commons.lang.StringUtils;

public class QRCodeView {
    private Ticket a;

    public QRCodeView(Ticket ticket) {
        this.a = ticket;
    }

    public BufferedImage getQrCodeImage() {
        try {
            int n = 70;
            EnumMap<EncodeHintType, Object> enumMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
            enumMap.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
            enumMap.put(EncodeHintType.MARGIN, (Object)1);
            enumMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H);
            QRCodeWriter qRCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qRCodeWriter.encode(this.a(), BarcodeFormat.QR_CODE, n, n, enumMap);
            int n2 = bitMatrix.getWidth();
            BufferedImage bufferedImage = new BufferedImage(n2, n2, 1);
            int n3 = bufferedImage.getHeight();
            bufferedImage.createGraphics();
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n2, n2);
            graphics2D.setColor(Color.black);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (!bitMatrix.get(i, j)) continue;
                    graphics2D.fillRect(i, j, 1, 1);
                }
            }
            BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 1);
            Graphics2D graphics2D2 = bufferedImage2.createGraphics();
            graphics2D2.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D2.dispose();
            return bufferedImage2;
        }
        catch (Exception exception) {
            throw new PosException(exception.getMessage());
        }
    }

    private String a() {
        String string = "";
        Store store = DataProvider.get().getStore();
        string = string + "Store name: " + store.getName();
        if (StringUtils.isNotBlank((String)store.getVATNumber())) {
            string = string + "\nVat number: " + store.getVATNumber();
        }
        if (this.a.getCreateDate() != null) {
            string = string + "\nTime: " + DateUtil.formatDateWithTime(this.a.getCreateDate());
        }
        if (this.a.getTaxAmount() != null) {
            string = string + "\nTax amount (" + CurrencyUtil.getCurrencySymbol() + "): " + NumberUtil.formatNumber(this.a.getTaxAmount());
        }
        if (this.a.getSubtotalAmount() != null) {
            string = string + "\nInvoice amount (" + CurrencyUtil.getCurrencySymbol() + "): " + NumberUtil.formatNumber(this.a.getSubtotalAmount());
        }
        return string;
    }
}

