/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AbstractReportDataSource;
import java.util.ArrayList;

public class OrderDataSource
extends AbstractReportDataSource {
    public OrderDataSource(PurchaseOrder purchaseOrder) {
        super(new String[]{"itemSL", "itemImage", "itemName", "batchNo", "expiryDate", "itemQty", "unit", "itemPrice", "itemSubtotal", "itemNote"});
        this.a(purchaseOrder);
    }

    private void a(PurchaseOrder purchaseOrder) {
        ArrayList<PurchaseOrderItem> arrayList = new ArrayList<PurchaseOrderItem>();
        arrayList.addAll(purchaseOrder.getOrderItems());
        this.setRows(arrayList);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)this.rows.get(n);
        switch (n2) {
            case 0: {
                return String.valueOf(n + 1);
            }
            case 1: {
                return null;
            }
            case 2: {
                return purchaseOrderItem.getName();
            }
            case 3: {
                return purchaseOrderItem.getBatchNumber();
            }
            case 4: {
                return purchaseOrderItem.getExpireDate() != null ? DateUtil.formatFullDateAsString(purchaseOrderItem.getExpireDate()) : null;
            }
            case 5: {
                return purchaseOrderItem.getQuantityDisplay();
            }
            case 6: {
                return purchaseOrderItem.getUnitNameDisplay();
            }
            case 7: {
                return purchaseOrderItem.getPriceDisplay();
            }
            case 8: {
                return purchaseOrderItem.getTotalDisplay();
            }
            case 9: {
                return purchaseOrderItem.getNote();
            }
        }
        return null;
    }
}

