/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OutletUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.Font;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseStaticText;
import net.sf.jasperreports.engine.base.JRBaseTextField;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportUtil {
    private static Log a = LogFactory.getLog(ReportUtil.class);
    private static final String b = "/com/floreantpos/report/template/";
    public static String TIME_FORMAT = "HH'h 'mm'm 'ss's'";

    public static void populateRestaurantProperties(Map<String, Object> map) {
        ReportUtil.populateRestaurantProperties(map, false);
    }

    public static void populateRestaurantProperties(Map<String, Object> map, boolean bl) {
        JasperReport jasperReport = null;
        jasperReport = bl ? ReportUtil.getReport("report_header_portrait") : ReportUtil.getReport(PaperSize.getReportNameAccording2Size("report_header"));
        Store store = DataProvider.get().getStore();
        Outlet outlet = DataProvider.get().getOutlet();
        if (store != null) {
            StoreUtil storeUtil = new StoreUtil();
            map.put("restaurantName", storeUtil.getName(store));
            OutletUtil outletUtil = new OutletUtil();
            map.put("addressLine1", outletUtil.getAddressLine1(outlet));
            map.put("addressLine2", outletUtil.getAddressLine2(outlet));
            map.put("addressLine3", outletUtil.getAddressLine3(outlet));
            map.put("phone", outletUtil.getTelephone(outlet));
            map.put("reportHeader", jasperReport);
            ReportUtil.populatePatternExpression(map, store);
        }
    }

    public static void populatePatternExpression(Map<String, Object> map, Store store) {
        boolean bl = DataProvider.get().getCurrentTerminal().isEnableRtl();
        map.put("isRtl", bl);
        ReportUtil.populateDemoLicenseMessage(map);
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        map.put("REPORT_LOCALE", locale);
        int n = store.getDecimalPlace();
        switch (n) {
            case 2: {
                map.put("patternEXP", "#,##0.00");
                break;
            }
            case 3: {
                map.put("patternEXP", "#,##0.000");
                break;
            }
            case 4: {
                map.put("patternEXP", "#,##0.0000");
                break;
            }
            default: {
                map.put("patternEXP", "#,##0.00");
            }
        }
    }

    public static void populateDemoLicenseMessage(Map<String, Object> map) {
        boolean bl = Application.getInstance().getLicense().isDemoLicense();
        if (!bl) {
            return;
        }
        map.put("demoLicense", bl);
        map.put("demoLicenseText", "Oropos demo license");
    }

    public static JasperReport getReport(String string) {
        return ReportUtil.a(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JasperReport a(String string) {
        InputStream inputStream = null;
        try {
            inputStream = ReceiptPrintService.class.getResourceAsStream(b + string + ".jasper");
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)inputStream);
            ReportUtil.setFont(jasperReport, "Arial");
            JasperReport jasperReport2 = jasperReport;
            IOUtils.closeQuietly((InputStream)inputStream);
            return jasperReport2;
        }
        catch (Exception exception) {
            a.error((Object)exception);
            JasperReport jasperReport = null;
            return jasperReport;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static void setFont(JasperReport jasperReport, Font font, String string) {
        ReportUtil.setFont(jasperReport, font.getFontName(), font.getSize(), string);
    }

    public static void setFont(JasperReport jasperReport, String string) {
        ReportUtil.setFont(jasperReport, string, null);
    }

    public static void setFont(JasperReport jasperReport, String string, Integer n) {
        ReportUtil.setFont(jasperReport, string, n, null);
    }

    public static void setFont(JasperReport jasperReport, String string, Integer n, String string2) {
        JRBand[] jRBandArray = jasperReport.getAllBands();
        for (int i = 0; i < jRBandArray.length; ++i) {
            List list = jRBandArray[i].getChildren();
            if (list == null) continue;
            for (JRChild jRChild : list) {
                JRBaseTextField jRBaseTextField;
                if (jRChild instanceof JRBaseTextField) {
                    jRBaseTextField = (JRBaseTextField)jRChild;
                    jRBaseTextField.setFontName(string);
                    if (StringUtils.isNotBlank((String)string2)) {
                        jRBaseTextField.setPdfFontName(string2);
                        jRBaseTextField.setPdfEmbedded(true);
                    }
                    if (n == null) continue;
                    jRBaseTextField.setFontSize(n);
                    continue;
                }
                if (!(jRChild instanceof JRBaseStaticText)) continue;
                jRBaseTextField = (JRBaseStaticText)jRChild;
                jRBaseTextField.setFontName(string);
                if (n == null) continue;
                jRBaseTextField.setFontSize(n);
            }
        }
    }

    public static void populateReportHeader(HashMap<String, Object> hashMap, Terminal terminal, Date date, Date date2, String string) {
        ReportUtil.populateReportHeader(hashMap, terminal, date, date2, string, false);
    }

    public static void populateReportHeader(HashMap<String, Object> hashMap, Terminal terminal, Date date, Date date2, String string, boolean bl) {
        String string2;
        String string3 = string2 = terminal == null ? POSConstants.ALL : terminal.getName();
        if (bl) {
            ReportUtil.populateReportTimeMonthFormat(hashMap, date, date2);
        } else {
            ReportUtil.populateReportTime(hashMap, date, date2);
        }
        if (string != null) {
            hashMap.put("userType", ReportUtil.reportLabelWithBoldTag(POSConstants.USER_TYPE) + " " + string);
        } else {
            hashMap.put("systemTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.SYSTEM_TYPE) + " " + POSConstants.SYSTEM_TOTAL);
        }
        hashMap.put("terminalName", ReportUtil.reportLabelWithBoldTag(POSConstants.TERMINAL) + " " + string2);
        hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
    }

    public static void populateReportTime(HashMap<String, Object> hashMap, Date date, Date date2) {
        hashMap.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + DateUtil.formatReportDateWithTime(new Date()));
        if (date != null) {
            hashMap.put("fromDate", ReportUtil.reportLabelWithBoldTag(POSConstants.FROM_DATE) + DateUtil.formatReportDateWithTime(date));
        }
        if (date2 != null) {
            hashMap.put("toDate", ReportUtil.reportLabelWithBoldTag(POSConstants.TO_DATE) + DateUtil.formatReportDateWithTime(date2));
        }
    }

    public static void populateReportTimeMonthFormat(HashMap<String, Object> hashMap, Date date, Date date2) {
        hashMap.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + DateUtil.formatReportDateWithTime(new Date()));
        if (date != null) {
            hashMap.put("fromDate", ReportUtil.reportLabelWithBoldTag(POSConstants.FROM_DATE) + DateUtil.format("MMMMM yyyy", date));
        }
        if (date2 != null) {
            hashMap.put("toDate", ReportUtil.reportLabelWithBoldTag(POSConstants.TO_DATE) + DateUtil.format("MMMMM yyyy", date2));
        }
    }

    public static void populateReportFooter(HashMap<String, Object> hashMap) {
        hashMap.put("footerPage", ReportUtil.reportLabelWithBoldTag(POSConstants.PAGE));
    }

    public static String doStrike(String string) {
        return "<strike>" + string + "</strike>";
    }

    public static String reportLabelWithBoldTag(String string) {
        String string2 = "<b>" + string + "</b>";
        return string2;
    }

    public static String getHourMinSecDisplay(long l) {
        return DurationFormatUtils.formatDuration((long)l, (String)TIME_FORMAT);
    }

    private static long a(long l) {
        return l / 3600000L;
    }

    private static String b(long l) {
        long l2 = l / 3600000L;
        double d = new Double(l -= l2 * 3600000L) / 60000.0;
        return NumberUtil.formatNumberIfNeeded(d);
    }

    public static void mirrorLayout(JasperPrint jasperPrint) {
        if (!DataProvider.get().getCurrentTerminal().isEnableRtl()) {
            return;
        }
        int n = jasperPrint.getPageWidth();
        for (Object e : jasperPrint.getPages()) {
            JRPrintPage jRPrintPage = (JRPrintPage)e;
            ReportUtil.a(jRPrintPage.getElements(), n);
        }
    }

    private static void a(List<?> list, int n) {
        for (JRPrintElement jRPrintElement : list) {
            int n2 = n - jRPrintElement.getX() - jRPrintElement.getWidth();
            jRPrintElement.setX(n2);
            if (!(jRPrintElement instanceof JRPrintFrame)) continue;
            JRPrintFrame jRPrintFrame = (JRPrintFrame)jRPrintElement;
            ReportUtil.a(jRPrintFrame.getElements(), jRPrintFrame.getWidth());
        }
    }
}

