/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MonthOfYear;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ItemwiseSalesReport;
import com.floreantpos.report.OpenTicketSummaryReport;
import com.floreantpos.report.Report;
import com.floreantpos.report.SalesByEmployeeReport;
import com.floreantpos.report.SalesReport;
import com.floreantpos.report.SalesTaxReport;
import com.floreantpos.report.VoidItemReport;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.PosWebService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class ReportViewer
extends JPanel {
    private JButton a;
    private JButton b;
    private JLabel c;
    private JComboBox d;
    private JXDatePicker e;
    private JXDatePicker f;
    private JComboBox<Date> g;
    private JComboBox<Date> h;
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private JCheckBox l;
    private JCheckBox m;
    private JLabel n;
    private JComboBox o;
    private JLabel p;
    private JComboBox<OrderType> q;
    private TransparentPanel r;
    private TransparentPanel s;
    private JCheckBox t;
    private Report u;
    private MultiSelectComboBox<MenuGroup> v;
    private JPanel w;
    private JLabel x;
    private FixedLengthTextField y;
    private JPanel z;
    private JPanel A;
    private JPanel B;
    private JPanel C;
    private JPanel D;
    private JPanel E;
    private JLabel F;
    private JComboBox<Object> G;
    private JCheckBox H;
    private JPanel I;
    private JComboBox<String> J;
    private JLabel K;
    private JPanel L;
    private JComboBox<MonthOfYear> M;
    private JComboBox<Integer> N;
    private JPanel O;
    private JComboBox<MonthOfYear> P;
    private JComboBox<Integer> Q;
    private JPanel R;
    private MultiSelectComboBox<User> S;
    private JCheckBox T;
    private FixedLengthTextField U;
    private JPanel V;

    public ReportViewer() {
        this.a();
    }

    public ReportViewer(Report report) {
        Object object;
        this.a();
        this.v.setItems(MenuGroupDAO.getInstance().findAll());
        TerminalDAO terminalDAO = new TerminalDAO();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(0, POSConstants.ALL);
        List<Terminal> list = terminalDAO.findAll();
        for (Terminal serializable2 : list) {
            if (!serializable2.isHasCashDrawer().booleanValue()) continue;
            arrayList.add(serializable2);
        }
        this.d.setModel(new ListComboBoxModel(arrayList));
        List<Customer> list2 = CustomerDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        Object object2 = list2.iterator();
        while (object2.hasNext()) {
            object = (Customer)object2.next();
            comboBoxModel.addElement(object);
        }
        object2 = new ArrayList();
        object2.add(0, POSConstants.ALL);
        object2.add(1, Messages.getString("ReportViewer.1"));
        object2.add(2, Messages.getString("ReportViewer.9"));
        this.G.setModel(new ListComboBoxModel((List)object2));
        object = POSUtil.getYearList();
        this.N.setModel(new ListComboBoxModel((List)object));
        this.Q.setModel(new ListComboBoxModel((List)object));
        this.selectCurrentMonth();
        List<User> list3 = UserDAO.getInstance().findAllActive();
        this.S.setItems(list3);
        this.setReport(report);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.r = new TransparentPanel();
        WrapLayout wrapLayout = new WrapLayout(0, 5, 5);
        this.r.setLayout(wrapLayout);
        this.c = new JLabel(Messages.getString("ReportViewer.4"));
        this.v = new MultiSelectComboBox();
        this.v.setMultiSelectListener(list -> this.a((ActionEvent)null));
        JLabel jLabel = new JLabel(Messages.getString("CUSTOMER"));
        this.U = new FixedLengthTextField(15, 20);
        this.U.setPreferredSize(PosUIManager.getSize((int)0, (int)22));
        this.U.setEditable(false);
        PosSmallButton posSmallButton = new PosSmallButton("...");
        posSmallButton.setPreferredSize(PosUIManager.getSize((int)20, (int)22));
        posSmallButton.setToolTipText(Messages.getString("SelectMember"));
        posSmallButton.addActionListener(actionEvent -> this.c());
        JButton jButton = new JButton("X");
        jButton.setToolTipText(Messages.getString("ReportViewer.17"));
        jButton.addActionListener(actionEvent -> this.b());
        this.F = new JLabel(Messages.getString("ReportViewer.10"));
        this.G = new JComboBox();
        this.G.addActionListener(actionEvent -> this.a(actionEvent));
        this.k = new JLabel(Messages.getString("ReportViewer.3"));
        this.d = new JComboBox();
        this.i = new JLabel(POSConstants.START_DATE + ":");
        this.f = UiUtil.getCurrentMonthStart();
        TimeComboBox timeComboBox = new TimeComboBox();
        this.g = timeComboBox.getDefaultTimeComboBox();
        this.j = new JLabel(POSConstants.END_DATE + ":");
        this.e = UiUtil.getCurrentMonthEnd();
        this.h = timeComboBox.getDefaultTimeComboBox();
        this.l = new JCheckBox(Messages.getString("ReportViewer.6"));
        this.t = new JCheckBox(Messages.getString("show_online_report_only"));
        this.t.addActionListener(actionEvent -> this.a(actionEvent));
        this.m = new JCheckBox(Messages.getString("ReportViewer.5"));
        this.m.addActionListener(actionEvent -> this.a(actionEvent));
        this.H = new JCheckBox(Messages.getString("ReportViewer.11"));
        this.H.setSelected(false);
        this.H.addActionListener(actionEvent -> this.a(actionEvent));
        this.n = new JLabel(Messages.getString("ReportViewer.7"));
        this.o = new JComboBox();
        this.p = new JLabel(Messages.getString("ReportViewer.0"));
        this.q = new JComboBox();
        this.a = new JButton(Messages.getString("ReportViewer.2"));
        this.s = new TransparentPanel();
        this.a.addActionListener(actionEvent -> this.a(actionEvent));
        this.b = new JButton(Messages.getString("ReportViewer.8"));
        this.b.addActionListener(actionEvent -> this.doClear(actionEvent));
        this.K = new JLabel(Messages.getString("ReportViewer.12"));
        this.J = new JComboBox();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, Messages.getString("ReportViewer.13"));
        arrayList.add(1, Messages.getString("ReportViewer.14"));
        this.J.setModel(new ListComboBoxModel(arrayList));
        this.J.addActionListener(actionEvent -> this.d());
        JLabel jLabel2 = new JLabel(POSConstants.FROM + ":");
        JLabel jLabel3 = new JLabel(POSConstants.TO + ":");
        this.M = new JComboBox<MonthOfYear>(MonthOfYear.values());
        this.P = new JComboBox<MonthOfYear>(MonthOfYear.values());
        this.N = new JComboBox();
        this.Q = new JComboBox();
        this.T = new JCheckBox(Messages.getString("ReportViewer.15"));
        JLabel jLabel4 = new JLabel(POSConstants.EMPLOYEE + ":");
        this.S = new MultiSelectionOverflowCombobox<User>();
        this.R = new JPanel();
        this.R.add(jLabel4);
        this.R.add(this.S);
        this.L = new JPanel();
        this.L.setVisible(false);
        this.L.add(jLabel2);
        this.L.add(this.M);
        this.L.add(this.N);
        this.O = new JPanel();
        this.O.setVisible(false);
        this.O.add(jLabel3);
        this.O.add(this.P);
        this.O.add(this.Q);
        this.I = new JPanel();
        this.I.add(this.K);
        this.I.add(this.J);
        this.w = new JPanel();
        this.w.add(this.c);
        this.w.add(this.v);
        this.x = new JLabel(Messages.getString("ReportViewer.16"));
        this.y = new FixedLengthTextField(10, 32);
        this.y.addActionListener(actionEvent -> this.a(actionEvent));
        this.V = new JPanel();
        this.V.add(jLabel);
        this.V.add(this.U);
        this.V.add(posSmallButton);
        this.V.add(jButton);
        this.w.add(this.V);
        this.E = new JPanel();
        this.E.add(this.F);
        this.E.add(this.G);
        this.z = new JPanel();
        this.z.add(this.k);
        this.z.add(this.d);
        this.A = new JPanel();
        this.A.add(this.i);
        this.A.add((Component)this.f);
        this.A.add(this.g);
        this.B = new JPanel();
        this.B.add(this.j);
        this.B.add((Component)this.e);
        this.B.add(this.h);
        this.r.add(this.w);
        this.r.add(this.x);
        this.r.add(this.y);
        this.r.add(this.E);
        this.r.add(this.z);
        this.r.add(this.A);
        this.r.add(this.B);
        this.r.add(this.l);
        this.r.add(this.m);
        this.r.add(this.H);
        this.r.add(this.a);
        this.s.setLayout(new BorderLayout(5, 5));
        this.s.add((Component)new JSeparator(0), "North");
        this.add((Component)this.r, "North");
        this.add((Component)this.s, "Center");
    }

    private void b() {
        if (StringUtils.isNotBlank((String)this.U.getText())) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ReportViewer.18"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            this.U.setText("");
            this.u.setCustomer(null);
            this.a((ActionEvent)null);
        }
    }

    private void c() {
        try {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(null, false);
            customerSelectorDialog.setCreateNewTicket(false);
            customerSelectorDialog.updateView(true);
            customerSelectorDialog.setVisibleHistoryButtons(false);
            customerSelectorDialog.setVisibleCreateNewCustomerBtn(false);
            customerSelectorDialog.openUndecoratedFullScreen();
            if (!customerSelectorDialog.isCanceled()) {
                Customer customer = customerSelectorDialog.getSelectedCustomer();
                this.U.setText(customer.getName());
                if (this.u != null) {
                    this.u.setCustomer(customer);
                }
                this.a((ActionEvent)null);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void d() {
        int n = this.J.getSelectedIndex();
        if (n == 0) {
            this.A.setVisible(true);
            this.B.setVisible(true);
            this.L.setVisible(false);
            this.O.setVisible(false);
        } else {
            this.A.setVisible(false);
            this.B.setVisible(false);
            this.L.setVisible(true);
            this.O.setVisible(true);
        }
        this.a((ActionEvent)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ActionEvent actionEvent) {
        if (this.u != null && this.u.getViewer() != null) {
            this.s.remove((Component)this.u.getViewer());
            this.s.revalidate();
            this.s.repaint();
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            MonthOfYear monthOfYear = (MonthOfYear)((Object)this.M.getSelectedItem());
            int n = (Integer)this.N.getSelectedItem();
            Date date = POSUtil.monthOfYear(monthOfYear.getValue(), n);
            MonthOfYear monthOfYear2 = (MonthOfYear)((Object)this.P.getSelectedItem());
            int n2 = (Integer)this.Q.getSelectedItem();
            Date date2 = POSUtil.monthOfYear(monthOfYear2.getValue(), n2);
            int n3 = this.J.getSelectedIndex();
            Date date3 = this.f.getDate();
            Date date4 = this.e.getDate();
            Date date5 = (Date)this.g.getSelectedItem();
            Date date6 = (Date)this.h.getSelectedItem();
            if (date3 != null) {
                date3 = DateUtil.copyTime(date3, date5);
            }
            if (date4 != null) {
                date4 = DateUtil.copyTime(date4, date6);
            }
            if (n3 == 1) {
                DateUtil.validateDate(date, date2);
            } else if (!this.u.isAllowEmptyDateField()) {
                DateUtil.validateDate(date3, date4);
            }
            this.s.removeAll();
            this.s.revalidate();
            this.s.add((Component)new JSeparator(0), "North");
            if (this.u != null) {
                UserType userType = null;
                if (this.o.getSelectedItem() instanceof UserType) {
                    userType = (UserType)this.o.getSelectedItem();
                }
                this.u.setUserType(userType);
                OrderType orderType = null;
                if (this.q.getSelectedItem() instanceof OrderType) {
                    orderType = (OrderType)this.q.getSelectedItem();
                }
                this.u.setOrderType(orderType);
                Terminal terminal = null;
                if (this.d.getSelectedItem() instanceof Terminal) {
                    terminal = (Terminal)this.d.getSelectedItem();
                }
                Boolean bl = null;
                if (this.G.getSelectedIndex() == 1) {
                    bl = Boolean.TRUE;
                } else if (this.G.getSelectedIndex() == 2) {
                    bl = Boolean.FALSE;
                }
                this.u.setReportType(n3);
                this.u.setInvItemType(bl);
                this.u.setMenuGroups(this.v.getSelectedItems());
                this.u.setTicketId(this.y.getText().trim());
                this.u.setTerminal(terminal);
                this.u.setStartDate(date3);
                this.u.setEndDate(date4);
                this.u.setIncludeFreeItems(this.l.isSelected());
                this.u.setShowInGroups(this.m.isSelected());
                this.u.setShowModifier(this.H.isSelected());
                this.u.setFromMonthAndYear(date);
                this.u.setToMonthAndYear(date2);
                this.u.setUsers(this.S.getSelectedItems());
                this.u.setShowOnlineTicket(this.t.isSelected());
                this.u.setShowBreakdown(this.T.isSelected());
                this.u.refresh();
                if (this.u != null && this.u.getViewer() != null) {
                    this.s.add((Component)this.u.getViewer());
                    this.s.revalidate();
                    this.s.repaint();
                }
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void doClear(ActionEvent actionEvent) {
        if (this.u != null) {
            if (this.u instanceof ItemwiseSalesReport) {
                this.v.setSelectedIndex(0);
                this.v.unselectAllItems();
                this.G.setSelectedIndex(0);
                this.d.setSelectedIndex(0);
                this.l.setSelected(false);
                this.H.setSelected(false);
                this.m.setSelected(false);
                JXDatePicker jXDatePicker = UiUtil.getCurrentMonthStart();
                this.f.setDate(jXDatePicker.getDate());
                this.e.setDate(new Date());
                this.U.setText("");
                this.u.setCustomer(null);
                this.t.setSelected(false);
                this.y.setText("");
                this.a((ActionEvent)null);
                return;
            }
            if (this.u instanceof SalesReport) {
                this.J.setSelectedIndex(0);
                JXDatePicker jXDatePicker = UiUtil.getCurrentMonthStart();
                this.f.setDate(jXDatePicker.getDate());
                this.e.setDate(new Date());
                this.U.setText("");
                this.u.setCustomer(null);
                this.t.setSelected(false);
                this.a((ActionEvent)null);
                return;
            }
            this.q.setSelectedIndex(0);
            this.o.setSelectedIndex(0);
            this.d.setSelectedIndex(0);
        }
    }

    public Report getReport() {
        return this.u;
    }

    public void setReport(Report report) {
        this.u = report;
        if (report instanceof ItemwiseSalesReport) {
            if (PosWebService.get().isCloudConfigured()) {
                this.r.add(this.t);
            }
            this.r.add(this.a);
            this.r.add(this.b);
            this.r.remove(this.z);
            this.e.setDate(new Date());
            this.u.setIsAllowEmptyDateField(Boolean.TRUE);
        }
        if (report instanceof SalesByEmployeeReport) {
            this.r.removeAll();
            this.r.add(this.R);
            this.r.add(this.A);
            this.r.add(this.B);
            this.r.add(this.a);
            this.u.setIsAllowEmptyDateField(Boolean.FALSE);
        }
        if (report instanceof SalesTaxReport) {
            this.r.removeAll();
            this.L.setVisible(true);
            this.O.setVisible(true);
            this.r.add(this.L);
            this.r.add(this.O);
            this.r.add(this.T);
            this.r.add(this.a);
            this.J.setSelectedIndex(1);
            this.u.setIsAllowEmptyDateField(Boolean.FALSE);
        }
        if (report instanceof SalesReport) {
            this.r.removeAll();
            this.f.setFormats(new String[]{"dd MMM yy"});
            this.e.setFormats(new String[]{"dd MMM yy"});
            this.r.add(this.I);
            this.r.add(this.V);
            this.r.add(this.L);
            this.r.add(this.O);
            this.r.add(this.A);
            this.r.add(this.B);
            if (PosWebService.get().isCloudConfigured()) {
                this.r.add(this.t);
            }
            this.g.setVisible(false);
            this.h.setVisible(false);
            this.r.add(this.a);
            this.r.add(this.b);
            this.e.setDate(new Date());
            this.u.setIsAllowEmptyDateField(Boolean.FALSE);
        }
        if (report instanceof VoidItemReport) {
            this.r.removeAll();
            this.r.add(this.z);
            this.r.add(this.A);
            this.r.add(this.B);
            this.r.add(this.a);
            this.u.setIsAllowEmptyDateField(Boolean.FALSE);
        }
        if (report instanceof OpenTicketSummaryReport) {
            this.r.removeAll();
            UserTypeDAO userTypeDAO = new UserTypeDAO();
            List<UserType> list = userTypeDAO.findAll();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(0, POSConstants.ALL);
            arrayList.addAll(list);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(0, POSConstants.ALL);
            arrayList2.addAll(OrderTypeDAO.getInstance().findAll());
            this.o.setModel(new ListComboBoxModel(arrayList));
            this.C = new JPanel();
            this.C.add(this.n);
            this.C.add(this.o);
            this.r.add(this.C);
            this.q.setModel(new ListComboBoxModel(arrayList2));
            this.D = new JPanel();
            this.D.add(this.p);
            this.D.add(this.q);
            this.r.add(this.D);
            this.r.add(this.A);
            this.r.add(this.B);
            this.r.add(this.z);
            this.r.add(this.a);
            this.r.add(this.b);
            this.u.setIsAllowEmptyDateField(Boolean.FALSE);
        }
    }

    public void selectCurrentMonth() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(2);
        this.M.setSelectedIndex(n);
        this.P.setSelectedIndex(n);
    }
}

