/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.chart;

import com.floreantpos.Messages;
import com.floreantpos.model.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.Period;

public enum ChartDuration {
    TODAY(Messages.getString("ChartDuration.0")),
    WEEK(Messages.getString("ChartDuration.1")),
    HALF_MONTH(Messages.getString("ChartDuration.2")),
    MONTH(Messages.getString("ChartDuration.3"));

    private String a;

    private ChartDuration(String string2) {
        this.a = string2;
    }

    public String getDurationName() {
        return this.a;
    }

    public static Date getFromDateBehind(ChartDuration chartDuration) {
        return ChartDuration.getFromDateBehind(Calendar.getInstance().getTime(), chartDuration);
    }

    public static Date getFromDateBehind(Date date, ChartDuration chartDuration) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if (chartDuration == WEEK) {
            calendar.add(5, -6);
        } else if (chartDuration == HALF_MONTH) {
            calendar.add(5, -14);
        } else if (chartDuration == MONTH) {
            calendar.add(2, -1);
        }
        Date date2 = DateUtil.startOfDay(calendar.getTime());
        return date2;
    }

    public static int getHoursPeriod(ChartDuration chartDuration) {
        return ChartDuration.getHoursPeriod(Calendar.getInstance().getTime(), chartDuration);
    }

    public static int getHoursPeriod(Date date, ChartDuration chartDuration) {
        Date date2 = ChartDuration.getFromDateBehind(date, chartDuration);
        Period period = new Period(date2.getTime(), date.getTime());
        int n = 0;
        if (Math.abs(period.getMonths()) >= 1) {
            n += Math.abs(period.getMonths()) * 30 * 24;
        }
        if (Math.abs(period.getWeeks()) >= 1) {
            n += Math.abs(period.getWeeks()) * 7 * 24;
        }
        if (Math.abs(period.getDays()) >= 1) {
            n += Math.abs(period.getDays() * 24);
        }
        if (Math.abs(period.getHours()) >= 1) {
            n += Math.abs(period.getHours());
        }
        return n;
    }

    public String toString() {
        return this.a;
    }
}

