/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.chart;

import com.floreantpos.Messages;
import com.floreantpos.model.PaymentType;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class DummyRecordService {
    public static final String[] MENU_ITEMS_NAME = new String[]{"American Burger", "Beef Burger", "Cheese Burger", "Chicken Burger", "COKE (Large)", "COKE (Medium)", "COKE (Small)", "FANTA", "SPRITE", "CHICKEN SANDWICH", "BEEF SANDWICH", "HAM SANDWICH", "Apple Pie", "French Fries", "Hot Dogs", "Chocolate Chip", "Fried Chicken", "Grilled Cheese", "Ice Cream", "Oreos"};
    public static final String[] USERS_NAME = new String[]{"Admin s", "Manager m", "Cashier c", "John Doe", "Juthi M", "Jack S", "David c", "James g", "Thomus s", "Linda c", "Elizabeth v", "Susan g", "Sarah l", "Anthony w", "Paul s", "Kevin a", "Ryan r", "Pamela a", "Helen B", "Victoria s"};
    private static PaymentType[] a = PaymentType.values();

    public static String createRandomNumber() {
        Random random = new Random();
        int n = random.nextInt(10000);
        return NumberUtil.format(n);
    }

    public static int createRandomInt() {
        Random random = new Random();
        return random.nextInt(10000);
    }

    public static DefaultCategoryDataset createtopItemBarChartDataSet() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        });
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            String string = MENU_ITEMS_NAME[random.nextInt(MENU_ITEMS_NAME.length)];
            treeMap.put(string, random.nextInt(100));
        }
        Set set = treeMap.keySet();
        for (String string : set) {
            defaultCategoryDataset.addValue((Number)treeMap.get(string), (Comparable)((Object)string), (Comparable)((Object)string));
        }
        return defaultCategoryDataset;
    }

    public static DefaultPieDataset createtopPaymentTypePieChartDataSet() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            PaymentType paymentType = a[random.nextInt(a.length)];
            defaultPieDataset.setValue((Comparable)((Object)paymentType.getDisplayString()), (double)random.nextInt(10000));
        }
        return defaultPieDataset;
    }

    public static DefaultCategoryDataset createtopEmployeesBarChartDataSet() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        });
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            String string = USERS_NAME[random.nextInt(USERS_NAME.length)];
            treeMap.put(string, random.nextInt(100));
        }
        Set set = treeMap.keySet();
        for (String string : set) {
            defaultCategoryDataset.addValue((Number)treeMap.get(string), (Comparable)((Object)string), (Comparable)((Object)string));
        }
        return defaultCategoryDataset;
    }

    public static TimeSeriesCollection createSalesReportLineChartDataSet(Date date) {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        Random random = new Random();
        Calendar calendar = Calendar.getInstance();
        Date date2 = calendar.getTime();
        TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>();
        TreeMap<Date, Double> treeMap2 = new TreeMap<Date, Double>();
        TreeMap<Date, Double> treeMap3 = new TreeMap<Date, Double>();
        TreeMap<Date, Double> treeMap4 = new TreeMap<Date, Double>();
        List<Date> list = POSUtil.getDaysBetweenDates(date, date2);
        for (Date date3 : list) {
            Double d;
            Double d2;
            Double d3;
            Double d4 = (Double)treeMap.get(date3);
            if (d4 == null) {
                treeMap.put(date3, Double.valueOf(random.nextInt(10000)));
            }
            if ((d3 = (Double)treeMap2.get(date3)) == null) {
                treeMap2.put(date3, Double.valueOf(random.nextInt(10000)));
            }
            if ((d2 = (Double)treeMap3.get(date3)) == null) {
                treeMap3.put(date3, Double.valueOf(random.nextInt(10000)));
            }
            if ((d = (Double)treeMap4.get(date3)) != null) continue;
            treeMap4.put(date3, Double.valueOf(random.nextInt(10000)));
        }
        timeSeriesCollection.addSeries(DummyRecordService.a(treeMap, Messages.getString("LineChartService.0") + CurrencyUtil.getCurrencySymbolWithBracket()));
        timeSeriesCollection.addSeries(DummyRecordService.a(treeMap2, Messages.getString("LineChartService.1") + CurrencyUtil.getCurrencySymbolWithBracket()));
        timeSeriesCollection.addSeries(DummyRecordService.a(treeMap3, Messages.getString("LineChartService.2") + CurrencyUtil.getCurrencySymbolWithBracket()));
        timeSeriesCollection.addSeries(DummyRecordService.a(treeMap4, Messages.getString("LineChartService.3")));
        return timeSeriesCollection;
    }

    private static TimeSeries a(Map<Date, Double> map, String string) {
        if (map.isEmpty()) {
            return null;
        }
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)string));
        Set<Date> set = map.keySet();
        for (Date date : set) {
            Double d = map.get(date);
            timeSeries.add((RegularTimePeriod)new Day(date), (Number)d);
        }
        return timeSeries;
    }
}

