/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.chart;

import com.floreantpos.Messages;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class LineChartService {
    private TimeSeriesCollection a = new TimeSeriesCollection();

    public void updateAllLineData(Date date) {
        try (Session session = TerminalDAO.getInstance().createNewSession();){
            this.updateAllLineData(session, date);
        }
    }

    public void updateAllLineData(Session session, Date date) {
        Calendar calendar = Calendar.getInstance();
        Date date2 = calendar.getTime();
        String string = DataProvider.get().getCurrentOutletId();
        Map<Date, Double> map = this.findTransAmntGroupByDate(session, string, date, date2);
        Map<Date, Double> map2 = this.findAmountByPaymentTypes(session, string, date, date2, PaymentType.CASH);
        Map<Date, Double> map3 = this.findAmountByPaymentTypes(session, string, date, date2, PaymentType.CREDIT_CARD);
        Map<Date, Double> map4 = this.findTicketItemCountGroupByDate(session, string, date, date2);
        List<Date> list = POSUtil.getDaysBetweenDates(date, date2);
        for (Date date3 : list) {
            Double d;
            Double d2;
            Double d3;
            Double d4 = map.get(date3);
            if (d4 == null) {
                map.put(date3, 0.0);
            }
            if ((d3 = map2.get(date3)) == null) {
                map2.put(date3, 0.0);
            }
            if ((d2 = map3.get(date3)) == null) {
                map3.put(date3, 0.0);
            }
            if ((d = map4.get(date3)) != null) continue;
            map4.put(date3, 0.0);
        }
        this.a(map, Messages.getString("LineChartService.0") + CurrencyUtil.getCurrencySymbolWithBracket());
        this.a(map2, Messages.getString("LineChartService.1") + CurrencyUtil.getCurrencySymbolWithBracket());
        this.a(map3, Messages.getString("LineChartService.2") + CurrencyUtil.getCurrencySymbolWithBracket());
        this.a(map4, Messages.getString("LineChartService.3"));
    }

    private void a(Map<Date, Double> map, String string) {
        if (map.isEmpty()) {
            return;
        }
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)string));
        Set<Date> set = map.keySet();
        for (Date date : set) {
            Double d = map.get(date);
            timeSeries.add((RegularTimePeriod)new Day(date), (Number)d);
        }
        this.a.addSeries(timeSeries);
    }

    public TimeSeriesCollection getLineDataCollection() {
        return this.a;
    }

    public Map<Date, Double> findTransAmntGroupByDate(Session session, String string, Date date, Date date2) {
        TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>(new Comparator<Date>(){

            @Override
            public int compare(Date date, Date date2) {
                return date.compareTo(date2);
            }
        });
        Criteria criteria = session.createCriteria(PosTransaction.class);
        ProjectionList projectionList = Projections.projectionList();
        String string2 = " sum( case when transaction_type = 'CREDIT' then amount else (amount * -1) end) as amount";
        String string3 = "date(transaction_time) as transaction_time, " + string2;
        Projection projection = Projections.sqlGroupProjection((String)string3, (String)"date(transaction_time)", (String[])new String[]{"transaction_time", "amount"}, (Type[])new Type[]{StandardBasicTypes.DATE, StandardBasicTypes.DOUBLE});
        projectionList.add(projection);
        criteria.setProjection((Projection)projectionList);
        criteria.add(Restrictions.in((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object[])new Object[]{TransactionType.CREDIT.name(), TransactionType.DEBIT.name()}));
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
        criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
        List list = criteria.list();
        if (list != null) {
            for (Object[] objectArray : list) {
                if (objectArray == null || objectArray[0] == null || objectArray[1] == null) continue;
                Date date3 = (Date)objectArray[0];
                Double d = (Double)treeMap.get(date3);
                if (d == null) {
                    d = 0.0;
                }
                d = d + (Double)objectArray[1];
                treeMap.put(date3, d);
            }
        }
        return treeMap;
    }

    public Map<Date, Double> findAmountByPaymentTypes(Session session, String string, Date date, Date date2, PaymentType paymentType) {
        TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>(new Comparator<Date>(){

            @Override
            public int compare(Date date, Date date2) {
                return date.compareTo(date2);
            }
        });
        Criteria criteria = session.createCriteria(PosTransaction.class);
        ProjectionList projectionList = Projections.projectionList();
        String string2 = " sum( case when transaction_type = 'CREDIT' then amount else (amount * -1) end) as amount";
        String string3 = "date(transaction_time) as transaction_time, " + string2;
        Projection projection = Projections.sqlGroupProjection((String)string3, (String)"date(transaction_time)", (String[])new String[]{"transaction_time", "amount"}, (Type[])new Type[]{StandardBasicTypes.DATE, StandardBasicTypes.DOUBLE});
        projectionList.add(projection);
        criteria.setProjection((Projection)projectionList);
        criteria.add(Restrictions.in((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object[])new Object[]{TransactionType.CREDIT.name(), TransactionType.DEBIT.name()}));
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
        criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
        if (paymentType.equals((Object)PaymentType.CASH)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        } else if (paymentType.equals((Object)PaymentType.CREDIT_CARD)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CREDIT_CARD.name()));
        }
        List list = criteria.list();
        if (list != null) {
            for (Object[] objectArray : list) {
                if (objectArray == null || objectArray[0] == null || objectArray[1] == null) continue;
                Date date3 = (Date)objectArray[0];
                Double d = (Double)treeMap.get(date3);
                if (d == null) {
                    d = 0.0;
                }
                d = d + (Double)objectArray[1];
                treeMap.put(date3, d);
            }
        }
        return treeMap;
    }

    public Map<Date, Double> findTicketItemCountGroupByDate(Session session, String string, Date date, Date date2) {
        TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>(new Comparator<Date>(){

            @Override
            public int compare(Date date, Date date2) {
                return date.compareTo(date2);
            }
        });
        Criteria criteria = session.createCriteria(TicketItem.class);
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_COMBO_CHILD, (Object)false));
        ProjectionList projectionList = Projections.projectionList();
        String string2 = "date(create_date) as create_date, sum( quantity) as quantity";
        Projection projection = Projections.sqlGroupProjection((String)string2, (String)"date(create_date)", (String[])new String[]{"create_date", "quantity"}, (Type[])new Type[]{StandardBasicTypes.DATE, StandardBasicTypes.DOUBLE});
        projectionList.add(projection);
        criteria.setProjection((Projection)projectionList);
        criteria.add(Restrictions.between((String)TicketItem.PROP_CREATE_DATE, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)false));
        List list = criteria.list();
        if (list != null) {
            for (Object[] objectArray : list) {
                if (objectArray == null || objectArray[0] == null || objectArray[1] == null) continue;
                Date date3 = (Date)objectArray[0];
                Double d = (Double)treeMap.get(date3);
                if (d == null) {
                    d = 0.0;
                }
                d = d + (Double)objectArray[1];
                treeMap.put(date3, d);
            }
        }
        return treeMap;
    }
}

