/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.model.BalanceForwardTransaction;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import java.util.Date;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomerAccountReportModel
extends ListTableModel {
    public CustomerAccountReportModel() {
        super(new String[]{"customerId", "customerName", "ticketNo", "transNo", "paymentType", "transTime", "description", "total", "memberId"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        BalanceUpdateTransaction balanceUpdateTransaction = (BalanceUpdateTransaction)this.rows.get(n);
        Customer customer = DataProvider.get().getCustomer(balanceUpdateTransaction.getAccountNumber());
        switch (n2) {
            case 0: {
                return balanceUpdateTransaction.getAccountNumber();
            }
            case 1: {
                return customer == null ? "" : customer.getName();
            }
            case 2: {
                return balanceUpdateTransaction.getTicketId();
            }
            case 3: {
                return balanceUpdateTransaction.getTransactionId();
            }
            case 4: {
                if (balanceUpdateTransaction instanceof BalanceForwardTransaction) {
                    return "";
                }
                String string = balanceUpdateTransaction.getPaymentTypeString();
                String string2 = null;
                string = string.equals(PaymentType.MEMBER_ACCOUNT.name()) ? PaymentType.MEMBER_ACCOUNT.getDisplayString() : string.replaceAll("_", " ");
                string2 = WordUtils.capitalizeFully((String)string);
                return string2;
            }
            case 5: {
                Date date = balanceUpdateTransaction.getTransactionTime();
                return date == null ? "" : DateUtil.formatReportDateAsString(balanceUpdateTransaction.getTransactionTime());
            }
            case 6: {
                if (balanceUpdateTransaction instanceof BalanceForwardTransaction) {
                    return "";
                }
                String string = balanceUpdateTransaction.getTransactionSubType();
                if (StringUtils.isEmpty((CharSequence)string)) {
                    if (balanceUpdateTransaction.getTransactionType().equals(TransactionType.DEBIT.name())) {
                        return Messages.getString("GiftCardTransactionsReportModel.2");
                    }
                    return Messages.getString("BALANCE_ADDED");
                }
                TransactionSubType transactionSubType = TransactionSubType.getSubType(string);
                return transactionSubType == null ? "" : transactionSubType.getDisplayString();
            }
            case 7: {
                return balanceUpdateTransaction.getAmount();
            }
            case 8: {
                String string = customer.getMemberId();
                return StringUtils.isBlank((CharSequence)string) ? "" : string;
            }
        }
        return null;
    }
}

