/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class EndOfDaySummaryReportModel
extends ListTableModel {
    public EndOfDaySummaryReportModel() {
        super(new String[]{"empName", "customerName", "ticketId", "ticketAmt", "serviceCharge", "tips", "tax", "total", "memberCharge", "creditCard", "cashPymt", "othersPayment", "discount", "refund", "taxReceived", "totalReceived", "returnAmount", "netSalesAmount"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        EndOfDayReportData endOfDayReportData = (EndOfDayReportData)this.rows.get(n);
        switch (n2) {
            case 0: {
                if (StringUtils.isBlank((String)endOfDayReportData.getEmployeeId())) {
                    return Messages.getString("DeliverySummaryReportModel.2");
                }
                return endOfDayReportData.getEmployeeId() + " - " + endOfDayReportData.getEmployeeName();
            }
            case 1: {
                String string = endOfDayReportData.getCustomerName();
                String string2 = StringUtils.isBlank((String)endOfDayReportData.getMemberId()) ? "" : " (" + endOfDayReportData.getMemberId() + ")";
                return string == null ? Messages.getString("GUEST") : string + string2;
            }
            case 2: {
                return endOfDayReportData.getTicketId();
            }
            case 3: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getGrossSelesAmount());
            }
            case 4: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getServiceCharge());
            }
            case 5: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getGratuityAmount());
            }
            case 6: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getTaxAmount());
            }
            case 7: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getTotalTicketAmount());
            }
            case 8: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getMemberCharge());
            }
            case 9: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getCreditCardPayment());
            }
            case 10: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getCashPayment());
            }
            case 11: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getOthersPayment());
            }
            case 12: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getDiscount());
            }
            case 13: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getRefundPaymentCredit());
            }
            case 14: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getTaxReceived() > endOfDayReportData.getTaxAmount() ? endOfDayReportData.getTaxAmount() : endOfDayReportData.getTaxReceived());
            }
            case 15: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getTotalReceived());
            }
            case 16: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getReturnAmount());
            }
            case 17: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getNetSalesAmount());
            }
        }
        return null;
    }
}

