/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.model.BalanceForwardTransaction;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GiftCardTransactionsReportModel
extends ListTableModel {
    private String[] a = new String[]{"txNumber", "ticketNo", "txTime", "desc", "txAmount", "txGiftCardNumber"};

    public GiftCardTransactionsReportModel(List list) {
        this.setColumnNames(this.a);
        this.setRows(list);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        BalanceUpdateTransaction balanceUpdateTransaction = (BalanceUpdateTransaction)this.rows.get(n);
        switch (n2) {
            case 0: {
                return balanceUpdateTransaction.getId();
            }
            case 1: {
                if (StringUtils.isNotEmpty((String)balanceUpdateTransaction.getTicketId())) {
                    return balanceUpdateTransaction.getTicketId();
                }
                return "";
            }
            case 2: {
                if (balanceUpdateTransaction.getTransactionTime() != null) {
                    return DateUtil.formatReportDateAsString(balanceUpdateTransaction.getTransactionTime());
                }
                return "";
            }
            case 3: {
                if (balanceUpdateTransaction.getDataVersion() != null && balanceUpdateTransaction.getDataVersion() == 2) {
                    String string = balanceUpdateTransaction.getProperty("description", "");
                    TransactionSubType transactionSubType = TransactionSubType.getSubType(string);
                    return transactionSubType == null ? "" : transactionSubType.getDisplayString();
                }
                if (balanceUpdateTransaction instanceof BalanceForwardTransaction) {
                    return "";
                }
                if (balanceUpdateTransaction.getTransactionType().equals(TransactionType.CREDIT.name())) {
                    return Messages.getString("GiftCardTransactionsReportModel.2");
                }
                return Messages.getString("BALANCE_ADDED");
            }
            case 4: {
                if (balanceUpdateTransaction.getDataVersion() != null && balanceUpdateTransaction.getDataVersion() == 2) {
                    return balanceUpdateTransaction.getAmount();
                }
                if (!(balanceUpdateTransaction instanceof BalanceForwardTransaction) && balanceUpdateTransaction.getTransactionType().equals(TransactionType.CREDIT.name())) {
                    return balanceUpdateTransaction.getAmount() * -1.0;
                }
                double d = balanceUpdateTransaction.getGiftCertFaceValue();
                if (d == 0.0) {
                    d = balanceUpdateTransaction.getAmount() - (balanceUpdateTransaction.getServiceChargeAmount() + balanceUpdateTransaction.getTaxAmount() + balanceUpdateTransaction.getTipsAmount());
                }
                return d;
            }
            case 5: {
                return balanceUpdateTransaction.getAccountNumber();
            }
        }
        return null;
    }
}

