/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import org.hibernate.Session;

public class InventoryService {
    private static InventoryService a;

    public static InventoryService getInstance() {
        if (a == null) {
            a = new InventoryService();
        }
        return a;
    }

    private InventoryService() {
    }

    public void adjustMenuItemCost(MenuItem menuItem, double d, double d2, InventoryUnit inventoryUnit) {
        MenuItemDAO.getInstance().refresh(menuItem);
        try (Session session = TerminalDAO.getInstance().createNewSession();){
            this.adjustMenuItemCost(menuItem, d, d2, inventoryUnit, session);
        }
    }

    public void adjustMenuItemCost(MenuItem menuItem, double d, double d2, InventoryUnit inventoryUnit, Session session) {
        Double d3;
        Double d4;
        Store store = DataProvider.get().getStore();
        if (store == null || menuItem == null || inventoryUnit == null || session == null) {
            return;
        }
        InventoryUnit inventoryUnit2 = menuItem.getUnit();
        if (inventoryUnit != null && inventoryUnit2 != null && !inventoryUnit2.equals(inventoryUnit)) {
            d4 = inventoryUnit.getConversionRate();
            d3 = inventoryUnit2.getConversionRate();
            d *= d4 / d3;
            d2 *= menuItem.getUnitQuantity(inventoryUnit, inventoryUnit2);
        }
        if ((d4 = menuItem.getUnitOnHand()) < 0.0) {
            d4 = 0.0;
        }
        d3 = menuItem.getCost();
        double d5 = (d4 * d3 + d2 * d) / (d4 + d2);
        if (store.isInventoryAvgPricingMethod()) {
            menuItem.setCost(d5);
        } else {
            menuItem.setCost(d);
        }
        menuItem.setLastPurchasedCost(d);
        menuItem.setAverageUnitPurchasePrice(d5);
    }
}

