/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ServicePaymentType;
import com.floreantpos.model.ServiceType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.MembershipService;
import com.floreantpos.ui.dialog.MembershipDataInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class ServiceProcessor {
    public void prcocess(TicketItem ticketItem, Ticket ticket, PosTransaction posTransaction, Session session) {
        ServiceType serviceType = ServiceType.valueOf(ticketItem.getServiceType());
        switch (serviceType) {
            case MEMBERSHIP: {
                MembershipService membershipService = new MembershipService();
                membershipService.process(ticketItem, ticket, session);
                break;
            }
            case ADD_CUSTOMER_BALANCE: {
                String string = ticket.getCustomerId();
                if (StringUtils.isBlank((String)string)) {
                    throw new PosException(Messages.getString("CustomerIsNotSelectedForTicket"));
                }
                Customer customer = CustomerDAO.getInstance().get(string, session);
                Double d = ticketItem.getUnitPrice();
                BalanceUpdateTransaction balanceUpdateTransaction = new BalanceUpdateTransaction();
                balanceUpdateTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
                balanceUpdateTransaction.setAccountNumber(string);
                balanceUpdateTransaction.setAmount(d);
                balanceUpdateTransaction.setBalanceBefore(customer.getBalance());
                balanceUpdateTransaction.setBalanceType(BalanceType.CUSTOMER);
                balanceUpdateTransaction.setDescription(TransactionSubType.BALANCE_ADDED.name());
                balanceUpdateTransaction.setTransactionSubType(TransactionSubType.BALANCE_ADDED.name());
                balanceUpdateTransaction.setTransactionType(TransactionType.CREDIT.name());
                balanceUpdateTransaction.setTicketId(ticket.getId());
                balanceUpdateTransaction.setTransactionId(posTransaction.getId());
                balanceUpdateTransaction.setPaymentType(posTransaction.getPaymentType());
                customer.setBalance(customer.getBalance() + d);
                CustomerDAO.getInstance().update(customer, session);
                BalanceUpdateTransactionDAO.getInstance().save(balanceUpdateTransaction);
                break;
            }
        }
    }

    public static boolean captureServiceInput(Ticket ticket, TicketItem ticketItem, MenuItem menuItem) {
        ServiceType serviceType = ServiceType.valueOf(menuItem.getServiceType());
        switch (serviceType) {
            case GENERIC: {
                ticketItem.setQuantity(1.0);
                ticketItem.setUnitPrice(menuItem.getPrice());
                return true;
            }
            case MEMBERSHIP: {
                MembershipDataInputDialog membershipDataInputDialog = new MembershipDataInputDialog(ticket, menuItem);
                membershipDataInputDialog.pack();
                membershipDataInputDialog.setOkButtonText(POSConstants.ADD_BUTTON_TEXT);
                String string = "service.paymentType";
                Customer customer = ticket.getCustomer();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
                String string2 = simpleDateFormat.format(new Date());
                Date date = null;
                try {
                    date = DateUtil.startOfDay(simpleDateFormat.parse(string2));
                }
                catch (ParseException parseException) {
                    PosLog.error(ServiceProcessor.class, parseException);
                }
                Date date2 = menuItem.getPaymentType().calculateEndDate(date);
                if (customer.hasProperty(string) && customer.isMembershipActive().booleanValue() && customer.getProperty(string).equals(ServicePaymentType.ONE_TIME.name())) {
                    throw new PosException(Messages.getString("AlreadyMemberMsg"));
                }
                if (customer.getMembershipStartDate() == null || !customer.isMembershipActive().booleanValue()) {
                    membershipDataInputDialog.open();
                    if (membershipDataInputDialog.isCanceled()) {
                        return false;
                    }
                    date = membershipDataInputDialog.getServiceStartTime();
                    date2 = membershipDataInputDialog.getServiceEndTime();
                }
                ticketItem.setServiceStartDate(date);
                ticketItem.setServiceEndDate(date2);
                List<Attribute> list = menuItem.getAttributes();
                if (list != null && list.size() > 0) {
                    Attribute attribute = list.get(0);
                    ticketItem.addProperty("attribute_id", attribute.getId());
                    ticketItem.addProperty("attribute_name", attribute.getName());
                }
                return true;
            }
            case ADD_CUSTOMER_BALANCE: {
                Double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("ServiceProcessor.0"), true);
                if (d == null) {
                    return false;
                }
                ticketItem.setDiscountApplicable(false);
                ticketItem.setQuantity(1.0);
                ticketItem.setUnitPrice(d);
                return true;
            }
        }
        return false;
    }
}

