/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class MultiSelectComboBox<E>
extends JComboBox<E> {
    protected String ALL = "ALL";
    protected boolean keepOpen;
    protected List<E> items;
    protected CheckableItem itemAll;
    private MultiSelectListener a;
    private int b;
    private int c;

    public MultiSelectComboBox() {
        this(Collections.emptyList());
    }

    public MultiSelectComboBox(List<E> list) {
        this(list, "ALL");
    }

    public MultiSelectComboBox(List<E> list, String string) {
        Dimension dimension = this.getPreferredSize();
        dimension.setSize(200, dimension.height);
        this.setPreferredSize(dimension);
        this.ALL = string;
        this.a();
        this.setItems(list);
    }

    public void setItems(List<E> list) {
        this.items = list;
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        this.itemAll = new CheckableItem(this.ALL, false);
        comboBoxModel.addElement(this.itemAll);
        for (E e : list) {
            CheckableItem checkableItem = new CheckableItem(e, false);
            comboBoxModel.addElement(checkableItem);
        }
        this.setModel(comboBoxModel);
    }

    public List<E> getSelectedItems() {
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.getModel();
        List list = comboBoxModel.getDataList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : list) {
            CheckableItem checkableItem = (CheckableItem)e;
            if (checkableItem.item == this.itemAll.getItem() || !checkableItem.isSelected()) continue;
            arrayList.add(checkableItem.item);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    public void setSelectedItems(List<E> list) {
        if (list == null || list.isEmpty()) {
            this.itemAll.selected = true;
            this.setSelectedItem(this.itemAll);
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.getModel();
        List list2 = comboBoxModel.getDataList();
        for (Object e : list2) {
            CheckableItem checkableItem = (CheckableItem)e;
            checkableItem.selected = false;
            for (E e2 : list) {
                if (!checkableItem.item.equals(e2) || checkableItem.isSelected()) continue;
                checkableItem.selected = true;
                this.setSelectedItem(checkableItem);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void a() {
        this.setRenderer(new CheckBoxCellRenderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getModifiers() == 16) {
                    MultiSelectComboBox.this.updateItem(MultiSelectComboBox.this.getSelectedIndex());
                    MultiSelectComboBox.this.keepOpen = true;
                    MultiSelectComboBox.this.b();
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "checkbox-select");
        this.getActionMap().put("checkbox-select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Accessible accessible = MultiSelectComboBox.this.getAccessibleContext().getAccessibleChild(0);
                if (accessible instanceof ComboPopup) {
                    ComboPopup comboPopup = (ComboPopup)((Object)accessible);
                    MultiSelectComboBox.this.updateItem(comboPopup.getList().getSelectedIndex());
                }
            }
        });
    }

    public void updateItem(int n) {
        if (this.isPopupVisible()) {
            Object e = this.getItemAt(n);
            CheckableItem checkableItem = (CheckableItem)e;
            checkableItem.selected ^= true;
            this.setSelectedIndex(-1);
            this.setSelectedItem(checkableItem);
            if (e.toString().equals(this.ALL)) {
                this.unselectAllItems();
                this.hidePopup();
            }
        }
    }

    public void unselectAllItems() {
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.getModel();
        List list = comboBoxModel.getDataList();
        for (Object e : list) {
            if (!(e instanceof CheckableItem)) continue;
            CheckableItem checkableItem = (CheckableItem)e;
            checkableItem.selected = false;
        }
    }

    @Override
    public void setPopupVisible(boolean bl) {
        if (this.keepOpen) {
            this.keepOpen = false;
        } else {
            super.setPopupVisible(bl);
        }
    }

    private void b() {
        if (this.a != null) {
            this.a.selectedItems(this.getSelectedItems());
        }
    }

    public List<E> getItems() {
        return this.items;
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        this.c();
        super.firePopupMenuWillBecomeVisible();
    }

    public void setRowHeight(int n) {
        this.b = n;
        Accessible accessible = this.getUI().getAccessibleChild(this, 0);
        if (accessible instanceof ComboPopup) {
            JList<Object> jList = ((ComboPopup)((Object)accessible)).getList();
            jList.setFixedCellHeight(n);
        }
    }

    private void c() {
        Serializable serializable;
        JComponent jComponent;
        ComboBoxUI comboBoxUI = this.getUI();
        if (0 > comboBoxUI.getAccessibleChildrenCount(this)) {
            return;
        }
        Accessible accessible = comboBoxUI.getAccessibleChild(this, 0);
        JComponent jComponent2 = (JComponent)((Object)accessible);
        if (jComponent2.isPreferredSizeSet()) {
            return;
        }
        Component component = ((Container)((Object)accessible)).getComponent(0);
        if (component instanceof JScrollPane) {
            jComponent = (JScrollPane)component;
            serializable = ((JScrollPane)jComponent).getVerticalScrollBar();
            serializable.setPreferredSize(PosUIManager.getSize((int)20, (int)serializable.getPreferredSize().height));
        }
        if (accessible instanceof BasicComboPopup && this.c > 0 && this.b > 0) {
            jComponent = (BasicComboPopup)accessible;
            serializable = jComponent.getPreferredSize();
            Dimension dimension = this.getSize();
            if (((Dimension)serializable).width < dimension.width) {
                ((Dimension)serializable).width = dimension.width;
            }
            jComponent.setLayout(new BorderLayout());
            if (0 < jComponent.getComponentCount()) {
                Component component2 = jComponent.getComponent(0);
                ((JPopupMenu)jComponent).remove(0);
                jComponent.add(component2, "Center");
            }
            ((Dimension)serializable).height = 2;
            for (int i = 0; i < Math.min(this.getModel().getSize(), this.c); ++i) {
                ((Dimension)serializable).height += this.b;
            }
            jComponent.setPreferredSize((Dimension)serializable);
        }
    }

    public void setVisibleRow(int n) {
        this.c = n;
    }

    public void setMultiSelectListener(MultiSelectListener multiSelectListener) {
        this.a = multiSelectListener;
    }

    public static interface MultiSelectListener {
        public void selectedItems(List var1);
    }

    private class CheckBoxCellRenderer
    implements ListCellRenderer {
        private final JLabel b = new JLabel(" ");
        private final JCheckBox c = new JCheckBox(" ");
        private final JLabel d;

        private CheckBoxCellRenderer() {
            this.d = new JLabel(MultiSelectComboBox.this.ALL);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CheckableItem checkableItem = (CheckableItem)object;
            if (checkableItem != null && checkableItem.toString().equals(MultiSelectComboBox.this.ALL)) {
                if (bl) {
                    this.d.setOpaque(true);
                    this.d.setBackground(jList.getSelectionBackground());
                    this.d.setForeground(jList.getSelectionForeground());
                } else {
                    this.d.setBackground(jList.getBackground());
                    this.d.setForeground(jList.getForeground());
                }
                return this.d;
            }
            if (n < 0) {
                this.b.setText(this.a(jList.getModel()).replace("[", "").replace("]", ""));
                return this.b;
            }
            this.c.setText(Objects.toString(checkableItem, ""));
            this.c.setSelected(checkableItem.selected);
            if (bl) {
                this.c.setBackground(jList.getSelectionBackground());
                this.c.setForeground(jList.getSelectionForeground());
            } else {
                this.c.setBackground(jList.getBackground());
                this.c.setForeground(jList.getForeground());
            }
            return this.c;
        }

        private String a(ListModel listModel) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object e = listModel.getElementAt(i);
                if (e == MultiSelectComboBox.this.itemAll || !(e instanceof Object) || !((CheckableItem)e).selected) continue;
                arrayList.add(e.toString());
            }
            if (arrayList.isEmpty()) {
                arrayList.add(MultiSelectComboBox.this.itemAll.toString());
            }
            return ((Object)arrayList).toString();
        }
    }

    public class CheckableItem {
        public Object item;
        public boolean selected;

        public CheckableItem(Object object, boolean bl) {
            this.item = object;
            this.selected = bl;
        }

        public String toString() {
            return this.item.toString();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public Object getItem() {
            return this.item;
        }
    }
}

