/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.MultiSelectComboBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.apache.commons.lang3.StringUtils;

public class MultiSelectComboBoxWithCategory<E>
extends MultiSelectComboBox<E> {
    private String a;
    protected List<String> itemCategory;

    public MultiSelectComboBoxWithCategory() {
        this((String)null);
    }

    public MultiSelectComboBoxWithCategory(String string) {
        this.a = this.ALL;
        this.itemCategory = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.a = string;
        }
        super.setRenderer(new CheckBoxCellRenderer());
        this.itemAll = new MultiSelectComboBox.CheckableItem(this.a, false);
        this.setItemsAndCategory(Collections.EMPTY_LIST);
    }

    public void setItemsAndCategory(List<E> list) {
        this.items = list;
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement(this.itemAll);
        this.itemCategory.clear();
        for (E e : list) {
            if (e instanceof Category) {
                this.itemCategory.add(e.toString());
            } else {
                this.itemCategory.add(null);
            }
            MultiSelectComboBox.CheckableItem checkableItem = new MultiSelectComboBox.CheckableItem(e, false);
            comboBoxModel.addElement(checkableItem);
        }
        this.setModel(comboBoxModel);
    }

    @Override
    public void updateItem(int n) {
        if (n > 0 && this.itemCategory.get(n - 1) != null) {
            this.setSelectedIndex(-1);
            return;
        }
        super.updateItem(n);
    }

    public static class Category {
        String a;

        public Category(String string) {
            this.a = string;
        }

        public String toString() {
            return this.a;
        }
    }

    private class CheckBoxCellRenderer
    implements ListCellRenderer {
        private final JLabel b = new JLabel(" ");
        private final JCheckBox c = new JCheckBox(" ");
        private final JLabel d = new JLabel(MultiSelectComboBoxWithCategory.a(MultiSelectComboBoxWithCategory.this));

        private CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            MultiSelectComboBox.CheckableItem checkableItem = (MultiSelectComboBox.CheckableItem)object;
            if (checkableItem != null && (checkableItem.toString().equals(MultiSelectComboBoxWithCategory.this.a) || MultiSelectComboBoxWithCategory.this.itemCategory.contains(checkableItem.toString()))) {
                if (bl) {
                    this.d.setOpaque(true);
                    this.d.setBackground(jList.getSelectionBackground());
                    this.d.setForeground(jList.getSelectionForeground());
                } else {
                    this.d.setBackground(jList.getBackground());
                    this.d.setForeground(jList.getForeground());
                }
                if (checkableItem.toString().equals(MultiSelectComboBoxWithCategory.this.a)) {
                    return this.d;
                }
                return new JLabel(checkableItem.toString());
            }
            if (n < 0) {
                this.b.setText(this.a(jList.getModel()).replace("[", "").replace("]", ""));
                return this.b;
            }
            this.c.setText(Objects.toString(checkableItem, ""));
            this.c.setSelected(checkableItem.selected);
            if (bl) {
                this.c.setBackground(jList.getSelectionBackground());
                this.c.setForeground(jList.getSelectionForeground());
            } else {
                this.c.setBackground(jList.getBackground());
                this.c.setForeground(jList.getForeground());
            }
            return this.c;
        }

        private String a(ListModel listModel) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object e = listModel.getElementAt(i);
                if (e == MultiSelectComboBoxWithCategory.this.itemAll || MultiSelectComboBoxWithCategory.this.itemCategory.contains(e.toString()) || !(e instanceof Object) || !((MultiSelectComboBox.CheckableItem)e).selected) continue;
                arrayList.add(e.toString());
            }
            if (arrayList.isEmpty()) {
                arrayList.add(MultiSelectComboBoxWithCategory.this.itemAll.toString());
            }
            return ((Object)arrayList).toString();
        }
    }
}

