/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.ITicketList;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.TicketListView;
import com.floreantpos.ui.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXDatePicker;

public class OrderFilterPanel
extends JXCollapsiblePane
implements ActionListener {
    private static final int a = 30;
    private ITicketList b;
    private TicketListView c;
    private JPanel d;
    private JXDatePicker e;
    private JXDatePicker f;
    private POSTextField g;
    private POSComboBox h;
    private POSToggleButton i;
    private POSComboBox j;

    public OrderFilterPanel(ITicketList iTicketList) {
        this.b = iTicketList;
        this.c = (TicketListView)iTicketList;
        this.setCollapsed(false);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5", "fill,grow", ""));
        this.d = new JPanel();
        this.d.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = this.c();
        jPanel.add((Component)this.d, "wrap");
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.setBorder(new EmptyBorder(0, 0, 5, 0));
    }

    private JPanel a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 3", "", ""));
        List<String> list = Arrays.asList(Messages.getString("OrderFilterPanel.8"), Messages.getString("OrderFilterPanel.9"));
        MultiSelectionOverflowCombobox<String> multiSelectionOverflowCombobox = new MultiSelectionOverflowCombobox<String>(list, Messages.getString("OrderFilterPanel.10"));
        multiSelectionOverflowCombobox.setRowHeight(PosUIManager.getSize((int)40));
        multiSelectionOverflowCombobox.setVisibleRow(3);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (TerminalConfig.isFilterByOwner()) {
            arrayList.add(list.get(0));
        }
        if (TerminalConfig.getPaymentStatusFilter() == PaymentStatusFilter.CLOSED) {
            arrayList.add(list.get(1));
        }
        multiSelectionOverflowCombobox.setSelectedItems(arrayList);
        multiSelectionOverflowCombobox.setMultiSelectListener(list2 -> {
            if (list2 == null) {
                TerminalConfig.setFilterByOwner(false);
                TerminalConfig.setPaymentStatusFilter(PaymentStatusFilter.OPEN.name());
            } else if (list.equals(list2)) {
                TerminalConfig.setFilterByOwner(true);
                TerminalConfig.setPaymentStatusFilter(PaymentStatusFilter.CLOSED.name());
            } else if (list2.contains(list.get(0))) {
                TerminalConfig.setFilterByOwner(true);
                TerminalConfig.setPaymentStatusFilter(PaymentStatusFilter.OPEN.name());
            } else if (list2.contains(list.get(1))) {
                TerminalConfig.setFilterByOwner(false);
                TerminalConfig.setPaymentStatusFilter(PaymentStatusFilter.CLOSED.name());
            }
            this.g();
        });
        jPanel.add(multiSelectionOverflowCombobox, " h " + PosUIManager.getSize((int)30) + "!, w " + PosUIManager.getSize((int)150) + "!");
        this.i = new POSToggleButton();
        this.i.setIcon(IconFactory.getIcon("/images/", "keyboard.png"));
        jPanel.add((Component)this.i, "w " + PosUIManager.getSize((int)90) + "! , h " + PosUIManager.getSize((int)30) + "!");
        this.i.addActionListener(actionEvent -> this.b());
        return jPanel;
    }

    private void b() {
        this.c.setQwertyKeyPadCollapsed(!this.i.isSelected());
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fillx"));
        jPanel.setBorder(new TitledBorder(Messages.getString("OrderFilterPanel.1")));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 3", "", ""));
        this.j = new POSComboBox();
        this.j.setRowHeight(PosUIManager.getSize((int)40));
        this.j.setVisibleRow(10);
        this.refreshOrderTypes();
        jPanel2.add(new JLabel(Messages.getString("OrderFilterPanel.6")));
        jPanel2.add((Component)this.j, "h " + PosUIManager.getSize((int)30) + "!, w " + PosUIManager.getSize((int)85) + "!");
        this.g = new POSTextField(8);
        this.g.setPreferredSize(PosUIManager.getSize((int)15, (int)30));
        jPanel2.add(new JLabel(Messages.getString("OrderFilterPanel.2")));
        jPanel2.add(this.g);
        this.g.addKeyListener(this.e());
        JLabel jLabel = new JLabel(POSConstants.START_DATE + ":");
        this.e = UiUtil.getCurrentMonthStart();
        this.e.setDate(null);
        this.e.setPreferredSize(PosUIManager.getSize((int)80, (int)30));
        jPanel2.add(jLabel);
        jPanel2.add((Component)this.e, "w " + PosUIManager.getSize((int)110) + "!");
        this.e.getEditor().addKeyListener(this.e());
        JLabel jLabel2 = new JLabel(POSConstants.END_DATE + ":");
        this.f = UiUtil.getCurrentMonthEnd();
        this.f.setDate(null);
        this.f.setPreferredSize(PosUIManager.getSize((int)80, (int)30));
        jPanel2.add(jLabel2);
        jPanel2.add((Component)this.f, "w " + PosUIManager.getSize((int)110) + "!");
        this.f.getEditor().addKeyListener(this.e());
        JLabel jLabel3 = new JLabel(Messages.getString("OrderFilterPanel.3"));
        this.h = new POSComboBox();
        this.h.setVisibleRow(5);
        this.h.setRowHeight(PosUIManager.getSize((int)40));
        this.h.addItem(10);
        this.h.addItem(25);
        this.h.addItem(50);
        this.h.addItem(100);
        this.h.addItem(300);
        this.h.setSelectedItem(TerminalConfig.getOrderViewPageSize());
        this.h.addKeyListener(this.e());
        jPanel2.add(jLabel3);
        jPanel2.add((Component)this.h, "h " + PosUIManager.getSize((int)30) + "!, w " + PosUIManager.getSize((int)60) + "!");
        PosButton posButton = new PosButton(Messages.getString("OrderFilterPanel.4"));
        posButton.addActionListener(actionEvent -> this.f());
        jPanel2.add(posButton);
        posButton.setPreferredSize(PosUIManager.getSize((int)60, (int)30));
        PosButton posButton2 = new PosButton(Messages.getString("OrderFilterPanel.5"));
        posButton2.setPreferredSize(PosUIManager.getSize((int)60, (int)30));
        posButton2.addActionListener(actionEvent -> this.d());
        jPanel2.add(posButton2);
        this.g.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    OrderFilterPanel.this.i.setSelected(true);
                    OrderFilterPanel.this.b();
                }
            }
        });
        jPanel.add((Component)jPanel2, "left, growx, pushx");
        jPanel.add((Component)this.a(), "right, pushx");
        return jPanel;
    }

    private void d() {
        this.j.setSelectedIndex(0);
        this.g.setText("");
        this.e.setDate(null);
        this.f.setDate(null);
        this.f();
    }

    public void refreshOrderTypes() {
        this.j.removeActionListener(this);
        this.j.removeAllItems();
        this.j.addItem(POSConstants.ALL);
        Object object = POSConstants.ALL;
        for (OrderType orderType : Application.getInstance().getOrderTypes()) {
            this.j.addItem(orderType);
            if (!TerminalConfig.getOrderTypeFilter().equals(orderType.getId())) continue;
            object = orderType;
        }
        this.j.setSelectedItem(object);
        this.j.addActionListener(this);
    }

    private KeyListener e() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    OrderFilterPanel.this.i.setSelected(false);
                    OrderFilterPanel.this.b();
                    OrderFilterPanel.this.f();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
    }

    private void f() {
        try {
            Date date = this.e.getDate();
            Date date2 = this.f.getDate();
            if (date != null && date2 != null) {
                DateUtil.validateDate(date, date2);
            }
            TerminalConfig.setSwitchboradTicketIdFilter(this.g.getText());
            TerminalConfig.setSwitchboradFromDateFilter(date);
            TerminalConfig.setSwitchboradToDateFilter(date2);
            TerminalConfig.setOrderViewPageSize((Integer)this.h.getSelectedItem());
            this.g();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage(), posException);
        }
    }

    private void g() {
        this.b.updateTicketList();
        this.c.updateButtonStatus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.j == actionEvent.getSource()) {
            Object object = this.j.getSelectedItem();
            if (object instanceof OrderType) {
                OrderType orderType = (OrderType)object;
                object = orderType.getId();
            }
            TerminalConfig.setOrderTypeFilter(object.toString());
            this.g();
        }
    }
}

