/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.JDBCConnectionException;

public class PinEntryView
extends TransparentPanel
implements ActionListener {
    private JPasswordField b;
    private JLabel c;
    private PosButton d;
    private PosButton e;
    private boolean f;
    protected User user;
    private boolean g;
    private User h;
    private JPanel i;
    private JPanel j = new JPanel(new GridLayout(0, 1));
    Action a = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PinEntryView.this.b.setText(PinEntryView.this.e() + actionEvent.getActionCommand());
            if (PinEntryView.this.g) {
                return;
            }
            String string = PinEntryView.this.e();
            Integer n = Application.getInstance().getTerminal().getDefaultPassLength();
            if (string != null && string.length() == n.intValue()) {
                PinEntryView.this.c.setText("");
                PinEntryView.this.i.setVisible(false);
                if (PinEntryView.this.checkLogin(string)) {
                    // empty if block
                }
            } else if (string != null && string.length() != n.intValue()) {
                PinEntryView.this.c.setText("");
                PinEntryView.this.i.setVisible(false);
            }
        }
    };

    public PinEntryView() {
        this.a();
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.d = new PosButton();
        this.d.setText(Messages.getString("PasswordEntryDialog.11"));
        this.e = new PosButton(POSConstants.LOGIN);
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout(10, 10));
        transparentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        TransparentPanel transparentPanel2 = new TransparentPanel((LayoutManager)new MigLayout("ins 0, fill"));
        JLabel jLabel = new JLabel(Messages.getString("PinEntryView.3"));
        jLabel.setFont(jLabel.getFont().deriveFont(18.0f).deriveFont(1));
        jLabel.setHorizontalTextPosition(0);
        transparentPanel2.add((Component)jLabel, "newline, center, gaptop " + PosUIManager.getSize((int)0) + "!");
        JPanel jPanel = this.b();
        jPanel.add((Component)transparentPanel2, "North");
        transparentPanel.add((Component)jPanel, "North");
        JPanel jPanel2 = this.c();
        transparentPanel.add(jPanel2);
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setBackground(Color.BLACK);
        int n = PosUIManager.getSize((int)10);
        int n2 = PosUIManager.getSize((int)(transparentPanel2.getPreferredSize().height + 15));
        this.add((Component)this.j, "West" + String.format(", gap %s! %s! %s! %s!", n, n, n2, n));
        this.add((Component)jSeparator, String.format("center, growy, gap %s! %s! %s! %s!", 0, 0, n2, n));
        this.add((Component)transparentPanel, "grow");
        this.setOpaque(true);
        this.setBackground(new Color(245, 245, 245, 100));
    }

    private JPanel b() {
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout(5, 5));
        this.b = new JPasswordField();
        this.b.setFont(this.b.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.b.setFocusable(true);
        this.b.requestFocus();
        this.b.setBackground(Color.WHITE);
        this.b.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (PinEntryView.this.g) {
                    return;
                }
                if (keyEvent.getKeyCode() == 8) {
                    PinEntryView.this.c.setText("");
                    PinEntryView.this.i.setVisible(false);
                    return;
                }
                String string = PinEntryView.this.e();
                Integer n = Application.getInstance().getTerminal().getDefaultPassLength();
                if (string != null && string.length() == n.intValue()) {
                    PinEntryView.this.c.setText("");
                    PinEntryView.this.i.setVisible(false);
                    PinEntryView.this.checkLogin(string);
                } else if (string != null && string.length() != n.intValue() && keyEvent.getKeyCode() != 10) {
                    PinEntryView.this.c.setText("");
                    PinEntryView.this.i.setVisible(false);
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    PinEntryView.this.doOk();
                }
            }
        });
        transparentPanel.add(this.b);
        this.c = new JLabel();
        this.c.setHorizontalAlignment(0);
        this.i = new JPanel();
        this.i.add(this.c);
        this.i.setVisible(false);
        transparentPanel.add((Component)this.i, "South");
        return transparentPanel;
    }

    private JPanel c() {
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(0, 3, 5, 5));
        String[][] stringArrayArray = new String[][]{{"7", "8", "9"}, {"4", "5", "6"}, {"1", "2", "3"}, {"0"}};
        Dimension dimension = PosUIManager.getSize_w110_h70();
        Font font = UIManager.getFont("Button.font").deriveFont((float)PosUIManager.getFontSize((int)32));
        for (int i = 0; i < stringArrayArray.length; ++i) {
            for (int j = 0; j < stringArrayArray[i].length; ++j) {
                String string = String.valueOf(stringArrayArray[i][j]);
                PosButton posButton = new PosButton();
                posButton.setAction(this.a);
                posButton.setFont(font);
                posButton.setText(string);
                posButton.setPreferredSize(dimension);
                posButton.setIconTextGap(0);
                posButton.setActionCommand(string);
                transparentPanel.add(posButton);
            }
        }
        ImageIcon imageIcon = IconFactory.getIcon("/ui_icons/", "clear.png");
        this.d.setIcon(imageIcon);
        this.d.setIconTextGap(0);
        Icon icon = IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.KEYBOARD_RETURN, (float)PosUIManager.getSize((int)25));
        this.e.setIcon(icon);
        transparentPanel.add(this.d);
        transparentPanel.add(this.e);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PinEntryView.this.d();
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PinEntryView.this.doOk();
            }
        });
        return transparentPanel;
    }

    public void doOk() {
        try {
            String string = this.e();
            if (this.g && this.h != null) {
                User user = UserDAO.getInstance().findUserBySecretKey(string);
                if (user == null || !user.equals(this.h)) {
                    this.c.setText(Messages.getString("PasswordEntryDialog.30"));
                    this.i.setVisible(true);
                }
            } else {
                this.checkLogin(string);
            }
        }
        catch (GenericJDBCException genericJDBCException) {
            POSMessageDialog.showError(genericJDBCException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doCancel() {
        this.user = null;
    }

    protected void doClearAll() {
        this.c.setText("");
        this.i.setVisible(false);
        this.b.setText("");
    }

    private void d() {
        this.c.setText("");
        this.i.setVisible(false);
        String string = this.e();
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.substring(0, string.length() - 1);
        }
        this.b.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(string)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(string)) {
            this.doOk();
        } else if (StringUtils.isNotEmpty((String)string)) {
            this.b.setText(this.e() + string);
        }
    }

    private String e() {
        return new String(this.b.getPassword());
    }

    protected synchronized boolean checkLogin(String string) {
        Object object;
        try {
            this.user = UserDAO.getInstance().findUserBySecretKey(string);
        }
        catch (JDBCConnectionException jDBCConnectionException) {
            POSMessageDialog.showError(this, Messages.getString("PasswordEntryDialog.0"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            return false;
        }
        if (this.user == null) {
            this.c.setText(Messages.getString("PasswordEntryDialog.30"));
            this.i.setVisible(true);
            return false;
        }
        if (this.user.getType() == null) {
            this.c.setText(Messages.getString("PasswordEntryDialog.5"));
            this.i.setVisible(true);
            return false;
        }
        List<User> list = this.user.getRoles();
        for (User object2 : list) {
            if (!object2.isClockedIn().booleanValue()) continue;
            this.user = object2;
            break;
        }
        if (this.isAutoLogOffMode()) {
            object = RootView.getInstance().getCurrentViewName();
            if (((String)object).equals("TABLE_MAP")) {
                if (!this.user.hasPermission(UserPermission.CREATE_TICKET)) {
                    this.c.setText(Messages.getString("PasswordEntryDialog.4"));
                    this.i.setVisible(true);
                    return false;
                }
            } else if (((String)object).equals("ORDER_VIEW")) {
                if (!(OrderView.getInstance().getCurrentTicket().getOwner().getId().equals(this.user.getId()) || this.user.hasPermission(UserPermission.CREATE_TICKET) && (this.user.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK) || this.user.hasPermission(UserPermission.PERFORM_MANAGER_TASK)))) {
                    this.c.setText(Messages.getString("PasswordEntryDialog.4"));
                    this.i.setVisible(true);
                    return false;
                }
            } else if (((String)object).equals("KD") && !this.user.hasPermission(UserPermission.KITCHEN_DISPLAY)) {
                this.c.setText(Messages.getString("PasswordEntryDialog.4"));
                this.i.setVisible(true);
                return false;
            }
        } else {
            object = Application.getInstance().getOrderTypes();
            String string2 = TerminalConfig.getDefaultView();
            if (object != null) {
                Iterator<OrderType> iterator = object.iterator();
                while (iterator.hasNext()) {
                    OrderType orderType = iterator.next();
                    if (string2 == null || !string2.equals(orderType.getName()) || this.user.hasPermission(UserPermission.CREATE_TICKET)) continue;
                    this.c.setText(Messages.getString("PasswordEntryDialog.4"));
                    this.i.setVisible(true);
                    return false;
                }
            }
            if (string2 != null && string2.equals("KD") && !this.user.hasPermission(UserPermission.KITCHEN_DISPLAY)) {
                this.c.setText(Messages.getString("PasswordEntryDialog.4"));
                this.i.setVisible(true);
                return false;
            }
        }
        this.setAutoLogOffMode(false);
        return true;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isAutoLogOffMode() {
        return this.f;
    }

    public void setAutoLogOffMode(boolean bl) {
        this.f = bl;
    }

    public void addTopButtons(Component ... componentArray) {
        for (Component component : componentArray) {
            this.j.add(component);
        }
    }
}

