/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import validation.ComboBoxValidationComponant;
import validation.ValidationCombobox;

public class PizzaPriceView
extends TransparentPanel {
    private MenuItem a;
    private TransparentPanel b;
    private List<PizzaCrust> c;
    private List<MenuItemSize> d;
    private ButtonGroup e = new ButtonGroup();
    private Map<String, MenuItemSize> f = new HashMap<String, MenuItemSize>();
    private Map<String, PizzaCrust> g = new HashMap<String, PizzaCrust>();

    public PizzaPriceView(MenuItem menuItem) {
        this.a = menuItem;
        this.c = PizzaCrustDAO.getInstance().findAll();
        if (this.c != null) {
            for (PizzaCrust comparable : this.c) {
                if (comparable == null) continue;
                this.g.put(comparable.getName().toLowerCase(), comparable);
            }
        }
        this.d = MenuItemSizeDAO.getInstance().findAll();
        if (this.d != null) {
            for (MenuItemSize menuItemSize : this.d) {
                if (menuItemSize == null) continue;
                this.f.put(menuItemSize.getName().toLowerCase(), menuItemSize);
            }
        }
        this.b();
    }

    public List<PizzaPrice> doSaveAndGetPizzaPrice() {
        ArrayList<PizzaPrice> arrayList = new ArrayList<PizzaPrice>();
        if (this.b != null && this.b.getComponentCount() > 0) {
            for (int i = 0; i < this.b.getComponentCount(); ++i) {
                PizzaCrust pizzaCrust;
                Component component = this.b.getComponent(i);
                if (!(component instanceof PizzaPriceLayout)) continue;
                PizzaPriceLayout pizzaPriceLayout = (PizzaPriceLayout)component;
                PizzaPrice pizzaPrice = new PizzaPrice();
                pizzaPrice.setCost(pizzaPriceLayout.getCost());
                MenuItemSize menuItemSize = pizzaPriceLayout.getMenuItemSize();
                if (menuItemSize != null && menuItemSize.getId() == null) {
                    MenuItemSizeDAO.getInstance().save(menuItemSize);
                }
                if ((pizzaCrust = pizzaPriceLayout.getCrust()) != null && pizzaCrust.getId() == null) {
                    PizzaCrustDAO.getInstance().save(pizzaCrust);
                }
                pizzaPrice.setSize(menuItemSize);
                pizzaPrice.setCrust(pizzaCrust);
                pizzaPrice.setPrice(pizzaPriceLayout.getPrice());
                pizzaPrice.setIsDefault(pizzaPriceLayout.isDefault());
                arrayList.add(pizzaPrice);
            }
            return arrayList;
        }
        return null;
    }

    public void deleteLayout(PizzaPriceLayout pizzaPriceLayout) {
        if (this.b != null) {
            if (this.b.getComponentCount() == 1) {
                return;
            }
            if (pizzaPriceLayout.isDefault()) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("PizzaPriceView.0"));
                return;
            }
        }
        this.b.remove(pizzaPriceLayout);
        this.a();
        this.c();
    }

    private void a() {
        if (this.b != null && this.b.getComponentCount() > 0) {
            for (int i = 0; i < this.b.getComponentCount(); ++i) {
                if (!(this.b.getComponent(i) instanceof PizzaPriceLayout)) continue;
                PizzaPriceLayout pizzaPriceLayout = (PizzaPriceLayout)this.b.getComponent(i);
                pizzaPriceLayout.validatePizzaPriceLayout();
            }
        }
    }

    public boolean isValidModifier() {
        return this.isValidModifier(false);
    }

    public boolean isValidModifier(boolean bl) {
        try {
            if (this.b != null && this.b.getComponentCount() > 0) {
                boolean bl2 = false;
                for (int i = 0; i < this.b.getComponentCount(); ++i) {
                    Component component = this.b.getComponent(i);
                    if (!(component instanceof PizzaPriceLayout)) continue;
                    PizzaPriceLayout pizzaPriceLayout = (PizzaPriceLayout)component;
                    if (pizzaPriceLayout.isDefault()) {
                        bl2 = true;
                    }
                    if (pizzaPriceLayout.validatePizzaPriceLayout(bl)) continue;
                    return false;
                }
                if (!bl2) {
                    throw new PosException(Messages.getString("PizzaPriceView.1"));
                }
                return true;
            }
            throw new PosException(Messages.getString("PizzaPriceView.2"));
        }
        catch (Exception exception) {
            if (bl) {
                throw new PosException(exception.getMessage());
            }
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage());
            return false;
        }
    }

    public PizzaCrust getExistingCrust(String string) {
        for (PizzaCrust pizzaCrust : this.c) {
            if (!pizzaCrust.getName().equalsIgnoreCase(string)) continue;
            return pizzaCrust;
        }
        return null;
    }

    public MenuItemSize getExistingSize(String string) {
        for (MenuItemSize menuItemSize : this.d) {
            if (!menuItemSize.getName().equalsIgnoreCase(string)) continue;
            return menuItemSize;
        }
        return null;
    }

    private void b() {
        this.setLayout((LayoutManager)new MigLayout("fillx,inset 5, hidemode 3"));
        this.setBorder(new TitledBorder(Messages.getString("PizzaPriceView.3")));
        this.b = new TransparentPanel();
        this.b.setLayout((LayoutManager)new MigLayout("fillx,inset 0, hidemode 3"));
        List<PizzaPrice> list = this.a.getPizzaPriceList();
        if (list != null && list.size() > 0) {
            for (PizzaPrice pizzaPrice : list) {
                PizzaPriceLayout pizzaPriceLayout = pizzaPrice.isIsDefault() != false ? new PizzaPriceLayout(true) : new PizzaPriceLayout(false);
                pizzaPriceLayout.setCrust(pizzaPrice.getCrust());
                pizzaPriceLayout.setSize(pizzaPrice.getSize());
                String string = NumberUtil.formatNumber(pizzaPrice.getCost());
                String string2 = NumberUtil.formatNumber(pizzaPrice.getPrice());
                pizzaPriceLayout.setCost(string);
                pizzaPriceLayout.setPrice(string2);
                this.b.add((Component)pizzaPriceLayout, "wrap");
            }
        } else {
            this.a(true);
        }
        JButton jButton = new JButton(Messages.getString("PizzaPriceView.4"));
        jButton.addActionListener(actionEvent -> {
            try {
                this.a();
                this.a(false);
            }
            catch (PosException posException) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), posException.getMessage());
            }
        });
        this.add((Component)this.b, "wrap");
        this.add(jButton);
        this.c();
    }

    private void a(boolean bl) {
        try {
            PizzaPriceLayout pizzaPriceLayout = new PizzaPriceLayout(bl);
            this.b.add((Component)pizzaPriceLayout, "wrap");
            this.c();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), posException.getMessage());
        }
    }

    private void c() {
        this.revalidate();
        this.repaint();
    }

    public class PizzaPriceLayout
    extends TransparentPanel
    implements ActionListener,
    KeyListener {
        private ComboBoxValidationComponant b;
        private ValidationCombobox c;
        private ComboBoxValidationComponant d;
        private ValidationCombobox e;
        private DoubleTextField f;
        private DoubleTextField g;
        private JRadioButton h;

        public PizzaPriceLayout(boolean bl) {
            this.setLayout((LayoutManager)new MigLayout("fillx,inset 0, hidemode 3", "[]5[]"));
            this.h = new JRadioButton("", bl);
            PizzaPriceView.this.e.add(this.h);
            this.c = new ValidationCombobox();
            ArrayList arrayList = new ArrayList();
            arrayList.add(null);
            arrayList.addAll(PizzaPriceView.this.d);
            this.c.setDataModel(arrayList);
            this.c.addActionListener(this);
            this.c.addKeyListener(this);
            this.b = new ComboBoxValidationComponant("", this.c, "70dlu");
            this.e = new ValidationCombobox();
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(null);
            arrayList2.addAll(PizzaPriceView.this.c);
            ComboBoxModel comboBoxModel = new ComboBoxModel(arrayList2);
            this.e.setModel(comboBoxModel);
            this.e.addActionListener(this);
            this.e.addKeyListener(this);
            this.d = new ComboBoxValidationComponant("", this.e, "70dlu");
            this.f = new DoubleTextField();
            this.f.setPreferredSize(PosUIManager.getSize((int)100, (int)20));
            this.g = new DoubleTextField();
            this.g.setPreferredSize(PosUIManager.getSize((int)100, (int)20));
            JButton jButton = new JButton("X");
            jButton.setFont(jButton.getFont().deriveFont(1));
            jButton.addActionListener(actionEvent -> this.b());
            this.add(this.a(Messages.getString("PizzaPriceView.5")));
            this.add(this.h);
            this.add((Component)this.a(Messages.getString("PizzaPriceView.6")), "gapleft 10,span 2");
            this.add(this.a());
            this.add(this.b);
            this.add((Component)this.a(Messages.getString("PizzaPriceView.7")), "gapleft 10,span 2");
            this.add(this.a());
            this.add(this.d);
            this.add((Component)this.a(Messages.getString("PizzaPriceView.8")), "gapleft 10");
            this.add(this.f);
            this.add((Component)this.a(Messages.getString("PizzaPriceView.9")), "gapleft 10,span 2");
            this.add(this.a());
            this.add(this.g);
            this.add(jButton);
        }

        private JLabel a(String string) {
            JLabel jLabel = new JLabel(string);
            return jLabel;
        }

        private JLabel a() {
            JLabel jLabel = this.a("*");
            jLabel.setForeground(Color.RED);
            return jLabel;
        }

        private void b() {
            PizzaPriceView.this.deleteLayout(this);
        }

        public boolean isDefault() {
            return this.h.isSelected();
        }

        public PizzaCrust getCrust() {
            Object object = this.e.getSelectedItem();
            if (object instanceof PizzaCrust) {
                PizzaCrust pizzaCrust = (PizzaCrust)object;
                return pizzaCrust;
            }
            return null;
        }

        public MenuItemSize getMenuItemSize() {
            Object object = this.c.getSelectedItem();
            if (object instanceof MenuItemSize) {
                MenuItemSize menuItemSize = (MenuItemSize)object;
                return menuItemSize;
            }
            return null;
        }

        public double getCost() {
            return this.f.getDoubleOrZero();
        }

        public double getPrice() {
            return this.g.getDoubleOrZero();
        }

        public void setCrust(PizzaCrust pizzaCrust) {
            this.e.setSelectedItem(pizzaCrust);
        }

        public void setSize(MenuItemSize menuItemSize) {
            this.c.setSelectedItem(menuItemSize);
        }

        public void setCost(String string) {
            this.f.setText(string);
        }

        public void setPrice(String string) {
            this.g.setText(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.c();
        }

        private void c() {
            this.a(this);
        }

        private void a(PizzaPriceLayout pizzaPriceLayout) {
            ValidationResult validationResult = new ValidationResult();
            ValidationResult validationResult2 = new ValidationResult();
            try {
                MenuItemSize menuItemSize = null;
                Object object = this.c.getSelectedItem();
                if (object != null) {
                    if (object instanceof String) {
                        menuItemSize = this.addNewPizzaSize((String)object);
                    } else if (object instanceof MenuItemSize) {
                        menuItemSize = (MenuItemSize)object;
                    }
                } else {
                    validationResult.addError(Messages.getString("PizzaPriceView.11"), (Object)GlobalIdGenerator.generateGlobalId());
                }
                if (menuItemSize == null) {
                    this.a(pizzaPriceLayout, validationResult, validationResult2);
                }
                PizzaCrust pizzaCrust = null;
                Object object2 = this.e.getSelectedItem();
                if (object2 != null) {
                    if (object2 instanceof String) {
                        pizzaCrust = this.addNewPizzaCrust((String)object2);
                    } else if (object2 instanceof PizzaCrust) {
                        pizzaCrust = (PizzaCrust)object2;
                    }
                } else {
                    validationResult2.addError(Messages.getString("PizzaPriceView.12"), (Object)GlobalIdGenerator.generateGlobalId());
                }
                if (pizzaCrust == null) {
                    this.a(pizzaPriceLayout, validationResult, validationResult2);
                }
                if (menuItemSize != null && pizzaCrust != null) {
                    int n = PizzaPriceView.this.b.getComponentCount();
                    if (PizzaPriceView.this.b != null && n > 0) {
                        for (int i = n - 1; i >= 0; --i) {
                            PizzaPriceLayout pizzaPriceLayout2;
                            if (!(PizzaPriceView.this.b.getComponent(i) instanceof PizzaPriceLayout) || (pizzaPriceLayout2 = (PizzaPriceLayout)PizzaPriceView.this.b.getComponent(i)).equals(pizzaPriceLayout)) continue;
                            MenuItemSize menuItemSize2 = pizzaPriceLayout2.getMenuItemSize();
                            PizzaCrust pizzaCrust2 = pizzaPriceLayout2.getCrust();
                            if (menuItemSize2 == null || pizzaCrust2 == null || !menuItemSize.equals(menuItemSize2) || !pizzaCrust.equals(pizzaCrust2)) continue;
                            throw new PosException(Messages.getString("PizzaPriceView.13"));
                        }
                    }
                }
            }
            catch (PosException posException) {
                if (validationResult.isEmpty()) {
                    validationResult.addError(posException.getMessage(), (Object)GlobalIdGenerator.generateGlobalId());
                } else {
                    validationResult.addError(posException.getMessage());
                }
                if (validationResult.isEmpty()) {
                    validationResult2.addError(posException.getMessage(), (Object)GlobalIdGenerator.generateGlobalId());
                }
                validationResult2.addError(posException.getMessage());
            }
            this.a(pizzaPriceLayout, validationResult, validationResult2);
        }

        private void a(PizzaPriceLayout pizzaPriceLayout, ValidationResult validationResult, ValidationResult validationResult2) {
            ComboBoxValidationComponant comboBoxValidationComponant = pizzaPriceLayout.getPizzaSizeComponant();
            ValidationResultModel validationResultModel = comboBoxValidationComponant.getValidationResultModel();
            validationResultModel.setResult(validationResult);
            comboBoxValidationComponant.updateValidationResult(validationResult, comboBoxValidationComponant.getValidationResultModel());
            ComboBoxValidationComponant comboBoxValidationComponant2 = pizzaPriceLayout.getPizzaCrustComponant();
            ValidationResultModel validationResultModel2 = comboBoxValidationComponant2.getValidationResultModel();
            validationResultModel2.setResult(validationResult2);
            comboBoxValidationComponant2.updateValidationResult(validationResult2, comboBoxValidationComponant2.getValidationResultModel());
            PizzaPriceView.this.c();
        }

        public boolean validatePizzaPriceLayout() {
            return this.validatePizzaPriceLayout(false);
        }

        public boolean validatePizzaPriceLayout(boolean bl) {
            Object object = this.c.getSelectedItem();
            ValidationResult validationResult = new ValidationResult();
            if (object == null) {
                this.c.requestFocus();
                validationResult.addError(Messages.getString("PizzaPriceView.11"), (Object)GlobalIdGenerator.generateGlobalId());
            }
            ComboBoxValidationComponant comboBoxValidationComponant = this.getPizzaSizeComponant();
            ValidationResultModel validationResultModel = comboBoxValidationComponant.getValidationResultModel();
            validationResultModel.setResult(validationResult);
            comboBoxValidationComponant.updateValidationResult(validationResult, comboBoxValidationComponant.getValidationResultModel());
            Object object2 = this.e.getSelectedItem();
            ValidationResult validationResult2 = new ValidationResult();
            if (object2 == null) {
                this.e.requestFocus();
                validationResult2.addError(Messages.getString("PizzaPriceView.12"), (Object)GlobalIdGenerator.generateGlobalId());
            }
            ComboBoxValidationComponant comboBoxValidationComponant2 = this.getPizzaCrustComponant();
            ValidationResultModel validationResultModel2 = comboBoxValidationComponant2.getValidationResultModel();
            validationResultModel2.setResult(validationResult2);
            comboBoxValidationComponant2.updateValidationResult(validationResult2, comboBoxValidationComponant2.getValidationResultModel());
            if (!validationResult.isEmpty() && bl) {
                throw new PosException(validationResult.getMessagesText());
            }
            if (!validationResult2.isEmpty() && bl) {
                throw new PosException(validationResult2.getMessagesText());
            }
            String string = this.f.getText();
            String string2 = this.g.getText();
            if (!NumberUtil.isValidDouble(string)) {
                this.f.requestFocus();
                if (bl) {
                    throw new PosException(Messages.getString("PizzaPriceView.16"));
                }
            }
            if (StringUtils.isBlank((CharSequence)string2)) {
                this.g.requestFocus();
                if (bl) {
                    throw new PosException(Messages.getString("PizzaPriceView.17"));
                }
            }
            if (!NumberUtil.isValidDouble(string2)) {
                this.g.requestFocus();
                if (bl) {
                    throw new PosException(Messages.getString("PizzaPriceView.17"));
                }
            }
            this.a(this);
            int n = PizzaPriceView.this.b.getComponentCount();
            if (PizzaPriceView.this.b != null && n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (!(PizzaPriceView.this.b.getComponent(i) instanceof PizzaPriceLayout)) continue;
                    PizzaPriceLayout pizzaPriceLayout = (PizzaPriceLayout)PizzaPriceView.this.b.getComponent(i);
                    ValidationResult validationResult3 = pizzaPriceLayout.getPizzaSizeComponant().getValidationResultModel().getResult();
                    if (!validationResult3.isEmpty()) {
                        if (bl) {
                            throw new PosException(validationResult3.getMessagesText());
                        }
                        return false;
                    }
                    ValidationResult validationResult4 = pizzaPriceLayout.getPizzaCrustComponant().getValidationResultModel().getResult();
                    if (validationResult4.isEmpty()) continue;
                    if (bl) {
                        throw new PosException(validationResult4.getMessagesText());
                    }
                    return false;
                }
            }
            return true;
        }

        public MenuItemSize addNewPizzaSize(String string) {
            String string2 = string.trim();
            MenuItemSize menuItemSize = (MenuItemSize)PizzaPriceView.this.f.get(string2.toLowerCase());
            if (menuItemSize != null) {
                this.c.setSelectedItem(menuItemSize);
                return menuItemSize;
            }
            this.c.removeItem(string);
            MenuItemSize menuItemSize2 = new MenuItemSize();
            menuItemSize2.setName(string2);
            PizzaPriceView.this.f.put(string2.toLowerCase(), menuItemSize2);
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.c.getModel();
            comboBoxModel.addElement(menuItemSize2);
            this.c.setSelectedItem(menuItemSize2);
            return menuItemSize2;
        }

        public PizzaCrust addNewPizzaCrust(String string) {
            String string2 = string.trim();
            PizzaCrust pizzaCrust = (PizzaCrust)PizzaPriceView.this.g.get(string2.toLowerCase());
            if (pizzaCrust != null) {
                this.e.setSelectedItem(pizzaCrust);
                return pizzaCrust;
            }
            this.e.removeItem(string);
            PizzaCrust pizzaCrust2 = new PizzaCrust();
            pizzaCrust2.setName(string2);
            PizzaPriceView.this.g.put(string2.toLowerCase(), pizzaCrust2);
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.e.getModel();
            comboBoxModel.addElement(pizzaCrust2);
            this.e.setSelectedItem(pizzaCrust2);
            return pizzaCrust2;
        }

        public ComboBoxValidationComponant getPizzaSizeComponant() {
            return this.b;
        }

        public ComboBoxValidationComponant getPizzaCrustComponant() {
            return this.d;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.validatePizzaPriceLayout();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

