/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.DrawerKickAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.StaffBankCloseAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CashDropTransactionDAO;
import com.floreantpos.model.dao.CashInTransactionDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.service.DetailsReportService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.GratuityDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PayoutDialog;
import com.floreantpos.ui.dialog.ServerOpenTicketListDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;

public class CashDrawerReportDialog
extends POSDialog
implements ActionListener {
    private TitlePanel a;
    private CashDrawer b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private PosButton h;
    private PosButton i;
    private PosButton j;
    private User k;
    private Terminal l;
    private PosButton m;
    private PosButton n;
    private PosButton o;
    private List<CashDrawer> p;
    private JPanel q;
    private JPanel r;
    private JPanel s;
    private PosButton t;
    private boolean u;
    private JasperPrint v;
    private boolean w;
    private PosButton x;

    public CashDrawerReportDialog(CashDrawer cashDrawer) {
        this(null, cashDrawer);
    }

    public CashDrawerReportDialog(User user, CashDrawer cashDrawer) {
        this(user, cashDrawer, false);
    }

    public CashDrawerReportDialog(User user, CashDrawer cashDrawer, boolean bl) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.k = user;
        this.b = cashDrawer;
        this.w = bl;
        this.l = cashDrawer.getTerminal();
        this.b();
        this.setSize(PosUIManager.getSize((int)800, (int)670));
    }

    private void a() {
        boolean bl;
        if (this.u) {
            return;
        }
        if (this.b.getId() == null || this.b.isClosed()) {
            this.a(false);
            return;
        }
        boolean bl2 = this.b.getTerminal().getId().intValue() == Application.getInstance().getTerminal().getId().intValue();
        boolean bl3 = bl = this.b.getDrawerType() == DrawerType.STAFF_BANK;
        if (bl) {
            this.c.setText(Messages.getString("CloseStaffBank"));
        }
        this.c.setEnabled(this.b.getId() != null && this.b.isOpen());
        this.h.setEnabled(this.b.getId() != null && this.b.isOpen());
        this.j.setVisible(bl);
        this.i.setVisible(bl);
        this.h.setVisible(bl);
        this.d.setVisible(!bl);
        this.e.setVisible(!bl && bl2);
        this.f.setVisible(bl2);
        this.g.setVisible(!bl && bl2);
        this.c.setVisible(!bl);
        this.o.setVisible(!bl);
    }

    private void a(boolean bl) {
        this.c.setEnabled(bl);
        this.h.setVisible(bl);
        this.j.setEnabled(bl);
        this.i.setEnabled(bl);
        this.h.setEnabled(bl);
        this.d.setEnabled(bl);
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
        this.c.setVisible(bl);
        this.o.setVisible(bl);
    }

    public void showInfoOnly(boolean bl) {
        this.u = bl;
        this.r.setVisible(!bl);
        if (this.k == null) {
            return;
        }
        if (this.u) {
            this.s.removeAll();
            this.s.add((Component)new JSeparator(), "grow,span,wrap");
            this.s.add((Component)this.n, "grow");
            this.s.add((Component)this.m, "grow");
            this.s.add((Component)this.t, "grow");
            this.h.setVisible(!this.u);
            this.c.setVisible(!this.u);
        }
    }

    private void b() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = new TitlePanel();
        this.add((Component)this.a, "North");
        this.q = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
        this.add(new PosScrollPane(this.q));
        this.s = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 5", "[grow]", ""));
        this.m = new PosButton(POSConstants.PRINT);
        this.t = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.x = new PosButton(Messages.getString("LOCK_DRAWER"));
        this.d = new PosButton(POSConstants.DRAWER_BLEED);
        this.e = new PosButton(Messages.getString("NO_SALE"));
        this.f = new PosButton(POSConstants.PAYOUT_BUTTON_TEXT);
        this.g = new PosButton(Messages.getString("cashIn"));
        this.c = new PosButton(Messages.getString("CashDrawerReportDialog.6"));
        this.x.setVisible(!this.b.isLocked() && this.l.isTwoCashDrawersEnable());
        this.x.addActionListener(this);
        this.d.addActionListener(this);
        this.f.addActionListener(this);
        this.g.addActionListener(this);
        this.e.setAction(new DrawerKickAction(this.b){

            @Override
            protected User getCurrentUser() {
                return CashDrawerReportDialog.this.k;
            }
        });
        this.c.addActionListener(actionEvent -> this.o());
        this.h = new PosButton(Messages.getString("CloseStaffBank"));
        this.h.addActionListener(actionEvent -> this.p());
        this.j = new PosButton(Messages.getString("DeclareTips"));
        this.j.addActionListener(actionEvent -> this.f());
        this.i = new PosButton(Messages.getString("CashDrawerReportDialog.9"));
        this.i.addActionListener(actionEvent -> this.g());
        this.r = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 0 20 0 20,wrap 1", "[120px,grow]", ""));
        this.s.add((Component)new JSeparator(), "grow,span,wrap");
        this.s.add((Component)this.m, "gapleft 160,grow");
        this.n = new PosButton(POSConstants.DETAILS);
        this.n.addActionListener(actionEvent -> this.d());
        this.o = new PosButton(Messages.getString("CashDrawerReportDialog.0"));
        this.o.addActionListener(actionEvent -> this.c());
        this.r.add((Component)this.x, "grow");
        this.r.add((Component)this.d, "grow");
        this.r.add((Component)this.e, "grow");
        this.r.add((Component)this.f, "grow");
        this.r.add((Component)this.g, "grow");
        this.s.add((Component)this.n, "grow");
        this.s.add((Component)this.o, "grow");
        this.s.add((Component)this.c, "grow");
        this.s.add((Component)this.h, "grow");
        this.s.add((Component)this.t, "grow");
        this.add((Component)this.s, "South");
        this.add((Component)this.r, "West");
        this.t.addActionListener(actionEvent -> this.h());
        this.m.addActionListener(actionEvent -> this.i());
    }

    public void refreshReport() throws Exception {
        this.createReport(!this.u);
        this.a();
    }

    private void c() {
        try {
            UserListDialog userListDialog = new UserListDialog();
            userListDialog.pack();
            userListDialog.open();
            if (userListDialog.isCanceled()) {
                return;
            }
            User user = userListDialog.getSelectedUser();
            if (!user.isClockedIn().booleanValue()) {
                POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.16"));
                return;
            }
            CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
            cashDrawerDAO.refresh(this.b);
            String string = this.b.getAssignedUserId();
            if (string.equals(user.getId())) {
                POSMessageDialog.showError(Messages.getString("CashDrawerReportDialog.1"));
                return;
            }
            cashDrawerDAO.transferUser(this.b, user);
            POSMessageDialog.showMessage(Messages.getString("DrawerAssignmentAction.8") + " " + user.getFullName());
            this.refreshReport();
            this.a(this.b, string);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void a(CashDrawer cashDrawer, String string) {
        try {
            String string2 = String.format("Drawer id : %s is transfered from user %s to user %s", cashDrawer.getId(), string, cashDrawer.getAssignedUserId());
            ActionHistoryDAO.saveHistory(this.k, "Cash drawer assignment change", string2);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void d() {
        try {
            if (this.b == null) {
                return;
            }
            this.e();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void e() throws Exception {
        Object object;
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        if (this.p != null && this.p.size() > 0) {
            for (CashDrawer cashDrawer : this.p) {
                List<PosTransaction> list = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(cashDrawer.getId(), false);
                arrayList.addAll(list);
            }
        } else {
            object = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(this.b.getId(), false);
            arrayList.addAll((Collection<PosTransaction>)object);
        }
        this.v = DetailsReportService.buildCashDrawerSummaryDetailTransationReport(arrayList, this.b);
        object = new DetailReportDialog(this.v);
        ((DetailReportDialog)object).setTitle(this.b.getType().intValue() == DrawerType.DRAWER.getTypeNumber() ? Messages.getString("CashDrawerReportDialog.13") : Messages.getString("CashDrawerReportDialog.14"));
        ((DetailReportDialog)object).updateView();
        ((POSDialog)object).openFullScreen();
    }

    private void f() {
        try {
            if (this.b == null) {
                return;
            }
            Double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), Messages.getString("CashDrawerReportDialog.21"), this.b.getTipsPaid());
            if (Double.isNaN(d)) {
                return;
            }
            this.b.setDeclaredTips(d);
            TerminalDAO.getInstance().performBatchSave(this.b);
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void g() {
        this.k();
    }

    private void h() {
        this.dispose();
    }

    @Override
    public void setTitle(String string) {
        this.a.setTitle(string);
        super.setTitle(VersionInfo.getAppName());
    }

    private void i() {
        try {
            PosPrintService.printCashDrawerReport(this.b);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + exception.getMessage(), exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            PosButton posButton = (PosButton)actionEvent.getSource();
            if (posButton == this.x) {
                this.j();
            }
            if (posButton == this.d) {
                this.l();
                this.refreshReport();
            } else if (posButton == this.f) {
                this.m();
                this.refreshReport();
            } else if (posButton == this.g) {
                this.n();
                this.refreshReport();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void j() {
        if (!PosAction.checkPermission(this.k, UserPermission.LOCK_DRAWER)) {
            return;
        }
        this.b.setLocked(true);
        CashDrawerDAO.getInstance().saveOrUpdate(this.b);
        this.x.setVisible(!this.b.isLocked());
    }

    private void k() {
        GratuityDialog gratuityDialog = new GratuityDialog((Window)this, this.k);
        gratuityDialog.setCaption(VersionInfo.getAppName());
        gratuityDialog.setOkButtonText(Messages.getString("PAY"));
        gratuityDialog.setSize(PosUIManager.getSize((int)780, (int)550));
        gratuityDialog.open();
        if (gratuityDialog.isCanceled()) {
            return;
        }
        try {
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void l() {
        try {
            DrawerUtil.kickDrawer(this.b);
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(true);
            numberSelectionDialog2.setTitle(VersionInfo.getAppName());
            numberSelectionDialog2.setCaption(Messages.getString("CashDropDialog.17"));
            numberSelectionDialog2.setAllowNegativeInput(false);
            numberSelectionDialog2.setValue(0.0);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (!numberSelectionDialog2.isCanceled()) {
                double d = numberSelectionDialog2.getValue();
                if (d > this.b.getDrawerAccountable()) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CashDrawerReportDialog.2"));
                    return;
                }
                CashDropTransaction cashDropTransaction = new CashDropTransaction();
                cashDropTransaction.setDrawerResetted(false);
                cashDropTransaction.setTerminal(this.l);
                cashDropTransaction.setCashDrawer(this.b);
                cashDropTransaction.setPaymentType(PaymentType.CASH);
                cashDropTransaction.setUser(this.k);
                cashDropTransaction.setServer(this.k);
                cashDropTransaction.setTransactionTime(new Date());
                cashDropTransaction.setAmount(d);
                cashDropTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
                CashDropTransactionDAO cashDropTransactionDAO = new CashDropTransactionDAO();
                cashDropTransactionDAO.saveNewCashDrop(cashDropTransaction, this.l);
                this.a(d, this.b);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("CashDropDialog.18"), exception);
        }
    }

    private void a(double d, CashDrawer cashDrawer) {
        try {
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            String string = String.format("Terminal id : %s, Cash drawer id : %s, Total : %s", terminal.getId(), cashDrawer.getId(), NumberUtil.formatNumber(d));
            ActionHistoryDAO.saveHistory(this.k, "Cash drawer bleed", string);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void m() {
        try {
            TerminalDAO.getInstance().refresh(this.l);
            if (!POSUtil.checkDrawerAssignment(this.l, this.k)) {
                return;
            }
            DrawerUtil.kickDrawer(this.b);
            PayoutDialog payoutDialog = new PayoutDialog((Dialog)this, this.k, this.l, this.b);
            payoutDialog.open();
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void n() {
        try {
            Double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("PosMessage.111"), false, false, 0.0);
            if (Double.isNaN(d) || d < 0.0) {
                return;
            }
            CashInTransactionDAO.getInstance().create(this.b, this.l, this.k, d);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CashDrawerReportDialog.3"));
            this.refreshReport();
            DrawerUtil.kickDrawer(this.b);
            ActionHistoryDAO.saveHistory(this.k, "Cash In", "Drawer id: " + this.b.getId());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void o() {
        try {
            DrawerUtil.kickDrawer(this.b);
            DrawerAssignmentAction drawerAssignmentAction = new DrawerAssignmentAction(this.l, this.b, this.k, this.w);
            drawerAssignmentAction.execute();
            this.b = CashDrawerDAO.getInstance().get(this.b.getId());
            this.refreshReport();
            ActionHistoryDAO.saveHistory(this.k, "Cash drawer close", "Drawer id: " + this.b.getId());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void p() {
        try {
            Serializable serializable;
            Store store = DataProvider.get().getStore();
            boolean bl = store.getBooleanProperty("do_not_allow_close_staff_bank_with.open_tickets", false);
            int n = TicketDAO.getInstance().countOpenTicketsForUser(this.k);
            if (n > 0) {
                serializable = new ServerOpenTicketListDialog(this.k, this.k, true);
                ((ServerOpenTicketListDialog)serializable).setTitle(Messages.getString("ClockInOutDialog.121"));
                ((Window)serializable).setSize(PosUIManager.getSize((int)830, (int)550));
                ((ServerOpenTicketListDialog)serializable).initData();
                ((POSDialog)serializable).open();
                if (((POSDialog)serializable).isCanceled()) {
                    return;
                }
            }
            if ((n = TicketDAO.getInstance().countOpenTicketsForUser(this.k)) > 0 && bl) {
                POSMessageDialog.showMessage(Messages.getString("CashDrawerReportDialog.5"));
                return;
            }
            if (!this.k.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CashDrawerReportDialog.25"));
                return;
            }
            serializable = new StaffBankCloseAction(this.b, this.k);
            ((StaffBankCloseAction)serializable).execute();
            this.b = CashDrawerDAO.getInstance().get(this.b.getId());
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public void createReport(boolean bl) throws Exception {
        PosPrintService.showCashDrawerReport(this.b, this.q);
    }
}

