/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.PrintUtil;
import com.floreantpos.ui.views.ClockInOutDialog3;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class ClockedInUserListDialog
extends OkCancelOptionDialog {
    BeanTableModel<User> a;
    JTable b;
    private PosButton c;
    private boolean d = false;
    private User e;

    public ClockedInUserListDialog(User user) {
        super((Frame)Application.getPosWindow(), true);
        this.e = user;
        this.setTitle(VersionInfo.getAppName());
        this.setCaption(Messages.getString("ClockedInUserListDialog.1"));
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.a = new BeanTableModel<User>(User.class){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 1) {
                    return Messages.getString("ClockedInUserListDialog.2");
                }
                return super.getValueAt(n, n2);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 != 1) {
                    super.setValueAt(object, n, n2);
                }
            }
        };
        this.a.addColumn("Name", "fullName");
        this.a.addColumn("", "clockedIn");
        this.b = new JTable(this.a);
        this.b.setRowHeight(PosUIManager.getSize((int)45));
        this.b.setShowGrid(false);
        this.b.getSelectionModel().setSelectionMode(0);
        jPanel.add(new JScrollPane(this.b));
        this.b.getTableHeader().setPreferredSize(PosUIManager.getSize((int)0, (int)35));
        this.c = new PosButton(Messages.getString("ClockedInUserListDialog.2"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                User user = ClockedInUserListDialog.this.getSelectedUser();
                if (user == null) {
                    return;
                }
                ClockedInUserListDialog.this.a(user);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                User user = ClockedInUserListDialog.this.getSelectedUser();
                if (user == null) {
                    return;
                }
                ClockedInUserListDialog.this.a(user);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.b, abstractAction, 1){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, this.b.getBackground());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(5, 5, 5, 5, this.b.getBackground());
        CompoundBorder compoundBorder = new CompoundBorder(matteBorder, this.c.getBorder());
        CompoundBorder compoundBorder2 = new CompoundBorder(matteBorder2, this.c.getBorder());
        buttonColumn.setUnselectedBorder(compoundBorder);
        buttonColumn.setFocusBorder(compoundBorder2);
        this.a();
        this.setOkButtonText(Messages.getString("DONE"));
        this.setCancelButtonVisible(false);
    }

    private void a() {
        List<User> list = UserDAO.getInstance().findClockedInUsers();
        this.a.setRows(list);
    }

    private void a(User user) {
        try {
            if (!(this.e.isManager() || this.e.isAdministrator() || this.e.hasPermission(UserPermission.OPEN_CLOSE_STORE))) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ClockedInUserListDialog.7"));
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ClockedInUserListDialog.8"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            UserDAO.getInstance().doForceClockOutUser(user, this.e);
            String string = Messages.getString("USER") + " " + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.10");
            if (POSMessageDialog.showMessageAndPromtToPrint(string)) {
                PrintUtil.printClockInOutReport(user, this);
            }
            if (this.e.getId().equals(user.getId())) {
                this.e.setClockedIn(user.isClockedIn());
                ClockInOutDialog3.getInstance(this.e, false);
            }
            this.a();
            this.d = true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public void hideUser(User user) {
        this.a.removeRow(user);
    }

    public User getSelectedUser() {
        int n = this.b.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.a.getRows().get(n);
    }

    @Override
    public void doOk() {
        this.setCanceled(true);
        this.dispose();
    }

    public boolean isDataUpdated() {
        return this.d;
    }
}

