/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxEditor;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class CustomerImportCheckingDialog
extends POSDialog {
    private BeanTableModel<Customer> a;
    private PosTable b;
    private File c;
    private List<Customer> d;
    private TitlePanel e;
    private Map<String, Attribute> f;
    private List<String> g;
    private Map<String, CustomerGroup> h;
    private Map<String, Integer> i;
    private Map<String, Integer> j;

    public CustomerImportCheckingDialog(File file) {
        this.c = file;
        this.i = new HashMap<String, Integer>();
        this.j = new HashMap<String, Integer>();
        this.f = new HashMap<String, Attribute>();
        List<Attribute> list = AttributeDAO.getInstance().findMembershipAttribute();
        if (list != null) {
            for (Attribute object : list) {
                this.f.put(object.getName(), object);
            }
        }
        this.g = new ArrayList<String>();
        this.g.add(null);
        this.g.add(Messages.getString("CustomerForm.2"));
        this.g.add(Messages.getString("CustomerForm.4"));
        this.g.add(Messages.getString("CustomerForm.5"));
        this.g.add(Messages.getString("CustomerForm.6"));
        this.h = new HashMap<String, CustomerGroup>();
        List<CustomerGroup> list2 = CustomerGroupDAO.getInstance().findAll();
        if (list2 != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                CustomerGroup customerGroup = (CustomerGroup)iterator.next();
                this.h.put(customerGroup.getName().toLowerCase(), customerGroup);
            }
        }
        this.b();
        this.a();
    }

    private void a() {
        try {
            List<Customer> list = this.a(this.c.toURI().toURL());
            if (list == null) {
                return;
            }
            this.a.setRows(list);
            this.a(list.size());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerImportCheckingDialog.0"), exception);
        }
    }

    private void a(int n) {
        this.e.setTitle("Imported " + n + Messages.getString("CustomerImportCheckingDialog.1"));
    }

    private void b() {
        this.setTitle(VersionInfo.getAppName());
        this.e = new TitlePanel();
        this.a = new BeanTableModel(Customer.class);
        this.c();
        this.b = new PosTable(this.a){

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
            }

            public boolean isCellEditable(int n, int n2) {
                Customer customer = (Customer)CustomerImportCheckingDialog.this.a.getRow(n);
                if (n2 == 10) {
                    return customer.isMember();
                }
                return super.isCellEditable(n, n2);
            }

            public void setValueAt(Object object, int n, int n2) {
                Customer customer = (Customer)CustomerImportCheckingDialog.this.a.getRow(n);
                if (n2 == 10 && object instanceof String) {
                    String string = (String)object;
                    if (StringUtils.isNotBlank((String)string)) {
                        Attribute attribute = (Attribute)CustomerImportCheckingDialog.this.f.get(string);
                        customer.setMembershipType(attribute.getId());
                    } else {
                        customer.setMembershipType(null);
                    }
                }
                super.setValueAt(object, n, n2);
            }
        };
        this.e();
        this.d();
        this.b.setAutoResizeMode(0);
        this.resizeColumnWidth((JTable)((Object)this.b));
        this.a.initTableRenderer((JTable)((Object)this.b));
        this.b.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.b.setRowHeight(PosUIManager.getSize((int)30));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.e, "North");
        this.add((Component)new JScrollPane((Component)((Object)this.b)), "Center");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 4 8 6 0", "[][center][]", ""));
        JLabel jLabel = new JLabel();
        jLabel.setBackground(Color.RED);
        jLabel.setOpaque(true);
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerImportCheckingDialog.2"));
        PosButton posButton = new PosButton(POSConstants.SAVE);
        posButton.addActionListener(actionEvent -> this.g());
        PosButton posButton2 = new PosButton(Messages.getString("DELETE"));
        posButton2.addActionListener(actionEvent -> this.f());
        jPanel.add((Component)jLabel, "left,w 20!,h 12!,split 2");
        jPanel.add(jLabel2);
        jPanel.add((Component)posButton, "split 4");
        jPanel.add(posButton2);
        jPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("CANCEL"))));
        this.add((Component)jPanel, "South");
    }

    private void c() {
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.4"), Customer.PROP_MEMBER_ID);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.5"), Customer.PROP_FIRST_NAME);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.6"), Customer.PROP_LAST_NAME);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.7"), Customer.PROP_LOYALTY_NO);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.8"), Customer.PROP_LOYALTY_POINT, 11, BeanTableModel.DataType.INTEGER);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.9"), Customer.PROP_MOBILE_NO);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.10"), Customer.PROP_EMAIL);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.11"), Customer.PROP_SALUTATION);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.12"), Customer.PROP_MEMBER);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.13"), Customer.PROP_LIFE_TIME_MEMBER);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.14"), "membershipTypeDisplayString", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.16"), Customer.PROP_MEMBERSHIP_START_DATE);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.17"), Customer.PROP_MEMBERSHIP_RENEW_DATE);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.18"), Customer.PROP_MEMBERSHIP_EXPIRY_DATE);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.19"), Customer.PROP_MEMBERSHIP_ACTIVE);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.20"), Customer.PROP_DOB);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.21"), Customer.PROP_SSN);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.22"), Customer.PROP_ADDRESS);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.23"), Customer.PROP_CITY);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.24"), Customer.PROP_STATE);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.25"), Customer.PROP_ZIP_CODE);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.26"), Customer.PROP_COUNTRY);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.27"), Customer.PROP_VIP);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.28"), Customer.PROP_CREDIT_LIMIT, 11, BeanTableModel.DataType.MONEY);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.30"), Customer.PROP_NOTE);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.31"), Customer.PROP_TAX_EXEMPT);
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.32"), "customerGroup");
        this.a.addColumn(Messages.getString("CustomerImportCheckingDialog.35"), Customer.PROP_ACTIVE);
    }

    private void d() {
        this.b.setHighlighters(new Highlighter[]{new ColorHighlighter((HighlightPredicate)new DuplicateCustomersHighlighter(), new Color(255, 77, 77), Color.white)});
    }

    private void e() {
        JComboBox jComboBox = new JComboBox();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(null);
        arrayList.addAll(this.f.keySet());
        jComboBox.setModel(new ComboBoxModel(arrayList));
        JTextComponent jTextComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        jTextComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    JComponent jComponent = (JComponent)keyEvent.getSource();
                    JComboBox jComboBox = (JComboBox)jComponent.getParent();
                    JTable jTable = (JTable)jComboBox.getParent();
                    jTable.changeSelection(0, 1, false, false);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        jTextComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JComponent jComponent = (JComponent)focusEvent.getSource();
                JComponent jComponent2 = (JComponent)jComponent.getParent();
                JComboBox jComboBox = (JComboBox)jComponent2;
                jComboBox.setPopupVisible(true);
                JTextComponent jTextComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
                jTextComponent.setSelectionStart(0);
                jTextComponent.setSelectionEnd(jTextComponent.getText().length());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        TableColumn tableColumn = this.b.getColumnModel().getColumn(11);
        jComboBox.setEditable(true);
        ComboBoxEditor comboBoxEditor = new ComboBoxEditor(jComboBox);
        tableColumn.setCellEditor(comboBoxEditor);
    }

    private void f() {
        Integer n;
        Object object;
        int n2 = this.b.getSelectedRow();
        if (n2 < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserTypeExplorer.1"));
            return;
        }
        int n3 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardImportCheckingDialog.9"), Messages.getString("GiftCardImportCheckingDialog.10"));
        if (n3 != 0) {
            return;
        }
        Customer customer = this.a.getRow(n2);
        String string = customer.getMemberId();
        if (StringUtils.isNotBlank((String)string) && (object = this.i.get(string)) != null) {
            object = (Integer)object - 1;
            this.i.put(string, (Integer)object);
        }
        if (StringUtils.isNotBlank((String)(object = customer.getLoyaltyNo())) && (n = this.j.get(object)) != null) {
            n = n - 1;
            this.j.put((String)object, n);
        }
        this.a.removeRow(n2);
        this.a(this.a.getRows().size());
    }

    private List<Customer> a(URL uRL) {
        return this.b(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Customer> b(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList<Customer> arrayList = new ArrayList<Customer>();
            CSVParser cSVParser = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)bufferedReader);
            for (CSVRecord cSVRecord : cSVParser) {
                Comparable comparable;
                String string = this.b("Member Id", cSVRecord);
                String string2 = this.b("First Name", cSVRecord);
                String string3 = this.b("Last Name", cSVRecord);
                String string4 = this.b("Secret Code", cSVRecord);
                String string5 = this.b("Loyalty No", cSVRecord);
                Integer n = this.d("Loyalty Point", cSVRecord);
                String string6 = this.b("Phone", cSVRecord);
                String string7 = this.b("Email", cSVRecord);
                String string8 = this.b("Salutation", cSVRecord);
                Boolean bl = this.e("Member", cSVRecord);
                Boolean bl2 = this.e("Life Time Member", cSVRecord);
                String string9 = this.b("Membership Type", cSVRecord);
                Date date = this.a("Membership Start Date", cSVRecord);
                Date date2 = this.a("Membership Renew Date", cSVRecord);
                Date date3 = this.a("Membership Expiry Date", cSVRecord);
                Boolean bl3 = this.e("Membership Active", cSVRecord);
                Date date4 = this.a("DoB", cSVRecord);
                String string10 = this.b("Ssn", cSVRecord);
                String string11 = this.b("Address", cSVRecord);
                String string12 = this.b("City", cSVRecord);
                String string13 = this.b("State", cSVRecord);
                String string14 = this.b("Zip", cSVRecord);
                String string15 = this.b("Country", cSVRecord);
                Boolean bl4 = this.e("Vip", cSVRecord);
                Double d = this.c("Credit Limit", cSVRecord);
                String string16 = this.b("Note", cSVRecord);
                Boolean bl5 = this.e("Tax Exempt", cSVRecord);
                String string17 = this.b("Pin", cSVRecord);
                String string18 = this.b("Customer Group Name", cSVRecord);
                Boolean bl6 = this.e("Active", cSVRecord);
                Customer customer = new Customer();
                customer.setMemberId(string);
                customer.setFirstName(string2);
                customer.setLastName(string3);
                customer.setName(string2 + " " + string3);
                customer.setSecretCode(string4);
                customer.setLoyaltyNo(string5);
                customer.setMobileNo(string6);
                customer.setLoyaltyPoint(n);
                customer.setEmail(string7);
                customer.setSalutation(string8);
                customer.setMember(bl);
                customer.setLifeTimeMember(bl2);
                Attribute attribute = this.f.get(string9);
                if (attribute != null) {
                    customer.setMembershipType(attribute.getId());
                }
                customer.setMembershipStartDate(date);
                customer.setMembershipRenewDate(date2);
                customer.setMembershipExpiryDate(date3);
                customer.setMembershipActive(bl3);
                if (date4 != null) {
                    customer.setDob(DateUtil.formatAsGiftCardDateFormat(date4));
                }
                customer.setSsn(string10);
                customer.setAddress(string11);
                customer.setCity(string12);
                customer.setState(string13);
                customer.setZipCode(string14);
                customer.setCountry(string15);
                customer.setVip(bl4);
                customer.setCreditLimit(d);
                customer.setNote(string16);
                customer.setTaxExempt(bl5);
                customer.setPin(string17);
                if (StringUtils.isNotBlank((String)string18)) {
                    comparable = this.h.get(string18.toLowerCase());
                    customer.setCustomerGroup((CustomerGroup)comparable);
                }
                customer.setActive(bl6);
                arrayList.add(customer);
                if (StringUtils.isNotBlank((String)string)) {
                    comparable = this.i.get(string);
                    if (comparable == null) {
                        comparable = Integer.valueOf(0);
                    }
                    try {
                        GenericDAO.getInstance().checkDifferentObjectExists(customer.getId(), string, Customer.class, Customer.PROP_MEMBER_ID);
                        comparable = Integer.valueOf((Integer)comparable + 1);
                    }
                    catch (DuplicateDataException duplicateDataException) {
                        comparable = Integer.valueOf((Integer)comparable + 2);
                    }
                    this.i.put(string, (Integer)comparable);
                }
                if (!StringUtils.isNotBlank((String)string5)) continue;
                comparable = this.j.get(string5);
                if (comparable == null) {
                    comparable = Integer.valueOf(0);
                }
                try {
                    GenericDAO.getInstance().checkDifferentObjectExists(customer.getId(), string5, Customer.class, Customer.PROP_LOYALTY_NO);
                    comparable = Integer.valueOf((Integer)comparable + 1);
                }
                catch (DuplicateDataException duplicateDataException) {
                    comparable = Integer.valueOf((Integer)comparable + 2);
                }
                this.j.put(string5, (Integer)comparable);
            }
            ArrayList<Customer> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            PosLog.error(CustomerImportCheckingDialog.class, Messages.getString("MessageDialog.0") + exception.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return null;
    }

    private Date a(String string, CSVRecord cSVRecord) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                Date date = DateUtil.parseByGiftCardDateFormat(string2);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n = calendar.get(1);
                if (n < 100) {
                    calendar.add(1, 2000);
                }
                return calendar.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String b(String string, CSVRecord cSVRecord) {
        try {
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                return string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Double c(String string, CSVRecord cSVRecord) {
        try {
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                return Double.parseDouble(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Integer d(String string, CSVRecord cSVRecord) {
        try {
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                return Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Boolean e(String string, CSVRecord cSVRecord) {
        try {
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                return Boolean.parseBoolean(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<Customer> getCustomers() {
        return this.d;
    }

    public void setCustomers(List<Customer> list) {
        this.d = list;
    }

    private void g() {
        Object object;
        Object object2;
        Object object3;
        if (this.a.getRows().size() < 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardImportCheckingDialog.3"));
            return;
        }
        this.d = new ArrayList<Customer>();
        this.d.addAll(this.a.getRows());
        Set<String> set = this.i.keySet();
        if (set != null) {
            object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = this.i.get(object2);
                if ((Integer)object <= 1) continue;
                POSMessageDialog.showError(Messages.getString("CustomerImportCheckingDialog.36"));
                return;
            }
        }
        if ((object3 = this.j.keySet()) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                Integer n = this.j.get(object);
                if (n <= 1) continue;
                POSMessageDialog.showError(Messages.getString("CustomerImportCheckingDialog.36"));
                return;
            }
        }
        try {
            this.h();
        }
        catch (PosException posException) {
            object = new DetailsInfoDialog(Messages.getString("CustomerImportCheckingDialog.51"), posException.getMessage());
            ((POSDialog)object).open();
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    private boolean a(String string, int n) {
        return StringUtils.isNotBlank((String)string) && string.length() > n;
    }

    private String a(String string, int n, String string2) {
        if (StringUtils.isNotBlank((String)string)) {
            string = string + " \n";
        }
        string = string + n + ". " + string2;
        return string;
    }

    private void h() {
        if (!this.d.isEmpty()) {
            String string = "";
            int n = 1;
            for (Customer customer : this.d) {
                String string2 = customer.getId();
                if (this.a(string2, 128)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.33"), 128);
                    ++n;
                    continue;
                }
                if (this.a(customer.getMemberId(), 30)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.37"), 30);
                    ++n;
                    continue;
                }
                if (this.a(customer.getFirstName(), 30)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.38"), 30);
                    ++n;
                    continue;
                }
                if (this.a(customer.getLastName(), 128)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.39"), 128);
                    ++n;
                    continue;
                }
                if (this.a(customer.getLoyaltyNo(), 30)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.40"), 30);
                    ++n;
                    continue;
                }
                String string3 = customer.getMobileNo();
                if (this.a(string3, 30)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.41"), 30);
                    ++n;
                    continue;
                }
                if (this.a(customer.getEmail(), 128)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.42"), 128);
                    ++n;
                    continue;
                }
                if (this.a(customer.getSsn(), 30)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.43"), 30);
                    ++n;
                    continue;
                }
                if (this.a(customer.getAddress(), 255)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.44"), 255);
                    ++n;
                    continue;
                }
                if (this.a(customer.getCity(), 160)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.45"), 160);
                    ++n;
                    continue;
                }
                if (this.a(customer.getState(), 30)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.46"), 30);
                    ++n;
                    continue;
                }
                if (this.a(customer.getZipCode(), 10)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.47"), 10);
                    ++n;
                    continue;
                }
                if (this.a(customer.getCountry(), 160)) {
                    string = this.a(string, n, string2);
                    string = string + String.format(Messages.getString("CustomerImportCheckingDialog.48"), 160);
                    ++n;
                    continue;
                }
                if (!this.a(customer.getNote(), 255)) continue;
                string = this.a(string, n, string2);
                string = string + String.format(Messages.getString("CustomerImportCheckingDialog.49"), 255);
            }
            if (StringUtils.isNotBlank((String)string)) {
                throw new PosException(string);
            }
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            int n;
            int n2 = this.b(jTable, i);
            if (n2 > (n = this.a(jTable, i))) {
                tableColumnModel.getColumn(i).setPreferredWidth(n2);
                continue;
            }
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
    }

    private int a(JTable jTable, int n) {
        int n2 = 50;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, n);
        n2 = Math.max(n2, component.getPreferredSize().width);
        return n2 + 20;
    }

    private int b(JTable jTable, int n) {
        int n2 = 50;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, n);
            Component component = jTable.prepareRenderer(tableCellRenderer, i, n);
            n2 = Math.max(component.getPreferredSize().width + 1, n2);
        }
        return n2 + 20;
    }

    class DuplicateCustomersHighlighter
    implements HighlightPredicate {
        DuplicateCustomersHighlighter() {
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            Integer n;
            Object object;
            int n2 = CustomerImportCheckingDialog.this.b.convertRowIndexToModel(componentAdapter.row);
            Customer customer = (Customer)CustomerImportCheckingDialog.this.a.getRow(n2);
            String string = customer.getMemberId();
            if (StringUtils.isNotBlank((String)string) && (Integer)(object = (Integer)CustomerImportCheckingDialog.this.i.get(string)) > 1) {
                return true;
            }
            object = customer.getLoyaltyNo();
            return StringUtils.isNotBlank((String)object) && (n = (Integer)CustomerImportCheckingDialog.this.j.get(object)) > 1;
        }
    }
}

