/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.BaseImageResourceDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.PaginationBar;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.ImageUploaderDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ImagePanel;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SerializationUtils;

public class ImageGalleryDialog
extends POSDialog
implements PaginationBar.PagingListener,
ActionListener,
MouseListener,
WindowListener {
    private JPanel c;
    private ImageResource d;
    private PaginatedTableModel e;
    private JPanel f;
    private POSToggleButton g;
    private POSToggleButton h;
    private POSToggleButton i;
    private POSToggleButton j;
    private POSToggleButton k;
    private ImageResource.IMAGE_CATEGORY l;
    private PosButton m;
    private POSTextField n;
    private PosButton o;
    private PosButton p;
    private PosButton q;
    private ButtonGroup r;
    private PosButton s;
    PosButton a;
    private Set<ImageResource> t;
    private SelectionMode u;
    private boolean v = true;
    private JPanel w;
    TitlePanel b = new TitlePanel();
    private PaginationBar x;
    private boolean y;
    private boolean z;

    public static synchronized ImageGalleryDialog getInstance() {
        return new ImageGalleryDialog(SelectionMode.SINGLE);
    }

    public static ImageGalleryDialog getInstance(SelectionMode selectionMode) {
        return new ImageGalleryDialog(selectionMode);
    }

    public ImageGalleryDialog(SelectionMode selectionMode) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.e = new PaginatedTableModel(){

            @Override
            public Object getValueAt(int n, int n2) {
                return null;
            }
        };
        this.u = selectionMode;
        this.a();
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
    }

    private void a() {
        this.t = new HashSet<ImageResource>();
        this.setLayout(new BorderLayout());
        this.w = new JPanel(new BorderLayout(5, 5));
        this.b.setTitle(Messages.getString("ImageGalleryDialog.0"));
        this.w.add((Component)this.b, "North");
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.g = new POSToggleButton(Messages.getString("ALL"));
        this.h = new POSToggleButton(Messages.getString("ImageGalleryDialog.2"));
        this.i = new POSToggleButton(Messages.getString("ImageGalleryDialog.3"));
        this.j = new POSToggleButton(Messages.getString("ImageGalleryDialog.4"));
        this.k = new POSToggleButton(Messages.getString("ImageGalleryDialog.5"));
        buttonGroup.add(this.g);
        buttonGroup.add(this.h);
        buttonGroup.add(this.i);
        buttonGroup.add(this.j);
        buttonGroup.add(this.k);
        this.g.addActionListener(this);
        this.h.addActionListener(this);
        this.i.addActionListener(this);
        this.j.addActionListener(this);
        this.k.addActionListener(this);
        JLabel jLabel = new JLabel(Messages.getString("ImageGalleryDialog.7"));
        jLabel.setHorizontalAlignment(0);
        this.n = new POSTextField(25);
        this.m = new PosButton(Messages.getString("Search"));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout());
        jPanel2.add((Component)jLabel, "right,growx");
        jPanel2.add((Component)this.n, "grow");
        jPanel2.add((Component)this.m, "grow");
        WrapLayout wrapLayout = new WrapLayout(1, 5, 0);
        JPanel jPanel3 = new JPanel(wrapLayout);
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel);
        this.w.add((Component)jPanel3, "West");
        this.add((Component)this.w, "North");
        this.c = new JPanel(new WrapLayout());
        this.f = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.c, 20, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.g.setSelected(true);
        this.l = null;
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.setLayout(new BorderLayout());
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel4.add(jPanel5);
        PosButton posButton = new PosButton(Messages.getString("ImageGalleryDialog.9"));
        posButton.addActionListener(actionEvent -> this.g());
        PosButton posButton2 = new PosButton(Messages.getString("ImageGalleryDialog.18"));
        posButton2.addActionListener(actionEvent -> this.h());
        JPanel jPanel6 = new JPanel();
        jPanel6.add(posButton);
        jPanel6.add(posButton2);
        jPanel4.add((Component)jPanel6, "West");
        this.a = new PosButton(Messages.getString("Close"));
        jPanel4.add((Component)this.a, "East");
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageGalleryDialog.this.d = null;
                if (ImageGalleryDialog.this.r != null) {
                    ImageGalleryDialog.this.r.clearSelection();
                }
                ImageGalleryDialog.this.setCanceled(true);
                ImageGalleryDialog.this.dispose();
            }
        });
        this.s = new PosButton(Messages.getString("ImageGalleryDialog.20"));
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageGalleryDialog.this.i();
            }
        });
        this.o = new PosButton(Messages.getString("ImageGalleryDialog.21"));
        this.o.setEnabled(false);
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ImageGalleryDialog.this.u == SelectionMode.MULTIPLE) {
                    ImageGalleryDialog.this.e();
                } else {
                    ImageGalleryDialog.this.f();
                }
            }
        });
        this.p = new PosButton(Messages.getString("DONE"));
        this.q = new PosButton(Messages.getString("ImageGalleryDialog.8"));
        this.p.setBackground(Color.GREEN.brighter());
        this.p.addActionListener(actionEvent -> {
            if (this.d == null && this.t.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ImageGalleryDialog.23"));
                return;
            }
            if (this.u == SelectionMode.SINGLE) {
                this.t.add(this.d);
            } else {
                this.b();
            }
            if (this.r != null) {
                this.r.clearSelection();
            }
            this.setCanceled(false);
            this.dispose();
        });
        this.q.addActionListener(actionEvent -> {
            if (this.c != null) {
                if (this.q.getText().equals(Messages.getString("ImageGalleryDialog.8"))) {
                    this.a(true);
                    this.q.setText(Messages.getString("ImageGalleryDialog.10"));
                } else {
                    this.a(false);
                    this.q.setText(Messages.getString("ImageGalleryDialog.8"));
                }
            }
        });
        jPanel5.add(this.p);
        jPanel5.add(this.q);
        jPanel5.add(this.o);
        this.m.addActionListener(actionEvent -> this.d());
        this.n.addActionListener(actionEvent -> this.d());
        this.f.add((Component)jPanel4, "South");
        this.add((Component)this.f, "South");
    }

    public void setTitlePanelVisible(boolean bl) {
        this.b.setVisible(bl);
    }

    public void setCloseButtonVisible(boolean bl) {
        this.a.setVisible(bl);
    }

    private void b() {
        for (int i = 0; i < this.c.getComponentCount(); ++i) {
            ImagePanel imagePanel = (ImagePanel)this.c.getComponent(i);
            if (!imagePanel.getBtnImage().isSelected()) continue;
            this.t.add((ImageResource)imagePanel.getBtnImage().getClientProperty("selected"));
        }
    }

    private ImagePanel c() {
        return this.a((String)null);
    }

    private ImagePanel a(String string) {
        for (int i = 0; i < this.c.getComponentCount(); ++i) {
            ImagePanel imagePanel = (ImagePanel)this.c.getComponent(i);
            if (StringUtils.isNotBlank((String)string)) {
                ImageResource imageResource = (ImageResource)imagePanel.getBtnImage().getClientProperty("selected");
                if (!imagePanel.getBtnImage().isSelected() || imageResource == null || !imageResource.getId().equals(string)) continue;
                return imagePanel;
            }
            if (!imagePanel.getBtnImage().isSelected()) continue;
            return imagePanel;
        }
        return null;
    }

    private void a(boolean bl) {
        for (int i = 0; i < this.c.getComponentCount(); ++i) {
            ImagePanel imagePanel = (ImagePanel)this.c.getComponent(i);
            imagePanel.setSelected(bl);
            this.d = (ImageResource)imagePanel.getBtnImage().getClientProperty("selected");
            if (bl) {
                this.t.add(this.d);
                continue;
            }
            this.t.remove(this.d);
        }
    }

    private void d() {
        this.e.setCurrentRowIndex(0);
        this.d = null;
        this.t.clear();
        this.a(this.l, this.n.getText());
    }

    public ImageResource getImageResource() {
        if (this.d != null) {
            return this.d;
        }
        return null;
    }

    public Set<ImageResource> getImageResources() {
        return this.t;
    }

    private void a(ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY, String string) {
        this.a(iMAGE_CATEGORY, string, false);
    }

    private void a(ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY, String string, boolean bl) {
        if (this.z) {
            return;
        }
        AsyncAction.execute(() -> {
            try {
                this.z = true;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.c.removeAll();
                this.c.revalidate();
                this.c.repaint();
                BaseImageResourceDAO.getInstance().getImages(this.e, iMAGE_CATEGORY, string);
                List list = this.e.getRows();
                this.x.updateView();
                this.r = this.u == SelectionMode.MULTIPLE ? null : new ButtonGroup();
                for (ImageResource imageResource : list) {
                    this.a(imageResource);
                }
            }
            catch (Throwable throwable) {
                PosLog.error(ImageGalleryDialog.class, throwable);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
                this.z = false;
            }
        });
    }

    private void a(ImageResource imageResource) {
        this.a(imageResource, false);
    }

    private void a(ImageResource imageResource, boolean bl) {
        ImagePanel imagePanel = new ImagePanel(this, imageResource, this.r, this.c);
        imagePanel.setSelected(this.t.contains(imageResource));
        if (bl) {
            this.c.add((Component)imagePanel, 0);
            this.d = imageResource;
        } else {
            this.c.add(imagePanel);
        }
        if (this.d != null) {
            imagePanel.setSelected(this.d.equals(imageResource));
        }
        this.c.revalidate();
        this.c.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.a(actionEvent);
    }

    private void a(ActionEvent actionEvent) {
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        if (jToggleButton.isSelected()) {
            this.d = (ImageResource)jToggleButton.getClientProperty("selected");
            if (this.u == SelectionMode.SINGLE) {
                this.t.clear();
            }
            this.t.add(this.d);
            this.o.setEnabled(true);
        } else {
            this.d = (ImageResource)jToggleButton.getClientProperty("selected");
            this.t.remove(this.d);
            this.o.setEnabled(!this.t.isEmpty());
        }
        if (actionEvent.getSource() == this.g) {
            this.l = null;
            this.a(this.l, null);
            this.o.setEnabled(true);
        } else if (actionEvent.getSource() == this.h) {
            this.l = ImageResource.IMAGE_CATEGORY.UNLISTED;
            this.a(this.l, null);
            this.o.setEnabled(true);
        } else if (actionEvent.getSource() == this.i) {
            this.l = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
            this.a(this.l, null);
            this.o.setEnabled(true);
        } else if (actionEvent.getSource() == this.k) {
            this.l = ImageResource.IMAGE_CATEGORY.PEOPLE;
            this.a(this.l, null);
            this.o.setEnabled(true);
        } else if (actionEvent.getSource() == this.j) {
            this.l = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            this.a(this.l, null);
            this.o.setEnabled(true);
        }
    }

    private void e() {
        if (!this.t.isEmpty()) {
            String string = String.format(Messages.getString("ImageGalleryDialog.11"), this.t.size());
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string, POSConstants.DELETE);
            if (n != 0) {
                return;
            }
            Iterator<ImageResource> iterator = this.t.iterator();
            while (iterator.hasNext()) {
                ImageResource imageResource = iterator.next();
                ImagePanel imagePanel = this.a(imageResource.getId());
                ImageResource imageResource2 = (ImageResource)SerializationUtils.clone((Serializable)imageResource);
                ImageResourceDAO.getInstance().refresh(imageResource2);
                try {
                    ImageResourceDAO.getInstance().checkRelationOndelete(imageResource2);
                }
                catch (PosException posException) {
                    DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
                    detailsInfoDialog.open();
                    continue;
                }
                this.b(imageResource2);
                iterator.remove();
                if (imagePanel == null) continue;
                this.c.remove(imagePanel);
                this.o.setEnabled(!this.t.isEmpty());
                this.c.revalidate();
                this.c.repaint();
            }
        }
    }

    private void f() {
        if (this.d == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ImageGalleryDialog.23"));
            return;
        }
        ImagePanel imagePanel = this.c();
        ImageResource imageResource = (ImageResource)SerializationUtils.clone((Serializable)this.d);
        String string = Messages.getString("ImageGalleryDialog.26");
        int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string, POSConstants.DELETE);
        if (n != 0) {
            return;
        }
        try {
            ImageResourceDAO.getInstance().refresh(imageResource);
            ImageResourceDAO.getInstance().checkRelationOndelete(imageResource);
            this.b(imageResource);
            if (imagePanel != null) {
                this.c.remove(imagePanel);
                this.o.setEnabled(false);
                this.c.revalidate();
                this.c.repaint();
            }
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void b(ImageResource imageResource) {
        imageResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.DELETED.getType());
        BaseImageResourceDAO.getInstance().saveOrUpdate(imageResource);
        OroMqttClient.getInstance().notifyDataUpdated(ImageResource.class);
        if (this.u == SelectionMode.SINGLE) {
            this.t.clear();
        }
        this.d = null;
    }

    private void g() {
        try {
            ImageUploaderDialog imageUploaderDialog = new ImageUploaderDialog(null, this.l);
            boolean bl = imageUploaderDialog.selectImage();
            imageUploaderDialog.setDescriptionVisible(true);
            imageUploaderDialog.setTitle(VersionInfo.getAppName());
            imageUploaderDialog.setDefaultCloseOperation(2);
            imageUploaderDialog.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
            if (bl) {
                imageUploaderDialog.open();
            }
            if (imageUploaderDialog.isCanceled()) {
                return;
            }
            if (this.y) {
                this.t.addAll(imageUploaderDialog.getUploadedBulkImage());
                this.setCanceled(false);
                this.dispose();
            }
            this.d = imageUploaderDialog.getSelectedImageResourse();
            this.a(this.d, true);
            if (this.u == SelectionMode.SINGLE) {
                this.t.add(this.d);
                this.setCanceled(false);
                this.dispose();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void h() {
        try {
            final ImageUploaderDialog imageUploaderDialog = new ImageUploaderDialog(this.l);
            imageUploaderDialog.setDescriptionVisible(false);
            imageUploaderDialog.setTitle(VersionInfo.getAppName());
            imageUploaderDialog.setDefaultCloseOperation(2);
            imageUploaderDialog.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
            imageUploaderDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    try {
                        imageUploaderDialog.selectBulkImage();
                    }
                    catch (PosException posException) {
                        POSMessageDialog.showError(posException.getMessage());
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(exception.getMessage(), exception);
                    }
                }
            });
            imageUploaderDialog.open();
            if (imageUploaderDialog.isCanceled()) {
                return;
            }
            if (this.y) {
                this.t.addAll(imageUploaderDialog.getUploadedBulkImage());
                this.setCanceled(false);
                this.dispose();
            }
            this.e.setCurrentRowIndex(0);
            this.a(this.l, null);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void i() {
        if (this.d == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ImageGalleryDialog.23"));
            return;
        }
        ImageUploaderDialog imageUploaderDialog = new ImageUploaderDialog(this.d);
        imageUploaderDialog.setTitle(Messages.getString("ImageGalleryDialog.37"));
        imageUploaderDialog.setDefaultCloseOperation(2);
        imageUploaderDialog.openFullScreen();
        if (imageUploaderDialog.isCanceled()) {
            return;
        }
        this.a(this.l, null);
    }

    public void setSelectBtnVisible(boolean bl) {
        this.p.setVisible(bl);
        this.q.setVisible(bl && this.u == SelectionMode.MULTIPLE);
        this.o.setVisible(!bl);
        this.s.setVisible(!bl);
    }

    public void setSelectedImageResourceNull() {
        this.d = null;
    }

    public void setSelectedImageResource(ImageResource imageResource) {
        this.d = imageResource;
    }

    public void disableSelectOnDblClick() {
        this.v = false;
    }

    public void setAutoCloseOnUpload() {
        this.y = true;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.v && this.r != null) {
            JToggleButton jToggleButton = (JToggleButton)mouseEvent.getSource();
            if (jToggleButton.isSelected()) {
                this.d = (ImageResource)jToggleButton.getClientProperty("selected");
            }
            if (this.r != null) {
                this.r.clearSelection();
            }
            this.setCanceled(false);
            this.dispose();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void pageRequested(int n) {
        if (this.u == SelectionMode.SINGLE) {
            this.t.clear();
        }
        this.d = null;
        this.a(this.l, null);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.initData();
    }

    public void initData() {
        Dimension dimension = this.c.getSize();
        int n = dimension.width / PosUIManager.getSize((int)160);
        int n2 = dimension.height / PosUIManager.getSize((int)160);
        if (n2 < 2) {
            n2 = 2;
        }
        int n3 = n * n2;
        this.e.setPageSize(n3);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.x = new PaginationBar(this, this.e);
        jPanel.add((Component)this.x, "growy");
        this.w.add((Component)jPanel, "East");
        this.a(this.l, null);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static enum SelectionMode {
        SINGLE,
        MULTIPLE;

    }
}

