/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ItemQtySelectionDialog
extends OkCancelOptionDialog {
    private int a;
    private JTextField b;
    private boolean c;
    private PosButton d;
    private PosButton e;
    private MenuItem f;
    private List<IUnit> g;
    private IUnit h;
    private IUnit i;
    private boolean j = true;

    public ItemQtySelectionDialog() {
        super(POSUtil.getFocusedWindow());
        this.a();
    }

    public ItemQtySelectionDialog(boolean bl, MenuItem menuItem) {
        super(POSUtil.getFocusedWindow());
        this.f = menuItem;
        this.g = this.f.getUnits();
        this.h = this.f.getUnit();
        this.setFloatingPoint(bl);
        this.a();
    }

    public ItemQtySelectionDialog(boolean bl, MenuItem menuItem, IUnit iUnit) {
        super(POSUtil.getFocusedWindow());
        this.f = menuItem;
        this.g = this.f.getUnits();
        this.h = iUnit;
        this.setFloatingPoint(bl);
        this.a();
    }

    public ItemQtySelectionDialog(boolean bl, MenuItem menuItem, IUnit iUnit, boolean bl2) {
        super(POSUtil.getFocusedWindow());
        this.f = menuItem;
        this.g = this.f.getUnits();
        this.h = iUnit;
        this.i = iUnit;
        this.setFloatingPoint(bl);
        this.setAllowUnitSelection(bl2);
        this.a();
    }

    private void a() {
        this.setResizable(true);
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        this.b = this.isFloatingPoint(true) ? new DoubleTextField(10) : new IntegerTextField(10);
        this.b.setHorizontalAlignment(11);
        this.b.setFont(this.b.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.b.setFocusable(true);
        this.b.requestFocus();
        this.b.setBackground(Color.WHITE);
        this.d = new PosButton("+");
        this.d.setFont(new Font("Arial", 0, PosUIManager.getSize((int)30)));
        this.d.setFocusable(false);
        this.d.setPreferredSize(PosUIManager.getSize((int)60, (int)60));
        this.e = new PosButton("-");
        this.e.setPreferredSize(PosUIManager.getSize((int)60, (int)60));
        this.e.setFont(new Font("Arial", 1, PosUIManager.getSize((int)30)));
        this.e.setFocusable(false);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        jPanel2.add((Component)this.d, "East");
        jPanel2.add((Component)this.b, "Center");
        jPanel2.add((Component)this.e, "West");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.add((Component)new NumericKeypad(), "Center");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fill, ins 0 0 0 0", "[grow][grow]", ""));
        JPanel jPanel5 = new JPanel((LayoutManager)new MigLayout("fill, ins 7 0 2 0"));
        jPanel5.add((Component)jPanel2, "grow, wrap");
        jPanel5.add((Component)jPanel3, "grow");
        jPanel4.add((Component)jPanel5, "grow");
        if (this.f.isAllowUnitSelection()) {
            JPanel jPanel6 = new JPanel(new WrapLayout(3));
            jPanel6.setPreferredSize(PosUIManager.getSize((int)200, (int)100));
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, Messages.getString("SelectUnit"), 2, 0), new EmptyBorder(0, 0, 0, 0));
            jPanel6.setBorder(compoundBorder);
            this.a(jPanel6);
            jPanel4.add((Component)jPanel6, "grow");
        }
        jPanel.add((Component)jPanel4, "Center");
        this.setControlButtonsVisible(true);
        this.buttonAction();
    }

    private void a(JPanel jPanel) {
        if (this.g == null) {
            return;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.g != null) {
            for (IUnit iUnit : this.g) {
                UnitButton unitButton = new UnitButton(iUnit);
                buttonGroup.add(unitButton);
                jPanel.add(unitButton);
            }
        }
    }

    public IUnit getSelectedUnit() {
        return this.i;
    }

    @Override
    public void doOk() {
        if (!this.a(this.b.getText())) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        if ((this.f.isFractionalUnit() == null || !this.f.isFractionalUnit().booleanValue()) && this.b().booleanValue()) {
            POSMessageDialog.showError(this, Messages.getString("ItemQtySelectionDialog.0"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void buttonAction() {
        try {
            this.d.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d;
                    String string = ItemQtySelectionDialog.this.b.getText();
                    if (StringUtils.isNotEmpty((String)string) && ((d = Double.parseDouble(string)) == Math.floor(d) || !Double.isInfinite(d))) {
                        ItemQtySelectionDialog.this.b.setText("" + NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
                    }
                }
            });
            this.e.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d;
                    String string = ItemQtySelectionDialog.this.b.getText();
                    if (StringUtils.isNotEmpty((String)string) && ((d = Double.parseDouble(string)) == Math.floor(d) || !Double.isInfinite(d)) && (d -= 1.0) >= 0.0) {
                        ItemQtySelectionDialog.this.b.setText("" + NumberUtil.trimDecilamIfNotNeeded(d));
                    }
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), numberFormatException.getMessage(), numberFormatException);
        }
    }

    public void setControlButtonsVisible(boolean bl) {
        this.d.setVisible(bl);
        this.e.setVisible(bl);
    }

    private boolean a(String string) {
        if (this.isFloatingPoint(false)) {
            try {
                Double.parseDouble(string);
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            Long.parseLong(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public void setTitle(String string) {
        super.setCaption(string);
        super.setTitle(string);
    }

    public void setDialogTitle(String string) {
        super.setTitle(string);
    }

    public double getValue() {
        return Double.parseDouble(this.b.getText());
    }

    public void setValue(double d) {
        if (d == 0.0) {
            if (this.c) {
                this.b.setText("0");
                this.b.selectAll();
            } else {
                this.b.setText("");
            }
        } else if (this.isFloatingPoint(true)) {
            this.b.setText(String.valueOf(d));
        } else {
            this.b.setText(String.valueOf((int)d));
        }
        this.b.selectAll();
    }

    public boolean isFloatingPoint(boolean bl) {
        return this.c;
    }

    public void setFloatingPoint(boolean bl) {
        this.c = bl;
    }

    public int getDefaultValue() {
        return this.a;
    }

    public void setDefaultValue(int n) {
        this.a = n;
        this.b.setText(String.valueOf(n));
    }

    private Boolean b() {
        int n;
        if (this.f == null) {
            return Boolean.FALSE;
        }
        double d = Double.parseDouble(this.b.getText());
        return d > (double)(n = (int)d);
    }

    public static ItemQtySelectionDialog getQtyAndUnit(MenuItem menuItem, String string, double d) {
        ItemQtySelectionDialog itemQtySelectionDialog = new ItemQtySelectionDialog(true, menuItem);
        itemQtySelectionDialog.setValue(d);
        itemQtySelectionDialog.setTitle(string);
        itemQtySelectionDialog.setDialogTitle(VersionInfo.getAppName());
        return itemQtySelectionDialog;
    }

    public static ItemQtySelectionDialog getQtyAndUnit(MenuItem menuItem, IUnit iUnit, String string, double d) {
        ItemQtySelectionDialog itemQtySelectionDialog = new ItemQtySelectionDialog(true, menuItem, iUnit, false);
        itemQtySelectionDialog.setValue(d);
        itemQtySelectionDialog.setTitle(string);
        itemQtySelectionDialog.setDialogTitle(VersionInfo.getAppName());
        return itemQtySelectionDialog;
    }

    public void setUtilityButtonsVisible(boolean bl) {
        this.d.setVisible(bl);
        this.e.setVisible(bl);
    }

    public boolean isAllowUnitSelection() {
        return this.j;
    }

    public void setAllowUnitSelection(boolean bl) {
        this.j = bl;
    }

    class UnitButton
    extends POSToggleButton
    implements ActionListener {
        private IUnit b;

        public UnitButton(IUnit iUnit) {
            this.b = iUnit;
            this.setText(iUnit.getName());
            this.addActionListener(this);
            if (iUnit.equals(ItemQtySelectionDialog.this.h)) {
                this.setSelected(true);
            } else if (!ItemQtySelectionDialog.this.isAllowUnitSelection()) {
                this.setVisible(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            if (jToggleButton.isSelected()) {
                ItemQtySelectionDialog.this.i = this.b;
            }
        }
    }
}

