/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosComboRenderer;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class MiscTicketItemDialog
extends OkCancelOptionDialog {
    private static final int a = 30;
    private TicketItem b;
    private JComboBox c;
    private FixedLengthTextField d;
    private DoubleTextField e;
    private JComboBox f;
    private JLabel g;
    private OrderType h;

    public MiscTicketItemDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.a();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(String.format("inset 0, fillx", 10), "", ""));
        this.setTitle(VersionInfo.getAppName());
        this.setCaption(Messages.getString("MiscTicketItemDialog.4"));
        JLabel jLabel = new JLabel(Messages.getString("MiscTicketItemDialog.6"));
        jPanel.add((Component)jLabel, "newline,alignx trailing");
        this.d = new FixedLengthTextField();
        this.d.setLength(120);
        jPanel.add((Component)this.d, String.format("growx, span, h %s!", PosUIManager.getSize((int)30)));
        JLabel jLabel2 = new JLabel(Messages.getString("MiscTicketItemDialog.9"));
        jPanel.add((Component)jLabel2, "newline,alignx trailing");
        this.e = new DoubleTextField();
        jPanel.add((Component)this.e, String.format("growx, w %s!, h %s!", PosUIManager.getSize((int)120), PosUIManager.getSize((int)30)));
        this.g = new JLabel(Messages.getString("MiscTicketItemDialog.2"));
        jPanel.add((Component)this.g, "alignx trailing");
        PosComboRenderer posComboRenderer = new PosComboRenderer();
        posComboRenderer.setEnableDefaultValueShowing(false);
        this.c = new JComboBox();
        this.c.setRenderer(posComboRenderer);
        jPanel.add((Component)this.c, String.format("w %s!, h %s!", PosUIManager.getSize((int)200), PosUIManager.getSize((int)30)));
        jPanel.add((Component)new JLabel(Messages.getString("MiscTicketItemDialog.15")), "alignx trailing");
        this.f = new JComboBox();
        this.f.setRenderer(posComboRenderer);
        jPanel.add((Component)this.f, String.format("w %s!, h %s!", PosUIManager.getSize((int)200), PosUIManager.getSize((int)30)));
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        jPanel.add((Component)((Object)qwertyKeyPad), "newline, grow, span, gaptop 10");
        this.getContentPanel().add(jPanel);
        this.b();
    }

    private void b() {
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        this.c.addItem(null);
        for (TaxGroup taxGroup : list) {
            this.c.addItem(taxGroup);
        }
        String string = TerminalConfig.getMiscItemDefaultTaxId();
        if (!string.equals("-1")) {
            for (int i = 0; i < list.size(); ++i) {
                TaxGroup taxGroup = list.get(i);
                if (!taxGroup.getId().equals(string)) continue;
                this.c.setSelectedIndex(i);
                break;
            }
        }
        List<PrinterGroup> list2 = PrinterGroupDAO.getInstance().findAll();
        this.f.addItem(null);
        for (PrinterGroup printerGroup : list2) {
            this.f.addItem(printerGroup);
            if (!printerGroup.isIsDefault()) continue;
            this.f.setSelectedItem(printerGroup);
        }
    }

    @Override
    public void doCancel() {
        this.setCanceled(true);
        this.b = null;
        this.dispose();
    }

    @Override
    public void doOk() {
        Comparable comparable;
        String string = this.d.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("MiscTicketItemDialog.1"));
            return;
        }
        if (StringUtils.isEmpty((String)this.e.getText())) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("MiscTicketItemDialog.3"));
            return;
        }
        double d = this.e.getDoubleOrZero();
        if (d < 0.0) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("NegativePriceNotAllowed"));
            return;
        }
        this.setCanceled(false);
        this.b = new TicketItem();
        this.b.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        this.b.setQuantity(1.0);
        this.b.setUnitPrice(d);
        this.b.setName(string.trim());
        this.b.setMenuItemId("0");
        this.b.setCategoryName(POSConstants.MISC_BUTTON_TEXT);
        this.b.setGroupName(POSConstants.MISC_BUTTON_TEXT);
        this.b.setShouldPrintToKitchen(false);
        OrderView orderView = OrderView.getInstance();
        Object object = orderView.getSelectedSeatNumber();
        if (object instanceof Integer) {
            this.b.setSeatNumber((Integer)object);
        } else if (object instanceof TicketItemSeat) {
            comparable = (TicketItemSeat)orderView.getSelectedSeatNumber();
            this.b.setSeat((TicketItemSeat)comparable);
            this.b.setSeatNumber(((BaseTicketItemSeat)comparable).getSeatNumber());
        }
        comparable = (TaxGroup)this.c.getSelectedItem();
        MenuItem.setItemTaxes(this.b, (TaxGroup)comparable, this.getOrderType());
        PrinterGroup printerGroup = (PrinterGroup)this.f.getSelectedItem();
        if (printerGroup != null) {
            this.b.setPrinterGroup(printerGroup);
            this.b.setShouldPrintToKitchen(true);
        }
        this.dispose();
    }

    public TicketItem getTicketItem() {
        return this.b;
    }

    public OrderType getOrderType() {
        return this.h;
    }

    public void setOrderType(OrderType orderType) {
        this.h = orderType;
    }
}

