/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.swing.AmountInputKeypad;
import com.floreantpos.swing.DefaultDocument;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;

public class MultiCurrencyAmountSelectionDialog
extends OkCancelOptionDialog {
    private List<Currency> a;
    private double b;
    private List<CurrencyRow> c = new ArrayList<CurrencyRow>();
    private CashDrawer d;
    private boolean e;
    private String f;

    public MultiCurrencyAmountSelectionDialog(CashDrawer cashDrawer, double d, List<Currency> list) {
        super(POSUtil.getFocusedWindow());
        this.a = list;
        this.d = cashDrawer;
        this.f = "" + d;
        this.a();
        this.setDefaultCloseOperation(2);
    }

    public void setReconcile(boolean bl) {
        this.e = bl;
    }

    private void a() {
        Serializable serializable2;
        JPanel jPanel = this.getContentPanel();
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setTitle(Messages.getString("MultiCurrencyAssignDrawerDialog.0"));
        this.setCaption(Messages.getString("MultiCurrencyAssignDrawerDialog.1"));
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 2, 10, 5);
        jPanel2.setLayout(gridLayout);
        JLabel jLabel = this.a(Messages.getString("MultiCurrencyAssignDrawerDialog.2"), 1, 16, 0);
        JLabel jLabel2 = this.a(Messages.getString("MultiCurrencyAssignDrawerDialog.3"), 1, 16, 0);
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        AmountInputKeypad amountInputKeypad = new AmountInputKeypad();
        for (Serializable serializable2 : this.a) {
            JLabel jLabel3 = this.a(serializable2.getName(), 0, 16, 0);
            DoubleTextField doubleTextField = serializable2.isMain() != false ? this.b(this.f, 0, 16, 4) : this.b("", 0, 16, 4);
            jPanel2.add(jLabel3);
            jPanel2.add(doubleTextField);
            CurrencyRow currencyRow = new CurrencyRow((Currency)serializable2, doubleTextField);
            this.c.add(currencyRow);
            KeyListener keyListener = amountInputKeypad.getKeyListener();
            currencyRow.b.addKeyListener(keyListener);
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        jPanel3.add(jPanel2);
        serializable2 = new JScrollPane(jPanel3);
        jPanel.add((Component)serializable2);
        jPanel.add((Component)amountInputKeypad, "South");
    }

    private JLabel a(String string, int n, int n2, int n3) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(n, PosUIManager.getSize((int)n2)));
        jLabel.setHorizontalAlignment(n3);
        return jLabel;
    }

    private DoubleTextField b(String string, int n, int n2, int n3) {
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setDocument(new DefaultDocument(false));
        doubleTextField.setText(StringUtils.isNotBlank((String)string) ? NumberUtil.format(Double.valueOf(string)) : string);
        doubleTextField.setFont(doubleTextField.getFont().deriveFont(n, PosUIManager.getSize((int)n2)));
        doubleTextField.setHorizontalAlignment(n3);
        doubleTextField.setBackground(Color.WHITE);
        return doubleTextField;
    }

    @Override
    public void doOk() {
        this.b = 0.0;
        for (CurrencyRow currencyRow : this.c) {
            CashBreakdown cashBreakdown = this.d.getCurrencyBalance(currencyRow.a);
            double d = currencyRow.b.getDouble();
            if (d < 0.0) {
                POSMessageDialog.showError(POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
                return;
            }
            if (Double.isNaN(d)) {
                d = 0.0;
            }
            if (!this.e) {
                cashBreakdown.setBalance(d);
            } else {
                cashBreakdown.setTotalAmount(d);
            }
            this.b += d / currencyRow.a.getExchangeRate();
        }
        if (this.e && this.b < this.d.getDrawerAccountable() && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("MultiCurrencyAmountSelectionDialog.1"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public double getTotalAmount() {
        return this.b;
    }

    private class CurrencyRow {
        Currency a;
        DoubleTextField b;

        public CurrencyRow(Currency currency, DoubleTextField doubleTextField) {
            this.a = currency;
            this.b = doubleTextField;
        }
    }
}

