/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.swing.AmountInputKeypad;
import com.floreantpos.swing.DefaultDocument;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class MultiCurrencyTenderDialog
extends OkCancelOptionDialog {
    private List<Currency> a;
    private double b;
    private double c;
    private double d;
    private List<CurrencyRow> e = new ArrayList<CurrencyRow>();
    private Ticket f;
    private List<PaymentByCurrency> g;
    private NumberFormat h = new DecimalFormat("0.00##");

    public MultiCurrencyTenderDialog(Ticket ticket, List<Currency> list) {
        super(POSUtil.getFocusedWindow());
        this.f = ticket;
        this.a = list;
        this.b = ticket.getDueAmount();
        this.a();
    }

    public MultiCurrencyTenderDialog(List<Ticket> list, List<Currency> list2) {
        super(POSUtil.getFocusedWindow());
        this.a = list2;
        this.f = list.get(list.size() - 1);
        this.b = 0.0;
        for (Ticket ticket : list) {
            this.b += ticket.getDueAmount().doubleValue();
        }
        this.a();
    }

    public MultiCurrencyTenderDialog(Ticket ticket, List<Currency> list, double d) {
        super(POSUtil.getFocusedWindow());
        this.f = ticket;
        this.a = list;
        this.b = d;
        this.a();
    }

    private void a() {
        JPanel jPanel = this.getContentPanel();
        jPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setTitle(VersionInfo.getAppName());
        this.setCaption(Messages.getString("MultiCurrencyTenderDialog.1") + " " + NumberUtil.getCurrencyFormat(this.b));
        this.setResizable(true);
        this.setMinimumSize(PosUIManager.getSize((int)730, (int)600));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("inset 0", "[grow,fill]", "[grow,fill]"));
        jPanel.setPreferredSize(PosUIManager.getSize((int)730, (int)500));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("ins 0"));
        jPanel3.add(this.a("Currency", 1, 15, 10));
        jPanel3.add((Component)this.a("Remaining", 1, 15, 0), "gapleft 20");
        jPanel3.add((Component)this.a("Tender", 1, 15, 11), "center");
        jPanel3.add((Component)this.a("Change", 1, 15, 11), "center");
        AmountInputKeypad amountInputKeypad = new AmountInputKeypad();
        KeyListener keyListener = amountInputKeypad.getKeyListener();
        for (Currency serializable2 : this.a) {
            CurrencyRow currencyRow = new CurrencyRow(serializable2, this.b);
            JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
            jPanel4.add(currencyRow.f);
            jPanel4.add((Component)currencyRow.g, "South");
            jPanel3.add((Component)jPanel4, "newline, gapright 20");
            jPanel3.add(currencyRow.e);
            DoubleTextField doubleTextField = currencyRow.b;
            DoubleTextField doubleTextField2 = currencyRow.c;
            doubleTextField.addKeyListener(keyListener);
            doubleTextField2.addKeyListener(keyListener);
            jPanel3.add((Component)doubleTextField, "grow");
            jPanel3.add((Component)doubleTextField2, "grow");
            this.e.add(currencyRow);
        }
        PosScrollPane posScrollPane = new PosScrollPane(jPanel3);
        posScrollPane.setBorder(null);
        jPanel2.add((Component)posScrollPane, "alignx left,aligny top");
        amountInputKeypad.setPreferredSize(PosUIManager.getSize((int)400, (int)250));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add((Component)amountInputKeypad, "grow, center");
        jPanel2.add((Component)new JSeparator(), "newline, gapbottom 1,gaptop 5");
        jPanel.add(jPanel2);
        jPanel.add((Component)transparentPanel, "South");
    }

    private JLabel a(String string, int n, int n2, int n3) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(n, PosUIManager.getSize((int)n2)));
        jLabel.setHorizontalAlignment(n3);
        return jLabel;
    }

    private DoubleTextField b(String string, int n, int n2, int n3) {
        DoubleTextField doubleTextField = new DoubleTextField(14, 13, 3);
        doubleTextField.setDocument(new DefaultDocument(false));
        doubleTextField.setText(StringUtils.isNotBlank((String)string) ? NumberUtil.format(Double.valueOf(string)) : string);
        doubleTextField.setText(string);
        doubleTextField.setFont(doubleTextField.getFont().deriveFont(n, PosUIManager.getSize((int)n2)));
        doubleTextField.setHorizontalAlignment(n3);
        doubleTextField.setBackground(Color.WHITE);
        return doubleTextField;
    }

    @Override
    public void doOk() {
        this.d();
        if (!this.b()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("INVALID_AMOUNT"));
            return;
        }
        boolean bl = Boolean.FALSE;
        for (CurrencyRow currencyRow : this.e) {
            if (currencyRow.a() < 0.0 || currencyRow.b() < 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("NegativeValueNotAllowed"));
                return;
            }
            if (!(currencyRow.b() > 0.0)) continue;
            bl = Boolean.TRUE;
            break;
        }
        double d = this.b - (this.c - this.d);
        this.g = new ArrayList<PaymentByCurrency>();
        for (CurrencyRow currencyRow : this.e) {
            PaymentByCurrency paymentByCurrency = null;
            double d2 = currencyRow.a();
            double d3 = currencyRow.b();
            if (d < 0.0 && currencyRow.a.isMain().booleanValue()) {
                if (!bl) {
                    d3 = Math.abs(d);
                    if (d3 <= this.f.getToleranceFactor()) {
                        d3 = 0.0;
                    }
                } else {
                    d3 = Math.abs(d) + currencyRow.b();
                }
            }
            if (d2 > 0.0) {
                paymentByCurrency = new PaymentByCurrency();
                paymentByCurrency.currency = currencyRow.a;
                paymentByCurrency.tenderedAmount = d2;
            }
            if (d3 > 0.0) {
                if (paymentByCurrency == null) {
                    paymentByCurrency = new PaymentByCurrency();
                }
                paymentByCurrency.currency = currencyRow.a;
                paymentByCurrency.tenderedAmount = d2;
                paymentByCurrency.setCashBackAmount(d3);
            }
            if (paymentByCurrency == null) continue;
            this.g.add(paymentByCurrency);
        }
        this.setCanceled(false);
        this.dispose();
    }

    private boolean b() {
        double d = this.b - (this.c - this.d);
        if (this.c <= 0.0) {
            return false;
        }
        double d2 = CurrencyUtil.getMainCurrency().getTolerance();
        if (d > d2) {
            return true;
        }
        return true;
    }

    private boolean c() {
        double d = this.b - (this.c - this.d);
        double d2 = CurrencyUtil.getMainCurrency().getTolerance();
        if (d <= d2) {
            if (d > 0.0) {
                this.a(d);
            }
            return true;
        }
        return false;
    }

    private void a(double d) {
        TicketDiscount ticketDiscount = new TicketDiscount();
        ticketDiscount.setName("Tolerance");
        ticketDiscount.setValue(NumberUtil.roundToThreeDigit(d));
        ticketDiscount.setAutoApply(true);
        ticketDiscount.setTicket(this.f);
        this.f.addTodiscounts(ticketDiscount);
        this.f.calculatePrice();
    }

    private void d() {
        double d;
        this.c = 0.0;
        this.d = 0.0;
        for (CurrencyRow currencyRow : this.e) {
            d = currencyRow.a();
            double d2 = currencyRow.b();
            this.c += d / currencyRow.a.getExchangeRate();
            this.d += d2 / currencyRow.a.getExchangeRate();
        }
        for (CurrencyRow currencyRow : this.e) {
            d = (this.b - (this.c - this.d)) * currencyRow.a.getExchangeRate();
            currencyRow.a(d);
        }
    }

    public double getTenderedAmount() {
        return this.c;
    }

    public double getChangeDueAmount() {
        return this.c - this.b;
    }

    public List<PaymentByCurrency> getPaymentByCurrencies() {
        return this.g;
    }

    public static class PaymentByCurrency {
        public Currency currency;
        public double tenderedAmount;
        public double cashBackAmount;
        public double paidAmount;

        public void setCashBackAmount(double d) {
            this.cashBackAmount = d;
        }

        public double getCashBackAmount() {
            return this.cashBackAmount;
        }
    }

    class CurrencyRow
    implements ActionListener,
    FocusListener {
        Currency a;
        DoubleTextField b;
        DoubleTextField c;
        double d;
        JLabel e;
        JLabel f;
        JLabel g;
        PosButton h = new PosButton(Messages.getString("MultiCurrencyTenderDialog.17"));
        PosButton i = new PosButton(Messages.getString("MultiCurrencyTenderDialog.18"));

        public CurrencyRow(Currency currency, double d) {
            this.a = currency;
            this.d = currency.getExchangeRate() * d;
            this.e = MultiCurrencyTenderDialog.this.a(NumberUtil.formatNumber(this.d), 0, 15, 4);
            this.g = MultiCurrencyTenderDialog.this.a(currency.getId().equals(CurrencyUtil.getMainCurrency().getId()) ? Messages.getString("MainCurrency") : "<html><span style='color:red; font-weight: bold;'>(1 " + CurrencyUtil.getCurrencySymbol() + " = " + MultiCurrencyTenderDialog.this.h.format(currency.getExchangeRate()) + " " + currency.getSymbol() + ")</span></html>", 0, 12, 10);
            this.f = MultiCurrencyTenderDialog.this.a(currency.getName(), 0, 15, 10);
            this.b = MultiCurrencyTenderDialog.this.b("", 0, 15, 4);
            this.c = MultiCurrencyTenderDialog.this.b("", 0, 15, 4);
            this.b.addFocusListener(this);
            this.c.addFocusListener(this);
            this.h.addActionListener(this);
            this.i.addActionListener(this);
        }

        double a() {
            double d = this.b.getDouble();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d;
        }

        double b() {
            double d = this.c.getDouble();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d;
        }

        void a(double d) {
            this.d = d;
            this.e.setText(NumberUtil.formatNumber(d));
        }

        double c() {
            return this.d;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.h) {
                this.b.setText(String.valueOf(NumberUtil.roundToThreeDigit(this.d)));
            } else {
                this.b.setText(String.valueOf(NumberUtil.roundToThreeDigit(Math.ceil(this.d))));
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            MultiCurrencyTenderDialog.this.d();
        }
    }
}

