/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.bo.actions.DataImportAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.QuickMenuItemEntryView;
import com.floreantpos.ui.views.order.DemoOrderViewDialog;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class QuickMenuItemEntryDialog
extends OkCancelOptionDialog
implements RefreshableView {
    private QuickMenuItemEntryView a;
    private JScrollPane b;

    public QuickMenuItemEntryDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.a();
        this.setDefaultCloseOperation(0);
    }

    private void a() {
        this.setDefaultCloseOperation(2);
        this.a = new QuickMenuItemEntryView(this);
        this.b = new JScrollPane(this.a, 20, 30);
        this.b.setBorder(null);
        this.b.getVerticalScrollBar().setUnitIncrement(10);
        JPanel jPanel = this.getContentPanel();
        int n = PosUIManager.getSize((int)10);
        jPanel.setBorder(new EmptyBorder(0, n, 0, n));
        jPanel.add(this.b);
        PosButton posButton = new PosButton(Messages.getString("Preview"));
        posButton.addActionListener(actionEvent -> {
            DemoOrderViewDialog demoOrderViewDialog = new DemoOrderViewDialog();
            demoOrderViewDialog.setMenuItems(this.a.getAllMenuItem());
            demoOrderViewDialog.openFullScreen();
        });
        this.getButtonPanel().add((Component)posButton, 0);
    }

    @Override
    public void doOk() {
        if (!this.a.save()) {
            return;
        }
        this.b();
        DataProvider.get().refreshTaxGroup();
        this.setCanceled(false);
        this.dispose();
    }

    private void b() {
        List<MenuItem> list = this.a.getAllMenuItem();
        DemoOrderViewDialog.MenuItemAnalyser menuItemAnalyser = new DemoOrderViewDialog.MenuItemAnalyser(list);
        menuItemAnalyser.dataAnalysis();
        for (MenuGroup menuGroup : menuItemAnalyser.getGroupMap().values()) {
            MenuGroup menuGroup2 = MenuGroupDAO.getInstance().findMenuGroupByName(menuGroup.getName());
            List<MenuPage> list2 = MenuPageDAO.getInstance().findByGroup(menuGroup2);
            List<MenuItem> list3 = list.stream().filter(menuItem -> menuGroup2.getMenuCategoryName().equals(menuItem.getMenuCategoryName()) && menuGroup2.getName().equals(menuItem.getMenuGroupName())).collect(Collectors.toList());
            int n = 0;
            DataImportAction.genenatePage(menuGroup2, list3, n, list2.size() + 1);
        }
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(VersionInfo.getAppName());
        this.setCaption(string);
    }

    @Override
    public void refresh() {
        if (this.b != null) {
            Dimension dimension = this.b.getViewport().getExtentSize();
            Dimension dimension2 = this.a.getSize();
            int n = dimension2.height - dimension.height;
            this.b.getViewport().setViewPosition(new Point(0, n));
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.a != null && this.a.getAllMenuItem().isEmpty()) {
            super.windowClosing(windowEvent);
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("QuickMenuItemEntryDialog.0"));
        if (n != 0) {
            super.windowClosing(windowEvent);
            return;
        }
        if (!this.a.save()) {
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }
}

