/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Department;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class SalesAreaSelectionDialog
extends POSDialog {
    private ScrollableFlowPanel a;
    private SalesArea b;

    public SalesAreaSelectionDialog() {
        this.a();
        this.b();
        this.setResizable(true);
    }

    private void a() {
        this.setTitle(VersionInfo.getAppName());
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("selectSalesArea"));
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        PosButton posButton = new PosButton(POSConstants.CANCEL);
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SalesAreaSelectionDialog.this.setCanceled(true);
                SalesAreaSelectionDialog.this.dispose();
            }
        });
        jPanel.add((Component)posButton, "w 120!,center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add(jPanel);
        this.add((Component)jPanel2, "South");
        this.a = new ScrollableFlowPanel(3);
        PosScrollPane posScrollPane = new PosScrollPane(this.a, 20, 31);
        posScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        posScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), posScrollPane.getBorder()));
        this.add((Component)posScrollPane, "Center");
        this.setSize(PosUIManager.getSize((int)800, (int)600));
    }

    private void b() {
        try {
            this.a.getContentPane().removeAll();
            Terminal terminal = Application.getInstance().getTerminal();
            Department department = terminal.getDepartment();
            SalesArea salesArea = terminal.getSalesArea();
            if (department != null) {
                List<SalesArea> list = SalesAreaDAO.getInstance().findSalesAreaByDept(department);
                this.a(salesArea, list);
            } else if (department == null) {
                List<SalesArea> list = SalesAreaDAO.getInstance().findAll();
                this.a(salesArea, list);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getLocalizedMessage(), posException);
        }
    }

    private void a(SalesArea salesArea, List<SalesArea> list) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (SalesArea salesArea2 : list) {
            SalesAreaButton salesAreaButton = new SalesAreaButton(salesArea2);
            if (salesArea != null && salesArea.equals(salesArea2)) {
                salesAreaButton.setFocusable(true);
                salesAreaButton.setFocusPainted(true);
            }
            this.a.add(salesAreaButton);
            buttonGroup.add(salesAreaButton);
        }
        this.a.repaint();
        this.a.revalidate();
    }

    public SalesArea getSelectedSalesArea() {
        return this.b;
    }

    private class SalesAreaButton
    extends POSToggleButton
    implements ActionListener {
        private static final int c = 119;
        SalesArea a;

        SalesAreaButton(SalesArea salesArea) {
            this.a = salesArea;
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setText("<html><body><center>" + salesArea.getName() + "</center></body></html>");
            this.setPreferredSize(new Dimension(119, TerminalConfig.getMenuItemButtonHeight()));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SalesAreaSelectionDialog.this.b = this.a;
            SalesAreaSelectionDialog.this.setCanceled(false);
            SalesAreaSelectionDialog.this.dispose();
        }
    }
}

