/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.service.DetailsReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;

public class ServerSummaryReportDialog
extends POSDialog {
    private TitlePanel a;
    private User b;
    private CashDrawer c;
    private StoreSession d;
    private PosButton e;
    private JPanel f;
    private PosButton g;
    private PosButton h;
    private OverflowCombobox i;
    private JPanel j;
    private JPanel k;
    private JasperPrint l;
    private JasperPrint m;

    public ServerSummaryReportDialog(User user, StoreSession storeSession) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.b = user;
        this.d = storeSession;
        this.a();
        this.setSize(PosUIManager.getSize((int)800, (int)(POSUtil.getMonitorScreenSize().height - 50)));
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = new TitlePanel();
        this.k = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
        this.f = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 4", "[grow]", ""));
        this.h = new PosButton(Messages.getString("DrawerPullReportDialog.8"));
        this.g = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.f.add((Component)new JSeparator(), "grow,span,wrap");
        this.e = new PosButton(POSConstants.DETAILS);
        this.f.add((Component)this.h, "grow");
        this.f.add((Component)this.e, "grow");
        this.f.add((Component)this.g, "grow");
        this.j = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,center,ins 5 5 5 5,wrap 5", "[grow]", ""));
        this.j.setVisible(false);
        List<User> list = UserDAO.getInstance().findAllActive();
        JLabel jLabel = new JLabel(POSConstants.SELECT_USER + " :");
        this.i = new OverflowCombobox((ComboBoxModel)new ListComboBoxModel(list));
        this.i.setSelectedItem(this.b);
        this.i.addActionListener(actionEvent -> {
            try {
                this.b = (User)this.i.getSelectedItem();
                this.refreshServerSummeryReport();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            }
        });
        if (this.b.isAdministrator() || this.b.isManager()) {
            this.j.setVisible(true);
        }
        this.j.add((Component)jLabel, "right");
        this.j.add((Component)this.i, "w 170!");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0"));
        jPanel.add((Component)this.j, "grow,wrap");
        jPanel.add((Component)new PosScrollPane(this.k), "grow");
        this.add((Component)this.a, "North");
        this.add(jPanel);
        this.add((Component)this.f, "South");
        this.e.addActionListener(actionEvent -> this.b());
        this.g.addActionListener(actionEvent -> this.c());
        this.h.addActionListener(actionEvent -> this.d());
    }

    private void b() {
        try {
            List<PosTransaction> list = PosTransactionDAO.getInstance().findTransactionsForServer(this.d.getId(), this.b.getId());
            this.l = DetailsReportService.buildServerSummaryDetailTransationReport(this.d, this.b, list);
            DetailReportDialog detailReportDialog = new DetailReportDialog(this.l);
            detailReportDialog.setTitle(Messages.getString("ServerSummaryReportDialog.13"));
            detailReportDialog.updateView();
            detailReportDialog.openFullScreen();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void c() {
        this.dispose();
    }

    private void d() {
        try {
            PosPrintService.printServerSummaryReport(this.b, this.d);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + exception.getMessage());
            PosLog.error(this.getClass(), exception);
        }
    }

    public void refreshServerSummeryReport() throws Exception {
        this.createServerSummaryReport();
    }

    @Override
    public void setTitle(String string) {
        this.a.setTitle(string);
        super.setTitle(AppProperties.getAppName());
    }

    public void createServerSummaryReport() throws Exception {
        PosPrintService.showServerSummaryReport(this.b, this.d, this.k);
    }
}

