/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class UserListDialog
extends OkCancelOptionDialog {
    BeanTableModel<User> a;
    JTable b;
    private JCheckBox c;

    public UserListDialog() {
        this(false);
    }

    public UserListDialog(boolean bl) {
        this(false, false);
    }

    public UserListDialog(String string, boolean bl, boolean bl2) {
        this(bl, bl2);
        this.setTitle(string);
    }

    public UserListDialog(boolean bl, boolean bl2) {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(VersionInfo.getAppName());
        this.setCaption(Messages.getString("UserListDialog.0"));
        JPanel jPanel = this.getContentPanel();
        this.a = new BeanTableModel(User.class);
        this.a.addColumn("Name", "fullName");
        this.b = new JTable(this.a);
        this.b.setRowHeight(PosUIManager.getSize((int)40));
        this.b.getSelectionModel().setSelectionMode(0);
        this.b.setTableHeader(null);
        JScrollPane jScrollPane = new JScrollPane(this.b);
        jScrollPane.setPreferredSize(PosUIManager.getSize((int)300, (int)300));
        jPanel.add(jScrollPane);
        this.c = new JCheckBox(Messages.getString("UserListDialog.1"));
        Terminal terminal = Application.getInstance().getTerminal();
        this.c.setVisible(bl2 && terminal.isTwoCashDrawersEnable());
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.add(this.c);
        jPanel.add((Component)jPanel2, "South");
        List<User> list = UserDAO.getInstance().findClockedInUsers(bl);
        this.a.addRows(list);
        if (list != null && !list.isEmpty()) {
            this.b.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void setUsers(List<User> list) {
        this.a.removeAll();
        this.a.addRows(list);
    }

    public void hideUser(User user) {
        this.a.removeRow(user);
    }

    public User getSelectedUser() {
        return this.a.getRows().get(this.b.getSelectedRow());
    }

    public boolean isLockCashDrawer() {
        return this.c.isSelected();
    }

    @Override
    public void doOk() {
        int n = this.b.getSelectedRow();
        if (n == -1) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("UserListDialog.4"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }
}

