/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.export_import.service.ExcelImporterService;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumnModel;
import liquibase.util.file.FilenameUtils;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.exception.ConstraintViolationException;

public class ExcelImportViewDialog
extends POSDialog {
    private static final String a = " ";
    private TitlePanel b;
    private JPanel c;
    private String d;
    private JTabbedPane e;
    private ItemContainer f;
    private ItemContainer g;
    private List<Object> h;
    private BusyDialog i;
    private List<ModifierGroup> j = new ArrayList<ModifierGroup>();

    public ExcelImportViewDialog(String string) throws Exception {
        this.d = string;
        this.a();
        this.g();
    }

    private void a() {
        this.setTitle(VersionInfo.getAppName());
        this.setLayout(new BorderLayout(5, 5));
        this.b = new TitlePanel();
        this.e = new JTabbedPane();
        this.f = new ItemContainer(this.c());
        this.g = new ItemContainer(this.b());
        this.e.addTab(Messages.getString("ExcelImportViewDialog.0"), this.f);
        this.e.addTab(Messages.getString("ExcelImportViewDialog.1"), this.g);
        this.add((Component)this.b, "North");
        this.add((Component)this.e, "Center");
        this.c = this.e();
        this.add((Component)this.c, "South");
    }

    private BeanTableModel b() {
        BeanTableModel beanTableModel = new BeanTableModel(MenuModifier.class);
        beanTableModel.addColumn(POSConstants.GROUP_NAME, "modifierGroupName");
        beanTableModel.addColumn(POSConstants.NAME, MenuModifier.PROP_NAME);
        beanTableModel.addColumn(POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuModifier.PROP_PRICE);
        beanTableModel.addColumn(POSConstants.ACTIVE, MenuModifier.PROP_ENABLE);
        beanTableModel.addColumn(POSConstants.PIZZA_MODIFIER, MenuModifier.PROP_PIZZA_MODIFIER);
        return beanTableModel;
    }

    private BeanTableModel c() {
        BeanTableModel<MenuItem> beanTableModel = new BeanTableModel<MenuItem>(MenuItem.class){
            private static final long b = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 6 || n2 == 7;
            }
        };
        beanTableModel.addColumn(POSConstants.CATEGORY, MenuItem.PROP_MENU_CATEGORY_NAME);
        beanTableModel.addColumn(POSConstants.GROUP, MenuItem.PROP_MENU_GROUP_NAME);
        beanTableModel.addColumn(POSConstants.NAME, MenuItem.PROP_NAME);
        beanTableModel.addColumn(POSConstants.DESCRIPTION, MenuItem.PROP_DESCRIPTION);
        beanTableModel.addColumn(POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuItem.PROP_PRICE);
        beanTableModel.addColumn(POSConstants.COST, MenuItem.PROP_COST);
        beanTableModel.addColumn(POSConstants.SKU, MenuItem.PROP_SKU);
        beanTableModel.addColumn(Messages.getString("ExcelImportViewDialog.15"), MenuItem.PROP_UNIT_NAME);
        beanTableModel.addColumn(POSConstants.BARCODE, MenuItem.PROP_BARCODE);
        beanTableModel.addColumn(POSConstants.ACTIVE, MenuItem.PROP_VISIBLE);
        beanTableModel.addColumn(POSConstants.FRACTIONAL_UNIT, MenuItem.PROP_FRACTIONAL_UNIT);
        beanTableModel.addColumn(POSConstants.INVENTORY_ITEM, MenuItem.PROP_INVENTORY_ITEM);
        beanTableModel.addColumn(Messages.getString("ExcelImportViewDialog.16"), "availableUnit");
        beanTableModel.addColumn(POSConstants.ALLOW_PRICE_OVERRIDE, MenuItem.PROP_EDITABLE_PRICE);
        return beanTableModel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.d().get(i));
        }
    }

    private List d() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(90);
        arrayList.add(90);
        arrayList.add(130);
        arrayList.add(130);
        arrayList.add(90);
        arrayList.add(80);
        arrayList.add(110);
        arrayList.add(80);
        arrayList.add(80);
        arrayList.add(100);
        arrayList.add(105);
        arrayList.add(95);
        arrayList.add(95);
        arrayList.add(95);
        return arrayList;
    }

    private JPanel e() {
        JButton jButton = new JButton(POSConstants.DELETE);
        jButton.setText(Messages.getString("MenuItemExplorer.19"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.f();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.SAVE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.setCanceled(false);
                    ExcelImportViewDialog.this.doSave();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        JButton jButton3 = new JButton(POSConstants.CANCEL);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.dispose();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center", ""));
        jPanel.add(jButton2);
        jPanel.add(jButton);
        jPanel.add(jButton3);
        return jPanel;
    }

    protected void doSave() {
        try {
            Object object;
            List<Object> list = this.getItemsList();
            if (list == null || list.isEmpty()) {
                POSMessageDialog.showError(Messages.getString("DataImortedFailed"));
                return;
            }
            long l = 0L;
            long l2 = 0L;
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
            List<Object> list2 = this.h();
            for (Object object2 : list2) {
                if (object2 instanceof MenuItem) {
                    object = (MenuItem)object2;
                    try {
                        MenuItemDAO.getInstance().saveOrUpdate((MenuItem)object);
                        ++l;
                    }
                    catch (Exception exception) {
                        arrayList.add((MenuItem)object);
                    }
                }
                if (!(object2 instanceof MenuModifier)) continue;
                object = (MenuModifier)object2;
                try {
                    MenuModifierDAO.getInstance().saveOrUpdate((MenuModifier)object);
                    ++l2;
                }
                catch (Exception exception) {
                    arrayList2.add((Serializable)object);
                }
            }
            for (ModifierGroup modifierGroup : this.j) {
                object = new ArrayList();
                List<MenuModifier> exception = modifierGroup.getModifiers();
                if (exception == null) continue;
                for (MenuModifier menuModifier : exception) {
                    if (menuModifier.getId() == null) continue;
                    object.add(menuModifier);
                }
                modifierGroup.getModifiers().clear();
                modifierGroup.getModifiers().addAll((Collection<MenuModifier>)object);
                ModifierGroupDAO.getInstance().saveOrUpdate(modifierGroup);
            }
            if (list2.size() == 0) {
                POSMessageDialog.showMessage(Messages.getString("ExcelImportViewDialog.6"));
                this.dispose();
                return;
            }
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ImportedSuccessFully"));
                this.dispose();
            } else {
                boolean bl;
                boolean bl2;
                this.h.clear();
                boolean bl3 = bl2 = !arrayList.isEmpty();
                if (bl2) {
                    this.h.addAll(arrayList);
                }
                boolean bl4 = bl = !arrayList2.isEmpty();
                if (bl) {
                    this.h.addAll(arrayList);
                }
                this.i();
                object = l + a + Messages.getString("ExcelImportViewDialog.8") + a + l2 + a + Messages.getString("ExcelImportViewDialog.9") + a;
                if (bl2 && bl) {
                    object = (String)object + Messages.getString("ExcelImportViewDialog.10");
                } else if (bl2) {
                    object = (String)object + Messages.getString("ExcelImportViewDialog.13");
                } else if (bl) {
                    object = (String)object + Messages.getString("ExcelImportViewDialog.14");
                }
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), (String)object);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void f() {
        try {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            int n = this.e.getSelectedIndex();
            ItemContainer itemContainer = (ItemContainer)this.e.getComponentAt(n);
            JTable jTable = itemContainer.c;
            BeanTableModel beanTableModel = itemContainer.b;
            int[] nArray = jTable.getSelectedRows();
            if (nArray.length <= 0) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i] - i;
                Object m = beanTableModel.getRow(n2);
                if (m != null && m instanceof MenuModifier) {
                    MenuModifier menuModifier = (MenuModifier)m;
                    for (ModifierGroup modifierGroup : this.j) {
                        List<MenuModifier> list = modifierGroup.getModifiers();
                        if (list == null) continue;
                        Iterator<MenuModifier> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            MenuModifier menuModifier2 = iterator.next();
                            if (!menuModifier2.getName().equals(menuModifier.getName())) continue;
                            iterator.remove();
                        }
                    }
                }
                beanTableModel.removeRow(n2);
            }
            this.a(beanTableModel.getRowCount());
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ExcelImportViewDialog.7"));
            return;
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void g() throws Exception {
        SwingWorker<List<Object>, Void> swingWorker = new SwingWorker<List<Object>, Void>(){

            @Override
            protected List<Object> doInBackground() throws Exception {
                String string = FilenameUtils.getExtension((String)ExcelImportViewDialog.this.d);
                if (string.equals("xlsx")) {
                    ExcelImportViewDialog.this.h = ExcelImporterService.getInstance().readXLSXFile(ExcelImportViewDialog.this.d);
                    return ExcelImportViewDialog.this.h;
                }
                if (string.equals("xls")) {
                    ExcelImportViewDialog.this.h = ExcelImporterService.getInstance().readXLSFile(ExcelImportViewDialog.this.d);
                    return ExcelImportViewDialog.this.h;
                }
                throw new PosException(Messages.getString("SelectAnExcelFile"));
            }

            @Override
            protected void done() {
                try {
                    if (this.get() == null) {
                        return;
                    }
                    ExcelImportViewDialog.this.i();
                    ExcelImportViewDialog.this.a(ExcelImportViewDialog.this.h.size());
                }
                catch (Exception exception) {
                    ExcelImportViewDialog.this.i.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (exception instanceof CancellationException) {
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    ExcelImportViewDialog.this.i.dispose();
                }
            }
        };
        this.i = new BusyDialog(swingWorker);
        swingWorker.execute();
        this.i.setVisible(true);
    }

    private List<Object> h() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Object> list = this.getItemsList();
        for (Object object : list) {
            boolean bl;
            Comparable comparable;
            if (object instanceof MenuItem) {
                comparable = (MenuItem)object;
                bl = MenuItemDAO.getInstance().hasByBarcodeOrSKUOrMenuItemName(((BaseMenuItem)comparable).getBarcode(), ((MenuItem)comparable).getSku(), ((BaseMenuItem)comparable).getName());
                if (!bl) {
                    arrayList.add(comparable);
                }
            }
            if (!(object instanceof MenuModifier)) continue;
            comparable = (MenuModifier)object;
            bl = MenuModifierDAO.getInstance().hasMenuModifierByName(((BaseMenuModifier)comparable).getName());
            if (bl) continue;
            arrayList.add(comparable);
        }
        return arrayList;
    }

    private void i() {
        try {
            this.f.b.removeAll();
            this.g.b.removeAll();
            for (Object object : this.h) {
                Comparable comparable;
                if (object instanceof MenuItem) {
                    comparable = (MenuItem)object;
                    if (this.a((MenuItem)comparable)) continue;
                    this.f.b.addRow(comparable);
                    continue;
                }
                if (object instanceof MenuModifier) {
                    comparable = (MenuModifier)object;
                    if (this.a((MenuModifier)comparable)) continue;
                    this.g.b.addRow(comparable);
                    continue;
                }
                if (!(object instanceof ModifierGroup)) continue;
                this.j.add((ModifierGroup)object);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private boolean a(MenuItem menuItem) {
        List list = this.f.b.getRows();
        if (list != null && !list.isEmpty()) {
            boolean bl = false;
            for (Object m : list) {
                if (!(m instanceof MenuItem)) continue;
                MenuItem menuItem2 = (MenuItem)m;
                if (menuItem.getName().equals(menuItem2.getName())) {
                    bl = true;
                    return bl;
                }
                if (StringUtils.isNotEmpty((String)menuItem.getSku()) && menuItem.getSku().equals(menuItem2.getSku())) {
                    bl = true;
                    return bl;
                }
                if (!StringUtils.isNotEmpty((String)menuItem.getBarcode()) || !menuItem.getBarcode().equals(menuItem2.getBarcode())) continue;
                bl = true;
                return bl;
            }
            return bl;
        }
        return false;
    }

    private boolean a(MenuModifier menuModifier) {
        List list = this.g.b.getRows();
        if (list != null && !list.isEmpty()) {
            boolean bl = false;
            for (Object m : list) {
                if (!(m instanceof MenuModifier)) continue;
                MenuModifier menuModifier2 = (MenuModifier)m;
                if (!menuModifier.getName().equals(menuModifier2.getName())) continue;
                bl = true;
                return bl;
            }
            return bl;
        }
        return false;
    }

    private void a(int n) {
        this.b.setTitle(Messages.getString("ExcelImportViewDialog.11") + n + Messages.getString("ExcelImportViewDialog.12"));
    }

    public List<Object> getItemsList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.e.getTabCount();
        for (int i = 0; i < n; ++i) {
            ItemContainer itemContainer = (ItemContainer)this.e.getComponentAt(i);
            arrayList.addAll(itemContainer.b.getRows());
        }
        return arrayList;
    }

    private void j() {
        try {
            int n = this.e.getSelectedIndex();
            ItemContainer itemContainer = (ItemContainer)this.e.getComponentAt(n);
            JTable jTable = itemContainer.c;
            jTable.selectAll();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    class ItemContainer
    extends JPanel {
        private BeanTableModel b;
        private JTable c;

        public ItemContainer(BeanTableModel beanTableModel) {
            this.b = beanTableModel;
            this.a();
        }

        private void a() {
            this.setLayout(new BorderLayout());
            this.c = new JTable(this.b);
            this.c.setDefaultRenderer(Object.class, new CustomCellRenderer());
            this.c.setSelectionMode(2);
            this.c.setRowHeight(PosUIManager.getSize((int)50));
            ExcelImportViewDialog.this.resizeColumnWidth(this.c);
            this.add(new JScrollPane(this.c));
        }
    }
}

