/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import.service;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.export_import.service.DataRestorService;
import com.floreantpos.util.datamigrate.DbConnectionInfo;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class DataBackupService {
    private final ProgressObserver a;
    private final DbConnectionInfo b;
    private final File c;

    public DataBackupService(ProgressObserver progressObserver, File file) {
        this.a = progressObserver;
        this.c = file;
        this.b = new DbConnectionInfo();
        this.b.setConnectionString(AppConfig.getConnectString());
        Database database = Database.getByProviderName(AppConfig.getDatabaseProviderName());
        this.b.setSelectedDatabase(database);
        this.b.setDriverClass(database.getHibernateConnectionDriverClass());
        this.b.setUserName(AppConfig.getDatabaseUser());
        this.b.setPassword(AppConfig.getDatabasePassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBackup() throws Exception {
        try (com.healthmarketscience.jackcess.Database database = DatabaseBuilder.create((Database.FileFormat)Database.FileFormat.V2010, (File)this.c);
             Connection connection = this.b.openConnection();){
            Application.getInstance().setShutdownLocked(true);
            PosLog.info(this.getClass(), String.format("Starting database backup %s", this.c.getName()));
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            List<String> list = DataRestorService.getTableNames(connection, this.b.getSelectedDatabase());
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                String string;
                String string2 = list.get(i);
                PosLog.debug(this.getClass(), "Table Name: " + string2);
                String string3 = string2.replaceAll("_", " ").toUpperCase();
                this.a.printInfo(String.format(Messages.getString("DataBackupService.0"), string3));
                int n = (int)Math.round(100.0 / (double)list.size() * (double)(i + 1));
                this.a.progress(string3);
                this.a.progress(n);
                this.a.hideSubProgressView();
                ResultSet resultSet = this.b.getSelectedDatabase() == Database.MYSQL ? databaseMetaData.getColumns(connection.getCatalog(), connection.getCatalog(), string2, null) : databaseMetaData.getColumns(null, null, string2, null);
                ArrayList<ColumnBuilder> arrayList = new ArrayList<ColumnBuilder>();
                while (resultSet.next()) {
                    string = resultSet.getString("COLUMN_NAME");
                    int n2 = resultSet.getInt("DATA_TYPE");
                    if (n2 == -7) {
                        n2 = 16;
                    }
                    object = DataType.fromSQLType((int)n2, (int)Integer.MAX_VALUE);
                    arrayList.add(new ColumnBuilder(string.toUpperCase(), (DataType)object));
                }
                string = "select * from " + string2;
                try {
                    Statement statement = connection.createStatement();
                    object = null;
                    try {
                        Table table = new TableBuilder(string2.toUpperCase()).addColumns(arrayList).toTable(database);
                        int n3 = 0;
                        int n4 = DataBackupService.getTotalRow(connection, string2);
                        try (ResultSet resultSet2 = statement.executeQuery(string);){
                            while (resultSet2.next()) {
                                int n5 = (int)Math.ceil(100.0 / (double)n4 * (double)(++n3));
                                this.a.progress(n5, String.format(Messages.getString("DataBackupService.1"), n3, n4));
                                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                                for (ColumnBuilder columnBuilder : arrayList) {
                                    String string4 = columnBuilder.getName();
                                    Object object2 = resultSet2.getObject(string4);
                                    if (object2 instanceof LocalDateTime) {
                                        LocalDateTime localDateTime = (LocalDateTime)object2;
                                        object2 = Timestamp.valueOf(localDateTime);
                                    }
                                    arrayList2.add(object2);
                                }
                                table.addRow(arrayList2.toArray());
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (statement != null) {
                            if (object != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), "Database backup failed", exception);
                }
            }
            connection.commit();
            this.a.progressComplete(true);
            PosLog.info(this.getClass(), "Database backup successfully completed");
        }
        finally {
            Application.getInstance().setShutdownLocked(false);
        }
    }

    /*
     * Exception decompiling
     */
    public static int getTotalRow(Connection var0, String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

