/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import.service;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.actions.MigrateDatabaseAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.datamigrate.DbConnectionInfo;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DataRestorService {
    private final ProgressObserver a;
    private final File b;

    public DataRestorService(ProgressObserver progressObserver, File file) {
        this.a = progressObserver;
        this.b = file;
    }

    public void startRestore() throws Exception {
        this.a.progress(-1);
        com.healthmarketscience.jackcess.Database database = DatabaseBuilder.open((File)this.b);
        DbConnectionInfo dbConnectionInfo = new DbConnectionInfo();
        dbConnectionInfo.setConnectionString(AppConfig.getConnectString());
        Database database2 = Database.getByProviderName(AppConfig.getDatabaseProviderName());
        dbConnectionInfo.setSelectedDatabase(database2);
        dbConnectionInfo.setDriverClass(database2.getHibernateConnectionDriverClass());
        dbConnectionInfo.setUserName(AppConfig.getDatabaseUser());
        dbConnectionInfo.setPassword(AppConfig.getDatabasePassword());
        dbConnectionInfo.openConnection();
        Database database3 = dbConnectionInfo.getSelectedDatabase();
        DatabaseUtil.updateSchema(dbConnectionInfo.getConnectionString(), database3.getHibernateDialect(), database3.getHibernateConnectionDriverClass(), dbConnectionInfo.getUserName(), dbConnectionInfo.getPassword());
        MigrateDatabaseAction.removeConstrainsFromDestDB(dbConnectionInfo);
        this.a(database, dbConnectionInfo);
        database3 = dbConnectionInfo.getSelectedDatabase();
        DatabaseUtil.updateSchema(dbConnectionInfo.getConnectionString(), database3.getHibernateDialect(), database3.getHibernateConnectionDriverClass(), dbConnectionInfo.getUserName(), dbConnectionInfo.getPassword());
    }

    private void a(com.healthmarketscience.jackcess.Database database, DbConnectionInfo dbConnectionInfo) throws Exception {
        Connection connection = dbConnectionInfo.getConnection();
        List<String> list = DataRestorService.getTableNames(connection, dbConnectionInfo.getSelectedDatabase());
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            Table table = database.getTable(string);
            int n = (int)Math.round(100.0 / (double)list.size() * (double)(i + 1));
            this.a.progress(n);
            String string2 = string.replaceAll("_", " ").toUpperCase();
            this.a.progress(string2);
            this.a.printInfo(Messages.getString("DataRestorService.0") + string2);
            this.a.hideSubProgressView();
            if (table == null) continue;
            List<String> list2 = this.a(connection, dbConnectionInfo.getSelectedDatabase(), string);
            String string3 = this.a(string, list2);
            this.a(table, list2, string3, connection);
        }
    }

    private String a(String string, List<String> list) {
        String string2 = "INSERT INTO " + string + " (";
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            string2 = string2 + string3;
            if (!iterator.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ") VALUES (";
        iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            string2 = string2 + "?";
            if (!iterator.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        return string2;
    }

    private void a(Table table, List<String> list, String string, Connection connection) throws Exception {
        PosLog.debug(this.getClass(), "Restore table: " + table.getName());
        for (int i = 0; i < table.getRowCount(); ++i) {
            Row row = table.getNextRow();
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                int n;
                for (n = 0; n < list.size(); ++n) {
                    String string2 = list.get(n);
                    Object object = this.a(row, string2.toUpperCase());
                    int n2 = n + 1;
                    if (object instanceof Date) {
                        Date date = (Date)object;
                        preparedStatement.setTimestamp(n2, Timestamp.from(date.toInstant()));
                        continue;
                    }
                    if (string2.equalsIgnoreCase("IMAGE")) {
                        preparedStatement.setBlob(n2, (Blob)null);
                        continue;
                    }
                    if (object instanceof byte[] || string2.equalsIgnoreCase("IMAGE_BYTES")) {
                        preparedStatement.setBytes(n2, (byte[])object);
                        continue;
                    }
                    preparedStatement.setObject(n2, object);
                }
                preparedStatement.executeUpdate();
                connection.commit();
                n = (int)Math.round(100.0 / (double)table.getRowCount() * (double)(i + 1));
                this.a.progress(n, String.format(Messages.getString("DataRestorService.1"), i + 1, table.getRowCount()));
                continue;
            }
            catch (Exception exception) {
                this.a.printError(exception.getMessage());
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    private Object a(Row row, String string) {
        return row.getOrDefault((Object)string, null);
    }

    public static List<String> getTableNames(Connection connection, Database database) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = connection.getCatalog();
        ResultSet resultSet = database == Database.MYSQL ? connection.getMetaData().getTables(string, string, null, new String[]{"TABLE"}) : connection.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
        while (resultSet.next()) {
            String string2 = resultSet.getString("TABLE_NAME");
            if (MigrateDatabaseAction.nonPosTableNames.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private List<String> a(Connection connection, Database database, String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = connection.getCatalog();
        ResultSet resultSet = database == Database.MYSQL ? connection.getMetaData().getColumns(string2, string2, string, null) : connection.getMetaData().getColumns(null, null, string, null);
        while (resultSet.next()) {
            String string3 = resultSet.getString("COLUMN_NAME");
            arrayList.add(string3);
        }
        return arrayList;
    }
}

