/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import.service;

import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelImporterService {
    private static final ExcelImporterService a = new ExcelImporterService();

    public static ExcelImporterService getInstance() {
        return a;
    }

    public void doImportMenuItemFromXLSX(List<Object> list, MenuCategory menuCategory, MenuGroup menuGroup, XSSFSheet xSSFSheet) throws Exception {
        Iterator iterator = xSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            boolean bl;
            XSSFRow xSSFRow = (XSSFRow)iterator.next();
            if (xSSFRow.getRowNum() == 0) continue;
            if (xSSFRow.getRowNum() == 1 && (bl = this.isRowEmpty((Row)xSSFRow))) break;
            XSSFCell xSSFCell = xSSFRow.getCell(2);
            if (xSSFCell == null || xSSFCell.getCellType() == 3) continue;
            Iterator iterator2 = xSSFRow.cellIterator();
            BaseMenuItem baseMenuItem = null;
            while (iterator2.hasNext()) {
                XSSFCell xSSFCell2;
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellType()) {
                    case 1: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        d = cell.getNumericCellValue();
                    }
                }
                if ((xSSFCell2 = xSSFSheet.getRow(0).getCell(cell.getColumnIndex())) == null) continue;
                String string2 = xSSFCell2.getStringCellValue();
                if (string2.equalsIgnoreCase("Product Category")) {
                    if (!StringUtils.isNotBlank((String)string) || (menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(string)) != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(this.a(string, 120));
                    menuCategory.setVisible(true);
                    MenuCategoryDAO.getInstance().save(menuCategory);
                    continue;
                }
                if (string2.equalsIgnoreCase("Product Group")) {
                    if (!StringUtils.isNotBlank((String)string) || menuCategory == null || (menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(string)) != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(this.a(string, 120));
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    MenuGroupDAO.getInstance().saveOrUpdate(menuGroup);
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (string2.equalsIgnoreCase("Product Name")) {
                    baseMenuItem = new MenuItem();
                    baseMenuItem.setName(this.a(string, 255));
                    if (menuCategory != null) {
                        baseMenuItem.setMenuCategoryId(menuCategory.getId());
                        baseMenuItem.setMenuCategoryName(menuCategory.getName());
                    }
                    if (menuGroup != null) {
                        baseMenuItem.setMenuGroupId(menuGroup.getId());
                        baseMenuItem.setMenuGroupName(menuGroup.getName());
                    }
                    baseMenuItem.setDescription("");
                    baseMenuItem.setPrice(0.0);
                    baseMenuItem.setCost(0.0);
                    baseMenuItem.setSku("");
                    baseMenuItem.setBarcode("");
                    continue;
                }
                if (string2.equalsIgnoreCase("Product Description")) {
                    baseMenuItem.setDescription(this.a(string, 512));
                    continue;
                }
                if (string2.equalsIgnoreCase("Price")) {
                    baseMenuItem.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equalsIgnoreCase("Cost")) {
                    baseMenuItem.setCost(this.a(string, d));
                    continue;
                }
                if (string2.equalsIgnoreCase("SKU")) {
                    if (StringUtils.isNotBlank((String)string)) {
                        baseMenuItem.setSku(string);
                        continue;
                    }
                    if (!(d > 0.0)) continue;
                    baseMenuItem.setSku(String.valueOf((int)d));
                    continue;
                }
                if (string2.equalsIgnoreCase("Unit Code") && StringUtils.isNotBlank((String)string)) {
                    String string3 = string.trim();
                    InventoryUnitDAO inventoryUnitDAO = InventoryUnitDAO.getInstance();
                    InventoryUnit inventoryUnit = inventoryUnitDAO.findInventoryUnitByCode(string3);
                    if (inventoryUnit == null) {
                        inventoryUnit = new InventoryUnit();
                        inventoryUnit.setCode(string);
                        inventoryUnit.setName(string);
                        inventoryUnitDAO.save(inventoryUnit);
                    }
                    ((MenuItem)baseMenuItem).setUnit(inventoryUnit);
                    continue;
                }
                if (string2.equalsIgnoreCase("Barcode")) {
                    if (StringUtils.isNotBlank((String)string)) {
                        baseMenuItem.setBarcode(string);
                        continue;
                    }
                    baseMenuItem.setBarcode(String.valueOf((int)d));
                    continue;
                }
                if (string2.equalsIgnoreCase("Active")) {
                    baseMenuItem.setVisible(this.a(string));
                    continue;
                }
                if (string2.equalsIgnoreCase("Fractional Unit")) {
                    baseMenuItem.setFractionalUnit(this.a(string));
                    continue;
                }
                if (string2.equalsIgnoreCase("Inventory Item")) {
                    baseMenuItem.setInventoryItem(this.a(string));
                    continue;
                }
                if (!string2.equalsIgnoreCase("Allow Price Override")) continue;
                baseMenuItem.setEditablePrice(this.a(string));
            }
            if (baseMenuItem == null || !StringUtils.isNotBlank((String)baseMenuItem.getName())) continue;
            list.add(baseMenuItem);
        }
    }

    private String a(String string, int n) {
        if (string != null && string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    public void doImportMenuModifierFromXLSX(List<Object> list, ModifierGroup modifierGroup, XSSFSheet xSSFSheet) throws Exception {
        HashMap<String, ModifierGroup> hashMap = new HashMap<String, ModifierGroup>();
        Iterator iterator = xSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            boolean bl;
            XSSFRow xSSFRow = (XSSFRow)iterator.next();
            if (xSSFRow.getRowNum() == 0) continue;
            if (xSSFRow.getRowNum() == 1 && (bl = this.isRowEmpty((Row)xSSFRow))) break;
            Iterator iterator2 = xSSFRow.cellIterator();
            BaseMenuModifier baseMenuModifier = null;
            while (iterator2.hasNext()) {
                XSSFCell xSSFCell;
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellType()) {
                    case 1: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        d = cell.getNumericCellValue();
                    }
                }
                if ((xSSFCell = xSSFSheet.getRow(0).getCell(cell.getColumnIndex())) == null) continue;
                String string2 = xSSFCell.getStringCellValue();
                if (string2.equalsIgnoreCase("Modifier Group")) {
                    modifierGroup = (ModifierGroup)hashMap.get(string);
                    if (modifierGroup != null) continue;
                    modifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(string);
                    if (modifierGroup == null) {
                        modifierGroup = new ModifierGroup();
                        modifierGroup.setName(this.a(string, 120));
                        modifierGroup.setMaxQuantity(1);
                        hashMap.put(string, modifierGroup);
                        continue;
                    }
                    hashMap.put(string, modifierGroup);
                    continue;
                }
                if (string2.equalsIgnoreCase("Modifiers Name")) {
                    baseMenuModifier = MenuModifierDAO.getInstance().findName(string);
                    if (baseMenuModifier == null) {
                        baseMenuModifier = new MenuModifier();
                        baseMenuModifier.setName(this.a(string, 120));
                        modifierGroup.addTomodifiers((MenuModifier)baseMenuModifier);
                    } else {
                        baseMenuModifier.setDeleted(false);
                        baseMenuModifier.setPrice(0.0);
                        List<MenuModifier> list2 = modifierGroup.getModifiers();
                        if (list2 == null) {
                            modifierGroup.addTomodifiers((MenuModifier)baseMenuModifier);
                        } else if (list2 != null && !list2.contains(baseMenuModifier)) {
                            modifierGroup.addTomodifiers((MenuModifier)baseMenuModifier);
                        }
                    }
                    ((MenuModifier)baseMenuModifier).setModifierGroup(modifierGroup);
                    continue;
                }
                if (string2.equals("Price")) {
                    baseMenuModifier.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equals("Active")) {
                    baseMenuModifier.setEnable(this.a(string));
                    continue;
                }
                if (!string2.equals("Pizza Modifier")) continue;
                baseMenuModifier.setPizzaModifier(this.a(string));
            }
            if (baseMenuModifier != null && StringUtils.isNotBlank((String)baseMenuModifier.getName())) {
                list.add(baseMenuModifier);
            }
            if (modifierGroup == null || !StringUtils.isNotBlank((String)modifierGroup.getName()) || list.contains(modifierGroup)) continue;
            list.add(modifierGroup);
        }
    }

    public void doImportMenuItemFromXLS(List<Object> list, MenuCategory menuCategory, MenuGroup menuGroup, HSSFSheet hSSFSheet) throws Exception {
        Iterator iterator = hSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            boolean bl;
            HSSFRow hSSFRow = (HSSFRow)iterator.next();
            if (hSSFRow.getRowNum() == 0) continue;
            if (hSSFRow.getRowNum() == 1 && (bl = this.isRowEmpty((Row)hSSFRow))) break;
            HSSFCell hSSFCell = hSSFRow.getCell(2);
            if (hSSFCell == null || hSSFCell.getCellType() == 3) continue;
            Iterator iterator2 = hSSFRow.cellIterator();
            BaseMenuItem baseMenuItem = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellType()) {
                    case 1: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = hSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Product Category")) {
                    if (!StringUtils.isNotBlank((String)string) || (menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(string)) != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(this.a(string, 120));
                    menuCategory.setVisible(true);
                    continue;
                }
                if (string2.equals("Product Group")) {
                    if (!StringUtils.isNotBlank((String)string) || menuCategory == null || (menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(string)) != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(this.a(string, 120));
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (string2.equals("Product Name")) {
                    baseMenuItem = new MenuItem();
                    baseMenuItem.setName(this.a(string, 255));
                    if (menuCategory != null) {
                        baseMenuItem.setMenuCategoryId(menuCategory.getId());
                        baseMenuItem.setMenuCategoryName(menuCategory.getName());
                    }
                    if (menuGroup != null) {
                        baseMenuItem.setMenuGroupId(menuGroup.getId());
                        baseMenuItem.setMenuGroupName(menuGroup.getName());
                    }
                    baseMenuItem.setDescription("");
                    baseMenuItem.setPrice(0.0);
                    baseMenuItem.setCost(0.0);
                    baseMenuItem.setSku("");
                    baseMenuItem.setBarcode("");
                    continue;
                }
                if (string2.equals("Product Description")) {
                    baseMenuItem.setDescription(this.a(string, 512));
                    continue;
                }
                if (string2.equals("Price")) {
                    baseMenuItem.setPrice(d);
                    continue;
                }
                if (string2.equals("Cost")) {
                    baseMenuItem.setCost(d);
                    continue;
                }
                if (string2.equals("SKU")) {
                    if (StringUtils.isNotBlank((String)string)) {
                        baseMenuItem.setSku(string);
                        continue;
                    }
                    baseMenuItem.setSku(String.valueOf((int)d));
                    continue;
                }
                if (string2.equals("Barcode")) {
                    if (StringUtils.isNotBlank((String)string)) {
                        baseMenuItem.setBarcode(string);
                        continue;
                    }
                    baseMenuItem.setBarcode(String.valueOf((int)d));
                    continue;
                }
                if (string2.equals("Active")) {
                    baseMenuItem.setVisible(this.a(string));
                    continue;
                }
                if (string2.equals("Fractional Unit")) {
                    baseMenuItem.setFractionalUnit(this.a(string));
                    continue;
                }
                if (string2.equals("Inventory Item")) {
                    baseMenuItem.setInventoryItem(this.a(string));
                    continue;
                }
                if (!string2.equals("Allow Price Override")) continue;
                baseMenuItem.setEditablePrice(this.a(string));
            }
            if (baseMenuItem == null || !StringUtils.isNotBlank((String)baseMenuItem.getName())) continue;
            list.add(baseMenuItem);
        }
    }

    public void doImportMenuModifierFromXLS(List<Object> list, ModifierGroup modifierGroup, HSSFSheet hSSFSheet) throws Exception {
        Iterator iterator = hSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            boolean bl;
            HSSFRow hSSFRow = (HSSFRow)iterator.next();
            if (hSSFRow.getRowNum() == 0) continue;
            if (hSSFRow.getRowNum() == 1 && (bl = this.isRowEmpty((Row)hSSFRow))) break;
            Iterator iterator2 = hSSFRow.cellIterator();
            BaseMenuModifier baseMenuModifier = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellType()) {
                    case 1: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = hSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Modifier Group")) {
                    modifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(string);
                    if (modifierGroup != null) continue;
                    modifierGroup = new ModifierGroup();
                    modifierGroup.setName(this.a(string, 120));
                    ModifierGroupDAO.getInstance().saveOrUpdate(modifierGroup);
                    continue;
                }
                if (string2.equals("Modifiers Name")) {
                    baseMenuModifier = MenuModifierDAO.getInstance().findName(string);
                    if (baseMenuModifier == null) {
                        baseMenuModifier = new MenuModifier();
                        baseMenuModifier.setName(this.a(string, 120));
                        modifierGroup.addTomodifiers((MenuModifier)baseMenuModifier);
                        continue;
                    }
                    baseMenuModifier.setPrice(0.0);
                    continue;
                }
                if (string2.equals("Price")) {
                    baseMenuModifier.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equals("Active")) {
                    baseMenuModifier.setEnable(this.a(string));
                    continue;
                }
                if (!string2.equals("Pizza Modifier")) continue;
                baseMenuModifier.setPizzaModifier(this.a(string));
            }
            if (baseMenuModifier == null || !StringUtils.isNotBlank((String)baseMenuModifier.getName())) continue;
            list.add(baseMenuModifier);
        }
    }

    private double a(String string, double d) {
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d2 = d;
        }
        return d2;
    }

    private boolean a(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return string.equalsIgnoreCase("yes");
    }

    public boolean isRowEmpty(Row row) {
        for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() == 3) continue;
            return false;
        }
        return true;
    }

    public boolean checkImporteMenuItemIsDublicate(List<MenuItem> list) {
        if (list == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (MenuItem serializable2 : list) {
            arrayList.add(serializable2.getBarcode());
            arrayList2.add(serializable2.getSku());
            boolean bl = MenuItemDAO.getInstance().hasByBarcodeOrSKUOrMenuItemName(serializable2.getBarcode(), serializable2.getSku());
            if (!bl) continue;
            return true;
        }
        HashSet hashSet = new HashSet(arrayList);
        if (hashSet.size() < arrayList.size()) {
            return true;
        }
        HashSet hashSet2 = new HashSet(arrayList2);
        return hashSet2.size() < arrayList2.size();
    }

    public MenuItem checkImporteMenuItemIsDublicate2(List<MenuItem> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (MenuItem menuItem : list) {
            arrayList.add(menuItem.getBarcode());
            arrayList2.add(menuItem.getSku());
            MenuItem menuItem2 = MenuItemDAO.getInstance().getMenuItemByBarcodeAndSKU(menuItem.getBarcode(), menuItem.getSku());
            if (menuItem2 == null) continue;
            return menuItem2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> readXLSXFile(String string) throws Exception {
        XSSFWorkbook xSSFWorkbook = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            xSSFWorkbook = new XSSFWorkbook((InputStream)fileInputStream);
            ExcelImporterService.getInstance().doImportMenuItemFromXLSX(arrayList, menuCategory, menuGroup, xSSFWorkbook.getSheetAt(0));
            ExcelImporterService.getInstance().doImportMenuModifierFromXLSX(arrayList, modifierGroup, xSSFWorkbook.getSheetAt(1));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            List<Object> list = null;
            return list;
        }
        finally {
            if (xSSFWorkbook != null) {
                xSSFWorkbook.close();
            }
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> readXLSFile(String string) throws Exception {
        HSSFWorkbook hSSFWorkbook = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
            ExcelImporterService.getInstance().doImportMenuItemFromXLS(arrayList, menuCategory, menuGroup, hSSFWorkbook.getSheetAt(0));
            ExcelImporterService.getInstance().doImportMenuModifierFromXLS(arrayList, modifierGroup, hSSFWorkbook.getSheetAt(1));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            List<Object> list = null;
            return list;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (hSSFWorkbook != null) {
                hSSFWorkbook.close();
            }
        }
        return arrayList;
    }
}

