/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.ShopTable;
import com.floreantpos.swing.PosButton;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLayeredPane;

public class ShopTableStyledButton
extends PosButton {
    private JLayeredPane a;
    private ShopTable b;
    private int d;

    public ShopTableStyledButton(JLayeredPane jLayeredPane, ShopTable shopTable) {
        this.a = jLayeredPane;
        this.b = shopTable;
        String string = shopTable.getId() != null ? shopTable.getId() + "" : "";
        this.setText(string);
        Integer n = shopTable.getWidth();
        Integer n2 = shopTable.getHeight();
        if (n == null || n == 0) {
            n = TerminalConfig.getFloorButtonWidth();
        }
        if (n2 == null || n2 == 0) {
            n2 = TerminalConfig.getFloorButtonHeight();
        }
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setBackground(this.a.getBackground());
        this.setOpaque(false);
        this.setBounds(this.a.getPreferredSize().width / 2 - n / 2, this.a.getPreferredSize().height / 2 - n2 / 2, n, n2);
    }

    public void drawShape(int n) {
        this.d = n;
        this.repaint();
    }

    @Override
    public void paintAll(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getBackground());
        if (this.d == 2) {
            graphics2D.fillOval(10, 10, this.getSize().width - 20, this.getSize().height - 20);
        } else if (this.d == 1) {
            graphics2D.fillRoundRect(2, 2, this.getSize().width - 4, this.getSize().height - 4, 20, 20);
        } else if (this.d != 3) {
            graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getForeground());
        graphics2D.setStroke(new BasicStroke(6.0f));
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.d == 2) {
            graphics2D.drawOval(10, 10, n - 20, n2 - 20);
        } else if (this.d == 1) {
            graphics2D.drawRoundRect(2, 2, n - 4, n2 - 4, 20, 20);
        } else if (this.d == 3) {
            int n3 = n / 2;
            int n4 = n / 2;
            int n5 = (int)Math.sqrt(n * n + n * n);
            int n6 = n5 - n;
            int n7 = n5 - n;
            graphics2D.rotate(Math.toRadians(45.0), n3, n4);
            graphics2D.drawRoundRect((n - n6) / 3, (n - n7) / 3, n - n6, n - n7, 20, 20);
        } else {
            graphics2D.drawRect(0, 0, n, n2);
        }
    }

    public ShopTable getTable() {
        return this.b;
    }
}

