/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.inv;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryLocationSelector;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class InventoryTransactionEntryForm
extends BeanEditor<InventoryTransaction> {
    private JButton a;
    private POSTextField b;
    private JLabel c;
    private POSTextField d;
    private JLabel e;
    private JLabel f;
    private InventoryTransaction g;
    private JComboBox<InventoryVendor> h;
    private JLabel i;
    private JComboBox j;
    private JLabel k;
    private DoubleTextField l;
    private JLabel m;
    private JLabel n;
    private DoubleTextField o;
    private POSTextField p;
    private DoubleTextField q;
    private POSTextField r;
    private InventoryLocation s;
    private InventoryLocation t;
    private JComboBox<IUnit> u;
    private POSTextField v;
    private JButton w;
    private JLabel x;
    private JButton y;
    private JComboBox z;
    private JLabel A;
    private JLabel B;

    public InventoryTransactionEntryForm() {
        this.setLayout(new BorderLayout());
        this.c();
    }

    public InventoryTransactionEntryForm(InventoryTransaction inventoryTransaction) {
        this.g = inventoryTransaction;
        this.setLayout(new BorderLayout());
        this.c();
        this.a();
        this.setBean(inventoryTransaction);
        if (StringUtils.isBlank((String)inventoryTransaction.getId())) {
            this.d();
        }
    }

    private void a() {
        InventoryVendorDAO inventoryVendorDAO = new InventoryVendorDAO();
        ArrayList<InventoryVendor> arrayList = new ArrayList<InventoryVendor>();
        arrayList.add(null);
        arrayList.addAll(inventoryVendorDAO.findAllEnabled());
        this.h.setModel(new ComboBoxModel(arrayList));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < InventoryTransaction.REASON_OUT.length; ++i) {
            arrayList2.add(InventoryTransaction.REASON_OUT[i]);
        }
        this.z.setModel(new ComboBoxModel(arrayList2));
        this.j.setEnabled(false);
        this.u.setModel(new ComboBoxModel());
        this.s = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation();
        this.t = InventoryLocationDAO.getInstance().getDefaultInInventoryLocation();
        if (this.s != null) {
            this.b.setText(this.s.getName());
        }
        if (this.t != null) {
            this.v.setText(this.t.getName());
        }
        if (this.g.getTransactionType().equals((Object)InventoryTransactionType.UNCHANGED)) {
            this.j.addItem(InventoryTransactionType.UNCHANGED);
            this.k.setVisible(false);
            this.m.setVisible(false);
            this.l.setVisible(false);
            this.o.setVisible(false);
            this.A.setVisible(false);
            this.z.setVisible(false);
            this.c.setText(Messages.getString("InventoryTransactionEntryForm.0"));
        } else if (this.g.getTransactionType().equals((Object)InventoryTransactionType.OUT)) {
            this.j.addItem(InventoryTransactionType.OUT);
            this.c.setText(Messages.getString("InventoryTransactionEntryForm.0"));
            this.x.setEnabled(false);
            this.v.setEnabled(false);
            this.w.setEnabled(false);
            this.y.setEnabled(false);
            this.k.setVisible(false);
            this.l.setVisible(false);
        }
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InventoryLocation inventoryLocation = InventoryLocationSelector.openLocationSelector();
                if (inventoryLocation == null) {
                    return;
                }
                InventoryTransactionEntryForm.this.s = inventoryLocation;
                InventoryTransactionEntryForm.this.b.setText(inventoryLocation.getName());
                InventoryTransactionEntryForm.this.d();
            }
        });
        this.w.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InventoryLocation inventoryLocation = InventoryLocationSelector.openLocationSelector();
                if (inventoryLocation == null) {
                    return;
                }
                InventoryTransactionEntryForm.this.t = inventoryLocation;
                InventoryTransactionEntryForm.this.v.setText(inventoryLocation.getName());
            }
        });
        this.b();
    }

    private void b() {
        MenuItem menuItem = this.g.getMenuItem();
        if (menuItem == null) {
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.u.getModel();
        comboBoxModel.removeAllElements();
        if (menuItem.isVariant().booleanValue()) {
            MenuItemDAO.getInstance().initializeUnits(menuItem.getParentMenuItem());
            comboBoxModel.setDataList(menuItem.getParentMenuItem().getStockCountableUnits());
        } else {
            MenuItemDAO.getInstance().initializeUnits(menuItem);
            comboBoxModel.setDataList(menuItem.getStockCountableUnits());
        }
        if (comboBoxModel.getDataList() != null && comboBoxModel.getDataList().size() > 0) {
            this.u.setSelectedItem(menuItem.isVariant() != false ? menuItem.getParentMenuItem().getStockCountableUnit() : menuItem.getStockCountableUnit());
        }
    }

    private void c() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        jPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("InventoryTransactionEntryForm.4"));
        jPanel.add((Component)jLabel, "cell 0 0,alignx trailing");
        this.d = new POSTextField();
        jPanel.add((Component)this.d, "cell 1 0,growx");
        this.e = new JLabel(Messages.getString("InventoryTransactionEntryForm.7"));
        jPanel.add((Component)this.e, "cell 0 1,alignx trailing ");
        this.p = new POSTextField();
        jPanel.add((Component)this.p, "cell 1 1,growx");
        this.p.setEditable(false);
        JLabel jLabel2 = new JLabel(Messages.getString("InventoryTransactionEntryForm.10"));
        jPanel.add((Component)jLabel2, "cell 0 2,alignx trailing");
        this.r = new POSTextField();
        jPanel.add((Component)this.r, "cell 1 2,growx");
        this.r.setEditable(false);
        this.f = new JLabel(Messages.getString("InventoryTransactionEntryForm.13"));
        jPanel.add((Component)this.f, "cell 0 3, alignx trailing");
        this.h = new JComboBox();
        jPanel.add(this.h, "cell 1 3, growx");
        this.A = new JLabel(Messages.getString("InventoryTransactionEntryForm.16"));
        jPanel.add((Component)this.A, "cell 0 4, alignx trailing");
        this.z = new JComboBox();
        this.z.setMinimumSize(PosUIManager.getSize((int)100, (int)0));
        jPanel.add((Component)this.z, "cell 1 4, growx");
        this.i = new JLabel(Messages.getString("InventoryTransactionEntryForm.19"));
        jPanel.add((Component)this.i, "cell 0 5, alignx trailing");
        this.j = new JComboBox();
        jPanel.add((Component)this.j, "cell 1 5, growx");
        this.c = new JLabel(Messages.getString("InventoryTransactionEntryForm.22"));
        jPanel.add((Component)this.c, "cell 0 6, alignx trailing");
        this.b = new POSTextField();
        jPanel.add((Component)this.b, "cell 1 6,split 3, growx");
        this.b.setEditable(false);
        this.a = new JButton(Messages.getString("SELECT"));
        jPanel.add(this.a);
        JButton jButton = new JButton(Messages.getString("InventoryTransactionEntryForm.26"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InventoryTransactionEntryForm.this.b.setText("");
                InventoryTransactionEntryForm.this.s = null;
                InventoryTransactionEntryForm.this.d();
            }
        });
        this.x = new JLabel(Messages.getString("InventoryTransactionEntryForm.28"));
        jPanel.add((Component)this.x, "cell 0 7, alignx trailing");
        this.v = new POSTextField();
        jPanel.add((Component)this.v, "cell 1 7,split 3, growx");
        this.v.setEditable(false);
        this.w = new JButton(Messages.getString("SELECT"));
        jPanel.add(this.w);
        this.y = new JButton(Messages.getString("InventoryTransactionEntryForm.32"));
        jPanel.add(this.y);
        this.y.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InventoryTransactionEntryForm.this.v.setText("");
                InventoryTransactionEntryForm.this.t = null;
            }
        });
        JLabel jLabel3 = new JLabel(Messages.getString("InventoryTransactionEntryForm.34"));
        jPanel.add((Component)jLabel3, "cell 0 8,alignx trailing");
        this.u = new JComboBox();
        this.u.setMinimumSize(PosUIManager.getSize((int)100, (int)0));
        jPanel.add(this.u, "cell 1 8");
        this.u.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
                InventoryTransactionEntryForm.this.d();
            }
        });
        this.k = new JLabel(Messages.getString("InventoryTransactionEntryForm.37") + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        jPanel.add((Component)this.k, "cell 0 9,alignx trailing");
        this.l = new DoubleTextField();
        jPanel.add((Component)this.l, "cell 1 9,growx");
        this.n = new JLabel(Messages.getString("InventoryTransactionEntryForm.42"));
        jPanel.add((Component)this.n, "cell 0 10,alignx trailing");
        this.q = new DoubleTextField();
        this.q.setMinimumSize(PosUIManager.getSize((int)100, (int)0));
        jPanel.add((Component)this.q, "cell 1 10 , split 3");
        this.B = new JLabel("(" + Messages.getString("InventoryTransactionEntryForm.1") + ")");
        jPanel.add(this.B);
        this.m = new JLabel(Messages.getString("InventoryTransactionEntryForm.46"));
        this.o = new DoubleTextField();
    }

    @Override
    public boolean save() {
        Transaction transaction = null;
        try (Session session = null;){
            if (!this.updateModel()) {
                boolean bl = false;
                return bl;
            }
            InventoryTransaction inventoryTransaction = (InventoryTransaction)this.getBean();
            String string = this.d.getText();
            PurchaseOrder purchaseOrder = new PurchaseOrder();
            purchaseOrder.setOrderId(string);
            inventoryTransaction.setReferenceNo(purchaseOrder.getId());
            InventoryTransactionDAO inventoryTransactionDAO = InventoryTransactionDAO.getInstance();
            session = inventoryTransactionDAO.createNewSession();
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)purchaseOrder);
            if (inventoryTransaction.getTransactionType() == InventoryTransactionType.UNCHANGED) {
                InventoryTransaction inventoryTransaction2 = (InventoryTransaction)CopyUtil.deepCopy(inventoryTransaction);
                InventoryTransaction inventoryTransaction3 = inventoryTransaction;
                inventoryTransaction2.setTransactionType(InventoryTransactionType.OUT);
                inventoryTransaction2.setTransactionDate(new Date());
                this.a(inventoryTransaction2);
                inventoryTransactionDAO.adjustInventoryStock(inventoryTransaction2, session);
                inventoryTransaction3.setTransactionType(InventoryTransactionType.IN);
                inventoryTransaction3.setTransactionDate(new Date());
                this.a(inventoryTransaction3);
                inventoryTransactionDAO.adjustInventoryStock(inventoryTransaction3, session);
            } else {
                this.a(inventoryTransaction);
                inventoryTransactionDAO.adjustInventoryStock(inventoryTransaction, session);
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    private void a(InventoryTransaction inventoryTransaction) {
        if (StringUtils.isBlank((String)inventoryTransaction.getOutletId())) {
            inventoryTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
        }
    }

    @Override
    public void updateView() {
        InventoryTransaction inventoryTransaction = (InventoryTransaction)this.getBean();
        if (inventoryTransaction == null) {
            return;
        }
        if (inventoryTransaction.getReferenceNo() != null) {
            this.d.setText(inventoryTransaction.getReferenceNo());
        }
        this.p.setText(inventoryTransaction.getMenuItem().getName());
        this.r.setText(inventoryTransaction.getMenuItem().getSku());
        PosGuiUtil.selectComboItemById(this.h, inventoryTransaction.getVendorId());
        this.j.setSelectedItem(inventoryTransaction.getType());
        InventoryLocation inventoryLocation = DataProvider.get().getInventoryLocationById(inventoryTransaction.getFromLocationId());
        InventoryLocation inventoryLocation2 = DataProvider.get().getInventoryLocationById(inventoryTransaction.getToLocationId());
        if (inventoryLocation != null) {
            this.b.setText(inventoryLocation.getName());
        }
        if (inventoryLocation2 != null) {
            this.v.setText(inventoryLocation2.getName());
        }
        this.l.setText(NumberUtil.formatNumber(inventoryTransaction.getUnitPrice()));
        this.q.setText(NumberUtil.format6DigitNumber(inventoryTransaction.getQuantity()));
    }

    @Override
    public boolean updateModel() {
        Object object;
        InventoryTransaction inventoryTransaction = (InventoryTransaction)this.getBean();
        MenuItem menuItem = inventoryTransaction.getMenuItem();
        if (menuItem == null) {
            POSMessageDialog.showError(this.getParent(), Messages.getString("InventoryTransactionEntryForm.47"));
            return false;
        }
        inventoryTransaction.setMenuItem(menuItem);
        IUnit iUnit = (IUnit)this.u.getSelectedItem();
        if (iUnit == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryTransactionEntryForm.48"));
            return false;
        }
        inventoryTransaction.setUnitId(iUnit.getId());
        inventoryTransaction.setUnitType(iUnit.getUnitType());
        if (this.q.getDoubleOrZero() < 0.0) {
            POSMessageDialog.showError(POSConstants.NEGATIVE_VALUE_NOT_ALLOWED);
            return false;
        }
        if (this.l.isVisible() && this.l.getDoubleOrZero() < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.11"));
            return false;
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.UNCHANGED) {
            if (this.s == null) {
                POSMessageDialog.showError(this.getParent(), Messages.getString("InventoryTransactionEntryForm.49"));
                return false;
            }
            inventoryTransaction.setFromLocationId(this.s.getId());
            if (this.t == null) {
                POSMessageDialog.showError(this.getParent(), Messages.getString("InventoryTransactionEntryForm.50"));
                return false;
            }
            inventoryTransaction.setToLocationId(this.t.getId());
            if (this.s.equals(this.t)) {
                POSMessageDialog.showError(this.getParent(), Messages.getString("InventoryTransactionEntryForm.51"));
                return false;
            }
        } else if (inventoryTransaction.getTransactionType() == InventoryTransactionType.OUT) {
            object = (String)this.z.getSelectedItem();
            inventoryTransaction.setReason((String)object);
            if (this.s == null) {
                POSMessageDialog.showError(this.getParent(), Messages.getString("InventoryTransactionEntryForm.52"));
                return false;
            }
            inventoryTransaction.setFromLocationId(this.s.getId());
        }
        object = InventoryStockDAO.getInstance();
        InventoryStock inventoryStock = ((InventoryStockDAO)object).getInventoryStock(inventoryTransaction.getMenuItem(), this.s.getId(), inventoryTransaction.getUnitId());
        double d = this.q.getDouble();
        if (d == 0.0) {
            POSMessageDialog.showError(this.getParent(), Messages.getString("InventoryTransactionEntryForm.53"));
            return false;
        }
        if (!this.g.getMenuItem().isFractionalUnit().booleanValue() && NumberUtil.isFractional(d).booleanValue()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("FractionalQuantityNotAllowed"));
            return false;
        }
        if (inventoryStock == null || inventoryStock.getQuantityInHand() <= 0.0 || d > inventoryStock.getQuantityInHand()) {
            POSMessageDialog.showError(this.getParent(), Messages.getString("InventoryTransactionEntryForm.54"));
            return false;
        }
        Object object2 = this.h.getSelectedItem();
        if (object2 instanceof InventoryVendor) {
            inventoryTransaction.setVendorId(((InventoryVendor)object2).getId());
        }
        inventoryTransaction.setTransactionDate(new Date());
        inventoryTransaction.setQuantity(d);
        double d2 = menuItem.getCost(iUnit.getUniqueCode());
        inventoryTransaction.setUnitCost(d2);
        inventoryTransaction.setUnitId(iUnit.getId());
        inventoryTransaction.setTotal(d * d2);
        return true;
    }

    @Override
    public String getDisplayText() {
        if (this.g.getTransactionType().equals((Object)InventoryTransactionType.UNCHANGED)) {
            return Messages.getString("InventoryTransactionEntryForm.55");
        }
        if (this.g.getTransactionType().equals((Object)InventoryTransactionType.OUT)) {
            return Messages.getString("InventoryTransactionEntryForm.56");
        }
        return "";
    }

    private void d() {
        String string;
        MenuItem menuItem = this.g.getMenuItem();
        if (this.s == null) {
            return;
        }
        String string2 = this.s.getId();
        IUnit iUnit = (IUnit)this.u.getSelectedItem();
        if (iUnit == null) {
            return;
        }
        InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
        InventoryStock inventoryStock = inventoryStockDAO.getInventoryStock(menuItem, string2, string = iUnit.getUniqueCode());
        if (inventoryStock != null) {
            this.B.setText("(" + Messages.getString("InventoryTransactionEntryForm.5") + NumberUtil.format6DigitNumber(inventoryStock.getQuantityInHand()) + " " + string + ")");
        } else {
            this.B.setText("(" + Messages.getString("InventoryTransactionEntryForm.11") + (string.equals("null") ? "" : string + ")"));
        }
        this.l.setText(NumberUtil.formatNumber(iUnit != null ? menuItem.getVariantCost(iUnit) : menuItem.getVariantCost()));
    }
}

